/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.context;

import com.kingdee.bos.Context;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.SolutionDescription;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ToolContextManager {
    private static HashMap baseTempDirs = new HashMap();

    public static void clear() {
    }

    public static void removeLoader(IProject project) {
        baseTempDirs.remove(project.getLocation().toOSString());
    }

    public static String[] getAllSolution() {
        ArrayList<String> list = new ArrayList<String>();
        IMDProject[] projs = MDResourceUtil.listMDProject();
        for (int i = 0; i < projs.length; ++i) {
            list.add(projs[i].getName() + "/" + "metadata");
        }
        return list.toArray(new String[0]);
    }

    public static Context getORMContext(IProject project) {
        return MDResourceUtil.toMDProject(project).getORMContext();
    }

    public static IToolContext getContext(IProject project) {
        IToolContext ctx = MDResourceUtil.toMDProject(project).getToolContext();
        if (ctx != null) {
            ContextManager.setContext2((Context)ctx.getORMContext());
        }
        return ctx;
    }

    public static IDevMetadataLoader getMetadataLoader(IProject project) {
        return MDResourceUtil.toMDProject(project).getMetadataLoader();
    }

    public static IDevMetadataLoader getMetadataLoader(IFolder folder) {
        if (folder == null) {
            return null;
        }
        IProject pro = folder.getProject();
        return ToolContextManager.getMetadataLoader(pro);
    }

    private static void createBaseTemp(IMDProject pro) {
        SolutionDescription desc = SolutionDescription.getSolutionDescriptor(MDResourceUtil.toIProject(pro));
        File baseTempDir = new File(pro.toFile(), "basetemp");
        baseTempDirs.put(pro.toFile().getAbsolutePath(), baseTempDir);
        if (baseTempDir.exists()) {
            PFileUtils.emptyDir(baseTempDir);
        } else {
            baseTempDir.mkdir();
        }
        Vector stdDirs = desc.getStdDirs();
        for (int i = 0; i < stdDirs.size(); ++i) {
            String temp = (String)stdDirs.get(i);
            File stdDir = new File(pro.toFile(), temp);
            ToolContextManager.releaseToBaseTempFolder(baseTempDir, stdDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseToBaseTempFolder(File baseTempDir, File stdDir) {
        try {
            File[] files = stdDir.listFiles();
            for (int j = 0; j < files.length; ++j) {
                File ttemp;
                File fil = files[j];
                String pp = baseTempDir.getAbsolutePath();
                if (fil.isDirectory()) {
                    File ttemp2 = new File(pp + "/" + fil.getName());
                    if (ttemp2.exists()) continue;
                    ttemp2.mkdirs();
                    ToolContextManager.releaseToBaseTempFolder(ttemp2, fil);
                    continue;
                }
                String extension = fil.getName();
                int index = extension.indexOf(".");
                if (index > 0) {
                    extension = extension.substring(index + 1);
                }
                if (index > 0 && extension != null && extension.equals("jar")) {
                    try (ZipFile zipfile = null;){
                        zipfile = new ZipFile(fil);
                        Enumeration<? extends ZipEntry> e = zipfile.entries();
                        while (e.hasMoreElements()) {
                            ZipEntry entry = e.nextElement();
                            String name = entry.getName();
                            StringTokenizer st = new StringTokenizer(name, "/");
                            int tSize = st.countTokens();
                            int p = 0;
                            File parentFolder = baseTempDir;
                            while (st.hasMoreTokens()) {
                                File cftemp;
                                name = st.nextToken();
                                String pn = parentFolder.getAbsolutePath();
                                if (entry.isDirectory()) {
                                    cftemp = new File(pn + "/" + name);
                                    if (!cftemp.exists()) {
                                        cftemp.mkdir();
                                    }
                                    parentFolder = cftemp;
                                } else if (p == tSize - 1) {
                                    cftemp = new File(pn + "/" + name);
                                    if (!cftemp.exists()) {
                                        cftemp.createNewFile();
                                    }
                                } else {
                                    cftemp = new File(pn + "/" + name);
                                    if (!cftemp.exists()) {
                                        cftemp.mkdir();
                                    }
                                    parentFolder = cftemp;
                                }
                                ++p;
                            }
                        }
                    }
                }
                if ((ttemp = new File(pp + "/" + fil.getName())).exists()) continue;
                ttemp.createNewFile();
            }
        }
        catch (Exception e) {
            String symbolic = ToolCommonPlugin.getDefault().getBundle().getSymbolicName();
            Status status = new Status(4, symbolic, 0, "create temp directory wrong!", (Throwable)e);
            ToolCommonPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public static void rebase(IMDProject project) {
        IToolContext ctx = project.getToolContext();
        if (!ctx.isExtSolution()) {
            return;
        }
        baseTempDirs.remove(project.toFile().getAbsolutePath());
        ToolContextManager.createBaseTemp(project);
        IDevMetadataLoader loader = project.getMetadataLoader();
        File[] stdDirFs = project.getBaseMetadataJars();
        try {
            loader.rebase(stdDirFs);
        }
        catch (IOException e) {
            String symbolic = ToolCommonPlugin.getDefault().getBundle().getSymbolicName();
            Status status = new Status(4, symbolic, 0, "rebase error!", (Throwable)e);
            ToolCommonPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public static void clearLoaderCache() {
        IMDProject[] projs = MDResourceUtil.listMDProject();
        for (int i = 0; i < projs.length; ++i) {
            projs[i].getMetadataLoader().clear();
        }
    }

    public static void openCache() {
        IMDProject[] projs = MDResourceUtil.listMDProject();
        for (int i = 0; i < projs.length; ++i) {
            projs[i].getMetadataLoader().openCache();
        }
    }

    public static void closeCache() {
        IMDProject[] projs = MDResourceUtil.listMDProject();
        for (int i = 0; i < projs.length; ++i) {
            projs[i].getMetadataLoader().closeCache();
        }
    }

    public static boolean isOpenCache() {
        int i = 0;
        IMDProject[] projs = MDResourceUtil.listMDProject();
        if (i < projs.length) {
            return projs[i].getMetadataLoader().isOpenCache();
        }
        return false;
    }
}

