/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.context.SolutionDescription;
import com.kingdee.bos.tool.dao.Messages;
import com.kingdee.bos.tool.views.verify.CheckReport;
import com.kingdee.bos.util.BOSObjectType;
import java.util.Vector;

public class VerifyNameAndPackageBeforeSave {
    public static void verifyModelName(IMDFile file, IObjectValue model) {
        if (!VerifyNameAndPackageBeforeSave.canVerify(model)) {
            return;
        }
        CheckReport checkReport = ToolCommonPlugin.getCheckReport();
        String fileName = file.getName();
        if (fileName != null && fileName.indexOf(".") > -1) {
            fileName = fileName.substring(0, fileName.indexOf("."));
        }
        String modelName = (String)model.get("name");
        String filePk = file.toFile().getAbsolutePath();
        IMDProject project = file.getMDProject();
        if (filePk.indexOf("\\") > -1) {
            String srcName;
            Vector stdV = SolutionDescription.getSolutionDescriptor(project).getStdDirs();
            int j = stdV.size();
            for (int i = 0; i < j; ++i) {
                String s = (String)stdV.get(i);
                if (!filePk.startsWith(s)) continue;
                filePk = filePk.replaceFirst(s, "");
                break;
            }
            Vector extV = SolutionDescription.getSolutionDescriptor(project).getExtDirs();
            int j2 = extV.size();
            for (int i = 0; i < j2; ++i) {
                String s = (String)extV.get(i);
                if (!filePk.startsWith(s)) continue;
                filePk = filePk.replaceFirst(s, "");
                break;
            }
            if (filePk.startsWith(srcName = SolutionDescription.getSolutionDescriptor(project).getSrcName())) {
                filePk = filePk.replaceFirst(srcName, "");
            }
            if (filePk.startsWith("\\")) {
                filePk = filePk.substring(1);
            }
            if (filePk.indexOf("\\") > -1) {
                if ((filePk = filePk.substring(0, filePk.lastIndexOf("\\"))).indexOf("\\") > -1) {
                    filePk = filePk.replace('\\', '.');
                }
            } else {
                filePk = null;
            }
        }
        String modelPk = (String)model.get("package");
        boolean nameFlag = false;
        if (fileName != null && fileName.equals(modelName)) {
            nameFlag = true;
        }
        MetaDataPK mdpk = new MetaDataPK(filePk, fileName);
        if (!nameFlag) {
            CheckReportItem item = new CheckReportItem(0, (IMetaDataPK)mdpk, model.getBOSType(), model.getPKField(), 11, new String[]{Messages.UpdateFileCommand_YuanShuJuDeNAMEShuXingYuWenJianMingChengBuYiZhi});
            checkReport.addItem(item);
            checkReport.addItemFolder(item, file.getMDProject());
        }
        boolean pkFlag = false;
        if (filePk != null && filePk.equals(modelPk) || modelPk == null) {
            pkFlag = true;
        }
        if (!pkFlag) {
            CheckReportItem item = new CheckReportItem(0, (IMetaDataPK)mdpk, model.getBOSType(), model.getPKField(), 11, new String[]{Messages.UpdateFileCommand_YuanShuJuDePACKAGEShuXingYuWenJianLuJingBuYiZhi});
            checkReport.addItem(item);
            checkReport.addItemFolder(item, file.getMDProject());
        }
    }

    private static boolean canVerify(IObjectValue model) {
        if (model == null) {
            return false;
        }
        BOSObjectType type = model.getBOSType();
        if (type == null) {
            return false;
        }
        return type.equals((Object)MetaDataTypeList.ABSTRACTTABLE) || type.equals((Object)MetaDataTypeList.DATATABLE) || type.equals((Object)MetaDataTypeList.CROSSTABLE) || type.equals((Object)MetaDataTypeList.EXTENDEDTABLE) || type.equals((Object)MetaDataTypeList.BIZDATATYPE) || type.equals((Object)MetaDataTypeList.BIZENUM) || type.equals((Object)MetaDataTypeList.BIZEXCEPTION) || type.equals((Object)MetaDataTypeList.ENTITY) || type.equals((Object)MetaDataTypeList.RELATIONSHIP) || type.equals((Object)MetaDataTypeList.JOINQUERY) || type.equals((Object)MetaDataTypeList.UNIONQUERY) || type.equals((Object)MetaDataTypeList.BASEQUERY) || type.equals((Object)MetaDataTypeList.FACADE) || type.equals((Object)MetaDataTypeList.FUNCTION) || type.equals((Object)MetaDataTypeList.RULE) || type.equals((Object)MetaDataTypeList.UIOBJECT) || type.equals((Object)MetaDataTypeList.MUTEX) || type.equals((Object)MetaDataTypeList.LOG) || type.equals((Object)MetaDataTypeList.PERMISSION) || type.equals((Object)MetaDataTypeList.RESOURCE_TYPE) || type.equals((Object)MetaDataTypeList.IMAGE_RESOURCE_TYPE);
    }
}

