/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.dbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.tool.dbupdate.DBUpdateStrategy;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DB2SchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.dbtools.Messages;
import com.kingdee.bos.tool.dbupdate.dbtools.ORACLESchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.SQLSERVERSchemaDAO;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportCollection;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportItem;
import com.kingdee.bos.tool.dbupdate.report.IndexReportCollection;
import com.kingdee.bos.tool.dbupdate.report.IndexReportItem;
import com.kingdee.bos.tool.dbupdate.report.PrimaryKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.Report;
import com.kingdee.bos.tool.dbupdate.report.TableReportCollection;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DBSchema {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.studio.dbupdate.dbtools.DBSchema");

    public static AbstractTableInfo[] getTables(Connection cn, AbstractTableInfo[] newTables) {
        int len = newTables.length;
        AbstractTableInfo[] oldTables = new AbstractTableInfo[len];
        try {
            for (int i = 0; i < len; ++i) {
                String oldTableName = "";
                oldTableName = newTables[i].getOldTableName() != null ? newTables[i].getOldTableName() : newTables[i].getName();
                oldTables[i] = DBSchemaDAO.getTable(cn, oldTableName);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error", (Throwable)ex);
        }
        logger.info((Object)Messages.DBSchema_HuoQuShuJuBiaoJieGouXinXiChengGong);
        return oldTables;
    }

    public static AbstractTableInfo[] getTablesForDiffDB(Connection cn, AbstractTableInfo[] newTables) {
        int len = newTables.length;
        String oldTableName = "";
        Connection conn = null;
        AbstractTableInfo[] oldTables = new AbstractTableInfo[len];
        try {
            int type = DBUtils.getDbType(cn);
            conn = DBUtils.getNativeConnection(cn);
            for (int i = 0; i < len; ++i) {
                oldTableName = newTables[i].getOldTableName() != null ? newTables[i].getOldTableName() : newTables[i].getName();
                oldTables[i] = DBUtils.isDB2(type) ? DB2SchemaDAO.getTable(conn, oldTableName) : (DBUtils.isOracle(type) ? ORACLESchemaDAO.getTable(conn, oldTableName) : (DBUtils.isMSSQL(type) ? SQLSERVERSchemaDAO.getTable(conn, oldTableName) : SQLSERVERSchemaDAO.getTable(conn, oldTableName)));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error", (Throwable)ex);
        }
        return oldTables;
    }

    public static AbstractTableInfo[] getAllTables(Connection cn) {
        String tableName = "";
        AbstractTableInfo[] oldTables = null;
        try {
            Vector vector = DBUtils.getAllTableName(cn);
            int len = vector.size();
            oldTables = new AbstractTableInfo[len];
            for (int i = 0; i < len; ++i) {
                tableName = (String)vector.elementAt(i);
                oldTables[i] = DBSchemaDAO.getTable(cn, tableName);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error", (Throwable)ex);
        }
        logger.info((Object)Messages.DBSchema_HuoQuShuJuBiaoJieGouXinXiChengGong);
        return oldTables;
    }

    public static AbstractTableInfo[] getAllTablesForDiffDB(Connection cn) {
        String tableName = "";
        Vector vector = null;
        Connection conn = null;
        AbstractTableInfo[] oldTables = null;
        try {
            int type = DBUtils.getDbType(cn);
            conn = DBUtils.getNativeConnection(cn);
            vector = DBUtils.isDB2(type) ? DB2SchemaDAO.getAllTableName(conn) : (DBUtils.isOracle(type) ? ORACLESchemaDAO.getAllTableName(conn) : (DBUtils.isMSSQL(type) ? SQLSERVERSchemaDAO.getAllTableName(conn) : SQLSERVERSchemaDAO.getAllTableName(conn)));
            if (vector == null) {
                return null;
            }
            int len = vector.size();
            oldTables = new AbstractTableInfo[len];
            for (int i = 0; i < len; ++i) {
                tableName = (String)vector.elementAt(i);
                oldTables[i] = DBUtils.isDB2(type) ? DB2SchemaDAO.getTable(conn, tableName) : (DBUtils.isOracle(type) ? ORACLESchemaDAO.getTable(conn, tableName) : (DBUtils.isMSSQL(type) ? SQLSERVERSchemaDAO.getTable(conn, tableName) : SQLSERVERSchemaDAO.getTable(conn, tableName)));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error", (Throwable)ex);
        }
        logger.info((Object)Messages.DBSchema_HuoQuShuJuBiaoJieGouXinXiChengGong);
        return oldTables;
    }

    public static void addNewSchema(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        DBSchema.addNewSchema(cn, table, dbUpdateList, true);
    }

    public static void addNewSchema(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList, boolean addFK) throws SQLException {
        DBSchemaDAO.createDBTable(cn, table, dbUpdateList);
        DBSchemaDAO.createPK(cn, table, dbUpdateList);
        DBSchemaDAO.createDBIndex(cn, table, dbUpdateList);
        if (addFK) {
            DBSchemaDAO.createFK(cn, table, dbUpdateList);
        }
    }

    public static void dropSchema(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        String dbType = cn.getMetaData().getDatabaseProductName().toUpperCase();
        DBSchemaDAO.dropRefForeignKey(cn, table, dbUpdateList);
        DBSchemaDAO.dropFK(cn, table, dbUpdateList);
        DBSchemaDAO.dropDBView(dbType, table, dbUpdateList);
        DBSchemaDAO.dropDBTable(cn, table.getName(), dbUpdateList);
    }

    public static void updateSchema(Connection cn, TableReportItem item, DBUpdateList dbUpdateList) throws SQLException {
        String dbType = cn.getMetaData().getDatabaseProductName().toUpperCase();
        AbstractTableInfo oldTable = item.getOldTable();
        AbstractTableInfo newTable = item.getNewTable();
        if (!DBUtils.dbHaveData(cn, oldTable.getName(), null)) {
            DBSchema.dropSchema(cn, oldTable, dbUpdateList);
            DBSchema.addNewSchema(cn, newTable, dbUpdateList);
            if (newTable != null) {
                DBSchemaDAO.createDBIndex(cn, oldTable, dbUpdateList);
            }
            DBSchemaDAO.createRefForeignKey(cn, oldTable, newTable, dbUpdateList);
        } else {
            DBSchemaDAO.dropRefForeignKey(cn, oldTable, dbUpdateList);
            DBSchemaDAO.dropFK(cn, oldTable, dbUpdateList);
            DBSchemaDAO.dropDBIndex(cn, oldTable, dbUpdateList);
            DBSchemaDAO.dropPK(cn, oldTable, dbUpdateList);
            DBSchemaDAO.dropDBView(dbType, newTable, dbUpdateList);
            DBSchemaDAO.copyDataToTempTable(cn, item, dbUpdateList);
            DBSchemaDAO.dropDBTable(cn, oldTable.getName(), dbUpdateList);
            DBSchemaDAO.renameDBTable(cn, item.getTempTableName(), newTable.getName(), dbUpdateList);
            DBSchemaDAO.createPK(cn, newTable, dbUpdateList);
            DBSchemaDAO.createDBIndex(cn, newTable, dbUpdateList);
            if (newTable != null) {
                DBSchemaDAO.createDBIndex(cn, oldTable, dbUpdateList);
            }
            DBSchemaDAO.createFK(cn, newTable, dbUpdateList);
            DBSchemaDAO.createRefForeignKey(cn, oldTable, newTable, dbUpdateList);
            DBSchemaDAO.createDBView(dbType, newTable, dbUpdateList);
        }
    }

    public static void updateSchemaIngnoreFKAndIndex(Connection cn, TableReportItem item, DBUpdateList dbUpdateList) throws SQLException {
        String dbType = cn.getMetaData().getDatabaseProductName().toUpperCase();
        AbstractTableInfo oldTable = item.getOldTable();
        AbstractTableInfo newTable = item.getNewTable();
        if (!DBUtils.dbHaveData(cn, oldTable.getName(), null)) {
            DBSchema.dropSchema(cn, oldTable, dbUpdateList);
            DBSchema.addNewSchema(cn, newTable, dbUpdateList, false);
            if (newTable != null) {
                DBSchemaDAO.createDBIndex(cn, oldTable, dbUpdateList);
            }
            DBSchemaDAO.createRefForeignKey(cn, oldTable, newTable, dbUpdateList);
        } else {
            DBSchemaDAO.dropRefForeignKey(cn, oldTable, dbUpdateList);
            DBSchemaDAO.dropFK(cn, oldTable, dbUpdateList);
            DBSchemaDAO.dropDBIndex(cn, oldTable, dbUpdateList);
            DBSchemaDAO.dropPK(cn, oldTable, dbUpdateList);
            DBSchemaDAO.dropDBView(dbType, newTable, dbUpdateList);
            DBSchemaDAO.copyDataToTempTable(cn, item, dbUpdateList);
            DBSchemaDAO.dropDBTable(cn, oldTable.getName(), dbUpdateList);
            DBSchemaDAO.renameDBTable(cn, item.getTempTableName(), newTable.getName(), dbUpdateList);
            DBSchemaDAO.createPK(cn, newTable, dbUpdateList);
            DBSchemaDAO.createDBIndex(cn, newTable, dbUpdateList);
            if (newTable != null) {
                DBSchemaDAO.createDBIndex(cn, oldTable, dbUpdateList);
            }
            DBSchemaDAO.createRefForeignKey(cn, oldTable, newTable, dbUpdateList);
            DBSchemaDAO.createDBView(dbType, newTable, dbUpdateList);
        }
    }

    public static void updateSchema(Connection cn, TableReportItem item, DBUpdateList dbUpdateList, DBUpdateStrategy strategy, boolean isIgnoreFKAndIndex) throws SQLException {
        if (DBUpdateStrategy.AddTempTable.equals((Object)strategy)) {
            if (isIgnoreFKAndIndex) {
                DBSchema.updateSchemaIngnoreFKAndIndex(cn, item, dbUpdateList);
            } else {
                DBSchema.updateSchema(cn, item, dbUpdateList);
            }
        } else if (DBUpdateStrategy.AlterTable.equals((Object)strategy)) {
            int dbType = DBUtils.getDbType(cn);
            AbstractTableInfo oldTable = item.getOldTable();
            AbstractTableInfo newTable = item.getNewTable();
            PrimaryKeyReportItem primaryKeyItem = item.getPrimaryKeyReportItem();
            if (0 == primaryKeyItem.getReportState()) {
                DBSchemaDAO.createPKExists(dbType, newTable, dbUpdateList);
            } else if (1 == primaryKeyItem.getReportState()) {
                DBSchemaDAO.dropPKExists(dbType, newTable, dbUpdateList);
            } else if (2 == primaryKeyItem.getReportState()) {
                DBSchemaDAO.dropPKExists(dbType, newTable, dbUpdateList);
                DBSchemaDAO.createPKExists(dbType, newTable, dbUpdateList);
            }
            IndexReportCollection indexrpts = item.getIndexReportCollection();
            for (int i = 0; i < indexrpts.size(); ++i) {
                IndexReportItem indexItem = indexrpts.get(i);
                if (0 == indexItem.getReportState()) {
                    DBSchemaDAO.createDBIndexExists(dbType, newTable, dbUpdateList, indexItem.getNewIndex());
                    continue;
                }
                if (1 == indexItem.getReportState()) {
                    DBSchemaDAO.dropDBIndexExists(dbType, oldTable, dbUpdateList, indexItem.getOldIndex());
                    continue;
                }
                if (2 != indexItem.getReportState()) continue;
                DBSchemaDAO.dropDBIndexExists(dbType, oldTable, dbUpdateList, indexItem.getOldIndex());
                DBSchemaDAO.createDBIndexExists(dbType, newTable, dbUpdateList, indexItem.getNewIndex());
            }
            ColumnReportCollection colrpts = item.getColumnReportCollection();
            for (int i = 0; i < colrpts.size(); ++i) {
                ColumnReportItem colrptitem = colrpts.get(i);
                if (0 == colrptitem.getReportState()) {
                    DBSchemaDAO.addColumnExists(dbType, newTable, dbUpdateList, colrptitem.getNewColumn());
                    continue;
                }
                if (1 == colrptitem.getReportState() || 2 != colrptitem.getReportState()) continue;
                DBSchemaDAO.alterColumnExists(dbType, newTable, dbUpdateList, colrptitem.getOldColumn(), colrptitem.getNewColumn(), item);
            }
        }
    }

    public static void checkChangeValid(Connection cn, Report diffReport) {
        try {
            if (diffReport == null || diffReport.getTableReportCollection() == null) {
                return;
            }
            TableReportCollection tableReportCollection = diffReport.getTableReportCollection();
            int n = tableReportCollection.size();
            for (int i = 0; i < n; ++i) {
                if (tableReportCollection.get(i).getReportState() == 2) {
                    DBSchemaDAO.checkColumnChangeValid(cn, tableReportCollection.get(i));
                }
                if (tableReportCollection.get(i).getReportState() != 0 && tableReportCollection.get(i).getReportState() != 2) continue;
                DBSchemaDAO.checkKeyValid(cn, tableReportCollection.get(i));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error", (Throwable)ex);
        }
    }
}

