/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.engine;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.tool.dbupdate.DBUpdateStrategy;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchema;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchemaCompare;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUpdate;
import com.kingdee.bos.tool.dbupdate.engine.DBUpdateEngine;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBSchemaDAO;
import com.kingdee.bos.tool.dbupdate.report.Report;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DBUpdateEngineImpl
implements DBUpdateEngine {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dbupdate.engine.DBUpdateEngineImpl");
    private DBUpdateStrategy strategy = null;

    @Override
    public Report getDifferenceReport(Connection cn, AbstractTableInfo[] newTables) throws SQLException {
        if (cn == null || newTables == null) {
            return null;
        }
        AbstractTableInfo[] oldTables = KDBSchemaDAO.getTables(cn, newTables);
        if (oldTables == null) {
            oldTables = new AbstractTableInfo[]{};
        }
        KDBSchemaDAO.adjustTables(cn, newTables);
        Report diffReport = DBSchemaCompare.compareForMapping(oldTables, newTables);
        DBSchema.checkChangeValid(cn, diffReport);
        return diffReport;
    }

    @Override
    public Report getDifferenceReport(AbstractTableInfo[] oldTables, AbstractTableInfo[] newTables) {
        logger.debug((Object)"\u6b63\u5728\u5206\u6790\u6570\u636e\u8868\u7ed3\u6784\u5dee\u5f02...");
        if (oldTables == null || newTables == null) {
            return null;
        }
        Report diffReport = DBSchemaCompare.compareForMapping(oldTables, newTables);
        logger.debug((Object)"\u6b63\u5728\u5206\u6790\u6570\u636e\u8868\u7ed3\u6784\u5dee\u5f02...\u5206\u6790\u5b8c\u6bd5!");
        return diffReport;
    }

    @Override
    public Report getDifferenceReport(Connection oldConnection, Connection newConnection) {
        AbstractTableInfo[] newTables;
        logger.debug((Object)"\u6b63\u5728\u5206\u6790\u6570\u636e\u8868\u7ed3\u6784\u5dee\u5f02...");
        if (oldConnection == null || newConnection == null) {
            return null;
        }
        AbstractTableInfo[] oldTables = DBSchema.getAllTablesForDiffDB(oldConnection);
        if (oldTables == null) {
            oldTables = new AbstractTableInfo[]{};
        }
        if ((newTables = DBSchema.getAllTablesForDiffDB(newConnection)) == null) {
            newTables = new AbstractTableInfo[]{};
        }
        Report diffReport = DBSchemaCompare.compareForNoMapping(oldTables, newTables);
        DBSchema.checkChangeValid(oldConnection, diffReport);
        logger.debug((Object)"\u6b63\u5728\u5206\u6790\u6570\u636e\u8868\u7ed3\u6784\u5dee\u5f02...\u5206\u6790\u5b8c\u6bd5!");
        return diffReport;
    }

    @Override
    public DBUpdateStrategy getDefaultUpdateStrategy() {
        if (this.strategy == null) {
            return DBUpdateStrategy.AlterTable;
        }
        return this.strategy;
    }

    @Override
    public DBUpdateList generateUpdateScript(Connection cn, Report report) {
        if (cn == null || report == null) {
            return null;
        }
        return this.generateUpdateScript(cn, report, this.getDefaultUpdateStrategy(), false);
    }

    public DBUpdateList generateUpdateScript(Connection cn, Report report, boolean ignoreFKAndIndexWhenUpdateTable) {
        if (cn == null || report == null) {
            return null;
        }
        return this.generateUpdateScript(cn, report, this.getDefaultUpdateStrategy(), ignoreFKAndIndexWhenUpdateTable);
    }

    @Override
    public DBUpdateList generateUpdateScript(Connection cn, Report report, DBUpdateStrategy strategy) {
        return this.generateUpdateScript(cn, report, strategy, false);
    }

    public DBUpdateList generateUpdateScript(Connection cn, Report report, DBUpdateStrategy strategy, boolean ignoreFKAndIndexWhenUpdateTable) {
        if (cn == null || report == null) {
            return null;
        }
        DBUpdateList dbUpdateList = new DBUpdateList();
        DBUpdate.update(cn, report, strategy, dbUpdateList, ignoreFKAndIndexWhenUpdateTable);
        return this.analysys(dbUpdateList);
    }

    @Override
    public DBUpdateList generateUpdateScript(Report report, DBUpdateStrategy strategy) {
        if (report == null) {
            return null;
        }
        DBUpdateList dbUpdateList = new DBUpdateList();
        return this.analysys(dbUpdateList);
    }

    private DBUpdateList analysys(DBUpdateList dbUpdateList) {
        DBUpdateList retDBUpdateList = new DBUpdateList();
        for (int i = 0; i < 19; ++i) {
            int n = dbUpdateList.size();
            for (int j = 0; j < n; ++j) {
                DBUpdateInfo info = dbUpdateList.getInfo(j);
                if (info.getType() != i) continue;
                retDBUpdateList.add(info);
            }
        }
        return retDBUpdateList;
    }

    @Override
    public void setUpdateStrategy(DBUpdateStrategy strategy) {
        this.strategy = strategy;
    }
}

