/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataViewCollection;
import com.kingdee.bos.metadata.data.DataViewInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnCollection;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBUtils;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportCollection;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportItem;
import com.kingdee.bos.tool.dbupdate.report.IndexReportCollection;
import com.kingdee.bos.tool.dbupdate.report.IndexReportItem;
import com.kingdee.bos.tool.dbupdate.report.PrimaryKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class KDBSchema {
    public static final String EXT_KEY_INDEX_CONSTRAINT = "HAS_CONSTRAINT";
    public static final String EXT_KEY_VIEW_EXISTS = "view_exists";
    private static final int DB2CstrMaxLen = 18;
    private static final int ORACLECstrMaxLen = 30;

    public static void addNewSchema(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) {
        KDBSchema.createTable(dbType, table, dbUpdateList);
        KDBSchema.createPK(dbType, table, dbUpdateList);
        KDBSchema.createIndex(dbType, table, dbUpdateList);
    }

    public static void dropSchema(String dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) {
        KDBSchema.dropView(table, dbUpdateList);
        KDBSchema.dropTable(dbType, table.getName(), dbUpdateList);
    }

    public static void updateSchema(int dbType, TableReportItem item, DBUpdateList dbUpdateList) {
        int state;
        int i;
        AbstractTableInfo oldTable = item.getOldTable();
        AbstractTableInfo newTable = item.getNewTable();
        PrimaryKeyReportItem primaryKeyItem = item.getPrimaryKeyReportItem();
        if (primaryKeyItem != null) {
            int state2 = primaryKeyItem.getReportState();
            if (0 == state2) {
                KDBSchema.createPK(dbType, newTable, dbUpdateList);
            } else if (1 == state2 || 2 == state2) {
                // empty if block
            }
        }
        IndexReportCollection indexrpts = item.getIndexReportCollection();
        for (i = 0; i < indexrpts.size(); ++i) {
            IndexReportItem indexItem = indexrpts.get(i);
            state = indexItem.getReportState();
            if (0 == state) {
                KDBSchema.createIndex(dbType, newTable, dbUpdateList, indexItem.getNewIndex());
                continue;
            }
            if (1 != state && 2 != indexItem.getReportState()) continue;
        }
        ColumnReportCollection colrpts = item.getColumnReportCollection();
        for (i = 0; i < colrpts.size(); ++i) {
            ColumnReportItem colrptitem = colrpts.get(i);
            state = colrptitem.getReportState();
            if (0 == state) {
                KDBSchema.addColumn(dbType, newTable, dbUpdateList, colrptitem.getNewColumn());
                continue;
            }
            if (1 != state && 2 != state) continue;
        }
    }

    public static void createTable(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) {
        KDBSchema.createTable(table, dbUpdateList, false);
    }

    public static void createTable(AbstractTableInfo table, DBUpdateList dbUpdateList, boolean isScript) {
        StringBuffer sb = new StringBuffer();
        if (isScript) {
            sb.append("IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + table.getName() + "')\n");
        }
        sb.append("CREATE TABLE " + table.getName() + " (");
        for (int i = 0; i < table.getColumns().size(); ++i) {
            sb.append(KDBUtils.getColSQL(table.getColumns().get(i)) + ",");
        }
        String sql = sb.toString();
        sql = sql.substring(0, sql.length() - 1) + ")";
        KDBSchema.addSQLToList(10, table.getName(), table.getName(), sql.toString(), dbUpdateList);
        DataViewCollection dataViews = table.getDataViews();
        if (dataViews != null && dataViews.size() > 0) {
            for (int i = 0; i < dataViews.size(); ++i) {
                DataViewInfo dataView = dataViews.get(i);
                String viewSql = dataView.getScript();
                if (StringUtils.isEmpty((String)viewSql)) continue;
                if (isScript) {
                    viewSql = "IF EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='" + dataView.getName() + "') \n DROP VIEW " + dataView.getName() + ";\n" + viewSql;
                }
                KDBSchema.addSQLToList(18, table.getName(), dataView.getName(), viewSql, dbUpdateList);
            }
        }
    }

    public static void dropTable(String dbType, String tableName, DBUpdateList dbUpdateList) {
        KDBSchema.dropTable(tableName, dbUpdateList);
    }

    public static void dropTable(String tableName, DBUpdateList dbUpdateList) {
        String sql = "DROP TABLE " + tableName;
        KDBSchema.addSQLToList(8, tableName, sql, dbUpdateList);
    }

    public static void alterColumn(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList, ColumnInfo oldColumn, ColumnInfo newColumn, TableReportItem rptitem) {
        String newDefValue;
        String oldDefValue;
        if (newColumn == null) {
            return;
        }
        String sql = null;
        if (DBUtils.isMSSQL(dbType)) {
            String defName;
            oldDefValue = null;
            newDefValue = null;
            if (oldColumn.getDefaultValue() != null) {
                oldDefValue = oldColumn.getDefaultValue();
            }
            if (newColumn.getDefaultValue() != null) {
                newDefValue = newColumn.getDefaultValue();
            }
            if (oldDefValue != null && !oldDefValue.equals(newDefValue) && (defName = oldColumn.getExtendedProperty("defaultName")) != null) {
                sql = "ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + defName;
                KDBSchema.addSQLToList(12, table.getName(), newColumn.getName(), sql, dbUpdateList);
            }
        }
        sql = "ALTER TABLE " + table.getName();
        sql = sql + " ALTER COLUMN " + newColumn.getName() + " " + KDBUtils.getDataType(newColumn);
        if (DBUtils.isOracle(dbType)) {
            if (newColumn.isNullable() != oldColumn.isNullable()) {
                sql = sql + (newColumn.isNullable() ? " NULL" : " NOT NULL");
            }
        } else {
            sql = sql + (newColumn.isNullable() ? " NULL" : " NOT NULL");
        }
        if (newColumn.getDefaultValue() != null) {
            if (!DBUtils.isMSSQL(dbType)) {
                sql = sql + " DEFAULT " + newColumn.getDefaultValue();
            }
        } else if (DBUtils.isOracle(dbType)) {
            sql = sql + " DEFAULT null";
        }
        KDBSchema.addSQLToList(12, table.getName(), newColumn.getName(), sql, dbUpdateList);
        if (DBUtils.isMSSQL(dbType)) {
            oldDefValue = null;
            newDefValue = null;
            if (oldColumn.getDefaultValue() != null) {
                oldDefValue = oldColumn.getDefaultValue();
            }
            if (newColumn.getDefaultValue() != null) {
                newDefValue = newColumn.getDefaultValue();
            }
            if (newDefValue != null && !newDefValue.equals(oldDefValue)) {
                sql = "ALTER TABLE " + table.getName() + " ADD DEFAULT " + newDefValue + " FOR " + newColumn.getName();
                KDBSchema.addSQLToList(12, table.getName(), newColumn.getName(), sql, dbUpdateList);
            }
        }
    }

    public static void addColumn(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList, ColumnInfo column) {
        if (column == null) {
            return;
        }
        String sql = "ALTER TABLE " + table.getName();
        sql = sql + " ADD " + KDBUtils.getColSQL(column);
        KDBSchema.addSQLToList(11, table.getName(), column.getName(), sql, dbUpdateList);
    }

    public static void createPK(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) {
        String pkname = KDBSchema.truncateName(dbType, table.getPrimaryKey().getName());
        table.getPrimaryKey().setName(pkname);
        KDBSchema.createPK(table, dbUpdateList, false);
    }

    public static void createPK(AbstractTableInfo table, DBUpdateList dbUpdateList, boolean isScript) {
        PrimaryKeyInfo pkinfo = table.getPrimaryKey();
        if (pkinfo == null) {
            return;
        }
        PKColumnCollection columns = pkinfo.getPKColumns();
        if (columns.size() == 0) {
            return;
        }
        String pkname = table.getPrimaryKey().getName();
        String sql = "";
        if (isScript) {
            pkname = KDBSchema.truncateName(1, pkname);
            sql = sql + "IF NOT EXISTS (SELECT * FROM KSQL_CONSTRAINTS WHERE KSQL_CONS_TABNAME = '" + table.getName().toUpperCase() + "' AND KSQL_CONS_NAME = '" + pkname + "' AND KSQL_CONS_TYPE = 'KSQL_CT_P')\n";
        }
        sql = sql + "ALTER TABLE " + table.getName() + " ADD CONSTRAINT " + pkname + " PRIMARY KEY (";
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo col = columns.get(i).getColumn();
            if (i > 0) {
                sql = sql + ", ";
            }
            sql = sql + col.getName();
        }
        sql = sql + ")";
        KDBSchema.addSQLToList(13, table.getName(), pkname, sql, dbUpdateList);
    }

    public static void dropPK(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) {
        PrimaryKeyInfo pk = table.getPrimaryKey();
        String pkname = KDBSchema.truncateName(dbType, pk.getName());
        pk.setName(pkname);
        KDBSchema.dropPK(table, dbUpdateList);
    }

    public static void dropPK(AbstractTableInfo table, DBUpdateList dbUpdateList) {
        if (table.getPrimaryKey() == null) {
            return;
        }
        String pkname = table.getPrimaryKey().getName();
        String sql = "ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + pkname;
        KDBSchema.addSQLToList(1, pkname, sql, dbUpdateList);
    }

    public static void createIndex(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList) {
        for (int i = 0; i < table.getIndexes().size(); ++i) {
            IndexInfo ind = table.getIndexes().get(i);
            ind.setName(KDBSchema.truncateName(dbType, ind.getName()));
        }
        KDBSchema.createIndex(table, dbUpdateList, false);
    }

    public static void createIndex(AbstractTableInfo table, DBUpdateList dbUpdateList, boolean isScript) {
        for (int i = 0; i < table.getIndexes().size(); ++i) {
            KDBSchema.createIndex(table, dbUpdateList, table.getIndexes().get(i), isScript);
        }
    }

    public static void createIndex(int dbType, AbstractTableInfo table, DBUpdateList dbUpdateList, IndexInfo idx) {
        idx.setName(KDBSchema.truncateName(dbType, idx.getName()));
        KDBSchema.createIndex(table, dbUpdateList, idx, false);
    }

    public static void createIndex(AbstractTableInfo table, DBUpdateList dbUpdateList, IndexInfo idx, boolean isScript) {
        if (idx.getIndexColumns() == null || idx.getIndexColumns().isEmpty()) {
            return;
        }
        StringBuffer sqlStr = new StringBuffer();
        String idxname = idx.getName();
        if (isScript) {
            idxname = KDBSchema.truncateName(1, idxname);
            sqlStr.append("IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='" + idxname + "')\n");
        }
        sqlStr.append("CREATE" + (idx.isUnique() ? " UNIQUE" : "") + " INDEX " + idxname + " ON " + table.getName() + "(");
        boolean skipIndex = false;
        for (int j = 0; j < idx.getIndexColumns().size(); ++j) {
            IndexColumnInfo idxcol = idx.getIndexColumns().get(j);
            if (idxcol == null || idxcol.getColumn() == null) {
                skipIndex = true;
                break;
            }
            sqlStr.append(idxcol.getColumn().getName() + " " + idxcol.getSortType().getName() + ",");
        }
        boolean bHasAccentIndex = false;
        if (!skipIndex && !bHasAccentIndex) {
            String sql = sqlStr.toString();
            sql = sql.substring(0, sql.length() - 1) + ")";
            KDBSchema.addSQLToList(15, table.getName(), idxname, sql, dbUpdateList);
        }
    }

    public static void dropIndex(AbstractTableInfo table, DBUpdateList dbUpdateList) {
        int n = table.getIndexes().size();
        for (int i = 0; i < n; ++i) {
            IndexInfo idx = table.getIndexes().get(i);
            KDBSchema.dropIndex(table, dbUpdateList, idx);
        }
    }

    public static void dropIndex(AbstractTableInfo table, DBUpdateList dbUpdateList, IndexInfo idx) {
        String sql;
        String idxname = idx.getName();
        if (!StringUtils.isEmpty((String)idx.getExtendedProperty(EXT_KEY_INDEX_CONSTRAINT))) {
            sql = "ALTER TABLE " + table.getName() + " DROP CONSTRAINT " + idx.getExtendedProperty(EXT_KEY_INDEX_CONSTRAINT);
            KDBSchema.addSQLToList(3, table.getName(), idxname, sql, dbUpdateList);
        }
        sql = "DROP INDEX " + table.getName() + "." + idxname;
        KDBSchema.addSQLToList(2, table.getName(), idxname, sql, dbUpdateList);
    }

    public static void createView(AbstractTableInfo table, DBUpdateList dbUpdateList, boolean isScript) throws SQLException {
        DataViewCollection dataViews = table.getDataViews();
        if (dataViews != null && dataViews.size() > 0) {
            for (int i = 0; i < dataViews.size(); ++i) {
                DataViewInfo dataView = dataViews.get(i);
                String viewSql = dataView.getScript();
                if (StringUtils.isEmpty((String)viewSql)) continue;
                if (isScript) {
                    String sql = "IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + dataView.getName() + "')\n DROP VIEW " + dataView.getName() + ";";
                    KDBSchema.addSQLToList(18, table.getName(), dataView.getName(), sql, dbUpdateList);
                }
                KDBSchema.addSQLToList(18, table.getName(), dataView.getName(), viewSql, dbUpdateList);
            }
        }
    }

    public static void dropView(AbstractTableInfo table, DBUpdateList dbUpdateList) {
        DataViewCollection dataViews = table.getDataViews();
        if (dataViews != null && dataViews.size() > 0) {
            for (int i = 0; i < dataViews.size(); ++i) {
                DataViewInfo dataView = dataViews.get(i);
                String viewName = dataView.getName();
                if (StringUtils.isEmpty((String)viewName)) continue;
                String viewSql = "DROP VIEW " + viewName;
                KDBSchema.addSQLToList(7, table.getName(), dataView.getName(), viewSql, dbUpdateList);
            }
        }
    }

    public static void adjustTable(int type, AbstractTableInfo table) {
        if (DBUtils.isDB2(type)) {
            ColumnCollection cols = table.getColumns();
            for (int i = 0; i < cols.size(); ++i) {
                ColumnInfo info = cols.get(i);
                if (!SQLType.BINARY.equals((Object)info.getTypeName())) continue;
                info.setTypeName(SQLType.VARCHAR);
            }
        }
    }

    protected static String getValueString(int sqlType, Object value) {
        if (sqlType == 1 || sqlType == 12) {
            if (value instanceof String && !StringUtils.isEmpty((String)((String)value)) && !"''".equals(value)) {
                return "'" + value + "'";
            }
            return "''";
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected static Object getDefaultValue(int sqlType) {
        switch (sqlType) {
            case -7: {
                return false;
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(0);
            }
            case -5: {
                return new Long(0L);
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(0.0);
            }
            case 2: 
            case 3: {
                return new BigDecimal(0.0);
            }
            case -1: 
            case 1: 
            case 12: {
                return "''";
            }
            case -3: 
            case -2: 
            case 2004: {
                return new byte[]{-128};
            }
            case 91: {
                return new Date(System.currentTimeMillis());
            }
            case 92: {
                Date date = new Date(System.currentTimeMillis());
                return new Time(date.getTime());
            }
            case 93: {
                Date timestamp = new Date(System.currentTimeMillis());
                return new Timestamp(timestamp.getTime());
            }
        }
        return null;
    }

    protected static void addSQLToList(int type, String name, String sql, DBUpdateList dbUpdateList) {
        KDBSchema.addSQLToList(type, "", name, sql, dbUpdateList);
    }

    protected static void addSQLToList(int type, String tableName, String name, String sql, DBUpdateList dbUpdateList) {
        DBUpdateInfo info = new DBUpdateInfo(type, tableName, name, sql);
        if (!dbUpdateList.containsInfo(info)) {
            dbUpdateList.addInfo(info);
        }
    }

    private static String truncateName(int databaseType, String name) {
        String newName = name;
        if (DBUtils.isDB2(databaseType) && name.length() > 18) {
            newName = name.substring(0, 18);
        } else if (DBUtils.isOracle(databaseType) && name.length() > 30) {
            newName = name.substring(0, 30);
        }
        return newName;
    }
}

