/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataHeavyLoadCache;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableCollection;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.bos.metadata.data.IndexColumnCollection;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnCollection;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dbupdate.DBCreateIndexSql;
import com.kingdee.bos.tool.dbupdate.DBCreateTableSql;
import com.kingdee.bos.tool.dbupdate.DBCreateXml;
import com.kingdee.bos.tool.dbupdate.DBCreateXmlRoot;
import com.kingdee.bos.tool.dbupdate.DBUpdateException;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.engine.DBUpdateEngineImpl;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBSchema;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBSchemaDAO;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBUtils;
import com.kingdee.bos.tool.dbupdate.report.Report;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class KDBUpdateUtils {
    public static String[] Update(Connection cn, List tables, String path, String slnName) throws SQLException {
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        DBUpdateList dbUpdateList = dbUpdateEngine.generateUpdateScript(cn, dbUpdateEngine.getDifferenceReport(cn, KDBUpdateUtils.getTables(tables, path, slnName)));
        int size = dbUpdateList.size();
        String[] sqls = new String[size];
        for (int i = 0; i < size; ++i) {
            sqls[i] = ((DBUpdateInfo)dbUpdateList.get(i)).getSql();
        }
        return sqls;
    }

    public static AbstractTableInfo[] getTables(String metadataPath, String solutionName) {
        Context ctx = new Context(null, solutionName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        DataTableCollection tables = MetaDataLoader.getDataTableCollection((Context)ctx);
        AbstractTableInfo[] tableInfos = new AbstractTableInfo[tables.size()];
        int n = tables.size();
        for (int i = 0; i < n; ++i) {
            tableInfos[i] = tables.get(i);
        }
        return tableInfos;
    }

    private static AbstractTableInfo[] getTables(List tables, String path, String slnName) {
        Context ctx = new Context(null, slnName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)path);
        AbstractTableInfo[] tableInfos = new AbstractTableInfo[tables.size()];
        int n = tables.size();
        for (int i = 0; i < n; ++i) {
            tableInfos[i] = MetaDataLoader.getDataTable((Context)ctx, (IMetaDataPK)new MetaDataPK(tables.get(i).toString()));
        }
        return tableInfos;
    }

    public static boolean updateDatabase(Connection cn, DBUpdateList updateList) throws DBUpdateException {
        KDBUpdateUtils.trimUpdateList(updateList);
        if (updateList.isEmpty()) {
            return true;
        }
        boolean oldAC = true;
        try {
            oldAC = cn.getAutoCommit();
            cn.setAutoCommit(false);
            Statement stmt = cn.createStatement();
            int n = updateList.size();
            for (int i = 0; i < n; ++i) {
                DBUpdateInfo info = (DBUpdateInfo)updateList.get(i);
                String sql = info.getSql();
                try {
                    stmt.execute(info.getSql());
                    continue;
                }
                catch (SQLException e) {
                    try {
                        cn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DBUpdateException("\u6267\u884c\u8bed\u53e5\u65f6\u51fa\u9519\uff1a" + sql + "\r\n\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), e);
                }
            }
            cn.commit();
        }
        catch (SQLException e) {
            throw new DBUpdateException("\u53d1\u751f\u6570\u636e\u5e93\u9519\u8bef", e);
        }
        finally {
            try {
                if (!cn.getAutoCommit()) {
                    cn.commit();
                }
                cn.setAutoCommit(oldAC);
            }
            catch (Exception ex) {
                LogTool.logError("\u63d0\u4ea4\u4e8b\u52a1\u65f6\u53d1\u751f\u9519\u8bef", ex);
            }
        }
        return true;
    }

    public static DBUpdateList generateDBUpdateList(Connection cn, SolutionInfo solution, AbstractTableInfo[] tables) throws DBUpdateException, SQLException {
        assert (solution != null);
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        String[] languages = KDBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = KDBUpdateUtils.ignoreDataView(tables);
        try {
            newTables = KDBUpdateUtils.addMultilangColumns(newTables, languages);
        }
        catch (CloneNotSupportedException e) {
            throw new DBUpdateException("\u590d\u5236\u591a\u8bed\u8a00\u4fe1\u606f\u65f6\u5931\u8d25", e);
        }
        Report report = dbUpdateEngine.getDifferenceReport(cn, newTables);
        DBUpdateList list = dbUpdateEngine.generateUpdateScript(cn, report);
        return list;
    }

    public static DBUpdateList generateDBUpdateList(SolutionInfo solution, AbstractTableInfo[] tables) throws DBUpdateException {
        String[] languages = KDBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = KDBUpdateUtils.ignoreDataView(tables);
        try {
            newTables = KDBUpdateUtils.addMultilangColumns(newTables, languages, false);
        }
        catch (CloneNotSupportedException e) {
            throw new DBUpdateException("\u590d\u5236\u591a\u8bed\u8a00\u4fe1\u606f\u65f6\u51fa\u9519", e);
        }
        DBUpdateList updateList = new DBUpdateList();
        HashMap<String, String> tableMDMap = new HashMap<String, String>();
        int n = newTables.length;
        for (int i = 0; i < n; ++i) {
            AbstractTableInfo table = newTables[i];
            tableMDMap.put(table.getName(), table.getFullName());
            KDBSchema.createTable(newTables[i], updateList, true);
            KDBSchema.createPK(newTables[i], updateList, true);
            KDBSchema.createIndex(newTables[i], updateList, true);
        }
        return updateList;
    }

    public static List getAllPackageInfos(IMDProject project) {
        List list = KDBUpdateUtils.getSubPackages(project, project.getPrefix());
        List list2 = KDBUpdateUtils.getSubPackages(project, "com.kingdee.bos");
        list.addAll(list2);
        for (int i = 0; i < list.size(); ++i) {
            PackageInfo pkginfo = (PackageInfo)list.get(i);
            for (int j = list.size() - 1; j > i; --j) {
                if (j == i || !pkginfo.getFullName().equalsIgnoreCase(((PackageInfo)list.get(j)).getFullName())) continue;
                list.remove(j);
            }
        }
        return list;
    }

    public static void repairUpdateList(DBUpdateList subList, DBUpdateList fullList) {
        String sql;
        String newname;
        String name;
        DBUpdateInfo dbinfo2;
        int j;
        DBUpdateInfo dbinfo;
        int i;
        if (subList != null) {
            block0: for (i = 0; i < subList.size(); ++i) {
                dbinfo = subList.getInfo(i);
                if (dbinfo == null || 13 != dbinfo.getType()) continue;
                for (j = subList.size() - 1; j > i; --j) {
                    dbinfo2 = subList.getInfo(j);
                    if (dbinfo2 == null || 13 != dbinfo2.getType() || !dbinfo.getName().equalsIgnoreCase(dbinfo2.getName())) continue;
                    name = dbinfo.getName();
                    newname = name + "_err";
                    sql = dbinfo.getSql();
                    sql = StringUtils.replace((String)sql, (String)("CONSTRAINT " + name), (String)("CONSTRAINT " + newname));
                    dbinfo.setName(newname);
                    dbinfo.setSql(sql);
                    --i;
                    continue block0;
                }
            }
        }
        if (fullList != null) {
            block2: for (i = 0; i < subList.size(); ++i) {
                dbinfo = subList.getInfo(i);
                if (dbinfo == null || 13 != dbinfo.getType()) continue;
                for (j = fullList.size() - 1; j >= 0; --j) {
                    dbinfo2 = fullList.getInfo(j);
                    if (dbinfo2 == null || 13 != dbinfo2.getType() || !dbinfo.getName().equalsIgnoreCase(dbinfo2.getName())) continue;
                    name = dbinfo.getName();
                    newname = name + "_err";
                    sql = dbinfo.getSql();
                    sql = StringUtils.replace((String)sql, (String)("CONSTRAINT " + name), (String)("CONSTRAINT " + newname));
                    dbinfo.setName(newname);
                    dbinfo.setSql(sql);
                    --i;
                    continue block2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean outputDBScript(String scriptPath, DBUpdateList updateList) throws IOException {
        KDBUpdateUtils.trimUpdateList(updateList);
        File file = new File(scriptPath + File.separator + "update.sql");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            int n = updateList.size();
            for (int i = 0; i < n; ++i) {
                DBUpdateInfo updateInfo = updateList.getInfo(i);
                ((OutputStream)out).write((updateInfo.getSql() + ";\n").getBytes("UTF-8"));
            }
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
        return true;
    }

    public static void outputDBScript(String scriptPath, DBUpdateList updateList, List packageInfos, Map tableNameMap) throws IOException {
        KDBUpdateUtils.trimUpdateList(updateList);
        if (updateList.isEmpty()) {
            return;
        }
        DBCreateXmlRoot rootCreateXml = new DBCreateXmlRoot();
        int n = packageInfos.size();
        for (int i = 0; i < n; ++i) {
            DBCreateXml createXml = KDBUpdateUtils.createCreateXml((PackageInfo)packageInfos.get(i), updateList, tableNameMap);
            rootCreateXml.addCreateXml(createXml);
        }
        rootCreateXml.create(scriptPath);
    }

    public static boolean outputDBScript(IMDProject project, String scriptPath, List ignorePackages, List errorInfos) throws IOException {
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            scriptFile.mkdirs();
        }
        AbstractTableInfo[] tables = KDBUpdateUtils.getAllTables(project);
        HashMap<String, AbstractTableInfo> newtables = new HashMap<String, AbstractTableInfo>();
        ArrayList<String> errTables = errorInfos;
        if (errTables == null) {
            errTables = new ArrayList<String>();
        }
        for (int i = 0; i < tables.length; ++i) {
            if (KDBUpdateUtils.isIgnore(tables[i].getPackage(), ignorePackages)) continue;
            if (newtables.get(tables[i].getName().toLowerCase()) == null) {
                newtables.put(tables[i].getName().toLowerCase(), tables[i]);
                continue;
            }
            String errtbl = "Table:[" + tables[i].getFullName() + "] equals with[" + ((AbstractTableInfo)newtables.get(tables[i].getName().toLowerCase())).getFullName() + "]";
            errTables.add(errtbl);
        }
        tables = newtables.values().toArray(new AbstractTableInfo[0]);
        HashMap<String, ArrayList<AbstractTableInfo>> topPacks = new HashMap<String, ArrayList<AbstractTableInfo>>();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (int i = 0; i < tables.length; ++i) {
            AbstractTableInfo table = tables[i];
            nameMap.put(table.getName(), table.getFullName());
            String pack = KDBUpdateUtils.getTopPack(table);
            ArrayList<AbstractTableInfo> list = (ArrayList<AbstractTableInfo>)topPacks.get(pack);
            if (list == null) {
                list = new ArrayList<AbstractTableInfo>();
                topPacks.put(pack, list);
            }
            list.add(table);
        }
        tables = null;
        DBUpdateList updateList = new DBUpdateList();
        List allPGI = KDBUpdateUtils.getAllPackageInfos(project);
        for (String pack : topPacks.keySet()) {
            List list = (List)topPacks.get(pack);
            if (list != null && list.size() > 0) {
                KDBUpdateUtils.outputDBScript(scriptPath, updateList, allPGI, nameMap);
            }
            topPacks.put(pack, null);
        }
        return true;
    }

    public static SolutionInfo getSolution(String metadataPath, String solutionName) {
        Context ctx = new Context(null, solutionName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        SolutionInfo solution = MetaDataLoader.getSolution((Context)ctx);
        return solution;
    }

    public static String[] getMultiLanguages(SolutionInfo solution) {
        LanguageCollection lc = solution.getLanguages();
        String[] languages = new String[lc.size()];
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo lan = lc.get(i);
            languages[i] = lan.getPostfix();
        }
        return languages;
    }

    public static String[] getMultiLanguages(String metadataPath, String solutionName) {
        return KDBUpdateUtils.getMultiLanguages(KDBUpdateUtils.getSolution(metadataPath, solutionName));
    }

    public static void AbstractTableInfo(AbstractTableInfo baseTable, AbstractTableInfo targetTable) {
        ColumnCollection baseColumns = baseTable.getColumns();
        HashMap<String, String> mLangMap = new HashMap<String, String>();
        for (int i = baseColumns.size(); i >= 0; --i) {
            ColumnInfo targetColumn;
            char c;
            ColumnInfo baseColumn = baseColumns.get(i);
            String name = baseColumn.getName().toLowerCase();
            boolean isMulti = false;
            int index = name.lastIndexOf("_l");
            if ((index != -1 || name.length() == index + 3) && Character.isDigit(c = name.charAt(index + 2))) {
                name = name.substring(index);
                isMulti = true;
                mLangMap.put(baseColumn.getName(), name);
            }
            if ((targetColumn = KDBUtils.getColumnByName(targetTable, name)) == null) continue;
            targetColumn.setTypeName(baseColumn.getTypeName());
            targetColumn.setMultilingual(isMulti);
            targetColumn.setPrecision(baseColumn.getPrecision());
            targetColumn.setScale(baseColumn.getScale());
            targetColumn.setLength(baseColumn.getLength());
            targetColumn.setNullable(baseColumn.isNullable());
            targetColumn.setDefaultValue(baseColumn.getDefaultValue());
        }
        IndexCollection baseIndexs = baseTable.getIndexes();
        IndexCollection targetIndexs = targetTable.getIndexes();
        targetIndexs.clear();
        for (int j = 0; j < baseIndexs.size(); ++j) {
            IndexInfo baseInfo = baseIndexs.get(j);
            IndexInfo targetInfo = new IndexInfo();
            targetInfo.setName(baseInfo.getName());
            HashSet<String> set = new HashSet<String>();
            IndexColumnCollection baseIndCols = baseInfo.getIndexColumns();
            for (int k = 0; k < baseIndCols.size(); ++k) {
                IndexColumnInfo baseIndCol = baseIndCols.get(k);
                String colName = null;
                if (mLangMap.containsKey(baseIndCol.getColumn().getName())) {
                    String name = (String)mLangMap.get(baseIndCol.getColumn().getName());
                    if (!set.contains(name)) {
                        set.add(name);
                        colName = name;
                    }
                } else {
                    colName = baseIndCol.getColumn().getName();
                }
                ColumnInfo colInfo = KDBUtils.getColumnByName(targetTable, colName);
                if (colInfo == null) continue;
                IndexColumnInfo targetIndCol = new IndexColumnInfo();
                targetIndCol.setSortType(baseIndCol.getSortType());
                targetIndCol.setColumn(colInfo);
                targetInfo.getIndexColumns().add(targetIndCol);
            }
            targetIndexs.add(targetInfo);
        }
        PrimaryKeyInfo basePkInfo = baseTable.getPrimaryKey();
        PrimaryKeyInfo targetPkInfo = targetTable.getPrimaryKey();
        if (targetPkInfo == null) {
            targetPkInfo = new PrimaryKeyInfo();
        }
        if (basePkInfo != null && basePkInfo.getName() != null && !basePkInfo.getName().equalsIgnoreCase(targetPkInfo.getName())) {
            targetPkInfo.setName(basePkInfo.getName());
            PKColumnCollection dbPkColumnCols = basePkInfo.getPKColumns();
            PKColumnCollection devPkColumnCols = targetPkInfo.getPKColumns();
            devPkColumnCols.clear();
            for (int k = 0; k < dbPkColumnCols.size(); ++k) {
                PKColumnInfo dbPkColInfo = dbPkColumnCols.get(k);
                ColumnInfo dbPkCol = dbPkColInfo.getColumn();
                ColumnInfo devPkCol = targetTable.getColumnByName(dbPkCol.getName());
                if (devPkCol == null) {
                    devPkCol = targetTable.getColumnByName((String)mLangMap.get(dbPkCol.getName()));
                }
                if (devPkCol == null) continue;
                PKColumnInfo devPkColInfo = new PKColumnInfo();
                devPkColInfo.setColumn(devPkCol);
                boolean bexists = false;
                for (int l = 0; l < devPkColumnCols.size(); ++l) {
                    PKColumnInfo tempPKCol = devPkColumnCols.get(l);
                    if (!tempPKCol.getColumn().getName().equalsIgnoreCase(devPkCol.getName())) continue;
                    bexists = true;
                    break;
                }
                if (bexists) continue;
                devPkColumnCols.add(devPkColInfo);
            }
            if (devPkColumnCols.size() > 0) {
                targetTable.setPrimaryKey(targetPkInfo);
            }
        }
    }

    public static boolean synTableMetasByDb(Connection cn, IMDProject project) throws Exception {
        if (cn == null) {
            return false;
        }
        AbstractTableInfo[] newTables = KDBUpdateUtils.getAllTables(project);
        String[] languages = KDBUpdateUtils.getMultiLanguages(project.getSolutionInfo());
        if ((newTables = KDBUpdateUtils.addMultilangColumns(newTables, languages, false)) == null) {
            return false;
        }
        AbstractTableInfo[] dbTables = KDBSchemaDAO.getTables(cn, newTables);
        IDevMetadataLoader devloader = project.getMetadataLoader();
        for (int i = 0; i < newTables.length; ++i) {
            AbstractTableInfo devTableInfo = (AbstractTableInfo)devloader.loadMetadata(MetaDataTypeList.ABSTRACTTABLE, (IMetaDataPK)new MetaDataPK(newTables[i].getFullName()));
            AbstractTableInfo dbTableInfo = null;
            for (int k = 0; k < dbTables.length; ++k) {
                AbstractTableInfo dbTemp = dbTables[k];
                if (dbTemp == null || !dbTemp.getName().equalsIgnoreCase(devTableInfo.getName())) continue;
                dbTableInfo = dbTemp;
                break;
            }
            if (dbTableInfo == null) continue;
            devloader.saveMetadata((AbstractMetaDataValue)devTableInfo);
        }
        return true;
    }

    private static List getSubPackages(IMDProject project, String packageName) {
        ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
        IMDFolder folder = project.getRoot().getChildFolder(StringUtils.replace((String)packageName, (String)".", (String)"/"));
        IMDResource[] files = folder.listChildren();
        for (int i = 0; i < files.length; ++i) {
            if (!(files[i] instanceof IMDFolder)) continue;
            IMDFolder f = (IMDFolder)files[i];
            PackageInfo pkinfo = new PackageInfo();
            pkinfo.setPackage(f.getPackageName());
            pkinfo.setName(files[i].getName());
            list.add(pkinfo);
        }
        return list;
    }

    private static DBCreateXml createCreateXml(PackageInfo pInfo, DBUpdateList updateList, Map tableMDMap) {
        DBCreateXml createXml = new DBCreateXml(pInfo);
        HashMap<String, DBCreateTableSql> tableSqlMap = new HashMap<String, DBCreateTableSql>();
        HashMap<String, DBCreateIndexSql> indexSqlMap = new HashMap<String, DBCreateIndexSql>();
        String packageName = pInfo.getPackage() + ".";
        int n = updateList.size();
        for (int i = 0; i < n; ++i) {
            DBUpdateInfo updateInfo = updateList.getInfo(i);
            String subPackageName = MetaDataUtils.getPackageName((String)((String)tableMDMap.get(updateInfo.getTableName())));
            if (StringUtils.isEmpty((String)subPackageName)) {
                LogTool.logError("\u5305\u540d\u79f0\u4e3a\u7a7a" + updateInfo.getTableName(), new Exception("\u5305\u540d\u79f0\u4e3a\u7a7a"));
                continue;
            }
            if (subPackageName.endsWith(".app")) {
                subPackageName = subPackageName + ".app";
            }
            if (!subPackageName.startsWith(packageName)) continue;
            if (15 == updateInfo.getType()) {
                DBCreateIndexSql indexSql = (DBCreateIndexSql)indexSqlMap.get(subPackageName);
                if (indexSql == null) {
                    indexSql = new DBCreateIndexSql(createXml, subPackageName);
                    indexSqlMap.put(subPackageName, indexSql);
                }
                indexSql.getUpdateList().addInfo(updateInfo);
                continue;
            }
            if (17 == updateInfo.getType()) continue;
            DBCreateTableSql tableSql = (DBCreateTableSql)tableSqlMap.get(subPackageName);
            if (tableSql == null) {
                tableSql = new DBCreateTableSql(createXml, subPackageName);
                tableSqlMap.put(subPackageName, tableSql);
            }
            tableSql.getUpdateList().addInfo(updateInfo);
        }
        Iterator iter = tableSqlMap.values().iterator();
        while (iter.hasNext()) {
            createXml.addCreateTableSql((DBCreateTableSql)iter.next());
        }
        iter = indexSqlMap.values().iterator();
        while (iter.hasNext()) {
            createXml.addCreateIndexSql((DBCreateIndexSql)iter.next());
        }
        return createXml;
    }

    public static void trimUpdateList(DBUpdateList updateList) {
        for (int i = updateList.size() - 1; i >= 0; --i) {
            int type = updateList.getInfo(i).getType();
            if (17 != type) continue;
            updateList.remove(i);
        }
    }

    private static AbstractTableInfo[] ignoreDataView(AbstractTableInfo[] tables) {
        ArrayList<AbstractTableInfo> list = new ArrayList<AbstractTableInfo>();
        int n = tables.length;
        for (int i = 0; i < n; ++i) {
            String tableName;
            if (tables[i] == null || (tableName = tables[i].getName()) == null || tableName.startsWith("V_") || tableName.startsWith("v_")) continue;
            list.add(tables[i]);
        }
        AbstractTableInfo[] newTables = new AbstractTableInfo[list.size()];
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            newTables[i] = (AbstractTableInfo)list.get(i);
        }
        return newTables;
    }

    private static AbstractTableInfo[] addMultilangColumns(AbstractTableInfo[] tables, String[] languages) throws CloneNotSupportedException {
        return KDBUpdateUtils.addMultilangColumns(tables, languages, true);
    }

    private static AbstractTableInfo[] addMultilangColumns(AbstractTableInfo[] tables, String[] languages, boolean copytable) throws CloneNotSupportedException {
        if (tables == null || tables.length <= 0) {
            return tables;
        }
        ArrayList<ColumnInfo> addedColumns = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> removedColumns = new ArrayList<ColumnInfo>();
        for (int tableIndex = 0; tableIndex < tables.length; ++tableIndex) {
            int c;
            AbstractTableInfo table = tables[tableIndex];
            if (tables[tableIndex] == null) continue;
            AbstractTableInfo newTable = null;
            newTable = copytable ? (AbstractTableInfo)ObjectUtils.createCopy((Object)table) : table;
            newTable.setAlias(table.getAlias());
            newTable.setName(table.getName());
            newTable.setOldTableName(table.getOldTableName());
            newTable.setUserDefined(table.isUserDefined());
            IndexCollection indexes = newTable.getIndexes();
            if (table == null) continue;
            ColumnCollection cc = table.getColumns();
            ColumnCollection newcc = newTable.getColumns();
            addedColumns.clear();
            removedColumns.clear();
            int n = cc.size();
            block1: for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
                PKColumnCollection pkCols;
                ColumnInfo column = cc.get(columnIndex);
                if (!column.isMultilingual()) continue;
                removedColumns.add(column);
                String name = column.getName();
                ColumnInfo[] newindexcols = new ColumnInfo[languages.length];
                for (int lan = 0; lan < languages.length; ++lan) {
                    ColumnInfo multiColumn = (ColumnInfo)ObjectUtils.createCopy((Object)column);
                    multiColumn.setName(name + "_" + languages[lan]);
                    newindexcols[lan] = multiColumn;
                    multiColumn.setMultilingual(false);
                    addedColumns.add(multiColumn);
                }
                block3: for (int i = 0; i < indexes.size(); ++i) {
                    IndexInfo index = indexes.get(i);
                    IndexColumnCollection idxCols = index.getIndexColumns();
                    for (int j = 0; j < idxCols.size(); ++j) {
                        IndexColumnInfo indexcol = idxCols.get(j);
                        ColumnInfo colinfo = indexcol.getColumn();
                        if (!colinfo.getName().equalsIgnoreCase(name)) continue;
                        indexcol.setColumn(newindexcols[0]);
                        for (int l = 1; l < newindexcols.length; ++l) {
                            IndexColumnInfo indexcol_lan = new IndexColumnInfo();
                            indexcol_lan.setSortType(indexcol.getSortType());
                            indexcol_lan.setColumn(newindexcols[l]);
                            idxCols.add(indexcol_lan);
                        }
                        continue block3;
                    }
                }
                PrimaryKeyInfo pkinfo = newTable.getPrimaryKey();
                if (pkinfo == null || (pkCols = pkinfo.getPKColumns()) == null) continue;
                for (int j = 0; j < pkCols.size(); ++j) {
                    PKColumnInfo pkcol = pkCols.get(j);
                    ColumnInfo colinfo = pkcol.getColumn();
                    if (!colinfo.getName().equalsIgnoreCase(name)) continue;
                    pkcol.setColumn(newindexcols[0]);
                    for (int l = 1; l < newindexcols.length; ++l) {
                        PKColumnInfo indexcol_lan = new PKColumnInfo();
                        indexcol_lan.setSortType(pkcol.getSortType());
                        indexcol_lan.setColumn(newindexcols[l]);
                        pkCols.add(indexcol_lan);
                    }
                    continue block1;
                }
            }
            n = removedColumns.size();
            for (c = 0; c < n; ++c) {
                newcc.remove((ColumnInfo)removedColumns.get(c));
            }
            n = addedColumns.size();
            for (c = 0; c < n; ++c) {
                newcc.add((ColumnInfo)addedColumns.get(c));
            }
            tables[tableIndex] = newTable;
        }
        return tables;
    }

    public static AbstractTableInfo[] getAllTables(IMDProject project) {
        MetaDataHeavyLoadCache loader = new MetaDataHeavyLoadCache(project.getORMContext());
        IObjectCollection tables = loader.getCollection(MetaDataTypeList.ABSTRACTTABLE);
        ArrayList<IObjectValue> tableList = new ArrayList<IObjectValue>();
        int n = tables.size();
        for (int i = 0; i < n; ++i) {
            tableList.add(tables.getObject(i));
        }
        AbstractTableInfo[] tableInfos = new AbstractTableInfo[tableList.size()];
        tableInfos = tableList.toArray(new AbstractTableInfo[0]);
        return tableInfos;
    }

    public static String getTopPack(AbstractTableInfo table) {
        String easPack = "com.kingdee.eas";
        String bosPack = "com.kingdee.bos";
        if (table.getPackage().startsWith("com.kingdee.bos")) {
            return "BOS";
        }
        String pack = table.getPackage();
        if (!pack.startsWith("com.kingdee.eas")) {
            return "OTHER";
        }
        if ((pack = pack.substring("com.kingdee.eas".length() + 1)).indexOf(46) != -1) {
            pack = pack.substring(0, pack.indexOf(46));
        }
        return pack;
    }

    private static boolean isIgnore(String spackage, List ignorePackages) {
        if (ignorePackages != null && !StringUtils.isEmpty((String)spackage)) {
            for (int i = 0; i < ignorePackages.size(); ++i) {
                if (ignorePackages.get(i) == null || !((String)ignorePackages.get(i)).equalsIgnoreCase(spackage)) continue;
                return true;
            }
        }
        return false;
    }
}

