/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class KingbaseDAOUtil {
    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        String sql = "Select tablename FROM pg_tables WHERE tablename = ?";
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, tableName.toLowerCase());
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            return null;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        AbstractTableInfo table = new AbstractTableInfo();
        table.setName(tableName);
        KingbaseDAOUtil.fillColumnInfo(cn, table);
        KingbaseDAOUtil.fillPKInfo(cn, table);
        KingbaseDAOUtil.fillIndexInfo(cn, table);
        KingbaseDAOUtil.fillFKInfo(cn, table);
        return table;
    }

    private static void fillColumnInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toLowerCase();
        String sql = "select  *  from information_schema.columns  where table_name = ? ";
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, tableName);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ColumnInfo col = new ColumnInfo();
            col.setName(rs.getString("COLUMN_NAME"));
            String typeName = rs.getString("UDT_NAME");
            SQLType dataType = KingbaseDAOUtil.getSQLType(typeName);
            col.setTypeName(dataType);
            String strDef = rs.getString("column_default");
            if ("null".equalsIgnoreCase(strDef)) {
                strDef = null;
            }
            if (strDef != null && strDef.length() != 0 && (strDef = strDef.trim()).startsWith("( ") && strDef.endsWith(" )")) {
                strDef = "(" + strDef.substring(2, strDef.length() - 4).trim() + ")";
            }
            col.setDefaultValue(strDef);
            int length = rs.getInt("character_maximum_length");
            if (typeName.equals("numeric")) {
                length = rs.getInt("numeric_precision");
            }
            col.setLength(length);
            col.setNullable(rs.getString("is_nullable").equals("YES"));
            col.setPrecision(rs.getInt("numeric_precision_radix"));
            col.setScale(rs.getInt("numeric_scale"));
            table.getColumns().add(col);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillPKInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toLowerCase();
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("/*dialect*/");
        queryBuffer.append(" select pg_constraint.conname as CONSTRAINT_NAME,").append("\tpg_attribute.attname as COLUMN_NAME,").append("\tpg_class.relname as TABLE_NAME,").append(" pg_attribute.attnum as POSITION ").append("\tfrom  pg_constraint ").append("\tinner join pg_class on pg_constraint.conrelid = pg_class.oid ").append(" inner join pg_attribute on pg_attribute.attrelid = pg_class.oid  and ").append(" pg_attribute.attnum = any(pg_constraint.conkey)").append("\tinner join pg_type on pg_type.oid = pg_attribute.atttypid").append("\twhere pg_class.relname = ? ").append("\tand pg_constraint.contype='p'  and pg_table_is_visible(pg_class.oid) ");
        PreparedStatement stmt2 = DBUtils.createPreparedStatement(cn, queryBuffer.toString(), new String[]{tableName});
        ResultSet rs2 = stmt2.executeQuery();
        if (rs2.next()) {
            PrimaryKeyInfo pk = new PrimaryKeyInfo();
            pk.setName(rs2.getString("CONSTRAINT_NAME"));
            table.setPrimaryKey(pk);
            ColumnInfo col = DBUtils.getColumnByName(table, rs2.getString("COLUMN_NAME"));
            PKColumnInfo pkcol = new PKColumnInfo();
            pkcol.setColumn(col);
            pk.getPKColumns().add(pkcol);
        }
        SQLUtils.cleanup((ResultSet)rs2, (Statement)stmt2);
    }

    private static void fillIndexInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toLowerCase();
        String sql = " select * from pg_indexes where schemaname='public' and tablename= ?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            PreparedStatement substmt;
            ResultSet subrs;
            String indexName = rs.getString("indexname");
            if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = new IndexInfo();
            index.setName(indexName);
            String indexdef = rs.getString("indexdef");
            if (indexdef != null) {
                index.setUnique(indexdef.indexOf("UNIQUE") > 0);
            }
            if ((subrs = (substmt = DBUtils.createPreparedStatement(cn, sql = "select * from  information_schema.table_constraints where constraint_name = ? and table_name = ?", new String[]{index.getName(), tableName})).executeQuery()).next()) {
                index.setExtendedProperty("HAS_CONSTRAINT", index.getName());
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            table.getIndexes().add(index);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillFKInfo(Connection cn, AbstractTableInfo table) throws SQLException {
    }

    protected static SQLType getSQLType(String typeName) {
        if (typeName.equals("varchar")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("numeric")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("date")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("timestamp(6)")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("timestamp")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("bytea")) {
            return SQLType.BLOB;
        }
        if (typeName.equals("text")) {
            return SQLType.CLOB;
        }
        LogTool.logError("Unknown SQL TYPE:" + typeName + ", Treat as NVARCHAR", new Exception("Unknown SQL TYPE"));
        return SQLType.VARCHAR;
    }

    public static void adjustTables(Connection cn, AbstractTableInfo[] tables) throws SQLException {
        for (int i = 0; i < tables.length; ++i) {
            KingbaseDAOUtil.adjustTable(cn, tables[i]);
        }
    }

    public static void adjustTable(Connection cn, AbstractTableInfo table) throws SQLException {
    }
}

