/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.report;

import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportItem;
import com.kingdee.bos.tool.dbupdate.report.ForeignKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.IndexReportItem;
import com.kingdee.bos.tool.dbupdate.report.PrimaryKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import com.kingdee.bos.tool.dbupdate.ui.DBSynchronizerMessages;
import com.kingdee.util.StringUtils;

public class ReportUtil {
    private static final String SEM = ";";
    private static final String COL = ":";
    private static final String TAB = "  ";
    private static final String NEWLINE = "\n";
    private static final String COLUMN_OLD = "ColumnOld";
    private static final String COLUMN_NEW = "ColumnNew";
    private static final String COLUMN_NAME = "ColumnName";
    private static final String COLUMN_TYPE = "ColumnType";
    private static final String COLUMN_LENGTH = "ColumnLength";
    private static final String COLUMN_PRECISION = "ColumnPrecision";
    private static final String COLUMN_SCALE = "ColumnScale";
    private static final String COLUMN_ISNULL = "ColumnIsNull";
    private static final String COLUMN_DEFAULT = "ColumnDefault";
    private static final String PK_OLD = "PKOld";
    private static final String PK_NEW = "PKNew";
    private static final String PK_NAME = "PKName";
    private static final String PK_COLUMN_NAME = "PKColumnName";
    private static final String PK_SORT_TYPE = "PKSortType";
    private static final String INDEX_OLD = "IndexOld";
    private static final String INDEX_NEW = "IndexNew";
    private static final String INDEX_NAME = "IndexName";
    private static final String INDEX_COLUMN_NAME = "IndexColumnName";
    private static final String INDEX_SORT_TYPE = "IndexSortType";
    private static final String FK_OLD = "FKOld";
    private static final String FK_NEW = "FKNew";
    private static final String FK_NAME = "FKName";
    private static final String FK_PK_COLUMN_NAME = "FKPKColumnName";
    private static final String FK_FK_COLUMN_NAME = "FKFKColumnName";
    private static final String TEMP_TABLE_POSTFIX = "_TEMP";

    public static String getColumnCompareDesc(ColumnReportItem item) {
        StringBuffer sb = new StringBuffer();
        ColumnInfo oldColumn = item.getOldColumn();
        ColumnInfo newColumn = item.getNewColumn();
        if (newColumn != null) {
            sb.append(DBSynchronizerMessages.ColumnNew + COL + NEWLINE);
            if (newColumn.getName() != null) {
                sb.append(TAB + DBSynchronizerMessages.ColumnName + COL + newColumn.getName() + SEM + NEWLINE);
            }
            if (newColumn.getTypeName() != null) {
                sb.append(TAB + DBSynchronizerMessages.ColumnType + COL + newColumn.getTypeName().getName() + SEM + NEWLINE);
            }
            if (newColumn.getLength() >= 0) {
                sb.append(TAB + DBSynchronizerMessages.ColumnLength + COL + newColumn.getLength() + SEM + NEWLINE);
            }
            if (newColumn.getPrecision() >= 0) {
                sb.append(TAB + DBSynchronizerMessages.ColumnPrecision + COL + newColumn.getPrecision() + SEM + NEWLINE);
            }
            if (newColumn.getScale() >= 0) {
                sb.append(TAB + DBSynchronizerMessages.ColumnScale + COL + newColumn.getScale() + SEM + NEWLINE);
            }
            sb.append(TAB + DBSynchronizerMessages.ColumnIsNull + COL + newColumn.isNullable() + SEM + NEWLINE);
            if (newColumn.getDefaultValue() != null) {
                sb.append(TAB + DBSynchronizerMessages.ColumnDefault + COL + newColumn.getDefaultValue() + SEM + NEWLINE);
            }
            sb.append(NEWLINE);
        }
        if (oldColumn != null) {
            sb.append(DBSynchronizerMessages.ColumnOld + COL + NEWLINE);
            if (oldColumn.getName() != null) {
                sb.append(TAB + DBSynchronizerMessages.ColumnName + COL + oldColumn.getName() + SEM + NEWLINE);
            }
            if (oldColumn.getTypeName() != null) {
                sb.append(TAB + DBSynchronizerMessages.ColumnType + COL + oldColumn.getTypeName().getName() + SEM + NEWLINE);
            }
            if (oldColumn.getLength() >= 0) {
                sb.append(TAB + DBSynchronizerMessages.ColumnLength + COL + oldColumn.getLength() + SEM + NEWLINE);
            }
            if (oldColumn.getPrecision() >= 0) {
                sb.append(TAB + DBSynchronizerMessages.ColumnPrecision + COL + oldColumn.getPrecision() + SEM + NEWLINE);
            }
            if (oldColumn.getScale() >= 0) {
                sb.append(TAB + DBSynchronizerMessages.ColumnScale + COL + oldColumn.getScale() + SEM + NEWLINE);
            }
            sb.append(TAB + DBSynchronizerMessages.ColumnIsNull + COL + oldColumn.isNullable() + SEM + NEWLINE);
            if (oldColumn.getDefaultValue() != null) {
                sb.append(TAB + DBSynchronizerMessages.ColumnDefault + COL + oldColumn.getDefaultValue() + SEM + NEWLINE);
            }
        }
        return sb.toString();
    }

    public static String getPKCompareDesc(PrimaryKeyReportItem item) {
        int i;
        int n;
        StringBuffer sb = new StringBuffer();
        PrimaryKeyInfo oldPK = item.getOldPK();
        PrimaryKeyInfo newPK = item.getNewPK();
        if (newPK != null) {
            sb.append(DBSynchronizerMessages.PKNew + COL + NEWLINE);
            if (newPK.getName() != null) {
                sb.append(TAB + DBSynchronizerMessages.PKName + COL + newPK.getName() + SEM + NEWLINE);
            }
            if (newPK.getPKColumns() != null) {
                n = newPK.getPKColumns().size();
                for (i = 0; i < n; ++i) {
                    if (newPK.getPKColumns().get(i) == null) continue;
                    if (newPK.getPKColumns().get(i).getColumn() != null && newPK.getPKColumns().get(i).getColumn().getName() != null) {
                        sb.append(TAB + DBSynchronizerMessages.PKColumnName + COL + newPK.getPKColumns().get(i).getColumn().getName() + SEM + NEWLINE);
                    }
                    if (newPK.getPKColumns().get(i).getSortType() == null || newPK.getPKColumns().get(i).getSortType().getName() == null) continue;
                    sb.append(TAB + DBSynchronizerMessages.PKSortType + COL + newPK.getPKColumns().get(i).getSortType().getName() + SEM + NEWLINE);
                }
            }
            sb.append(NEWLINE);
        }
        if (oldPK != null) {
            sb.append(DBSynchronizerMessages.PKOld + COL + NEWLINE);
            if (oldPK.getName() != null) {
                sb.append(TAB + DBSynchronizerMessages.PKName + COL + oldPK.getName() + SEM + NEWLINE);
            }
            if (oldPK.getPKColumns() != null) {
                n = oldPK.getPKColumns().size();
                for (i = 0; i < n; ++i) {
                    if (oldPK.getPKColumns().get(i) == null) continue;
                    if (oldPK.getPKColumns().get(i).getColumn() != null && oldPK.getPKColumns().get(i).getColumn().getName() != null) {
                        sb.append(TAB + DBSynchronizerMessages.PKColumnName + COL + oldPK.getPKColumns().get(i).getColumn().getName() + SEM + NEWLINE);
                    }
                    if (oldPK.getPKColumns().get(i).getSortType() == null || oldPK.getPKColumns().get(i).getSortType().getName() == null) continue;
                    sb.append(TAB + DBSynchronizerMessages.PKSortType + COL + oldPK.getPKColumns().get(i).getSortType().getName() + SEM + NEWLINE);
                }
            }
        }
        return sb.toString();
    }

    public static String getIndexCompareDesc(IndexReportItem item) {
        int i;
        int n;
        StringBuffer sb = new StringBuffer();
        IndexInfo oldIndex = item.getOldIndex();
        IndexInfo newIndex = item.getNewIndex();
        if (newIndex != null) {
            sb.append(DBSynchronizerMessages.IndexNew + COL + NEWLINE);
            if (newIndex.getName() != null) {
                sb.append(TAB + DBSynchronizerMessages.IndexName + COL + newIndex.getName() + SEM + NEWLINE);
            }
            if (newIndex.getIndexColumns() != null) {
                n = newIndex.getIndexColumns().size();
                for (i = 0; i < n; ++i) {
                    if (newIndex.getIndexColumns().get(i) == null) continue;
                    if (newIndex.getIndexColumns().get(i).getColumn() != null && newIndex.getIndexColumns().get(i).getColumn().getName() != null) {
                        sb.append(TAB + DBSynchronizerMessages.IndexColumnName + COL + newIndex.getIndexColumns().get(i).getColumn().getName() + SEM + NEWLINE);
                    }
                    if (newIndex.getIndexColumns().get(i).getSortType() == null || newIndex.getIndexColumns().get(i).getSortType().getName() == null) continue;
                    sb.append(TAB + DBSynchronizerMessages.IndexSortType + COL + newIndex.getIndexColumns().get(i).getSortType().getName() + SEM + NEWLINE);
                }
            }
            sb.append(NEWLINE);
        }
        if (oldIndex != null) {
            sb.append(DBSynchronizerMessages.IndexOld + COL + NEWLINE);
            if (oldIndex.getName() != null) {
                sb.append(TAB + DBSynchronizerMessages.IndexName + COL + oldIndex.getName() + SEM + NEWLINE);
            }
            if (oldIndex.getIndexColumns() != null) {
                n = oldIndex.getIndexColumns().size();
                for (i = 0; i < n; ++i) {
                    if (oldIndex.getIndexColumns().get(i) == null) continue;
                    if (oldIndex.getIndexColumns().get(i).getColumn() != null && oldIndex.getIndexColumns().get(i).getColumn().getName() != null) {
                        sb.append(TAB + DBSynchronizerMessages.IndexColumnName + COL + oldIndex.getIndexColumns().get(i).getColumn().getName() + SEM + NEWLINE);
                    }
                    if (oldIndex.getIndexColumns().get(i).getSortType() == null || oldIndex.getIndexColumns().get(i).getSortType().getName() == null) continue;
                    sb.append(TAB + DBSynchronizerMessages.IndexSortType + COL + oldIndex.getIndexColumns().get(i).getSortType().getName() + SEM + NEWLINE);
                }
            }
        }
        return sb.toString();
    }

    public static String getFKCompareDesc(ForeignKeyReportItem item) {
        int i;
        int n;
        StringBuffer sb = new StringBuffer();
        ForeignKeyInfo oldFK = item.getOldFK();
        ForeignKeyInfo newFK = item.getNewFK();
        if (newFK != null) {
            sb.append(DBSynchronizerMessages.FKNew + COL + NEWLINE);
            if (newFK.getName() != null) {
                sb.append(TAB + DBSynchronizerMessages.FKName + COL + newFK.getName() + SEM + NEWLINE);
            }
            if (newFK.getFKColumnPairs() != null) {
                n = newFK.getFKColumnPairs().size();
                for (i = 0; i < n; ++i) {
                    if (newFK.getFKColumnPairs().get(i) == null) continue;
                    if (newFK.getFKColumnPairs().get(i).getPrimaryKeyColumn() != null && newFK.getFKColumnPairs().get(i).getPrimaryKeyColumn().getName() != null) {
                        sb.append(TAB + DBSynchronizerMessages.FKPKColumnName + COL + newFK.getFKColumnPairs().get(i).getPrimaryKeyColumn().getName() + SEM + NEWLINE);
                    }
                    if (newFK.getFKColumnPairs().get(i).getForeignKeyColumn() == null || newFK.getFKColumnPairs().get(i).getForeignKeyColumn().getName() == null) continue;
                    sb.append(TAB + DBSynchronizerMessages.FKFKColumnName + COL + newFK.getFKColumnPairs().get(i).getForeignKeyColumn().getName() + SEM + NEWLINE);
                }
            }
            sb.append(NEWLINE);
        }
        if (oldFK != null) {
            sb.append(DBSynchronizerMessages.FKOld + COL + NEWLINE);
            if (oldFK.getName() != null) {
                sb.append(TAB + DBSynchronizerMessages.FKName + COL + oldFK.getName() + SEM + NEWLINE);
            }
            if (oldFK.getFKColumnPairs() != null) {
                n = oldFK.getFKColumnPairs().size();
                for (i = 0; i < n; ++i) {
                    if (oldFK.getFKColumnPairs().get(i) == null) continue;
                    if (oldFK.getFKColumnPairs().get(i).getPrimaryKeyColumn() != null && oldFK.getFKColumnPairs().get(i).getPrimaryKeyColumn().getName() != null) {
                        sb.append(TAB + DBSynchronizerMessages.FKPKColumnName + COL + oldFK.getFKColumnPairs().get(i).getPrimaryKeyColumn().getName() + SEM + NEWLINE);
                    }
                    if (oldFK.getFKColumnPairs().get(i).getForeignKeyColumn() == null || oldFK.getFKColumnPairs().get(i).getForeignKeyColumn().getName() == null) continue;
                    sb.append(TAB + DBSynchronizerMessages.FKFKColumnName + COL + oldFK.getFKColumnPairs().get(i).getForeignKeyColumn().getName() + SEM + NEWLINE);
                }
            }
        }
        return sb.toString();
    }

    public static String getTempTableName(TableReportItem item) {
        return ReportUtil.getTempTableName(item.getItemName());
    }

    public static String getTempTableName(String tableName) {
        String tempTableName = tableName;
        if (tempTableName == null) {
            return "";
        }
        if (tempTableName.length() <= 25) {
            tempTableName = tempTableName + TEMP_TABLE_POSTFIX;
        } else {
            tempTableName = StringUtils.abbreviate((String)tempTableName, (int)25);
            tempTableName = tempTableName + TEMP_TABLE_POSTFIX;
        }
        return tempTableName;
    }
}

