/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.ui.wizard;

import com.kingdee.bos.metadata.management.DataSourceInfo;
import com.kingdee.bos.metadata.management.JdbcDriverType;
import com.kingdee.bos.tool.dbupdate.data.SyncSolutionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class FileProcess {
    private static final String TAG_ROOT = "syncSolution";
    private static final String TAG_DATASOURCE = "datasource";
    private static final String TAG_DATASOURCE_MASTER = "master";
    private static final String TAG_DATASOURCE_TARGET = "target";
    private static final String ATT_DS_DRIVER_NAME = "driverName";
    private static final String ATT_DS_HOST = "host";
    private static final String ATT_DS_PORT_NUMBER = "portNumber";
    private static final String ATT_DS_DB_NAME = "dbName";
    private static final String ATT_DS_USER = "user";
    private static final String ATT_DS_P = "password";

    public static void store(SyncSolutionInfo solution, OutputStream out) throws IOException {
        Element root = new Element(TAG_ROOT);
        Element dsElement = new Element(TAG_DATASOURCE);
        root.addContent((Content)dsElement);
        Element masterDs = new Element(TAG_DATASOURCE_MASTER);
        FileProcess.setDsElementAttr(masterDs, solution.getMasterDs());
        dsElement.addContent((Content)masterDs);
        Element targetDs = new Element(TAG_DATASOURCE_TARGET);
        FileProcess.setDsElementAttr(targetDs, solution.getTargetDs());
        dsElement.addContent((Content)targetDs);
        Format format = Format.getRawFormat();
        format.setIndent("    ");
        XMLOutputter outputter = new XMLOutputter(format);
        Document doc = new Document(root);
        outputter.output(doc, out);
    }

    private static Element setDsElementAttr(Element elementDs, DataSourceInfo dsInfo) {
        elementDs.setAttribute(ATT_DS_DRIVER_NAME, dsInfo.getDriverType() == null ? "" : dsInfo.getDriverType().getName());
        elementDs.setAttribute(ATT_DS_HOST, dsInfo.getHost() == null ? "" : dsInfo.getHost());
        elementDs.setAttribute(ATT_DS_PORT_NUMBER, dsInfo.getPort() == 0 ? "" : dsInfo.getPort() + "");
        elementDs.setAttribute(ATT_DS_DB_NAME, dsInfo.getDbName() == null ? "" : dsInfo.getDbName());
        elementDs.setAttribute(ATT_DS_USER, dsInfo.getUser() == null ? "" : dsInfo.getUser());
        elementDs.setAttribute(ATT_DS_P, dsInfo.getPassword() == null ? "" : dsInfo.getPassword());
        return elementDs;
    }

    public static SyncSolutionInfo load(InputStream in) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(in);
        Element root = doc.getRootElement();
        Element ds = root.getChild(TAG_DATASOURCE);
        Element masterDsElement = ds.getChild(TAG_DATASOURCE_MASTER);
        DataSourceInfo masterDs = FileProcess.generateDsInfo(masterDsElement);
        Element targetDsElement = ds.getChild(TAG_DATASOURCE_TARGET);
        DataSourceInfo targetDs = FileProcess.generateDsInfo(targetDsElement);
        SyncSolutionInfo solution = new SyncSolutionInfo();
        solution.setMasterDs(masterDs);
        solution.setTargetDs(targetDs);
        return solution;
    }

    private static DataSourceInfo generateDsInfo(Element element) {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setDriverType(JdbcDriverType.getEnum((String)element.getAttribute(ATT_DS_DRIVER_NAME).getValue()));
        dsInfo.setDbName(element.getAttribute(ATT_DS_DB_NAME).getValue());
        dsInfo.setHost(element.getAttribute(ATT_DS_HOST).getValue());
        dsInfo.setPort(Integer.parseInt(element.getAttribute(ATT_DS_PORT_NUMBER).getValue()));
        dsInfo.setUser(element.getAttribute(ATT_DS_USER).getValue());
        dsInfo.setPassword(element.getAttribute(ATT_DS_P).getValue());
        return dsInfo;
    }
}

