/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.function;

import com.kingdee.bos.tool.function.Func1;
import com.kingdee.bos.tool.function.Functions;
import com.kingdee.bos.tool.function.Preconditions;
import com.kingdee.bos.tool.function.Predicate;
import com.kingdee.bos.tool.function.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Files {
    public static File ofFile(String filePath) {
        return new File(filePath);
    }

    public static File ofFile(File parent, String filePath) {
        return new File(parent, filePath);
    }

    public static File ofFile(File parent, String ... childs) {
        return new File(parent, Strings.join(childs, "/"));
    }

    public static File ofFile(String parent, String filePath) {
        return new File(parent, filePath);
    }

    public static File ofFile(String parent, String ... childs) {
        return new File(parent, Strings.join(childs, "/"));
    }

    public static boolean exist(File file) {
        return file.exists();
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                file.delete();
            } else {
                if (file.listFiles().length > 0) {
                    File[] delFile = file.listFiles();
                    int i = file.listFiles().length;
                    for (int j = 0; j < i; ++j) {
                        Files.deleteFile(delFile[j]);
                    }
                }
                file.delete();
            }
        }
    }

    public static void listALlFiles(File parentDir, List<File> list, Predicate<File> predicate) {
        File[] fs;
        Preconditions.checkNotNull(parentDir, "\u53c2\u6570parentDir\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkNotNull(list, "\u53c2\u6570list\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkNotNull(predicate, "\u53c2\u6570predicate\u4e0d\u80fd\u4e3a\u7a7a");
        if (!parentDir.exists()) {
            return;
        }
        for (File file : fs = parentDir.listFiles()) {
            if (file.isFile() && predicate.apply(file)) {
                list.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            Files.listALlFiles(file, list, predicate);
        }
    }

    public static List<File> getAllFiles(File parentDir, Predicate<File> predicate) {
        ArrayList<File> list = new ArrayList<File>();
        Files.listALlFiles(parentDir, list, predicate);
        Functions.debug(Strings.format("getAllFiles: parentDir=%s children_file_num=%s", parentDir, list.size()));
        return list;
    }

    public static List<File> getAllFiles(File parentDir) {
        ArrayList<File> list = new ArrayList<File>();
        Files.listALlFiles(parentDir, list, Predicate.alwaysTrue);
        return list;
    }

    public static void listALlFiles(File parentDir, List<File> list) {
        Files.listALlFiles(parentDir, list, Predicate.alwaysTrue);
    }

    public static String getFileRelativePath(File source, String parentPath) {
        return Functions.invokeAsParam(source.getAbsolutePath().substring(Files.ofFile(parentPath).getAbsolutePath().length()), new Func1<String, String>(){

            @Override
            public String invoke(String relPath) {
                return relPath.startsWith("\\") ? Strings.dropFirstChar(relPath) : relPath;
            }
        });
    }
}

