/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.tool.multipageeditor.AbstractPage;
import com.kingdee.bos.tool.multipageeditor.common.CommonEditor;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;

public abstract class AbstractEditor
extends CommonEditor {
    private boolean modify = false;
    private boolean needSync = false;
    protected int currentPage = 0;
    protected IFile file;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ide.multipageeditor.AbstractEditor");

    @Override
    public void doSaveAs() {
    }

    protected abstract void createTabPages();

    public void setNeedSync(boolean needSync) {
        this.needSync = needSync;
    }

    public boolean isNeedSync() {
        return this.needSync;
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setModify(boolean modify) {
        this.modify = modify;
        this.firePropertyChange(257);
    }

    protected final void createPages() {
        this.createTabPages();
    }

    public boolean isDirty() {
        return this.modify;
    }

    public void refreshPages() {
        logger.debug((Object)"refreshPages");
        if (this.fPages == null) {
            return;
        }
        for (int i = 0; i < this.fPages.size(); ++i) {
            if (!(this.fPages.get(i) instanceof AbstractPage)) continue;
            ((AbstractPage)this.fPages.get(i)).refreshPage();
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        String title = null;
        String titleTip = null;
        title = input.getName();
        titleTip = input.getToolTipText();
        if (input instanceof IFileEditorInput) {
            IFile file;
            this.file = file = ((IFileEditorInput)input).getFile();
        }
        if (title != null) {
            this.setPartName(title);
        }
        if (titleTip != null) {
            this.setTitleToolTip(titleTip);
        }
        super.init(site, input);
    }

    @Override
    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex > this.getPageCount()) {
            newPageIndex = this.getPageCount() - 1;
        }
        this.currentPage = newPageIndex;
        if (this.isNeedSync()) {
            this.refreshPages();
            this.setNeedSync(false);
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        this.setModify(false);
        this.setNeedSync(false);
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    protected int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return super.isSaveOnCloseNeeded();
    }
}

