/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.tool.multipageeditor.BasePage;
import com.kingdee.bos.tool.multipageeditor.BasePageSection;
import com.kingdee.bos.tool.multipageeditor.Messages;
import com.kingdee.util.HierarchyTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class TreeWithButtonsSection
extends BasePageSection {
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected HierarchyTreeNode root;
    protected int treeStyle = 66304;
    protected Hashtable buttons = new Hashtable();
    protected String[] buttonNames;
    protected int sectionHeightSpan = 1;
    protected int type = 256;
    protected int treeHeightHint = -1;
    protected int buttonWidthHint = 80;
    protected SelectionListener btnListener = new InnerSelectionAdapter();
    protected ITreeContentProvider contentProvider = new InnerContentProvider();
    protected ILabelProvider labelProvider = new InnerLabelProvider();
    public final String IMPORTER = Messages.TreeWithButtonsSection_DaoRu;
    public final String ADD = Messages.TreeWithButtonsSection_ZengJia;
    public final String REMOVE = Messages.TreeWithButtonsSection_ShanChu;
    public final String UP = Messages.TreeWithButtonsSection_XiangShang;
    public final String DOWN = Messages.TreeWithButtonsSection_XiangXia;
    public final String OVERRIDE = Messages.TreeWithButtonsSection_FuGai;

    public TreeWithButtonsSection(BasePage page, String title, String desc) {
        super(page, title, desc);
        this.root = new HierarchyTreeNode();
    }

    public void setType(int type) {
        if (type == 256 || type != 512) {
            // empty if block
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setTreeStyle(int i) {
        this.treeStyle = i;
    }

    public int getTreeStyle() {
        return this.treeStyle;
    }

    public void setButtonWidthHint(int i) {
        this.buttonWidthHint = i;
    }

    public int getButtonWidthHint() {
        return this.buttonWidthHint;
    }

    public void setButtonNames(String[] buttonNames) {
        this.buttonNames = new String[buttonNames.length];
        System.arraycopy(buttonNames, 0, this.buttonNames, 0, buttonNames.length);
    }

    public String[] getButtonNames() {
        return this.buttonNames;
    }

    public Button getButtonBy(String buttonName) {
        return (Button)this.buttons.get(buttonName);
    }

    @Override
    protected Composite createClient(Composite parent) {
        super.createClient(parent);
        Composite container = this.widgetFactory.createComposite(parent);
        GridData griddata = new GridData(1808);
        container.setLayoutData((Object)griddata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.beforeCreateWidgets(container);
        Composite treeArea = this.widgetFactory.createComposite(container);
        layout = new GridLayout();
        layout.numColumns = this.type == 256 ? 2 : 1;
        treeArea.setLayout((Layout)layout);
        griddata = new GridData(1808);
        treeArea.setLayoutData((Object)griddata);
        this.createTree(treeArea);
        this.createButtons(treeArea);
        this.widgetFactory.paintBordersFor(treeArea);
        this.widgetFactory.paintBordersFor(container);
        this.afterCreateWidgets(container);
        return container;
    }

    protected void createTree(Composite container) {
        this.refreshRoot();
        this.tree = this.widgetFactory.createTree(container, this.treeStyle);
        GridData griddata = new GridData(1808);
        if (this.treeHeightHint != -1) {
            griddata.heightHint = this.treeHeightHint;
        }
        this.tree.setLayoutData((Object)griddata);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeWithButtonsSection.this.handleTreeDoubleClicked(event);
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeWithButtonsSection.this.handleTreeSelectionChanged(event);
            }
        });
        this.treeViewer.expandAll();
    }

    protected Composite createButtons(Composite container) {
        Composite btnContainer = this.widgetFactory.createComposite(container);
        GridData data = new GridData();
        if (this.type == 256) {
            data.widthHint = this.buttonWidthHint;
        }
        btnContainer.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        if (this.type == 256) {
            layout.numColumns = 1;
            layout.marginWidth = 2;
            layout.marginHeight = 2;
        } else {
            layout.numColumns = this.buttonNames.length;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        btnContainer.setLayout((Layout)layout);
        GridData buttonAreaGD = new GridData(1040);
        btnContainer.setLayoutData((Object)buttonAreaGD);
        for (int i = 0; i < this.buttonNames.length; ++i) {
            Button btn = this.widgetFactory.createButton(btnContainer, this.buttonNames[i], 8);
            this.buttons.put(this.buttonNames[i], btn);
            data = new GridData();
            if (this.type == 256) {
                data.horizontalAlignment = 4;
            } else {
                data.widthHint = this.buttonWidthHint;
            }
            btn.setLayoutData((Object)data);
            btn.addSelectionListener(this.btnListener);
        }
        return btnContainer;
    }

    protected void handleButtonClicked(String buttonName, Button button, SelectionEvent e) {
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        if (this.isReadOnly()) {
            return;
        }
        if (this.contextContainer != null) {
            if (this.contextContainer.getObjectValue() == null) {
                for (int i = 0; i < this.buttonNames.length; ++i) {
                    this.getButtonBy(this.buttonNames[i]).setEnabled(false);
                }
            } else {
                for (int i = 0; i < this.buttonNames.length; ++i) {
                    this.getButtonBy(this.buttonNames[i]).setEnabled(true);
                }
            }
        }
        this.refreshTree();
    }

    protected abstract void beforeCreateWidgets(Composite var1);

    protected abstract void afterCreateWidgets(Composite var1);

    protected void refreshTree() {
        this.refreshRoot();
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)this.root);
        }
    }

    protected abstract void refreshRoot();

    protected Image getImage(HierarchyTreeNode node) {
        return null;
    }

    protected String getText(HierarchyTreeNode node) {
        String text = ((IObjectValue)node.getUserObject()).getString("name");
        if (text == null) {
            text = node.toString();
        }
        return text;
    }

    protected HierarchyTreeNode getSelectedObject() {
        return (HierarchyTreeNode)((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    protected List getSelectedObjects() {
        return ((StructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void handleTreeDoubleClicked(DoubleClickEvent event) {
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent event) {
    }

    protected void selectTreeItem(int index) {
        if (index >= this.tree.getItemCount()) {
            index = this.tree.getItemCount() - 1;
        }
        if (index < 0) {
            index = 0;
        }
        TreeItem[] selectedItem = new TreeItem[1];
        if (this.tree.getItems().length == 0) {
            return;
        }
        selectedItem[0] = this.tree.getItems()[index];
        this.tree.setSelection(selectedItem);
    }

    protected void selectTreeItems(int[] indexs) {
        if (this.tree.getItemCount() == 0 || this.tree.getItems().length == 0) {
            return;
        }
        ArrayList<TreeItem> selectedItems = new ArrayList<TreeItem>();
        for (int index = 0; index < indexs.length; ++index) {
            if (index < 0 || index >= this.tree.getItemCount() || this.tree.getItems()[indexs[index]] == null) continue;
            selectedItems.add(this.tree.getItems()[indexs[index]]);
        }
        if (selectedItems.size() == 0) {
            selectedItems.add(this.tree.getItems()[this.tree.getItemCount() - 1]);
        }
        TreeItem[] selectedItem = new TreeItem[selectedItems.size()];
        for (int i = 0; i < selectedItems.size(); ++i) {
            selectedItem[i] = (TreeItem)selectedItems.get(i);
        }
        this.tree.setSelection(selectedItem);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshTree();
    }

    private class InnerSelectionAdapter
    extends SelectionAdapter {
        private InnerSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button btn = (Button)e.getSource();
            Enumeration enu = TreeWithButtonsSection.this.buttons.keys();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                if (btn != TreeWithButtonsSection.this.buttons.get(key)) continue;
                TreeWithButtonsSection.this.handleButtonClicked(key, btn, e);
                break;
            }
        }
    }

    private class InnerLabelProvider
    extends LabelProvider {
        private InnerLabelProvider() {
        }

        public Image getImage(Object element) {
            return TreeWithButtonsSection.this.getImage((HierarchyTreeNode)element);
        }

        public String getText(Object element) {
            return TreeWithButtonsSection.this.getText((HierarchyTreeNode)element);
        }
    }

    private class InnerContentProvider
    implements ITreeContentProvider {
        private InnerContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            HierarchyTreeNode node = (HierarchyTreeNode)parentElement;
            return node.childrenArray();
        }

        public Object getParent(Object element) {
            HierarchyTreeNode node = (HierarchyTreeNode)element;
            return node.getParent();
        }

        public boolean hasChildren(Object element) {
            return !((HierarchyTreeNode)element).isLeaf();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

