/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.multipageeditor.common.CommonPage;
import com.kingdee.bos.tool.multipageeditor.common.ICommonPage;
import com.kingdee.bos.tool.multipageeditor.common.ICommonPageSection;
import com.kingdee.bos.tool.multipageeditor.common.ToggleControl;
import com.kingdee.bos.tool.multipageeditor.common.WidgetFactory;
import com.kingdee.bos.tool.widgets.HrefText;
import com.kingdee.bos.utils.FileAccessSupport;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public abstract class CommonPageSection
extends ContentViewer
implements ICommonPageSection {
    public static final int SELECTION = 1;
    private String fHeaderColorKey;
    protected static final int WHINT = 200;
    protected static final int LEFT_SEC_WHINT = 110;
    private String fHeaderText;
    protected int fHSpan;
    protected Composite fSectionControl;
    protected Label fHeader;
    protected Control fSeparator;
    private String fDescription;
    protected Composite fParent;
    protected Label fDescriptionLabel;
    protected ToggleControl fToggle;
    protected boolean fReadOnly;
    private boolean fAddSeparator;
    private boolean fDescriptionPainted;
    private boolean fHeaderPainted;
    private boolean fCollapsable;
    private boolean fCollapsed;
    protected WidgetFactory widgetFactory;
    protected ICommonPage fPage;
    private Document dom;

    public CommonPageSection(CommonPage page) {
        this.fPage = page;
        this.widgetFactory = page.fWf;
        this.fHeaderColorKey = "__default__header__";
        this.fHSpan = 1;
        this.fAddSeparator = true;
        this.fDescriptionPainted = true;
        this.fHeaderPainted = true;
        this.fCollapsable = true;
        this.fCollapsed = false;
        if (SWT.getPlatform().equals("motif")) {
            this.fDescriptionPainted = false;
        }
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    protected abstract Composite createClient(Composite var1);

    @Override
    public Control createControl(Composite composite) {
        this.fParent = composite;
        Composite composite1 = this.widgetFactory.createComposite(this.fParent);
        SectionLayout sectionlayout = new SectionLayout();
        composite1.setLayout((Layout)sectionlayout);
        composite1.setData((Object)this);
        if (this.fHeaderPainted) {
            Color color = this.widgetFactory.getColor(this.getHeaderColorKey());
            this.fHeader = this.widgetFactory.createHeadingLabel(composite1, this.getHeaderText(), color, 64);
            if (this.fCollapsable) {
                this.fToggle = new ToggleControl(composite1, 0);
                FontData[] afontdata = JFaceResources.getBannerFont().getFontData();
                if (afontdata != null) {
                    this.fToggle.setHeight(afontdata[0].getHeight());
                }
                this.fToggle.setBackground(this.widgetFactory.getBackgroundColor());
                this.fToggle.setActiveDecorationColor(this.widgetFactory.getHyperlinkColor());
                this.fToggle.setDecorationColor(this.widgetFactory.getColor("__compSep"));
                this.fToggle.setActiveCursor(this.widgetFactory.getHyperlinkCursor());
                this.fToggle.setName(this.getHeaderText());
                this.fToggle.setDescription(this.getDescription());
                this.fToggle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionevent) {
                        boolean flag = CommonPageSection.this.fToggle.getSelection();
                        CommonPageSection.this.setCollapsed(flag);
                    }
                });
            }
        }
        if (this.fAddSeparator) {
            this.fSeparator = this.widgetFactory.createCompositeSeparator(composite1);
        }
        if (this.fDescriptionPainted && this.fDescription != null) {
            this.fDescriptionLabel = this.widgetFactory.createLabel(composite1, this.fDescription, 64);
        }
        this.fSectionControl = this.createClient(composite1);
        this.setCollapsed(this.fCollapsed);
        this.refresh();
        return composite1;
    }

    @Override
    public ISelectionChangedListener createTblSelChngLstnr() {
        ISelectionChangedListener iselectionchangedlistener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionchangedevent) {
                CommonPageSection.this.handleTableSelectionChanged(selectionchangedevent);
            }
        };
        return iselectionchangedlistener;
    }

    public void reflow() {
        Composite composite;
        if (this.fSectionControl != null && !this.fSectionControl.isDisposed() && (composite = this.fSectionControl.getParent()) != null && !composite.isDisposed()) {
            composite.layout(true);
            Composite composite1 = composite.getParent();
            if (composite1 != null && !composite1.isDisposed()) {
                composite1.layout(true);
            }
        }
    }

    protected CCombo createCombo(Composite composite, String text) {
        return this.createCombo(composite, text, null);
    }

    protected CCombo createCombo(Composite composite, String text, boolean needAttachment) {
        return this.createCombo(composite, text, needAttachment, null);
    }

    protected CCombo createCombo(Composite composite, String text, String toolTips) {
        Label label = this.widgetFactory.createLabel(composite, text);
        if (!StringUtils.isEmpty((String)toolTips)) {
            label.setToolTipText(toolTips);
        }
        CCombo ccombo = this.widgetFactory.createCCombo(composite);
        GridData griddata = new GridData(772);
        ccombo.setLayoutData((Object)griddata);
        return ccombo;
    }

    protected CCombo createCombo(Composite composite, String text, boolean needAttachment, String toolTips) {
        CCombo combo = this.createCombo(composite, text, toolTips);
        if (needAttachment) {
            this.widgetFactory.createLabel(composite, "");
        }
        return combo;
    }

    protected CCombo createCombo(Composite composite, String text, int span) {
        this.widgetFactory.createLabel(composite, text);
        CCombo ccombo = this.widgetFactory.createCCombo(composite);
        GridData griddata = new GridData(772);
        griddata.horizontalSpan = span;
        ccombo.setLayoutData((Object)griddata);
        return ccombo;
    }

    protected Button createCheckBox(Composite composite, String text) {
        this.widgetFactory.createLabel(composite, "");
        Button bn = this.widgetFactory.createCheckBox(composite, text);
        GridData griddata = new GridData(772);
        bn.setLayoutData((Object)griddata);
        return bn;
    }

    protected Text createText(int style, Composite composite, String text) {
        this.widgetFactory.createLabel(composite, text);
        Text theText = this.widgetFactory.createText(composite, "", style);
        GridData griddata = new GridData(772);
        theText.setLayoutData((Object)griddata);
        return theText;
    }

    protected Text createText(Composite composite, String text) {
        return this.createText(composite, text, 1);
    }

    protected Text createText(Composite composite, String text, int horizontalSpan) {
        this.widgetFactory.createLabel(composite, text);
        Text theText = this.widgetFactory.createText(composite, "");
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = horizontalSpan;
        theText.setLayoutData((Object)griddata);
        return theText;
    }

    protected Text createText(Composite composite, String text, boolean needAttachment) {
        Text theText = this.createText(composite, text);
        if (needAttachment) {
            this.widgetFactory.createLabel(composite, "");
        }
        return theText;
    }

    protected Text createText(Composite composite, int horizontalSpan) {
        Text text = this.widgetFactory.createText(composite, "");
        GridData griddata = new GridData(772);
        griddata.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)griddata);
        return text;
    }

    protected HrefText createHrefText(Composite composite, String text) {
        return this.createHrefText(composite, text, 1, null);
    }

    protected HrefText createHrefText(Composite composite, String text, String toolTips) {
        return this.createHrefText(composite, text, 1, toolTips);
    }

    protected HrefText createHrefText(Composite composite, String text, int horizontalSpan, String toolTips) {
        Label label = this.widgetFactory.createLabel(composite, text);
        if (!StringUtils.isEmpty((String)toolTips)) {
            label.setToolTipText(toolTips);
        }
        HrefText theText = this.widgetFactory.createHrefText(composite, "");
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = horizontalSpan;
        theText.setLayoutData(griddata);
        return theText;
    }

    protected HrefText createHrefText(Composite composite, String text, int horizontalSpan) {
        return this.createHrefText(composite, text, horizontalSpan, null);
    }

    protected HrefText createHrefText(Composite composite, String text, boolean needAttachment) {
        HrefText theText = this.createHrefText(composite, text);
        if (needAttachment) {
            this.widgetFactory.createLabel(composite, "");
        }
        return theText;
    }

    protected HrefText createHrefText(Composite composite, int horizontalSpan) {
        HrefText text = this.widgetFactory.createHrefText(composite, "");
        GridData griddata = new GridData(772);
        griddata.horizontalSpan = horizontalSpan;
        text.setLayoutData(griddata);
        return text;
    }

    protected Text createTextArea(Composite composite, String labelText) {
        this.widgetFactory.createLabel(composite, labelText);
        Text text = this.widgetFactory.createTextArea(composite, "");
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Text createTextArea(Composite composite, String labelText, boolean needAttachment) {
        Text text = this.createTextArea(composite, labelText);
        if (needAttachment) {
            this.widgetFactory.createLabel(composite, "");
        }
        return text;
    }

    protected Button createPromptButton(Composite composite) {
        Button pBtn = this.widgetFactory.createButton(composite, "...", 0x800000);
        GridData gd = new GridData(128);
        gd.heightHint = 18;
        gd.widthHint = 18;
        pBtn.setLayoutData((Object)gd);
        return pBtn;
    }

    @Override
    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    public boolean doGlobalAction(String s) {
        return false;
    }

    @Override
    public final String getDescription() {
        return this.fDescription;
    }

    @Override
    public String getHeaderColorKey() {
        return this.fHeaderColorKey;
    }

    @Override
    public final String getHeaderText() {
        return this.fHeaderText;
    }

    @Override
    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    protected final void setAddSeparator(boolean flag) {
        this.fAddSeparator = flag;
    }

    private String trimNewLines(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                stringbuffer.append(' ');
                continue;
            }
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    protected void setDescription(String desc) {
        this.fDescription = this.trimNewLines(desc);
        if (this.fDescriptionLabel != null) {
            this.fDescriptionLabel.setText(desc);
        }
    }

    @Override
    public void setFocus() {
        if (this.fSectionControl != null && !this.fSectionControl.isDisposed()) {
            this.fSectionControl.getParent().setFocus();
        }
    }

    @Override
    public void setGridData(Control control) {
        GridData gridData = new GridData(770);
        gridData.widthHint = 200;
        gridData.horizontalSpan = this.getHSpan();
        control.setLayoutData((Object)gridData);
    }

    protected int getHSpan() {
        return this.fHSpan;
    }

    protected void setHSpan(int i) {
        this.fHSpan = i;
    }

    @Override
    public final void setHeaderColorKey(String s) {
        this.fHeaderColorKey = s;
    }

    protected final void setHeaderText(String s) {
        this.fHeaderText = s;
        if (this.fHeader != null) {
            this.fHeader.setText(this.fHeaderText);
        }
    }

    @Override
    public void setReadOnly(boolean flag) {
        this.fReadOnly = flag;
    }

    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        FontData[] afontdata;
        if (this.fHeader != null && !this.fHeader.isDisposed()) {
            this.fHeader.setFont(JFaceResources.getBannerFont());
        }
        if (this.fToggle != null && !this.fToggle.isDisposed() && (afontdata = JFaceResources.getBannerFont().getFontData()) != null) {
            this.fToggle.setHeight(afontdata[0].getHeight());
        }
        if (this.fSectionControl != null && !this.fSectionControl.isDisposed()) {
            this.reflow();
            this.fSectionControl.layout(true);
        }
    }

    @Override
    public final boolean getCollapsable() {
        return this.fCollapsable;
    }

    @Override
    public Control getControl() {
        return this.fSectionControl;
    }

    @Override
    public void setCollapsed(boolean flag) {
        this.fCollapsed = flag;
        if (this.fToggle != null) {
            this.fToggle.setSelection(flag);
            this.reflow();
            if (this.fDescriptionLabel != null) {
                this.fDescriptionLabel.setVisible(!flag);
            }
            if (this.fSectionControl != null) {
                this.fSectionControl.setVisible(!flag);
            }
        }
    }

    @Override
    public final void setCollapsable(boolean flag) {
        this.fCollapsable = flag;
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent selectionchangedevent) {
    }

    @Override
    public ICommonPage getPage() {
        return this.fPage;
    }

    @Override
    public IMDSourceEditor getEditor() {
        return this.fPage.getEditor();
    }

    public void setEnabled(boolean flag) {
        this.fToggle.setEnabled(flag);
    }

    protected boolean isAccessEnabled(FLAG op, Object vo) {
        FileAccessSupport support = FileAccessSupport.getInstance(this.getEditor().getMDProject());
        if (support != null) {
            IMDFile mdFile = this.getEditor().getMDFile();
            if (FLAG.ADD.equals((Object)op)) {
                return support.canAddField(mdFile);
            }
            if (FLAG.DELETE.equals((Object)op)) {
                return support.canDeleteField(mdFile, vo);
            }
            if (FLAG.MODIFY.equals((Object)op)) {
                return support.canModifyField(mdFile, vo);
            }
        }
        return false;
    }

    protected Object getOwnPropertyAdapter(String key) {
        return FileAccessSupport.makeUserDefinedAdapterWithFalse();
    }

    protected Document getDom() {
        if (this.dom == null) {
            this.dom = this.createDom();
        }
        return this.dom;
    }

    protected Document createDom() {
        try {
            InputStream input = this.getEditor().getMDFile().getLibContent();
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(input);
            input.close();
            return doc;
        }
        catch (IOException e) {
            LogTool.logInfo("\u88c5\u8f7d\u6587\u4ef6\u5f02\u5e38", e);
        }
        catch (JDOMException e) {
            LogTool.logInfo("JDOM\u5f02\u5e38", e);
        }
        return null;
    }

    protected static enum FLAG {
        ADD,
        DELETE,
        MODIFY;

    }

    class SectionLayout
    extends Layout {
        int vspacing = 3;
        int sepHeight = 2;

        protected Point computeSize(Composite composite, int i, int j, boolean flag) {
            int k = 0;
            int l = 0;
            int i1 = 0;
            int j1 = 0;
            if (i != -1) {
                k = i;
            }
            if (j != -1) {
                l = j;
            }
            i1 = k;
            if (CommonPageSection.this.fSectionControl != null) {
                Point point = CommonPageSection.this.fSectionControl.computeSize(-1, -1, flag);
                if (k == 0) {
                    i1 = k = point.x;
                }
                if (l == 0) {
                    l = point.y;
                }
            }
            Point point1 = null;
            if (CommonPageSection.this.fCollapsable && CommonPageSection.this.fToggle != null) {
                point1 = CommonPageSection.this.fToggle.computeSize(-1, -1, flag);
            }
            if (j == -1 && CommonPageSection.this.fHeaderPainted && CommonPageSection.this.fHeader != null) {
                int k1 = i1;
                if (point1 != null) {
                    k1 = i1 - point1.x - 5;
                }
                Point point3 = CommonPageSection.this.fHeader.computeSize(k1, -1, flag);
                l += point3.y;
                j1 = point3.y;
                l += this.vspacing;
            }
            if (j == -1 && CommonPageSection.this.fAddSeparator) {
                l += this.sepHeight;
                l += this.vspacing;
                j1 += this.vspacing + this.sepHeight;
            }
            if (j == -1 && CommonPageSection.this.fDescriptionPainted && CommonPageSection.this.fDescriptionLabel != null) {
                Point point2 = CommonPageSection.this.fDescriptionLabel.computeSize(i1, -1, flag);
                l += point2.y;
                l += this.vspacing;
            }
            if (CommonPageSection.this.fToggle != null && CommonPageSection.this.fToggle.getSelection()) {
                l = j1;
            }
            return new Point(k, l);
        }

        protected void layout(Composite composite, boolean flag) {
            int i = composite.getClientArea().width;
            int j = composite.getClientArea().height;
            int k = 0;
            Point point = null;
            if (CommonPageSection.this.fCollapsable) {
                point = CommonPageSection.this.fToggle.computeSize(-1, -1, flag);
            }
            if (CommonPageSection.this.fHeaderPainted && CommonPageSection.this.fHeader != null) {
                int l = i;
                if (point != null) {
                    l = i - point.x - 5;
                }
                Point point1 = CommonPageSection.this.fHeader.computeSize(l, -1, flag);
                int i1 = 0;
                if (CommonPageSection.this.fToggle != null) {
                    int j1 = k + point1.y - point.y;
                    CommonPageSection.this.fToggle.setBounds(0, j1, point.x, point.y);
                    i1 = point.x;
                }
                CommonPageSection.this.fHeader.setBounds(i1, k, l, point1.y);
                k += point1.y + this.vspacing;
            }
            if (CommonPageSection.this.fAddSeparator && CommonPageSection.this.fSeparator != null) {
                CommonPageSection.this.fSeparator.setBounds(0, k, i, 2);
                k += this.sepHeight + this.vspacing;
            }
            if (CommonPageSection.this.fToggle != null && CommonPageSection.this.fToggle.getSelection()) {
                return;
            }
            if (CommonPageSection.this.fDescriptionPainted && CommonPageSection.this.fDescriptionLabel != null) {
                Point point2 = CommonPageSection.this.fDescriptionLabel.computeSize(i, -1, flag);
                CommonPageSection.this.fDescriptionLabel.setBounds(0, k, i, point2.y);
                k += point2.y + this.vspacing;
            }
            if (CommonPageSection.this.fSectionControl != null) {
                CommonPageSection.this.fSectionControl.setBounds(0, k, i, j - k);
            }
        }

        SectionLayout() {
        }
    }
}

