/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import com.kingdee.bos.tool.multipageeditor.common.IHyperlinkListener;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class HyperlinkHandler
implements MouseListener,
MouseTrackListener,
PaintListener,
FocusListener,
KeyListener {
    public static final int UNDERLINE_NEVER = 1;
    public static final int UNDERLINE_ROLLOVER = 2;
    public static final int UNDERLINE_ALWAYS = 3;
    private Cursor hyperlinkCursor;
    private Cursor busyCursor;
    private boolean hyperlinkCursorUsed = true;
    private int hyperlinkUnderlineMode = 3;
    private Color background;
    private Color foreground;
    private Color activeBackground;
    private Color activeForeground;
    private Hashtable hyperlinkListeners = new Hashtable();
    private Control lastLink;

    public HyperlinkHandler() {
        this.hyperlinkCursor = new Cursor((Device)Display.getCurrent(), 21);
        this.busyCursor = new Cursor((Device)Display.getCurrent(), 1);
    }

    public void dispose() {
        this.hyperlinkCursor.dispose();
        this.busyCursor.dispose();
    }

    public Color getActiveBackground() {
        return this.activeBackground;
    }

    public Color getActiveForeground() {
        return this.activeForeground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Cursor getBusyCursor() {
        return this.busyCursor;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Cursor getHyperlinkCursor() {
        return this.hyperlinkCursor;
    }

    public int getHyperlinkUnderlineMode() {
        return this.hyperlinkUnderlineMode;
    }

    public Control getLastLink() {
        return this.lastLink;
    }

    public boolean isHyperlinkCursorUsed() {
        return this.hyperlinkCursorUsed;
    }

    public void mouseDoubleClick(MouseEvent mouseevent) {
    }

    public void mouseDown(MouseEvent mouseevent) {
        if (mouseevent.button == 1) {
            return;
        }
        this.lastLink = (Control)mouseevent.widget;
    }

    public void mouseEnter(MouseEvent mouseevent) {
        IHyperlinkListener ihyperlinklistener;
        Control control = (Control)mouseevent.widget;
        if (this.isHyperlinkCursorUsed()) {
            control.setCursor(this.hyperlinkCursor);
        }
        if (this.activeBackground != null) {
            control.setBackground(this.activeBackground);
        }
        if (this.activeForeground != null) {
            control.setForeground(this.activeForeground);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(control, true);
        }
        if ((ihyperlinklistener = (IHyperlinkListener)this.hyperlinkListeners.get(control)) != null) {
            ihyperlinklistener.linkEntered(control);
        }
    }

    public void mouseExit(MouseEvent mouseevent) {
        IHyperlinkListener ihyperlinklistener;
        Control control = (Control)mouseevent.widget;
        if (this.isHyperlinkCursorUsed()) {
            control.setCursor(null);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(control, false);
        }
        if (this.background != null) {
            control.setBackground(this.background);
        }
        if (this.foreground != null) {
            control.setForeground(this.foreground);
        }
        if ((ihyperlinklistener = (IHyperlinkListener)this.hyperlinkListeners.get(control)) != null) {
            ihyperlinklistener.linkExited(control);
        }
    }

    public void mouseHover(MouseEvent mouseevent) {
    }

    public void mouseUp(MouseEvent mouseevent) {
        if (mouseevent.button != 1) {
            return;
        }
        IHyperlinkListener ihyperlinklistener = (IHyperlinkListener)this.hyperlinkListeners.get(mouseevent.widget);
        if (ihyperlinklistener != null) {
            Control control = (Control)mouseevent.widget;
            control.setCursor(this.busyCursor);
            ihyperlinklistener.linkActivated(control);
            if (!control.isDisposed()) {
                control.setCursor(this.isHyperlinkCursorUsed() ? this.hyperlinkCursor : null);
            }
        }
    }

    public void paintControl(PaintEvent paintevent) {
        Control control = (Control)paintevent.widget;
        if (this.hyperlinkUnderlineMode == 3) {
            HyperlinkHandler.underline(control, true);
        }
    }

    public void registerHyperlink(Control control, IHyperlinkListener ihyperlinklistener) {
        if (this.background != null) {
            control.setBackground(this.background);
        }
        if (this.foreground != null) {
            control.setForeground(this.foreground);
        }
        control.addMouseListener((MouseListener)this);
        control.addMouseTrackListener((MouseTrackListener)this);
        control.addFocusListener((FocusListener)this);
        control.addKeyListener((KeyListener)this);
        if (this.hyperlinkUnderlineMode == 3) {
            control.addPaintListener((PaintListener)this);
        }
        this.hyperlinkListeners.put(control, ihyperlinklistener);
        this.removeDisposedLinks();
    }

    private void removeDisposedLinks() {
        Enumeration enumeration = this.hyperlinkListeners.keys();
        while (enumeration.hasMoreElements()) {
            Control control = (Control)enumeration.nextElement();
            if (!control.isDisposed()) continue;
            this.hyperlinkListeners.remove(control);
        }
    }

    public void reset() {
        this.hyperlinkListeners.clear();
    }

    public void setActiveBackground(Color color) {
        this.activeBackground = color;
    }

    public void setActiveForeground(Color color) {
        this.activeForeground = color;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setHyperlinkCursorUsed(boolean flag) {
        this.hyperlinkCursorUsed = flag;
    }

    public void setHyperlinkUnderlineMode(int i) {
        this.hyperlinkUnderlineMode = i;
    }

    public static void underline(Control control, boolean flag) {
        if (!(control instanceof Label)) {
            return;
        }
        Composite composite = control.getParent();
        Rectangle rectangle = control.getBounds();
        GC gc = new GC((Drawable)composite);
        Color color = flag ? control.getForeground() : control.getBackground();
        gc.setForeground(color);
        int i = rectangle.y + rectangle.height;
        gc.drawLine(rectangle.x, i, rectangle.x + rectangle.width, i);
        gc.dispose();
    }

    public void focusGained(FocusEvent focusevent) {
        IHyperlinkListener ihyperlinklistener;
        Control control = (Control)focusevent.widget;
        if (this.isHyperlinkCursorUsed()) {
            control.setCursor(this.hyperlinkCursor);
        }
        if (this.activeBackground != null) {
            control.setBackground(this.activeBackground);
        }
        if (this.activeForeground != null) {
            control.setForeground(this.activeForeground);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(control, true);
        }
        if ((ihyperlinklistener = (IHyperlinkListener)this.hyperlinkListeners.get(control)) != null) {
            ihyperlinklistener.linkEntered(control);
        }
    }

    public void focusLost(FocusEvent focusevent) {
        IHyperlinkListener ihyperlinklistener;
        Control control = (Control)focusevent.widget;
        if (this.isHyperlinkCursorUsed()) {
            control.setCursor(null);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(control, false);
        }
        if (this.background != null) {
            control.setBackground(this.background);
        }
        if (this.foreground != null) {
            control.setForeground(this.foreground);
        }
        if ((ihyperlinklistener = (IHyperlinkListener)this.hyperlinkListeners.get(control)) != null) {
            ihyperlinklistener.linkExited(control);
        }
    }

    public void keyPressed(KeyEvent keyevent) {
        Control control;
        IHyperlinkListener ihyperlinklistener;
        if (keyevent.character == '\r' && (ihyperlinklistener = (IHyperlinkListener)this.hyperlinkListeners.get(control = (Control)keyevent.widget)) != null) {
            ihyperlinklistener.linkActivated(control);
        }
    }

    public void keyReleased(KeyEvent keyevent) {
    }
}

