/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.views.verify;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.tool.utils.ToolCommonImages;
import com.kingdee.bos.tool.views.verify.FilterDialog;
import com.kingdee.bos.tool.views.verify.LogViewContentProvider;
import com.kingdee.bos.tool.views.verify.LogViewLabelProvider;
import com.kingdee.bos.tool.views.verify.Messages;
import com.kingdee.bos.tool.views.verify.VerifyMessageEntry;
import com.kingdee.bos.util.BOSObjectType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;

public class VerifyMessageView
extends ViewPart
implements PropertyChangeListener {
    private TableViewer viewer;
    private List messages = new ArrayList();
    public static final String P_LOG_WARNING = "warning";
    public static final String P_LOG_ERROR = "error";
    public static final String P_LOG_FATAL = "info";
    public static final String P_LOG_LIMIT = "limit";
    public static final String P_USE_LIMIT = "useLimit";
    private static final String P_COLUMN_1 = "column1";
    private static final String P_COLUMN_2 = "column2";
    private static final String P_COLUMN_3 = "column3";
    private static final String P_COLUMN_4 = "column4";
    public static final String P_ACTIVATE = "activate";
    public static byte MESSAGE = 0;
    public static byte PLUGIN = 1;
    public static byte DATE = (byte)2;
    private Action clearAction;
    private Action filterAction;
    private IMemento memento;
    private Action deleteLogAction;
    private TableColumn column0;
    private TableColumn column1;
    private TableColumn column2;
    private TableColumn column3;
    private TableColumn column4;

    public VerifyMessageView() {
        Collection items = ToolCommonPlugin.getCheckReport().getItems();
        this.transInfos(items);
        ToolCommonPlugin.getCheckReport().addCheckReportChangeListener(this);
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 65536);
        table.setLayoutData((Object)new GridData(1808));
        this.createColumns(table);
        this.createViewer(table);
        this.createPopupMenuManager(table);
        this.makeActions(table);
        this.fillToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getTable().setToolTipText("");
    }

    public Collection getItems() {
        return this.messages;
    }

    public void clear() {
        this.messages.clear();
        this.viewer.getTable().setRedraw(false);
        this.viewer.refresh();
        this.viewer.getTable().setRedraw(true);
    }

    private void fillToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = bars.getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.clearAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.deleteLogAction);
        toolBarManager.add((IContributionItem)new Separator());
        IMenuManager mgr = bars.getMenuManager();
        mgr.add((IAction)this.filterAction);
    }

    private void createViewer(Table table) {
        this.viewer = new TableViewer(table);
        LogViewContentProvider cprovider = new LogViewContentProvider();
        cprovider.setMemento(this.memento);
        this.viewer.setContentProvider((IContentProvider)cprovider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LogViewLabelProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        this.viewer.setInput((Object)this.messages);
    }

    private void createPopupMenuManager(Table table) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                VerifyMessageView.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    private void createColumns(Table table) {
        this.column0 = new TableColumn(table, 0);
        this.column0.setText("!");
        this.column0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerSorter sorter = new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        VerifyMessageEntry entry1 = (VerifyMessageEntry)e1;
                        VerifyMessageEntry entry2 = (VerifyMessageEntry)e2;
                        return entry1.getLevel() - entry2.getLevel();
                    }
                };
                VerifyMessageView.this.viewer.setSorter(sorter);
                VerifyMessageView.this.viewer.refresh();
            }
        });
        this.column1 = new TableColumn(table, 0);
        this.column1.setText(Messages.VerifyMessageView_YouXianJi);
        this.column2 = new TableColumn(table, 0);
        this.column2.setText(Messages.VerifyMessageView_CuoWuXinXi);
        this.column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerSorter sorter = new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        VerifyMessageEntry entry1 = (VerifyMessageEntry)e1;
                        VerifyMessageEntry entry2 = (VerifyMessageEntry)e2;
                        return super.compare(viewer, (Object)entry1.getMessage(), (Object)entry2.getMessage());
                    }
                };
                VerifyMessageView.this.viewer.setSorter(sorter);
                VerifyMessageView.this.viewer.refresh();
            }
        });
        this.column3 = new TableColumn(table, 0);
        this.column3.setText(Messages.VerifyMessageView_XiaoYanDuiXiang);
        this.column3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerSorter sorter = new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        VerifyMessageEntry entry1 = (VerifyMessageEntry)e1;
                        VerifyMessageEntry entry2 = (VerifyMessageEntry)e2;
                        return super.compare(viewer, (Object)entry1.getTarget().getFullName(), (Object)entry2.getTarget().getFullName());
                    }
                };
                VerifyMessageView.this.viewer.setSorter(sorter);
                VerifyMessageView.this.viewer.refresh();
            }
        });
        this.column4 = new TableColumn(table, 0);
        this.column4.setText(Messages.VerifyMessageView_XiuGaiCeLue);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(21));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(50));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(500));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(250));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(400));
        table.setLayout((Layout)tlayout);
        table.setHeaderVisible(true);
    }

    private void makeActions(Table table) {
        this.clearAction = new Action(Messages.VerifyMessageView_QingChuShiTuXinXi){

            public void run() {
                VerifyMessageView.this.handleClear();
            }
        };
        this.clearAction.setImageDescriptor(ToolCommonImages.getImageDescriptor("clear.gif"));
        this.clearAction.setToolTipText(Messages.VerifyMessageView_QingChuShiTuXinXi);
        this.clearAction.setText(Messages.VerifyMessageView_QingChuShiTuXinXi);
        this.deleteLogAction = new Action(Messages.VerifyMessageView_ShanChuXinXi){

            public void run() {
                VerifyMessageView.this.doDeleteLog();
            }
        };
        this.deleteLogAction.setToolTipText(Messages.VerifyMessageView_ShanChuXinXi);
        this.deleteLogAction.setImageDescriptor(ToolCommonImages.getImageDescriptor("delete.gif"));
        this.filterAction = new Action(Messages.VerifyMessageView_GuoLvQi){

            public void run() {
                VerifyMessageView.this.handleFilter();
            }
        };
        this.filterAction.setToolTipText(Messages.VerifyMessageView_GuoLvQi);
        this.filterAction.setImageDescriptor(ToolCommonImages.getImageDescriptor("filter.gif"));
    }

    private void handleFilter() {
        FilterDialog dialog = new FilterDialog(this.getSite().getShell(), this.memento);
        dialog.create();
        dialog.getShell().setText(Messages.VerifyMessageView_XiaoYanXinXiGuoLv);
        if (dialog.open() == 0) {
            LogViewContentProvider cprovider = new LogViewContentProvider();
            cprovider.setMemento(this.memento);
            this.viewer.setContentProvider((IContentProvider)cprovider);
            this.viewer.getTable().setRedraw(false);
            this.viewer.refresh();
            this.viewer.getTable().setRedraw(true);
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteLogAction);
        manager.add((IContributionItem)new Separator());
    }

    public void addMessage(VerifyMessageEntry msg) {
        this.messages.add(msg);
        this.viewer.getTable().setRedraw(false);
        this.viewer.refresh();
        this.viewer.getTable().setRedraw(true);
    }

    protected void handleClear() {
        BusyIndicator.showWhile((Display)this.viewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                VerifyMessageView.this.messages.clear();
                VerifyMessageView.this.asyncRefresh(false);
            }
        });
    }

    protected void doDeleteLog() {
        BusyIndicator.showWhile((Display)this.viewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ToolCommonPlugin.getCheckReport().clearItems();
            }
        });
    }

    private void asyncRefresh(boolean activate) {
        final Control control = this.viewer.getControl();
        if (control.isDisposed()) {
            return;
        }
        Display display = control.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!control.isDisposed()) {
                        VerifyMessageView.this.viewer.refresh();
                    }
                }
            });
        }
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().setFocus();
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"LOGVIEW") : memento;
        this.initializeMemento();
    }

    private void initializeMemento() {
        Integer width;
        if (this.memento.getString(P_USE_LIMIT) == null) {
            this.memento.putString(P_USE_LIMIT, "true");
        }
        if (this.memento.getInteger(P_LOG_LIMIT) == null) {
            this.memento.putInteger(P_LOG_LIMIT, 50);
        }
        if (this.memento.getString(P_LOG_FATAL) == null) {
            this.memento.putString(P_LOG_FATAL, "true");
        }
        if (this.memento.getString(P_LOG_WARNING) == null) {
            this.memento.putString(P_LOG_WARNING, "true");
        }
        if (this.memento.getString(P_LOG_ERROR) == null) {
            this.memento.putString(P_LOG_ERROR, "true");
        }
        if ((width = this.memento.getInteger(P_COLUMN_1)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_1, 20);
        }
        if ((width = this.memento.getInteger(P_COLUMN_2)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_2, 300);
        }
        if ((width = this.memento.getInteger(P_COLUMN_3)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_3, 150);
        }
        if ((width = this.memento.getInteger(P_COLUMN_4)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_4, 150);
        }
        if (this.memento.getString(P_ACTIVATE) == null) {
            this.memento.putString(P_ACTIVATE, "true");
        }
    }

    public void saveState(IMemento memento) {
        if (this.memento == null || memento == null) {
            return;
        }
        this.memento.putInteger(P_COLUMN_1, this.column1.getWidth());
        this.memento.putInteger(P_COLUMN_2, this.column2.getWidth());
        this.memento.putInteger(P_COLUMN_3, this.column3.getWidth());
        this.memento.putInteger(P_COLUMN_4, this.column4.getWidth());
        memento.putMemento(this.memento);
    }

    public void dispose() {
        ToolCommonPlugin.getCheckReport().removeCheckReportChangeListener(this);
        super.dispose();
    }

    private void transInfos(Collection items) {
        this.messages.clear();
        ArrayList temp = new ArrayList();
        temp.addAll(items);
        int size = temp.size();
        for (int i = size - 1; i > -1; --i) {
            this.messages.add(temp.get(i));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Collection items = (Collection)e.getNewValue();
        this.transInfos(items);
        LogViewContentProvider cprovider = new LogViewContentProvider();
        cprovider.setMemento(this.memento);
        this.viewer.setContentProvider((IContentProvider)cprovider);
        this.viewer.getTable().setRedraw(false);
        this.viewer.refresh();
        this.viewer.getTable().setRedraw(true);
    }

    private class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent e) {
            TableItem[] items = VerifyMessageView.this.viewer.getTable().getSelection();
            if (items.length > 0) {
                VerifyMessageEntry entry = (VerifyMessageEntry)items[0].getData();
                MetaDataInfo md = entry.getTarget();
                IMDProject project = ToolCommonPlugin.getCheckReport().getItemFolder(entry);
                if (project == null) {
                    return;
                }
                BOSObjectType type = BOSObjectType.create((String)md.getMetaDataType());
                IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)(md.getPackage() + "." + md.getName()));
                IMDFile file = MDResourceUtil.getFile(project, pk, type);
                if (null != file) {
                    EditorHelper.openFile(file);
                }
            }
        }
    }
}

