/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.widgets;

import com.kingdee.bos.tool.widgets.HrefText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class HrefTextResourceManager
implements DisposeListener {
    private int refcount = 0;
    private HrefTextResource resource = null;
    private static HrefTextResourceManager manager;

    private HrefTextResourceManager() {
    }

    public static synchronized HrefTextResourceManager getInstance() {
        if (manager == null) {
            manager = new HrefTextResourceManager();
        }
        return manager;
    }

    public synchronized void widgetDisposed(DisposeEvent e) {
        --this.refcount;
        if (this.refcount == 0 && this.resource != null) {
            this.resource.dispose();
            this.resource = null;
        }
    }

    public synchronized HrefTextResource applyResource(HrefText text) {
        if (this.resource == null) {
            this.resource = new HrefTextResource();
            this.resource.init(text);
        }
        text.addDisposeListener(this);
        ++this.refcount;
        return this.resource;
    }

    public static class HrefTextResource {
        public Color normalColor;
        public Color hoverColor;
        public Cursor hoverCursor;
        public Font hoverFont;

        private HrefTextResource() {
        }

        private void init(HrefText text) {
            if (this.normalColor == null) {
                this.normalColor = new Color((Device)text.getShell().getDisplay(), HrefText.getNormalColorRgb());
            }
            if (this.hoverColor == null) {
                this.hoverColor = new Color((Device)text.getShell().getDisplay(), HrefText.getHoverColorRgb());
            }
            if (this.hoverCursor == null) {
                this.hoverCursor = new Cursor((Device)text.getShell().getDisplay(), 21);
            }
            if (this.hoverFont == null) {
                FontData fontData = text.getFont().getFontData()[0];
                fontData.data.lfUnderline = 1;
                this.hoverFont = new Font((Device)text.getShell().getDisplay(), fontData);
            }
        }

        private void dispose() {
            if (this.normalColor != null && !this.normalColor.isDisposed()) {
                this.normalColor.dispose();
            }
            if (this.hoverColor != null && !this.hoverColor.isDisposed()) {
                this.hoverColor.dispose();
            }
            if (this.hoverCursor != null && !this.hoverCursor.isDisposed()) {
                this.hoverCursor.dispose();
            }
            if (this.hoverFont != null && !this.hoverFont.isDisposed()) {
                this.hoverFont.dispose();
            }
        }
    }
}

