/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.i18n;

import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.wizard.i18n.RegisterInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LocalClassLoader
extends ClassLoader {
    private RegisterInfo info = null;

    public LocalClassLoader(ClassLoader parent, RegisterInfo registerInfo) {
        super(parent);
        this.info = registerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String name) {
        if (name.endsWith(this.info.getClsName())) {
            File f = new File(this.info.getPkgUrl());
            InputStream input = null;
            if (f.getName().endsWith(".class")) {
                try {
                    input = new FileInputStream(f);
                }
                catch (FileNotFoundException e) {
                    LogTool.logError("load fille error!", e);
                    return null;
                }
            }
            if (f.getName().endsWith(".zip")) {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(f);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                    }
                    String cfname = StringUtils.replace((String)this.info.getClsName(), (String)".", (String)"/") + ".class";
                    input = zipFile.getInputStream(zipFile.getEntry(cfname));
                }
                catch (IOException e) {
                    LogTool.logError("load zip file error", e);
                    Class clazz = null;
                    return clazz;
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e) {
                            LogTool.logError("load zip file error", e);
                        }
                    }
                }
            }
            if (f.getName().endsWith(".jar")) {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(f);
                    String cfname = StringUtils.replace((String)this.info.getClsName(), (String)".", (String)"/") + ".class";
                    input = jarFile.getInputStream(jarFile.getEntry(cfname));
                }
                catch (IOException e) {
                    LogTool.logError("load zip file error", e);
                    Class clazz = null;
                    return clazz;
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {
                            LogTool.logError("load zip file error", e);
                        }
                    }
                }
            }
            byte[] b = this.loadClassData(input);
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                LogTool.logError("load zip file error", e);
            }
            return this.defineClass(name, b, 0, b.length);
        }
        return null;
    }

    private byte[] loadClassData(InputStream input) {
        try {
            byte[] ns;
            byte[] result = new byte[]{};
            byte[] bs = new byte[1024];
            int total = 0;
            int len = input.read(bs);
            while (len != -1) {
                total += len;
                ns = new byte[result.length + len];
                System.arraycopy(result, 0, ns, 0, result.length);
                System.arraycopy(bs, 0, ns, result.length, len);
                result = ns;
                len = input.read(bs);
            }
            ns = new byte[total];
            System.arraycopy(result, 0, ns, 0, total);
            return ns;
        }
        catch (IOException e) {
            return null;
        }
    }
}

