/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard.i18n;

import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.stringextr.FileExtrInfo;
import com.kingdee.bos.tool.stringextr.FileTool;
import com.kingdee.bos.tool.stringextr.IStringExtractor;
import com.kingdee.bos.tool.stringextr.StringResourceInfo;
import com.kingdee.bos.tool.stringextr.impl.EclipseJavaStringExtractor;
import com.kingdee.bos.tool.wizard.i18n.ExtrOptions;
import com.kingdee.bos.tool.wizard.i18n.LocalClassLoader;
import com.kingdee.bos.tool.wizard.i18n.MD5;
import com.kingdee.bos.tool.wizard.i18n.RegisterInfo;
import com.kingdee.bos.tool.wizard.i18n.ResourceInfo;
import com.kingdee.bos.tool.wizard.i18n.SEJavaPropWizardPage;
import com.kingdee.bos.tool.wizard.i18n.SEViewJavaWizardPage;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class StringExtrWizard
extends Wizard {
    private IStructuredSelection selection;
    private SEJavaPropWizardPage javaPropPage = new SEJavaPropWizardPage("\u8bbe\u7f6e\u63d0\u53d6\u9009\u9879");
    private SEViewJavaWizardPage viewJavaPage = new SEViewJavaWizardPage("\u67e5\u770bJava\u4e2d\u7684\u5b57\u7b26\u4e32");
    private ExtrOptions options = new ExtrOptions();
    private Map fileExtrInfoMap = new HashMap();
    ResourceInfo resourceInfo = null;

    public StringExtrWizard() {
        super.setWindowTitle("\u5b57\u7b26\u4e32\u62bd\u53d6\u5411\u5bfc");
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
        this.addPage((IWizardPage)this.javaPropPage);
        this.addPage((IWizardPage)this.viewJavaPage);
    }

    public boolean performFinish() {
        this.javaPropPage.store();
        this.javaPropPage.storeOptions();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("\u5b57\u7b26\u4e32\u62bd\u53d6", 2);
                    if (StringExtrWizard.this.options.isExportXML()) {
                        try {
                            StringExtrWizard.this.write2XML(monitor);
                        }
                        catch (Exception e) {
                            LogTool.logError("output", e);
                            throw new InvocationTargetException(e);
                        }
                    }
                    monitor.worked(1);
                    if (StringExtrWizard.this.options.isRefactor()) {
                        try {
                            StringExtrWizard.this.refactor(monitor);
                        }
                        catch (Exception e) {
                            LogTool.logError("refactor", e);
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LogTool.logError("ERROR", e);
            MessageDialog.openError((Shell)this.getShell(), (String)"\u9519\u8bef", (String)"\u62bd\u53d6\u8d44\u6e90\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u4ee5\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f");
            return false;
        }
        return true;
    }

    private void refactor(IProgressMonitor mMonitor) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Map infoMap = this.viewJavaPage.infoMap;
        SubProgressMonitor monitor = new SubProgressMonitor(mMonitor, infoMap.size());
        monitor.subTask("\u91cd\u6784\u6587\u4ef6");
        if (this.options.isExportXML() && !this.options.isReplaceOrg() && this.options.getBackupDir() != null) {
            new File(this.options.getBackupDir()).mkdirs();
        }
        RegisterInfo registerInfo = this.options.getRegisterInfo();
        String clsName = registerInfo.getClsName();
        IStringExtractor extractor = null;
        if (!StringUtils.isEmpty((String)registerInfo.getPkgUrl())) {
            LocalClassLoader loader = new LocalClassLoader(((Object)((Object)this)).getClass().getClassLoader(), registerInfo);
            extractor = (IStringExtractor)loader.loadClass(clsName).newInstance();
        }
        if (extractor == null) {
            extractor = new EclipseJavaStringExtractor();
        }
        Iterator iter = infoMap.values().iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            FileExtrInfo info = (FileExtrInfo)iter.next();
            if (info.getSource() == null || !info.getSource().getName().endsWith(".java")) continue;
            File destRoot = null;
            if (this.options.isReplaceOrg()) {
                String[] ps = info.getPkgName().split("\\.");
                destRoot = info.getSource();
                for (int i = 0; i <= ps.length; ++i) {
                    destRoot = destRoot.getParentFile();
                }
            } else {
                destRoot = new File(this.options.getBackupDir());
                destRoot.mkdirs();
            }
            monitor.setTaskName(info.getSource().getName());
            StringBuffer sb = StringExtrWizard.readFile(info.getSource());
            List children = info.getStringInfos();
            Properties prop = extractor.loadOrgProperties(info, destRoot);
            int offset = 0;
            for (int i = 0; i < children.size(); ++i) {
                StringResourceInfo sInfo = (StringResourceInfo)children.get(i);
                if (sInfo.isCanceled()) continue;
                String fKey = extractor.getCode("java", info.getPkgName(), sInfo.getKey());
                int sPos = sInfo.getPos() + offset - 1;
                int ePos = sPos + sInfo.getValue().length() + 2;
                offset += fKey.length() - sInfo.getValue().length() - 2;
                sb.replace(sPos, ePos, fKey);
                if (!this.options.isReplaceExists() && prop.containsKey(sInfo.getKey())) continue;
                prop.put(sInfo.getKey(), sInfo.getValue());
            }
            File newFile = new File(destRoot.getAbsolutePath() + File.separator + StringUtils.replace((String)info.getPkgName(), (String)".", (String)"/") + File.separator + info.getSource().getName());
            FileTool.writ2File(sb.toString(), newFile);
            extractor.storeProperties(prop, info, destRoot);
            extractor.genExtCode(info, destRoot);
            monitor.worked(1);
        }
    }

    public static Properties readProperties(File file) throws IOException {
        Properties prop = new Properties();
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                prop.load(input);
            }
            catch (Throwable throwable) {
                FileUtils.close(input);
                throw throwable;
            }
            FileUtils.close(input);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readFile(File file) throws IOException {
        StringBuffer sb;
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            char[] bs = new char[255];
            int len = reader.read(bs);
            sb = new StringBuffer();
            while (len != -1) {
                sb.append(new String(bs, 0, len));
                len = reader.read(bs);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(reader);
            FileUtils.close(fileReader);
            throw throwable;
        }
        FileUtils.close(reader);
        FileUtils.close(fileReader);
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write2XML(IProgressMonitor mMonitor) throws FileNotFoundException, IOException {
        Map infoMap = this.viewJavaPage.infoMap;
        SubProgressMonitor monitor = new SubProgressMonitor(mMonitor, infoMap.size());
        monitor.subTask("\u8f93\u51fa\u5230XML\u6587\u4ef6");
        Document doc = new Document();
        Element root = new Element("properties");
        doc.setRootElement(root);
        Iterator iter = infoMap.values().iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            FileExtrInfo info = (FileExtrInfo)iter.next();
            monitor.setTaskName(info.getSource().getName());
            Element fElement = new Element("file");
            root.addContent((Content)fElement);
            fElement.addContent((Content)new Element("path").setText(info.getSource().getAbsolutePath()));
            try {
                fElement.addContent((Content)new Element("md5").setText(MD5.asHex(MD5.getHash(info.getSource()))));
            }
            catch (IOException e) {
                LogTool.logError("MD5 error", e);
            }
            fElement.addContent((Content)new Element("package").setText(info.getPkgName()));
            fElement.addContent((Content)new Element("prop-file").setText(info.getMessageFile()));
            Element itemsElement = new Element("items");
            fElement.addContent((Content)itemsElement);
            List list = info.getStringInfos();
            for (int i = 0; i < list.size(); ++i) {
                StringResourceInfo sInfo = (StringResourceInfo)list.get(i);
                if (sInfo.isCanceled()) continue;
                Element itemEl = new Element("item");
                itemsElement.addContent((Content)itemEl);
                itemEl.addContent((Content)new Element("value").addContent((Content)new CDATA(sInfo.getValue())));
                itemEl.addContent((Content)new Element("key").setText(sInfo.getKey()));
                itemEl.addContent((Content)new Element("line").setText(String.valueOf(sInfo.getLine())));
                itemEl.addContent((Content)new Element("column").setText(String.valueOf(sInfo.getColumn())));
                itemEl.addContent((Content)new Element("pos").setText(String.valueOf(sInfo.getPos())));
                itemEl.addContent((Content)new Element("isFinal").setText(String.valueOf(sInfo.isFinal())));
            }
            monitor.worked(1);
        }
        Format format = Format.getRawFormat();
        format.setIndent("  ");
        XMLOutputter output = new XMLOutputter(format);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.options.getXmlDir());
            output.output(doc, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            FileUtils.close(fileOutputStream);
            throw throwable;
        }
        FileUtils.close(fileOutputStream);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    private void parseInfo(ResourceInfo info, IResource res, String type, boolean showEmpty) throws CoreException {
        if (res instanceof IContainer) {
            IResource[] rss = ((IContainer)res).members();
            for (int i = 0; i < rss.length; ++i) {
                if (rss[i] instanceof IFile && !rss[i].getName().endsWith(type)) continue;
                ResourceInfo sInfo = new ResourceInfo(rss[i]);
                this.parseInfo(sInfo, rss[i], type, showEmpty);
                if (!(rss[i] instanceof IFile) && !showEmpty && sInfo.getChildren().size() <= 0) continue;
                info.getChildren().add(sInfo);
            }
        }
    }

    private ResourceInfo parseInfo() {
        if (this.resourceInfo != null) {
            return this.resourceInfo;
        }
        if (this.selection == null) {
            return null;
        }
        this.resourceInfo = new ResourceInfo();
        IResource res = null;
        Object object = this.selection.getFirstElement();
        if (object instanceof IJavaElement) {
            res = ((IJavaElement)object).getResource();
        } else if (object instanceof IResource) {
            res = (IResource)object;
        }
        if (!(res instanceof IFile) || res.getName().endsWith(".java")) {
            ResourceInfo sub = new ResourceInfo(res);
            this.resourceInfo.getChildren().add(sub);
            try {
                this.parseInfo(sub, res, ".java", false);
            }
            catch (CoreException e) {
                LogTool.logError("\u89e3\u6790\u8d44\u6e90\u65f6\u53d1\u751f\u9519\u8bef", e);
            }
        }
        return this.resourceInfo;
    }

    public ResourceInfo getResourceInfo() {
        return this.parseInfo();
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }

    public ExtrOptions getOptions() {
        return this.options;
    }

    public Map getFileExtrInfoMap() {
        return this.fileExtrInfoMap;
    }

    public boolean canFinish() {
        return this.viewJavaPage.isPageComplete();
    }
}

