/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webframework.dynamic.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.meta.ui.MetaComponent;
import com.kingdee.bos.meta.ui.MetaComponentProperty;
import com.kingdee.bos.meta.ui.MetaWebEditPage;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.webframework.dynamic.DesensitizationRuleCollection;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureCollection;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureFactory;
import com.kingdee.bos.webframework.dynamic.DynamicConfigureInfo;
import com.kingdee.bos.webframework.dynamic.IDynamicConfigure;
import com.kingdee.bos.webframework.dynamic.PrivacyPlanCollection;
import com.kingdee.bos.webframework.dynamic.PrivacyPlanFactory;
import com.kingdee.bos.webframework.dynamic.RuleDetailFactory;
import com.kingdee.bos.webframework.dynamic.RuleDetailInfo;
import com.kingdee.eas.common.client.SysContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class PrivacyPlanHelper {
    private static Logger logger = Logger.getLogger(PrivacyPlanHelper.class);

    public static List<desensitizationRule> getDesensitizationRules(Context ctx, String uipk) {
        List<desensitizationRule> desensitizationRules = null;
        if (StringUtils.isNotEmpty((CharSequence)uipk)) {
            DynamicConfigureInfo pageInfo = PrivacyPlanHelper.getDynamicConfigureInfoByUipk(ctx, uipk);
            if (pageInfo == null || pageInfo.getEntityObjectName() == null) {
                return desensitizationRules;
            }
            EntityObjectInfo entityInfo = PrivacyPlanHelper.getEntity(ctx, pageInfo.getEntityObjectName());
            return PrivacyPlanHelper.getDesensitizationRules(ctx, entityInfo);
        }
        return desensitizationRules;
    }

    public static List<desensitizationRule> getDesensitizationRules(Context ctx, String uipk, String queryPk) {
        if (StringUtils.isEmpty((CharSequence)queryPk)) {
            return PrivacyPlanHelper.getDesensitizationRules(ctx, uipk);
        }
        QueryInfo queryInfo = PrivacyPlanHelper.getQuery(ctx, queryPk);
        return PrivacyPlanHelper.getDesensitizationRules(ctx, queryInfo);
    }

    public static List<desensitizationRule> getDesensitizationRules(Context ctx, QueryInfo queryInfo) {
        try {
            if (queryInfo != null && queryInfo.getMainObject() != null) {
                SubObjectInfo mainObject = queryInfo.getMainObject();
                String entityName = ((EntityObjectInfo)mainObject.get("entityRef")).getFullName();
                EntityObjectInfo entityInfo = PrivacyPlanHelper.getEntity(ctx, entityName);
                List<desensitizationRule> ruleList = PrivacyPlanHelper.getDesensitizationRules(ctx, entityInfo);
                PrivacyPlanHelper.matchRuleField(ruleList, entityName, queryInfo, ctx);
                return ruleList;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get query main object error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"get desensitization rules by query error", (Throwable)e);
        }
        return null;
    }

    public static List<desensitizationRule> getDesensitizationRules(Context ctx, EntityObjectInfo entityInfo) {
        int j;
        int i;
        ArrayList<desensitizationRule> desensitizationRules = new ArrayList<desensitizationRule>();
        PropertyCollection properties = entityInfo.getInheritedProperties();
        HashMap<String, String> baseDatas = new HashMap<String, String>();
        for (int i2 = 0; i2 < properties.size(); ++i2) {
            PropertyInfo property = properties.get(i2);
            if (!(property instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkProperty = (LinkPropertyInfo)property;
            baseDatas.put(linkProperty.getName(), linkProperty.getRelationship().getSupplierObject().getFullName());
        }
        List<desensitizationRule> baseDataRules = PrivacyPlanHelper.getDesensitizationRuleByBaseData(ctx, baseDatas, entityInfo);
        PrivacyPlanCollection privacyPlans = PrivacyPlanHelper.getPrivacyPlansByEntity(ctx, entityInfo.getFullName());
        if ((privacyPlans == null || privacyPlans.size() == 0) && baseDataRules.size() == 0) {
            return desensitizationRules;
        }
        ArrayList<desensitizationRule> entityRules = new ArrayList<desensitizationRule>();
        for (i = 0; privacyPlans != null && i < privacyPlans.size(); ++i) {
            DesensitizationRuleCollection coll = privacyPlans.get(i).getRule();
            for (j = 0; j < coll.size(); ++j) {
                desensitizationRule rule = new desensitizationRule();
                rule.setFieldName(coll.get(j).getFieldName());
                try {
                    RuleDetailInfo ruleType = RuleDetailFactory.getLocalInstance(ctx).getRuleDetailInfo((IObjectPK)new ObjectUuidPK(coll.get(j).getRuleType().getId()));
                    int desensitizeMode = ruleType.getDesensitizationMode();
                    rule.setDesensitizeMode(desensitizeMode);
                    rule.setReplaceTo(ruleType.getReplaceTo());
                    if (desensitizeMode == 1) {
                        rule.setFirstdDigits(ruleType.getFirstdDigits());
                        rule.setLastDigits(ruleType.getLastDigits());
                    } else if (desensitizeMode == 2) {
                        rule.setRegExp(ruleType.getRegExp());
                    }
                    entityRules.add(rule);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"get RuleDetail error", (Throwable)e);
                }
            }
        }
        desensitizationRules.addAll(entityRules);
        for (i = 0; i < baseDataRules.size(); ++i) {
            boolean flag = true;
            for (j = 0; j < entityRules.size(); ++j) {
                if (!baseDataRules.get(i).getFieldName().equals(((desensitizationRule)entityRules.get(j)).getFieldName())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            desensitizationRules.add(baseDataRules.get(i));
        }
        return desensitizationRules;
    }

    public static Map<String, List<desensitizationRule>> getDesensitizationRules(Context ctx, String uipk, MetaWebEditPage metaWebEditPage) {
        HashMap<String, List<desensitizationRule>> map = new HashMap<String, List<desensitizationRule>>();
        for (MetaComponent componentInfo : metaWebEditPage.getComponents()) {
            MetaComponentProperty queryPK;
            if (!"com.kingdee.bos.ctrl.web.QueryGrid".equals(componentInfo.getClassType()) || (queryPK = componentInfo.getPropertyByName("queryPK")) == null) continue;
            map.put(componentInfo.getPropertyByName("id").getValue(), PrivacyPlanHelper.getDesensitizationRules(ctx, uipk, queryPK.getValue()));
        }
        return map;
    }

    public static String desensitization(String source, desensitizationRule dRule) {
        if (source == null || source.length() == 0 || "null".equals(source)) {
            return "";
        }
        int desensitizationType = dRule.getDesensitizeMode();
        int length = source.length();
        char[] chars = source.toCharArray();
        StringBuffer sb = new StringBuffer();
        switch (desensitizationType) {
            case 1: {
                for (int i = 0; i < length; ++i) {
                    if (i < dRule.getFirstdDigits() || i >= length - dRule.getLastDigits()) {
                        sb.append(chars[i]);
                        continue;
                    }
                    sb.append(dRule.getReplaceTo());
                }
                break;
            }
            case 2: {
                return source.replaceAll(dRule.getRegExp(), dRule.getReplaceTo());
            }
            case 3: {
                return dRule.getReplaceTo();
            }
        }
        return sb.toString();
    }

    private static void matchRuleField(List<desensitizationRule> rules, String entityName, QueryInfo queryInfo, Context ctx) {
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        EntityObjectInfo entityInfo = PrivacyPlanHelper.getEntity(ctx, entityName);
        Map<String, String> mapping = PrivacyPlanHelper.getEntity2QueryFieldName(queryInfo, entityInfo);
        for (desensitizationRule rule : rules) {
            String fieldName = rule.getFieldName();
            int index = fieldName.indexOf(".");
            if (index != -1) {
                LinkPropertyInfo property = (LinkPropertyInfo)entityInfo.getPropertyByName(fieldName.substring(0, fieldName.indexOf(".")));
                RelationshipInfo relationship = property.getRelationship();
                EntityObjectInfo supplierObject = relationship.getSupplierObject();
                String mappingFieldName = mapping.get(supplierObject.getFullName() + "." + fieldName);
                if (PrivacyPlanHelper.isEntry(property)) {
                    mappingFieldName = mapping.get(supplierObject.getFullName() + "." + fieldName.substring(index + 1));
                }
                rule.setFieldName(mappingFieldName == null ? fieldName : mappingFieldName);
                continue;
            }
            String mappingFieldName = mapping.get(entityName + "." + entityInfo.getName() + "." + fieldName);
            rule.setFieldName(mappingFieldName == null ? fieldName : mappingFieldName);
        }
    }

    private static Map<String, String> getEntity2QueryFieldName(QueryInfo queryInfo, EntityObjectInfo entityInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<EntityObjectInfo> entryEntityList = new ArrayList<EntityObjectInfo>();
        PropertyCollection properties = entityInfo.getInheritedProperties();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo property = properties.get(i);
            if (!(property instanceof LinkPropertyInfo) || !PrivacyPlanHelper.isEntry((LinkPropertyInfo)property)) continue;
            entryEntityList.add(((LinkPropertyInfo)property).getRelationship().getSupplierObject());
        }
        HashMap<String, String> subObjectName2EntityNameMap = new HashMap<String, String>();
        JoinCollection joins = ((JoinQueryInfo)queryInfo).getJoins();
        HashMap<String, SubObjectInfo> entryLinkedProperty = new HashMap<String, SubObjectInfo>();
        for (int i = 0; i < joins.size(); ++i) {
            JoinItemCollection joinItem = joins.get(i).getJoinItems();
            SubObjectInfo leftObject = joins.get(i).getLeftObject();
            String rightObjectName = joins.get(i).getRightObject().getName();
            PropertyRefCollection propRefs = joinItem.get(0).getLeftField().getPropertyRefs();
            if (propRefs.size() != 1) continue;
            if (PrivacyPlanHelper.isEntryObject(leftObject, entryEntityList)) {
                entryLinkedProperty.put(rightObjectName, leftObject);
                subObjectName2EntityNameMap.put(leftObject.getName() + "." + rightObjectName, propRefs.get(0).getRefProperty().getName());
                continue;
            }
            subObjectName2EntityNameMap.put(rightObjectName, propRefs.get(0).getRefProperty().getName());
        }
        QueryFieldCollection queryFields = queryInfo.getUnits().getQueryFields();
        for (int i = 0; i < queryFields.size(); ++i) {
            String realEntityObjectName;
            QueryFieldInfo queryField = queryFields.get(i);
            PropertyRefCollection propertyRefCollection = queryField.getPropertyRefs();
            if (propertyRefCollection.size() != 1) continue;
            SubEntityInfo subObject = propertyRefCollection.get(0).getSubEntity();
            String subObjectName = subObject.getName();
            if (entryLinkedProperty.containsKey(subObjectName)) {
                EntityObjectInfo entryEntity = (EntityObjectInfo)((SubObjectInfo)entryLinkedProperty.get(subObjectName)).get("entityRef");
                realEntityObjectName = subObjectName2EntityNameMap.get(entryLinkedProperty.get(subObjectName) + "." + subObjectName) != null ? (String)subObjectName2EntityNameMap.get(entryLinkedProperty.get(subObjectName) + "." + subObjectName) : subObjectName;
                String refPropertyName = propertyRefCollection.get(0).getRefProperty().getName();
                result.put(entryEntity.getFullName() + "." + realEntityObjectName + "." + refPropertyName, queryField.getName());
                continue;
            }
            String refPropertyName = propertyRefCollection.get(0).getRefProperty().getName();
            if (PrivacyPlanHelper.isEntryObject((SubObjectInfo)subObject, entryEntityList)) {
                result.put(((EntityObjectInfo)subObject.get("entityRef")).getFullName() + "." + refPropertyName, queryField.getName());
                continue;
            }
            realEntityObjectName = subObjectName2EntityNameMap.get(subObjectName) != null ? (String)subObjectName2EntityNameMap.get(subObjectName) : subObjectName;
            result.put(((EntityObjectInfo)subObject.get("entityRef")).getFullName() + "." + realEntityObjectName + "." + refPropertyName, queryField.getName());
        }
        return result;
    }

    private static boolean isEntryObject(SubObjectInfo leftObject, List<EntityObjectInfo> entryEntityList) {
        for (EntityObjectInfo entryEntity : entryEntityList) {
            if (!((EntityObjectInfo)leftObject.get("entityRef")).getFullName().equals(entryEntity.getFullName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }

    private static PrivacyPlanCollection getPrivacyPlansByEntity(Context ctx, String entityName) {
        PrivacyPlanCollection privacyPlans = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)entityName, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("enabled", (Object)1, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            privacyPlans = PrivacyPlanFactory.getLocalInstance(ctx).getPrivacyPlanCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return privacyPlans;
    }

    private static List<desensitizationRule> getDesensitizationRuleByBaseData(Context ctx, Map<String, String> baseDatas, EntityObjectInfo entityInfo) {
        ArrayList<desensitizationRule> baseDataRules = new ArrayList<desensitizationRule>();
        if (CollectionUtils.isEmpty(baseDatas)) {
            return baseDataRules;
        }
        HashSet<String> baseDatasSet = new HashSet<String>();
        for (String baseData : baseDatas.values()) {
            baseDatasSet.add(baseData);
        }
        PrivacyPlanCollection privacyPlans = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType", baseDatasSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enabled", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBaseData", (Object)true, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("billType"));
        selectorItemCollection.add(new SelectorItemInfo("rule.fieldName"));
        selectorItemCollection.add(new SelectorItemInfo("rule.ruleType.replaceTo"));
        selectorItemCollection.add(new SelectorItemInfo("rule.ruleType.desensitizationMode"));
        selectorItemCollection.add(new SelectorItemInfo("rule.ruleType.firstdDigits"));
        selectorItemCollection.add(new SelectorItemInfo("rule.ruleType.lastDigits"));
        selectorItemCollection.add(new SelectorItemInfo("rule.ruleType.regExp"));
        entityViewInfo.setSelector(selectorItemCollection);
        try {
            privacyPlans = PrivacyPlanFactory.getLocalInstance(ctx).getPrivacyPlanCollection(entityViewInfo);
            for (int i = 0; i < privacyPlans.size(); ++i) {
                String billType = privacyPlans.get(i).getBillType();
                for (Map.Entry<String, String> entry : baseDatas.entrySet()) {
                    if (!billType.equals(entry.getValue())) continue;
                    DesensitizationRuleCollection coll = privacyPlans.get(i).getRule();
                    for (int j = 0; j < coll.size(); ++j) {
                        desensitizationRule rule = new desensitizationRule();
                        rule.setFieldName(entry.getKey() + "." + coll.get(j).getFieldName());
                        RuleDetailInfo ruleType = coll.get(j).getRuleType();
                        int desensitizeMode = ruleType.getDesensitizationMode();
                        rule.setDesensitizeMode(desensitizeMode);
                        rule.setReplaceTo(ruleType.getReplaceTo());
                        if (desensitizeMode == 1) {
                            rule.setFirstdDigits(ruleType.getFirstdDigits());
                            rule.setLastDigits(ruleType.getLastDigits());
                        } else if (desensitizeMode == 2) {
                            rule.setRegExp(ruleType.getRegExp());
                        }
                        baseDataRules.add(rule);
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return baseDataRules;
    }

    private static DynamicConfigureInfo getDynamicConfigureInfoByUipk(Context ctx, String uipk) {
        DynamicConfigureInfo pageInfo = null;
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("entityObjectName"));
        selectorItemCollection.add(new SelectorItemInfo("parentID"));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("webUIObjectName", (Object)uipk, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        try {
            IDynamicConfigure iDynamicConfigure = DynamicConfigureFactory.getLocalInstance(ctx);
            DynamicConfigureCollection dynamicConfigureCollection = iDynamicConfigure.getDynamicConfigureCollection(entityViewInfo);
            if (dynamicConfigureCollection.size() > 0) {
                pageInfo = dynamicConfigureCollection.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return pageInfo;
    }

    private static EntityObjectInfo getEntity(Context ctx, String entityName) {
        Project depend = null;
        if (SysContext.getSysContext().getProperty((Object)"DTKF_DEPEND") != null) {
            depend = (Project)SysContext.getSysContext().getProperty((Object)"DTKF_DEPEND");
        }
        MetaDataPK entityPK = MetaDataPK.create((String)entityName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        if (depend == null) {
            return (EntityObjectInfo)loader.get(MetaDataTypeList.ENTITY, (IMetaDataPK)entityPK, Project.Projects.getProjects((Project[])new Project[0]));
        }
        return (EntityObjectInfo)loader.get(MetaDataTypeList.ENTITY, (IMetaDataPK)entityPK, Project.Projects.getProjects((Project[])new Project[]{depend}));
    }

    public static QueryInfo getQuery(Context ctx, String entityName) {
        MetaDataPK entityPK = MetaDataPK.create((String)entityName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        QueryInfo query = loader.getQuery((IMetaDataPK)entityPK);
        if (query != null && query.getQueryPK() == null) {
            query = null;
        }
        return query;
    }

    public static class desensitizationRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String fieldName;
        private Integer desensitizeMode;
        private String replaceTo;
        private String regExp;
        private Integer firstdDigits;
        private Integer lastDigits;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Integer getDesensitizeMode() {
            return this.desensitizeMode;
        }

        public void setDesensitizeMode(Integer desensitizeMode) {
            this.desensitizeMode = desensitizeMode;
        }

        public String getReplaceTo() {
            return this.replaceTo;
        }

        public void setReplaceTo(String replaceTo) {
            this.replaceTo = replaceTo;
        }

        public String getRegExp() {
            return this.regExp;
        }

        public void setRegExp(String regExp) {
            this.regExp = regExp;
        }

        public Integer getFirstdDigits() {
            return this.firstdDigits;
        }

        public void setFirstdDigits(Integer firstdDigits) {
            this.firstdDigits = firstdDigits;
        }

        public Integer getLastDigits() {
            return this.lastDigits;
        }

        public void setLastDigits(Integer lastDigits) {
            this.lastDigits = lastDigits;
        }
    }
}

