/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.workflow.cust.WFOrgRoleCollection;
import com.kingdee.bos.workflow.cust.WFPersonRoleCollection;
import com.kingdee.bos.workflow.cust.WFPositionRoleCollection;
import com.kingdee.bos.workflow.cust.WFRoleInfo;
import com.kingdee.bos.workflow.cust.WFRoleState;
import com.kingdee.bos.workflow.cust.WFRoleType;
import com.kingdee.bos.workflow.cust.app.AbstractWFRoleControllerBean;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WFRoleControllerBean
extends AbstractWFRoleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.cust.app.WFRoleControllerBean");

    @Override
    protected void _insertOrgRoleHst(Context ctx, IObjectValue info, String userid) throws BOSException {
        int version = this.insertRoleHst(ctx, (WFRoleInfo)info, userid);
        String sql = "insert into T_WFR_OrgRoleHst (FROLEID,FVERSION,FORGID,FISINCLUDE,FINDEX) values (?,?,?,?,?) ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        WFOrgRoleCollection collection = ((WFRoleInfo)info).getOrgEntrys();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                String orgid = "";
                if (collection.get(i).getOrgID() != null) {
                    orgid = collection.get(i).getOrgID().getId().toString();
                }
                Object[] params = new Object[]{((WFRoleInfo)info).getId().toString(), version, orgid, collection.get(i).isIsInclude(), i};
                paramsList.add(params);
                if (paramsList.size() <= 2000) continue;
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                paramsList.clear();
            }
            if (paramsList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            }
        }
    }

    @Override
    protected void _insertPersonRoleHst(Context ctx, IObjectValue info, String userid) throws BOSException {
        int version = this.insertRoleHst(ctx, (WFRoleInfo)info, userid);
        String sql = "insert into T_WFR_PersonRoleHst (FROLEID,FVERSION,FORGID,FPSERSONID,FISINCLUDE,FISDELE,FDELEPERSONID,FINDEX) values (?,?,?,?,?,?,?,?) ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        WFPersonRoleCollection collection = ((WFRoleInfo)info).getPersonEntrys();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                String orgid = "";
                if (collection.get(i).getOrgID() != null) {
                    orgid = collection.get(i).getOrgID().getId().toString();
                }
                String personid = "";
                if (collection.get(i).getPersonID() != null) {
                    personid = collection.get(i).getPersonID().getId().toString();
                }
                String delePersonid = "";
                if (collection.get(i).getDelePersonID() != null) {
                    delePersonid = collection.get(i).getDelePersonID().getId().toString();
                }
                Object[] params = new Object[]{((WFRoleInfo)info).getId().toString(), version, orgid, personid, collection.get(i).isIsInclude(), collection.get(i).isIsDele(), delePersonid, i};
                paramsList.add(params);
                if (paramsList.size() <= 2000) continue;
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                paramsList.clear();
            }
            if (paramsList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            }
        }
    }

    @Override
    protected void _insertPositionRoleHst(Context ctx, IObjectValue info, String userid) throws BOSException {
        int version = this.insertRoleHst(ctx, (WFRoleInfo)info, userid);
        String sql = "insert into T_WFR_PositionRoleHst (FROLEID,FVERSION,FORGID,FPOSITIONID,FISINCLUDE,FISDELE,FDELEPERSONID,FINDEX) values (?,?,?,?,?,?,?,?) ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        WFPositionRoleCollection collection = ((WFRoleInfo)info).getPositionEntrys();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                String orgid = "";
                if (collection.get(i).getOrgID() != null) {
                    orgid = collection.get(i).getOrgID().getId().toString();
                }
                String positionid = "";
                if (collection.get(i).getPositionID() != null) {
                    positionid = collection.get(i).getPositionID().getId().toString();
                }
                String delePersonid = "";
                if (collection.get(i).getDelePersonID() != null) {
                    delePersonid = collection.get(i).getDelePersonID().getId().toString();
                }
                Object[] params = new Object[]{((WFRoleInfo)info).getId().toString(), version, orgid, positionid, collection.get(i).isIsInclude(), collection.get(i).isIsDele(), delePersonid, i};
                paramsList.add(params);
                if (paramsList.size() <= 2000) continue;
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                paramsList.clear();
            }
            if (paramsList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            }
        }
    }

    private int insertRoleHst(Context ctx, WFRoleInfo info, String userid) throws BOSException {
        String l = ctx.getLocale().toString();
        int version = 0;
        String roleid = "";
        if (info.getId() != null) {
            roleid = info.getId().toString();
        }
        if (!"".equals(roleid)) {
            StringBuffer bf = new StringBuffer("SELECT max(FVERSION) version FROM T_WFR_WFRoleHst where FROLEID = '");
            bf.append(roleid);
            bf.append("'");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)bf.toString());
            try {
                if (rows.next()) {
                    version = rows.getBigDecimal(1) != null ? rows.getBigDecimal(1).intValue() + 1 : 1;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            String sql = "insert into T_WFR_WFRoleHst (FROLEID,FVERSION,FROLENAME_" + l + ",FROLEDESCRIBE_" + l + ",FROLETYPE,FSTATE,FADMIN,FTreeID,FNUMBER,FCreatorID,FCreateTime) values (?,?,?,?,?,?,?,?,?,?,?) ";
            Object[] params = new Object[]{roleid, version, info.getRoleName(), info.getRoleDescribe(), info.getRoleType().getValue(), info.getState().getValue(), info.getAdmin().getId().toString(), info.getTreeid().getId().toString(), info.getNumber(), userid, new Timestamp(System.currentTimeMillis())};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        return version;
    }

    @Override
    protected void _updateWfRoleState(Context ctx, List ids, WFRoleState state) throws BOSException {
        if (StringUtils.isBlank((String)this.concat(ids))) {
            return;
        }
        String sql = "update T_WFR_WFRole set FSTATE=?,FLASTUPDATETIME=?, FLASTUPDATEUSERID=? where fid in (" + this.concat(ids) + ")";
        Object[] params = new Object[]{state.getValue(), new Timestamp(System.currentTimeMillis()), ctx.getCaller().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        CoreBaseCollection colls = this.getCollection(ctx, "where id in (" + this.concat(ids) + ")");
        for (int i = 0; i < colls.size(); ++i) {
            WFRoleInfo info = (WFRoleInfo)colls.get(i);
            if (WFRoleType.ORGROLE.equals((Object)info.getRoleType())) {
                this._insertOrgRoleHst(ctx, (IObjectValue)info, ctx.getCaller().toString());
                continue;
            }
            if (WFRoleType.PERSONROLE.equals((Object)info.getRoleType())) {
                this._insertPersonRoleHst(ctx, (IObjectValue)info, ctx.getCaller().toString());
                continue;
            }
            if (!WFRoleType.POSITIONROLE.equals((Object)info.getRoleType())) continue;
            this._insertPositionRoleHst(ctx, (IObjectValue)info, ctx.getCaller().toString());
        }
    }

    @Override
    protected void _batchAdmin(Context ctx, List ids, String admin) throws BOSException {
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)ctx, (WorkflowLogItem)WorkflowLogItem.WF_ROLE_UPDATE, (Object)ids);
        if (StringUtils.isBlank((String)this.concat(ids))) {
            return;
        }
        String sql = "update T_WFR_WFRole set FADMIN=?,FLASTUPDATETIME=?, FLASTUPDATEUSERID=? where fid in (" + this.concat(ids) + ")";
        Object[] params = new Object[]{admin, new Timestamp(System.currentTimeMillis()), ctx.getCaller().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        CoreBaseCollection colls = this.getCollection(ctx, "where id in (" + this.concat(ids) + ")");
        for (int i = 0; i < colls.size(); ++i) {
            WFRoleInfo info = (WFRoleInfo)colls.get(i);
            if (WFRoleType.ORGROLE.equals((Object)info.getRoleType())) {
                this._insertOrgRoleHst(ctx, (IObjectValue)info, ctx.getCaller().toString());
                continue;
            }
            if (WFRoleType.PERSONROLE.equals((Object)info.getRoleType())) {
                this._insertPersonRoleHst(ctx, (IObjectValue)info, ctx.getCaller().toString());
                continue;
            }
            if (!WFRoleType.POSITIONROLE.equals((Object)info.getRoleType())) continue;
            this._insertPositionRoleHst(ctx, (IObjectValue)info, ctx.getCaller().toString());
        }
        WorkflowLogUtil.endLogByLocal((Context)ctx, (IObjectPK)logPk);
    }

    public String concat(List<String> ids) {
        StringBuffer bf = new StringBuffer();
        if (ids == null || ids.size() == 0) {
            return bf.toString();
        }
        for (String s : ids) {
            bf.append("'");
            bf.append(s);
            bf.append("',");
        }
        return bf.toString().substring(0, bf.toString().length() - 1);
    }
}

