/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.app.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.cust.WFRoleType;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleAdapter;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WfRoleTestHelper {
    private static WfRoleAdapter roleAdapter = null;
    private static WfRoleTestHelper instance = null;

    public static WfRoleTestHelper getInstance() {
        return instance;
    }

    public WfRoleAdapter getRoleAdapter() {
        return roleAdapter;
    }

    public boolean test4RoleGroupByApplier(Context ctx, String roleGroupId, IObjectValue billInfo, String requestPropertyName, boolean IsInclude) throws WfException {
        PersonInfo person = roleAdapter.findPersonInBillInfo(ctx, billInfo, requestPropertyName);
        HashMap<String, String> map = this.sortRoles(ctx, roleGroupId);
        boolean b = this.test4Applier(ctx, map, person);
        return IsInclude ? b : !b;
    }

    public boolean test4RoleGroupByApplier(Context ctx, String roleGroupId, String billId, String requestPropertyName, boolean IsInclude) throws WfException {
        String requestType = roleAdapter.getRequestType(ctx, billId, requestPropertyName);
        PersonInfo person = roleAdapter.findPersonInBill(ctx, billId, requestPropertyName, requestType);
        HashMap<String, String> map = this.sortRoles(ctx, roleGroupId);
        boolean b = this.test4Applier(ctx, map, person);
        return IsInclude ? b : !b;
    }

    public boolean testByOrgProName(Context ctx, String orgRoleId, IObjectValue billInfo, String orgPropertyName, boolean OrgIsInclude) throws WfException {
        if (orgRoleId == null) {
            throw new WfException("\u53c2\u6570\u503c\u89d2\u8272ID\u4e3a\u7a7a\u3002");
        }
        if (billInfo == null) {
            throw new WfException("\u53c2\u6570\u503c\u5355\u636e\u4fe1\u606fbillInfo\u4e3a\u7a7a\u3002");
        }
        if (orgPropertyName == null) {
            throw new WfException("\u53c2\u6570\u503c\u7533\u8bf7\u5c5e\u6027orgPropertyName\u4e3a\u7a7a\u3002");
        }
        OrgUnitInfo orgInfo = (OrgUnitInfo)WfRoleUtils.getBillPropInfo(billInfo, orgPropertyName);
        OrgType orgType = WfRoleUtils.getOrgType(ctx, billInfo, orgPropertyName);
        OrgUnitInfo[] orgs = WfRoleUtils.findAdminOrgInfos(ctx, orgInfo, orgType);
        boolean orgTest = this.test4OrgPropRole(ctx, orgs, orgRoleId);
        return OrgIsInclude ? orgTest : !orgTest;
    }

    public boolean testByOrgProName(Context ctx, String orgRoleId, String billId, String orgPropertyName, boolean OrgIsInclude) throws WfException {
        if (orgRoleId == null) {
            throw new WfException("\u53c2\u6570\u503c\u89d2\u8272ID\u4e3a\u7a7a\u3002");
        }
        if (billId == null) {
            throw new WfException("\u53c2\u6570\u503c\u5355\u636e\u4fe1\u606fbillId\u4e3a\u7a7a\u3002");
        }
        if (orgPropertyName == null) {
            throw new WfException("\u53c2\u6570\u503c\u7533\u8bf7\u5c5e\u6027orgPropertyName\u4e3a\u7a7a\u3002");
        }
        OrgType orgType = WfRoleUtils.getOrgType(ctx, billId, orgPropertyName);
        OrgUnitInfo[] orgs = WfRoleUtils.findOrgInfosBillInfo(ctx, billId, orgPropertyName, orgType);
        boolean orgTest = this.test4OrgPropRole(ctx, orgs, orgRoleId);
        return OrgIsInclude ? orgTest : !orgTest;
    }

    private boolean test4OrgPropRole(Context ctx, OrgUnitInfo[] orgInfos, String roleGroupId) throws WfException {
        HashMap<String, String> map = this.sortRoles(ctx, roleGroupId);
        boolean a = false;
        boolean b = false;
        boolean c = false;
        if (map.get("T_WFR_PERSONROLE") != null) {
            a = this.orgProp_hasDataInTable("T_WFR_PERSONROLE", map.get("T_WFR_PERSONROLE"), orgInfos, ctx);
        }
        if (map.get("T_WFR_POSITIONROLE") != null) {
            b = this.orgProp_hasDataInTable("T_WFR_POSITIONROLE", map.get("T_WFR_POSITIONROLE"), orgInfos, ctx);
        }
        if (map.get("T_WFR_WFOrgRole") != null) {
            c = this.orgProp_hasDataInTable("T_WFR_WFOrgRole", map.get("T_WFR_WFOrgRole"), orgInfos, ctx);
        }
        return a || b || c;
    }

    private boolean test4Applier(Context ctx, HashMap<String, String> mapRoleIds, PersonInfo person) throws WfException {
        boolean a = false;
        boolean b = false;
        boolean c = false;
        if (mapRoleIds.get("T_WFR_PERSONROLE") != null) {
            a = this.test4person(ctx, person, mapRoleIds.get("T_WFR_PERSONROLE"));
        }
        if (mapRoleIds.get("T_WFR_POSITIONROLE") != null) {
            b = this.test4Position(ctx, person, mapRoleIds.get("T_WFR_POSITIONROLE"));
        }
        if (mapRoleIds.get("T_WFR_WFOrgRole") != null) {
            c = this.test4Org(ctx, person, mapRoleIds.get("T_WFR_WFOrgRole"));
        }
        return a || b || c;
    }

    private HashMap<String, String> sortRoles(Context ctx, String roleGroupId) throws WfException {
        String[] roleIdArray = roleAdapter.getRolesOfGroup(ctx, roleGroupId);
        Map<String, Object> roleData = null;
        WFRoleType roleType = null;
        String typePer = "";
        String typePos = "";
        String typeOrg = "";
        for (String roleId : roleIdArray) {
            roleData = roleAdapter.getRoleData(ctx, roleId);
            roleType = (WFRoleType)((Object)roleData.get("roletype"));
            if (roleType.getValue() == 0) {
                typePer = typePer + "'" + roleId + "',";
                continue;
            }
            if (roleType.getValue() == 1) {
                typePos = typePos + "'" + roleId + "',";
                continue;
            }
            if (roleType.getValue() != 2) continue;
            typeOrg = typeOrg + "'" + roleId + "',";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (typePer.length() > 0) {
            map.put("T_WFR_PERSONROLE", this.formatIdStr(typePer));
        }
        if (typePos.length() > 0) {
            map.put("T_WFR_POSITIONROLE", this.formatIdStr(typePos));
        }
        if (typeOrg.length() > 0) {
            map.put("T_WFR_WFOrgRole", this.formatIdStr(typeOrg));
        }
        return map;
    }

    private boolean orgProp_hasDataInTable(String tableName, String ids, OrgUnitInfo[] orgInfos, Context ctx) throws WfException {
        List<?> list;
        String sqlStr = "select forgid from " + tableName + " where FROLEID in(" + ids + ") ";
        if (orgInfos != null && orgInfos.length != 0) {
            String orgIdStr = WfRoleUtils.joinIdString(orgInfos);
            sqlStr = sqlStr + " and FORGID in (" + orgIdStr + ")";
        }
        if ((list = WfRoleUtils.exectueQuery(ctx, sqlStr, null, null)).size() <= 0) {
            sqlStr = "select top 1 t1.forgid from " + tableName + " t1 inner join T_ORG_Admin t2 on t1.FORGID = t2.FID where t1.FROLEID in(" + ids + ") and t1.FISINCLUDE = 1 ";
            if (orgInfos != null && orgInfos.length != 0) {
                String longNumStrParam = WfRoleUtils.joinLongNumString(orgInfos);
                sqlStr = sqlStr + " and  t2.FLongNumber in (" + longNumStrParam + ") ";
            }
            if ((list = WfRoleUtils.exectueQuery(ctx, sqlStr = sqlStr + " order by t2.flevel desc ", null, null)).size() <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean test4person(Context ctx, PersonInfo person, String roleIds) throws WfException {
        String sqlStr = "select fid from T_WFR_PERSONROLE where FROLEID in(" + roleIds + ") and FPSERSONID = ?";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{person.getId().toString()});
        int real = list.size();
        if (real > 0) {
            return true;
        }
        sqlStr = "select count(*) ftotal from T_WFR_PERSONROLE t1,  T_ORG_PositionMember t3, T_ORG_Position t4,T_ORG_Admin t5,T_ORG_Admin t6  where t3.FPositionID = t4.FID  and t5.FID = t4.FAdminOrgUnitID  and t1.FORGID = t6.FID  and (SUBSTRING(t5.FLongNumber, 0,LENGTH(t6.FLongNumber) + 1) = t6.FLongNumber || '!' AND t5.FLevel > t6.FLevel) and t3.FPersonID = ?  and t1.FROLEID in (" + roleIds + ") and t1.FPSERSONID = ?  and t1.FISINCLUDE = 1 ";
        list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12, 12}, new String[]{person.getId().toString(), person.getId().toString()});
        return roleAdapter.isExisted(list);
    }

    private boolean test4Position(Context ctx, PersonInfo person, String roleIds) throws WfException {
        String sqlStr = "select count(*) ftotal from T_WFR_POSITIONROLE t1, T_ORG_PositionMember t2 where t2.FPositionID  =  t1.FPOSITIONID and t1.FROLEID in(" + roleIds + ") and t2.FPERSONID = ? ";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{person.getId().toString()});
        if (roleAdapter.isExisted(list)) {
            return true;
        }
        sqlStr = "select count(*) ftotal from T_WFR_POSITIONROLE t1,  T_ORG_PositionMember t3, T_ORG_Position t4,T_ORG_Admin t5,T_ORG_Admin t6  where t3.FPositionID = t4.FID  and t5.FID = t4.FAdminOrgUnitID  and t1.FORGID = t6.FID  and (SUBSTRING(t5.FLongNumber, 0,LENGTH(t6.FLongNumber) + 1) = t6.FLongNumber || '!' AND t5.FLevel > t6.FLevel) and t1.FPositionID = t3.FPositionID  and t1.FISINCLUDE = 1  and t1.FROLEID in(" + roleIds + ") and t3.FPERSONID = ? ";
        list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{person.getId().toString()});
        return roleAdapter.isExisted(list);
    }

    private boolean test4Org(Context ctx, PersonInfo person, String roleIds) throws WfException {
        String sqlStr = "select count(*) ftotal from T_WFR_WFOrgRole t1, T_ORG_PositionMember t3, T_ORG_Position t4  where t3.FPositionID = t4.FID  and t1.FORGID = t4.FAdminOrgUnitID  and t1.FROLEID = (" + roleIds + ")  and t3.FPersonID = ?";
        List<?> list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{person.getId().toString()});
        if (roleAdapter.isExisted(list)) {
            return true;
        }
        sqlStr = "select count(*) ftotal from T_WFR_WFOrgRole t1, T_ORG_PositionMember t3, T_ORG_Position t4,T_ORG_Admin t5,T_ORG_Admin t6  where t3.FPositionID = t4.FID  and t5.FID = t4.FAdminOrgUnitID  and t1.FORGID = t6.FID  and (SUBSTRING(t5.FLongNumber, 0,LENGTH(t6.FLongNumber) + 1) = t6.FLongNumber || '!' AND t5.FLevel > t6.FLevel) and t1.FISINCLUDE = 1  and t1.FROLEID in (" + roleIds + ")  and t3.FPersonID = ?";
        list = WfRoleUtils.exectueQuery(ctx, sqlStr, new int[]{12}, new String[]{person.getId().toString()});
        return roleAdapter.isExisted(list);
    }

    private String formatIdStr(String idStr) {
        if (idStr.endsWith(",")) {
            idStr = idStr.substring(0, idStr.length() - 1);
        }
        return idStr;
    }

    static {
        roleAdapter = new WfRoleAdapter();
        instance = new WfRoleTestHelper();
    }
}

