/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.app.startsheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizProcInfo;
import com.kingdee.bos.workflow.cust.WFBillConditionCollection;
import com.kingdee.bos.workflow.cust.WFBillConditionInfo;
import com.kingdee.bos.workflow.cust.WFStartOrgCollection;
import com.kingdee.bos.workflow.cust.WFStartOrgInfo;
import com.kingdee.bos.workflow.cust.WFStartSchemeFactory;
import com.kingdee.bos.workflow.cust.WFStartSchemeInfo;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleAdapter;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleTestHelper;
import com.kingdee.bos.workflow.cust.app.impl.WfRoleUtils;
import com.kingdee.bos.workflow.cust.app.startsheme.SQLUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public class WFStartSchemeHelper {
    public static Object[] findProcDef(Context ctx, String billBosType, IObjectValue bizObject, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        return WFStartSchemeHelper.findProcDef(ctx, billBosType, null, bizObject, bizFunc, bizPackage, bizOperation);
    }

    public static Object[] findProcDef(Context ctx, String billBosType, String billId, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        return WFStartSchemeHelper.findProcDef(ctx, billBosType, billId, null, bizFunc, bizPackage, bizOperation);
    }

    private static Object[] findProcDef(Context ctx, String billBosType, String billId, IObjectValue bizObject, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        boolean bRet;
        Object[] result = new Object[3];
        Object[] procDef = WFStartSchemeHelper.findProcDefByBillBosType(ctx, billBosType);
        if (procDef == null) {
            result[0] = "A0100";
            return result;
        }
        String procDefId = (String)procDef[0];
        int innerVersion = (Integer)procDef[1];
        WFStartSchemeInfo startScheme = WFStartSchemeHelper.findScheme(ctx, procDefId);
        if (startScheme == null) {
            result[0] = "A0200";
            return result;
        }
        String startSchemeId = "";
        if (startScheme.getId() != null) {
            startSchemeId = startScheme.getId().toString();
        }
        if (!(bRet = WFStartSchemeHelper.isAssigned(ctx, startScheme, billBosType, billId, bizObject))) {
            result[0] = "A0300";
            result[1] = startSchemeId;
            return result;
        }
        bRet = WFStartSchemeHelper.isMatchBillCondition(ctx, startScheme, billBosType, billId, bizObject);
        if (!bRet) {
            result[0] = "A0400";
            result[1] = startSchemeId;
            return result;
        }
        bRet = WFStartSchemeHelper.isMatchAdvancedCondition(ctx, startScheme, billBosType, billId, bizObject);
        if (!bRet) {
            result[0] = "A0500";
            result[1] = startSchemeId;
            return result;
        }
        bRet = WFStartSchemeHelper.isMatchWFRoleCondition(ctx, startScheme, billId, bizObject);
        if (!bRet) {
            result[0] = "A0600";
            result[1] = startSchemeId;
            return result;
        }
        String firstActId = WFStartSchemeHelper.findFirstActId(ctx, procDefId, bizFunc, bizPackage, bizOperation);
        BizProcInfo bizProcInfo = new BizProcInfo();
        bizProcInfo.setProcDefId(procDefId);
        bizProcInfo.setInnerVersion(innerVersion);
        bizProcInfo.setProcStartActDefId(firstActId);
        result[0] = "A0700";
        result[1] = bizProcInfo;
        result[2] = startSchemeId;
        return result;
    }

    private static Object[] findProcDefByBillBosType(Context ctx, String billBosType) throws WfException {
        StringBuffer sql = new StringBuffer(300);
        sql.append("select top 1 FPROCDEFID, FINNERVERSION ").append("from t_wfr_procdef a ").append("where a.finnerversion = ").append("(select max(finnerversion) ").append("from t_wfr_procdef ").append("where fprocdefid = a.fprocdefid) ").append("and a.FBillBosType = ? ").append("and a.FENABLE = 1 ").append("order by FCREATEDTIME desc ");
        Object[] result = null;
        try {
            IRowSet rs = SQLUtils.executeQuery(ctx, sql.toString(), new Object[]{billBosType});
            if (rs.next()) {
                result = new Object[]{rs.getString("FPROCDEFID"), rs.getInt("FINNERVERSION")};
            }
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        return result;
    }

    private static WFStartSchemeInfo findScheme(Context ctx, String procDefId) throws WfException {
        WFStartSchemeInfo result = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select *,").append("wfStartOrgEntrys.isInclude,wfStartOrgEntrys.adminOrg.id,").append("wfStartOrgEntrys.adminOrg.number,wfStartOrgEntrys.adminOrg.longnumber,").append("wfBillConditionEntrys.billPropertyName_EN,wfBillConditionEntrys.billPropertyValueType,wfBillConditionEntrys.billPropertyValue_EN ").append("where state = 0 and procDefID = '" + procDefId + "'");
            CoreBaseCollection col = WFStartSchemeFactory.getLocalInstance(ctx).getCollection(sb.toString());
            if (col.size() > 0) {
                result = (WFStartSchemeInfo)col.get(0);
            }
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        return result;
    }

    private static boolean isAssigned(Context ctx, WFStartSchemeInfo schemeInfo, String billBosType, String billId, IObjectValue bizObject) throws WfException {
        WFStartOrgCollection col = schemeInfo.getWfStartOrgEntrys();
        if (col.size() == 0) {
            return true;
        }
        BOSObjectType bosType = BOSObjectType.create((String)billBosType);
        String orgProName = schemeInfo.getBizOrgPropertyName();
        OrgType orgType = WfRoleUtils.getOrgType(ctx, bosType, orgProName);
        OrgUnitInfo[] adminOrgs = null;
        if (bizObject != null) {
            OrgUnitInfo mainOrgUnitInfo = (OrgUnitInfo)bizObject.get(orgProName);
            if (mainOrgUnitInfo == null) {
                throw new WfException("\u5355\u636e(" + bosType.toString() + ")\u7684\u5c5e\u6027\u503c\u4e0d\u662forgUnitInfo\u7c7b\u578b.");
            }
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            ObjectStringPK orgPK = new ObjectStringPK(mainOrgUnitInfo.getId().toString());
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("longnumber"));
            selector.add(new SelectorItemInfo("isAdminOrgUnit"));
            IObjectValue objVal = null;
            try {
                objVal = dynamicObject.getValue(mainOrgUnitInfo.getBOSType(), (IObjectPK)orgPK, selector);
            }
            catch (BOSException e) {
                throw new WfException(e.getMessage(), (Throwable)e);
            }
            mainOrgUnitInfo = (OrgUnitInfo)objVal;
            adminOrgs = WfRoleUtils.findAdminOrgInfos(ctx, mainOrgUnitInfo, orgType);
        } else {
            adminOrgs = WfRoleUtils.findOrgInfosBillInfo(ctx, billId, orgProName, orgType);
        }
        for (OrgUnitInfo adminInfo : adminOrgs) {
            int sizeJ = col.size();
            for (int j = 0; j < sizeJ; ++j) {
                WFStartOrgInfo wfStartOrgInfo = col.get(j);
                AdminOrgUnitInfo assignAdmin = col.get(j).getAdminOrg();
                if (assignAdmin != null && assignAdmin.getLongNumber() != null && assignAdmin.getLongNumber().equals(adminInfo.getLongNumber())) {
                    return true;
                }
                if (!wfStartOrgInfo.isIsInclude()) continue;
                String longnumber1 = assignAdmin.getLongNumber() + "!";
                if (!adminInfo.getLongNumber().substring(0, longnumber1.length() - 1).equals(assignAdmin.getLongNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMatchBillCondition(Context ctx, WFStartSchemeInfo schemeInfo, String billBosType, String billId, IObjectValue bizObject) throws WfException {
        if (schemeInfo.getBillConditionScript() != null && schemeInfo.getBillConditionScript().length() > 0) {
            IObjectValue objVal = null;
            if (billId != null && bizObject == null) {
                WFBillConditionCollection col = schemeInfo.getWfBillConditionEntrys();
                SelectorItemCollection selector = new SelectorItemCollection();
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    WFBillConditionInfo conditionInfo = col.get(i);
                    selector.add(new SelectorItemInfo(conditionInfo.getBillPropertyName_EN()));
                    if (!conditionInfo.getBillPropertyValueType().startsWith("F7")) continue;
                    selector.add(new SelectorItemInfo(conditionInfo.getBillPropertyValue_EN()));
                }
                IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                ObjectStringPK pk = new ObjectStringPK(billId);
                try {
                    objVal = dynamicObject.getValue(BOSObjectType.create((String)billBosType), (IObjectPK)pk, selector);
                }
                catch (BOSException e) {
                    throw new WfException(e.getMessage(), (Throwable)e);
                }
            } else {
                objVal = bizObject;
            }
            return WFStartSchemeHelper.evalScript(ctx, objVal, schemeInfo.getBillConditionScript());
        }
        return true;
    }

    private static boolean isMatchAdvancedCondition(Context ctx, WFStartSchemeInfo schemeInfo, String billBosType, String billId, IObjectValue bizObject) throws WfException {
        if (schemeInfo.getAdvanceScript() != null && schemeInfo.getAdvanceScript().length() > 0) {
            IObjectValue objVal = null;
            if (billId != null && bizObject == null) {
                IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                ObjectStringPK pk = new ObjectStringPK(billId);
                try {
                    objVal = dynamicObject.getValue(BOSObjectType.create((String)billBosType), (IObjectPK)pk);
                }
                catch (BOSException e) {
                    throw new WfException(e.getMessage(), (Throwable)e);
                }
            } else {
                objVal = bizObject;
            }
            return WFStartSchemeHelper.evalScript(ctx, objVal, schemeInfo.getAdvanceScript());
        }
        return true;
    }

    private static boolean isMatchWFRoleCondition(Context ctx, WFStartSchemeInfo schemeInfo, String billId, IObjectValue bizObject) throws WfException {
        if (schemeInfo.isIsRole()) {
            boolean isMatched = false;
            WfRoleTestHelper helper = WfRoleTestHelper.getInstance();
            WfRoleAdapter wfRoleAdapter = helper.getRoleAdapter();
            isMatched = !StringUtils.isEmpty((String)schemeInfo.getBillPersonProperty()) ? (schemeInfo.isIsWfRoleGroup() ? (bizObject != null ? helper.test4RoleGroupByApplier(ctx, schemeInfo.getWfRoleGroup().getId().toString(), bizObject, schemeInfo.getBillPersonProperty(), schemeInfo.isIsBelong()) : helper.test4RoleGroupByApplier(ctx, schemeInfo.getWfRoleGroup().getId().toString(), billId, schemeInfo.getBillPersonProperty(), schemeInfo.isIsBelong())) : (bizObject != null ? wfRoleAdapter.test(ctx, schemeInfo.getWfRole().getId().toString(), bizObject, schemeInfo.getBillPersonProperty(), schemeInfo.isIsBelong()) : wfRoleAdapter.test(ctx, schemeInfo.getWfRole().getId().toString(), billId, schemeInfo.getBillPersonProperty(), schemeInfo.isIsBelong()))) : true;
            if (!isMatched) {
                return false;
            }
            isMatched = !StringUtils.isEmpty((String)schemeInfo.getBillOrgProperty()) ? (schemeInfo.isIsWfOrgRoleGroup() ? (bizObject != null ? helper.testByOrgProName(ctx, schemeInfo.getWfOrgRoleGroup().getId().toString(), bizObject, schemeInfo.getBillOrgProperty(), schemeInfo.isIsBelongOrg()) : helper.testByOrgProName(ctx, schemeInfo.getWfOrgRoleGroup().getId().toString(), billId, schemeInfo.getBillOrgProperty(), schemeInfo.isIsBelongOrg())) : (bizObject != null ? wfRoleAdapter.testByOrgProName(ctx, schemeInfo.getWfOrgRole().getId().toString(), bizObject, schemeInfo.getBillOrgProperty(), schemeInfo.isIsBelongOrg()) : wfRoleAdapter.testByOrgProName(ctx, schemeInfo.getWfOrgRole().getId().toString(), billId, schemeInfo.getBillOrgProperty(), schemeInfo.isIsBelongOrg()))) : true;
            return isMatched;
        }
        return true;
    }

    private static String findFirstActId(Context ctx, String procDefId, String bizFunc, String bizPackage, String bizOperation) throws WfException {
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT top 1 FACTDEFID FROM T_WFR_BIZPROC ").append(" WHERE FPROCDEFID = ? and FBIZFUNC = ? and FBIZPACKAGE = ? and FBIZOPERATION = ? ").append(" ORDER BY FPERFORMERTYPE ASC, FPROCDEFPRIORITY DESC");
        String result = null;
        try {
            IRowSet rs = SQLUtils.executeQuery(ctx, sql.toString(), new Object[]{procDefId, bizFunc, bizPackage, bizOperation});
            if (rs.next()) {
                result = rs.getString("FACTDEFID");
            }
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
        return result;
    }

    private static boolean evalScript(Context ctx, IObjectValue bizObject, String script) throws WfException {
        Object rtnVal;
        Interpreter interpreter = new Interpreter(ctx);
        interpreter.setProperyExprOwnerNullIgore(true);
        try {
            HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
            map.put("__processTrigger", bizObject);
            rtnVal = interpreter.eval(script, map);
        }
        catch (Throwable e) {
            return false;
        }
        if (rtnVal == null) {
            return false;
        }
        if (rtnVal instanceof Boolean) {
            return (Boolean)rtnVal;
        }
        if (rtnVal instanceof Number) {
            return ((Number)rtnVal).intValue() == 1;
        }
        return false;
    }
}

