/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz.event;

import com.kingdee.bos.Context;
import com.kingdee.bos.event.CommonEvent;
import com.kingdee.bos.event.EventDataType;
import com.kingdee.bos.event.EventPriority;
import com.kingdee.bos.event.EventSeverity;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.adapter.BOSEventServiceConfig;
import com.kingdee.bos.event.core.launcher.EventLauncherFactory;
import com.kingdee.bos.event.exception.CommonEventException;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.exception.EventValidationException;
import com.kingdee.bos.event.model.EventRepositoryService;
import com.kingdee.bos.event.model.cem.ExtendedData;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.EventActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfEventProducer {
    private static final Logger logger = Logger.getLogger(WfEventProducer.class);
    private WfEngine engine;
    private EventRepositoryService eventRepositoryService;

    public WfEventProducer(WfEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("WfEventProducer must have a WfEngine ,can't be null");
        }
        this.engine = engine;
    }

    public void createAndSendEvent(EventActivityDef eventActivityDef, Map parameterMap) throws Exception {
        if (eventActivityDef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"createAndSendEvent args eventActivityDef is null");
            }
            return;
        }
        ICommonEvent commonEvent = this.createAndFillEvent(eventActivityDef, parameterMap);
        if (commonEvent == null) {
            throw new WfException("commonEvent is null");
        }
        this.sendEvent(commonEvent);
    }

    public void sendEvent(ICommonEvent commonEvent) throws WfException, CommonEventException {
        String protocol = BOSEventServiceConfig.getInstance().getProtocol();
        String serverUrl = BOSEventServiceConfig.getInstance().getServerUrl();
        if (StringUtils.isEmpty((String)protocol) || StringUtils.isEmpty((String)serverUrl)) {
            throw new WfException("EventServer config protocol is null");
        }
        EventLauncherFactory.getEventLauncher((String)protocol, (String)serverUrl).sendEvent(commonEvent);
    }

    private ICommonEvent createAndFillEvent(EventActivityDef eventActivityDef, Map parameterMap) throws WfException {
        com.kingdee.bos.event.model.cem.CommonEvent commonEventDef;
        String eventName = eventActivityDef.getEventName();
        if (StringUtils.isEmpty((String)eventName)) {
            throw new WfException(eventActivityDef.getName() + " eventName is empty");
        }
        CommonEvent commonEvent = new CommonEvent(eventName);
        try {
            commonEventDef = this.getEventRepositoryService().getCommonEvent(eventName);
        }
        catch (EventRepositoryException e) {
            throw new WfException((Throwable)e, true);
        }
        this.fillBasicAttr((ICommonEvent)commonEvent, commonEventDef);
        this.fillExtendedAttr((ICommonEvent)commonEvent, parameterMap);
        this.fillContextAttr((ICommonEvent)commonEvent);
        return commonEvent;
    }

    private void fillContextAttr(ICommonEvent commonEvent) {
        if (commonEvent == null) {
            return;
        }
        Context context = this.engine.context();
        commonEvent.setDataCenterName(context.getAIS());
        commonEvent.setSolutionName(context.getSolution());
        commonEvent.setContextDataValue("contextId", context.getContextID());
        commonEvent.setContextDataValue("userName", context.getUserName());
    }

    private void fillExtendedAttr(ICommonEvent commonEvent, Map parameterMap) throws WfException {
        if (parameterMap == null || parameterMap.size() <= 0) {
            return;
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            String extendedAttrName = (String)entry.getKey();
            try {
                commonEvent.setExtendedDataValue(extendedAttrName, entry.getValue());
            }
            catch (EventValidationException e) {
                throw new WfException((Throwable)e, true);
            }
        }
    }

    private void fillBasicAttr(ICommonEvent commonEvent, com.kingdee.bos.event.model.cem.CommonEvent commonEventDef) throws WfException {
        if (commonEvent == null || commonEventDef == null) {
            throw new IllegalArgumentException();
        }
        commonEvent.setEventDefId(commonEventDef.getId());
        commonEvent.setAlias(this.engine.getLocale(), commonEventDef.getAlias());
        commonEvent.setDescription(this.engine.getLocale(), commonEventDef.getDescription());
        commonEvent.setEventType(commonEventDef.getType());
        commonEvent.setGroup(commonEventDef.getGroup());
        commonEvent.setPriority(EventPriority.getEnum((String)commonEventDef.getPriority()));
        commonEvent.setSeverity(EventSeverity.getEnum((String)commonEventDef.getSeverity()));
        commonEvent.setVersion(commonEventDef.getVersion());
        Object[] extendsAttr = commonEventDef.getExtendedDatas().getExtendedData().toArray();
        if (extendsAttr != null && extendsAttr.length > 0) {
            for (int i = 0; i < extendsAttr.length; ++i) {
                ExtendedData data = (ExtendedData)extendsAttr[i];
                try {
                    commonEvent.addExtendedData(data.getName(), EventDataType.getEnum((String)data.getDataType()), null);
                    continue;
                }
                catch (EventValidationException e) {
                    throw new WfException((Throwable)e, true);
                }
            }
        }
    }

    private EventRepositoryService getEventRepositoryService() {
        if (this.eventRepositoryService == null) {
            this.eventRepositoryService = new EventRepositoryService();
        }
        return this.eventRepositoryService;
    }
}

