/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.biz.event;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.subscribe.IEventSubscriberOrmrpcProxy;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.event.EventExecutorDelegator;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.EventProcMetaInfo;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.CommonEventUtils;
import com.kingdee.bos.workflow.util.MethodDesc;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class WfEventSubscriber
extends ORMObject
implements IEventSubscriberOrmrpcProxy {
    private static final Logger logger = Logger.getLogger(WfEventSubscriber.class);

    public void onEvent(ICommonEvent event) throws Exception {
        if (event == null) {
            throw new WfException("WfEventSubscriber received event is null,please check!");
        }
        if (StringUtils.isEmpty((String)event.getSolutionName()) || StringUtils.isEmpty((String)event.getDataCenterName())) {
            throw new WfException("WfEventSubscriber receiced event's datacenter and solution can't be null");
        }
        WfEngine wfEngine = WfEngine.getEngine(event.getDataCenterName(), event.getSolutionName());
        EventProcMetaInfo[] eventProcMetaInfos = CommonEventUtils.getMatchedEventProcMetaInfo(event, wfEngine);
        if (eventProcMetaInfos == null || eventProcMetaInfos.length <= 0) {
            String log = "The Event not refrence by workflow,will be discard! The Event Name is : " + event.getName();
            logger.info((Object)log);
            CommonEventUtils.loggingToEngineLog(wfEngine, log, null);
        } else {
            this.invokeEventExecutor(event, eventProcMetaInfos, wfEngine);
        }
    }

    public void invokeEventExecutor(ICommonEvent event, EventProcMetaInfo[] eventProcMetaInfos, WfEngine wfEngine) throws WfException {
        Class<EventExecutorDelegator> classCaller = EventExecutorDelegator.class;
        EventExecutorDelegator obj = new EventExecutorDelegator();
        String methodName = "delegateToEventExecutor";
        Class[] parameterTypes = new Class[]{ICommonEvent.class, EventProcMetaInfo[].class, WfEngine.class};
        Object[] args = new Object[]{event, eventProcMetaInfos, wfEngine};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        WfTxHelper.invokeRequired(wfEngine.context(), invocationDesc);
    }
}

