/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cleaner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.wrapper.InterfaceWrapper;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.cleaner.CalcPlan;
import com.kingdee.bos.workflow.cleaner.WfCalcDataSize;
import com.kingdee.bos.workflow.cleaner.WfDataCleaner;
import com.kingdee.bos.workflow.enactment.message.DirectSenderAgent;
import com.kingdee.bos.workflow.metas.IInvokeMethodDelegate;
import com.kingdee.bos.workflow.metas.InvokeMethodDelegateFactory;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.cbos.process.vm.utils.XmlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.springframework.util.unit.DataSize;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WfDataManager {
    private static final Logger logger = Logger.getLogger(WfDataManager.class);
    private static final String PLANID = "1";
    private static final String PLANID_CONFIG = "2";
    private static final String JOBID_CALC = "f7230cbe-b792-43c4-b8e5-98084446365dBGJOBDEF";
    private static final String JOBID_CLEAN = "767a4cd4-2f31-4576-9777-1c98bc845d8dBGJOBDEF";
    private static final String fakeBostye = "WFDATARD";
    private static final Set<String> wfTables = new HashSet<String>();
    private static final Set<String> wfHisTables = new HashSet<String>();
    private static final Set<String> wfLogTables = new HashSet<String>();
    private static String wfTableSql;
    private static Map<String, String> oracletableSpace;
    private static Map<String, String> dbNameMap;
    private static final WfDataManager instance;
    private static final Map<String, Integer> dbtypeCache;
    private static final String AUTO_DELETE_PERMANENT = "auto_del_permanent";
    private static final String DELETE_PERMANENT = "del_permanent";
    private static final String DELETE_TEMPORARY = "del_temporary";
    private static final String RECOVERY = "recovery";
    private static final String commonSql = " where fprocinstId in (select fprocinstId from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s )";
    private static Map<String, String> tableSqlMap;

    public static void testPlan(Context ctx) throws BOSException {
        WfDataManager.testPlan(ctx, false);
    }

    public static void testPlan(Context ctx, boolean isSendMsg) throws BOSException {
        IInvokeMethodDelegate invokeMethodDelegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
        invokeMethodDelegate.invokeRequired(WfDataManager.class.getName(), (Object)instance, "testPlanInner", new Class[]{Context.class, Boolean.TYPE}, new Object[]{ctx, isSendMsg});
    }

    public void testPlanInner(Context ctx, boolean isSendMsg) throws BOSException {
        CalcPlan plan;
        List<JSONObject> data = WfDataManager.getDataSizeRecord(ctx, 1);
        if (data.size() > 0) {
            Date lastCreateTime = data.get(0).getDate("createTime");
            if (System.currentTimeMillis() - lastCreateTime.getTime() <= 60000L) {
                Locale locale = ctx.getLocale();
                if (locale.toString().toLowerCase(Locale.ENGLISH).equals("l1")) {
                    throw new BOSException("please try again later, the shortest intervals of check-operation is 1 minute");
                }
                if (locale.toString().toLowerCase(Locale.ENGLISH).equals("l3")) {
                    throw new BOSException("\u8acb\u7a0d\u5f8c\u64cd\u4f5c\uff0c\u76ee\u524d\u6700\u77ed\u6aa2\u67e5\u6642\u9593\u9593\u9694\u70ba1\u5206\u9418");
                }
                throw new BOSException("\u8bf7\u7a0d\u540e\u64cd\u4f5c\uff0c\u76ee\u524d\u6700\u77ed\u68c0\u67e5\u65f6\u95f4\u95f4\u9694\u4e3a1\u5206\u949f");
            }
        }
        Map<String, Object> recordData = WfDataManager.createDataSizeRecord(ctx);
        String recordDataJSON = JSON.toJSONString(recordData);
        String sendDataJSON = null;
        if (isSendMsg && (plan = WfDataManager.getPlan(ctx)) != null && isSendMsg) {
            long threshold = plan.getThreshold();
            long realThreshold = (Long)recordData.get("wfSize");
            JSONArray receivers = plan.getReceivers();
            if (realThreshold > threshold && receivers.size() > 0) {
                String title = plan.getTitle();
                String body = plan.getBody();
                if (StringUtils.isEmpty((String)body)) {
                    body = title;
                }
                boolean email = plan.isEmail();
                boolean mobile = plan.isMobile();
                boolean wfMsg = plan.isWfMsg();
                HashMap<String, Object> sendData = new HashMap<String, Object>();
                sendData.put("title", title);
                sendData.put("body", body);
                sendData.put("wfMsg", wfMsg);
                sendData.put("email", email);
                sendData.put("mobile", mobile);
                sendData.put("receivers", receivers);
                sendData.put("threshold", threshold);
                sendData.put("realThreshold", realThreshold);
                sendDataJSON = JSON.toJSONString(sendData);
                if (wfMsg || email || mobile) {
                    StringBuilder receiversBuilder = new StringBuilder();
                    for (int i = 0; i < receivers.size(); ++i) {
                        String receiver = receivers.getJSONObject(i).getString("id");
                        if (i > 0) {
                            receiversBuilder.append(";");
                        }
                        receiversBuilder.append(receiver);
                    }
                    WfDataManager.sendMsg(ctx, title, body, wfMsg, email, mobile, receiversBuilder.toString());
                }
            }
        }
        String sql = "insert into T_WFR_DataSizeRecord (fid,FRecordData,FSendData,FCreateTime) values (?,?,?,?)";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{BOSUuid.create((String)fakeBostye).toString(), recordDataJSON, sendDataJSON, new Timestamp(System.currentTimeMillis())});
    }

    private static void initDbMap() throws BOSException {
        String datacenterConfigPath;
        if (dbNameMap == null && !StringUtils.isEmpty((String)(datacenterConfigPath = System.getProperty("datacenter.config")))) {
            try {
                String xml = FileUtils.readFileToString((File)new File(datacenterConfigPath));
                Document document = XmlUtil.parse((String)xml);
                NodeList datacenters = document.getElementsByTagName("datacenter");
                dbNameMap = new HashMap<String, String>();
                for (int i = 0; i < datacenters.getLength(); ++i) {
                    Element datacenter = (Element)datacenters.item(i);
                    String dbType = datacenter.getAttribute("dbtype");
                    if ("oracle".equalsIgnoreCase(dbType)) {
                        dbNameMap.put(datacenter.getAttribute("id"), datacenter.getAttribute("dbuser"));
                        continue;
                    }
                    dbNameMap.put(datacenter.getAttribute("id"), datacenter.getAttribute("dbname"));
                }
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private static String initOracletableSpace(Context ctx) throws BOSException {
        String oracleTableSpaceSql = oracletableSpace.get(ctx.getAIS());
        if (oracleTableSpaceSql == null) {
            String sql = "select distinct tablespace_name from dba_data_files where  tablespace_name like '%" + dbNameMap.get(ctx.getAIS()) + "%' ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)WfDataManager.dialectSql(sql));
            StringBuilder sb = new StringBuilder();
            sb.append(" (");
            try {
                while (rs.next()) {
                    sb.append("'").append(rs.getString(1)).append("',");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            sb.setLength(sb.length() - 1);
            sb.append(")");
            oracleTableSpaceSql = sb.toString();
            oracletableSpace.put(ctx.getAIS(), oracleTableSpaceSql);
        }
        return oracleTableSpaceSql;
    }

    private static Map<String, Object> createDataSizeRecord(Context ctx) throws BOSException {
        try {
            Object rowSet;
            Statement statement;
            Throwable throwable;
            int dbType = WfDataManager.getDbType(ctx);
            String allSql = null;
            String wfSql = null;
            long databaseSize = 0L;
            long wfAllSize = 0L;
            WfDataManager.initDbMap();
            ArrayList tableSizeList = new ArrayList();
            if (DbType.isOracle((int)dbType) || dbType == 11) {
                String oracleTableSpaceSql = WfDataManager.initOracletableSpace(ctx);
                allSql = dbType == 11 ? "select bytes from dba_data_files where tablespace_name in " + oracleTableSpaceSql : "select sum(bytes) from(\tselect bytes from dba_temp_files where tablespace_name in " + oracleTableSpaceSql + "\tunion all\tselect bytes from dba_data_files where tablespace_name in " + oracleTableSpaceSql + ")";
                wfSql = "\tselect tableName,sum(bytes) from( select segment_name tableName,bytes from user_segments where  segment_name in " + wfTableSql + "  and  tablespace_name in " + oracleTableSpaceSql + " union all select b.table_name tableName,a.bytes bytes from user_segments a join user_indexes b on a.segment_name=b.index_name where b.table_name in " + wfTableSql + " and a.tablespace_name in " + oracleTableSpaceSql + " ) group by tableName";
            } else if (dbType == 3) {
                throwable = null;
                try (Connection conn = EJBFactory.getConnection((Context)ctx);){
                    String sql2 = "exec sp_spaceused";
                    statement = conn.createStatement();
                    rowSet = statement.executeQuery(WfDataManager.dialectSql(sql2));
                    if (rowSet.next()) {
                        String string = rowSet.getString("database_size");
                        databaseSize = DataSize.parse((CharSequence)WfDataManager.formatDataSizeStr(string)).toBytes();
                        SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
                    }
                    for (String wfTable : wfTables) {
                        sql2 = "exec sp_spaceused " + wfTable;
                        statement = conn.createStatement();
                        rowSet = statement.executeQuery(WfDataManager.dialectSql(sql2));
                        if (rowSet.next()) {
                            long indexSize = DataSize.parse((CharSequence)WfDataManager.formatDataSizeStr(rowSet.getString("index_size"))).toBytes();
                            long data = DataSize.parse((CharSequence)WfDataManager.formatDataSizeStr(rowSet.getString("data"))).toBytes();
                            long tableSize = indexSize + data;
                            HashMap<String, Object> row = new HashMap<String, Object>();
                            row.put("name", wfTable);
                            row.put("size", tableSize);
                            row.put("humanSize", WfDataManager.toHumanSize(tableSize));
                            tableSizeList.add(row);
                            wfAllSize += tableSize;
                        }
                        SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
                    }
                }
                catch (Throwable sql2) {
                    throwable = sql2;
                    throw sql2;
                }
            } else if (dbType == 5 || dbType == 12) {
                throwable = null;
                try (Connection conn = EJBFactory.getConnection((Context)ctx);){
                    String sql3 = "select pg_database_size('" + dbNameMap.get(ctx.getAIS()) + "')";
                    statement = conn.createStatement();
                    rowSet = statement.executeQuery(WfDataManager.dialectSql(sql3));
                    if (rowSet.next()) {
                        databaseSize = rowSet.getLong(1);
                        SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
                    }
                    for (String wfTable : wfTables) {
                        sql3 = "select pg_indexes_size('" + wfTable + "') +pg_table_size('" + wfTable + "')";
                        statement = conn.createStatement();
                        rowSet = statement.executeQuery(WfDataManager.dialectSql(sql3));
                        if (rowSet.next()) {
                            long tableSize = rowSet.getLong(1);
                            HashMap<String, Object> row = new HashMap<String, Object>();
                            row.put("name", wfTable);
                            row.put("size", tableSize);
                            row.put("humanSize", WfDataManager.toHumanSize(tableSize));
                            tableSizeList.add(row);
                            wfAllSize += tableSize;
                        }
                        SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
                    }
                }
                catch (Throwable sql3) {
                    throwable = sql3;
                    throw sql3;
                }
            } else if (dbType == 1 || dbType == 9) {
                int pageSize = 4096;
                allSql = "select sum(NPAGES)*" + pageSize + "  from syscat.tables where TABSCHEMA='" + dbNameMap.get(ctx.getAIS()) + "'";
                wfSql = "select  TABNAME tableName,NPAGES*" + pageSize + " bytes  from syscat.tables where TABSCHEMA='" + dbNameMap.get(ctx.getAIS()) + "' and TABNAME in " + wfTableSql;
            } else if (dbType == 6) {
                allSql = "select sum(data_length)+ sum(index_length) from information_schema.tables where table_schema='" + dbNameMap.get(ctx.getAIS()) + "'";
                wfSql = "select table_name tableName, sum(data_length)+ sum(index_length) bytes from information_schema.tables where table_schema='" + dbNameMap.get(ctx.getAIS()) + "' and table_name in  " + wfTableSql;
            } else {
                throw new BOSException("unsupport dbType " + DbType.getName((int)dbType));
            }
            if (allSql != null) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)WfDataManager.dialectSql(allSql));
                if (rs.next()) {
                    databaseSize = rs.getLong(1);
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)WfDataManager.dialectSql(wfSql));
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    String tableName = rs.getString(1);
                    long tableSize = rs.getLong(2);
                    row.put("name", tableName);
                    row.put("size", tableSize);
                    row.put("humanSize", WfDataManager.toHumanSize(tableSize));
                    tableSizeList.add(row);
                    wfAllSize += tableSize;
                }
            }
            long wfSize = 0L;
            long wfLogSize = 0L;
            for (Map map : tableSizeList) {
                String tableName = (String)map.get("name");
                long size = (Long)map.get("size");
                if (wfLogTables.contains(tableName)) {
                    wfLogSize += size;
                } else {
                    wfSize += size;
                }
                map.put("precent", String.format("%.2f", (double)size * 100.0 / (double)wfAllSize));
            }
            HashMap<String, Object> recordData = new HashMap<String, Object>();
            recordData.put("databaseSize", databaseSize);
            recordData.put("databaseHumanSize", WfDataManager.toHumanSize(databaseSize));
            recordData.put("wfAllPrecent", String.format("%.2f", (double)wfAllSize * 100.0 / (double)databaseSize));
            recordData.put("wfAllSize", wfAllSize);
            recordData.put("wfAllHumanSize", WfDataManager.toHumanSize(wfAllSize));
            recordData.put("otherHumanSize", WfDataManager.toHumanSize(databaseSize - wfAllSize));
            recordData.put("wfSize", wfSize);
            recordData.put("wfHumanSize", WfDataManager.toHumanSize(wfSize));
            recordData.put("wfPrecent", String.format("%.2f", (double)wfSize * 100.0 / (double)databaseSize));
            recordData.put("wfLogSize", wfLogSize);
            recordData.put("wfLogHumanSize", WfDataManager.toHumanSize(wfLogSize));
            recordData.put("wfLogPrecent", String.format("%.2f", (double)wfLogSize * 100.0 / (double)databaseSize));
            Collections.sort(tableSizeList, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    long size1 = (Long)o1.get("size");
                    long size2 = (Long)o2.get("size");
                    return Long.compare(size2, size1);
                }
            });
            recordData.put("list", tableSizeList);
            long l = 0L;
            long exceptTop5Size = 0L;
            if (tableSizeList != null && tableSizeList.size() > 0) {
                int count5 = 0;
                for (int i = 0; i < tableSizeList.size(); ++i) {
                    Map item = (Map)tableSizeList.get(i);
                    long size = (Long)item.get("size");
                    l += size;
                    if (++count5 > 4) break;
                }
            }
            exceptTop5Size = wfAllSize - l;
            recordData.put("exceptTop5Size", exceptTop5Size);
            recordData.put("exceptTop5HumanSize", WfDataManager.toHumanSize(exceptTop5Size));
            recordData.put("exceptTop5Precent", String.format("%.2f", (double)exceptTop5Size * 100.0 / (double)wfAllSize));
            return recordData;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static int getDbType(Context ctx) throws SQLException {
        Integer dbType;
        if (dbtypeCache.containsKey(ctx.getAIS())) {
            dbType = dbtypeCache.get(ctx.getAIS());
        } else {
            try (Connection conn = EJBFactory.getConnection((Context)ctx);){
                dbType = KSqlUtil.getDbType((Connection)conn);
            }
            dbtypeCache.put(ctx.getAIS(), dbType);
        }
        return dbType;
    }

    private static String joinTable() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (");
        for (String wfTable : wfTables) {
            sb.append("'").append(wfTable).append("',");
        }
        sb.setLength(sb.length() - 1);
        sb.append(") ");
        return sb.toString();
    }

    private static String toHumanSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] UNIT_NAMES = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
        int digitGroups = Math.min(UNIT_NAMES.length - 1, (int)(Math.log10(size) / Math.log10(1024.0)));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + UNIT_NAMES[digitGroups];
    }

    private static String dialectSql(String sql) {
        return "/*dialect*/" + sql;
    }

    private static void sendMsg(Context ctx, String title, String body, boolean wfMsg, boolean email, boolean mobile, String receivers) {
        Message message = MessageFactory.newMessage();
        Locale[] locales = ApplicationUtil.getContextLocales((Context)ctx);
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            message.setLocaleStringHeader("title", title, locale);
            message.setLocaleStringHeader("body", title, locale);
            message.setLocaleStringHeader("sender", ctx.getUserName(), locale);
        }
        message.setBooleanHeader("isSendEmail", email);
        message.setBooleanHeader("isSendMobile", mobile);
        message.setStringHeader("receiver", receivers);
        message.setStringHeader("senderId", ctx.getCaller().toString());
        message.setIntHeader("bizType", 0);
        message.setStringHeader("sourceID", JOBID_CALC);
        message.setBooleanHeader("isSendCommon", wfMsg);
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("databaseCenter", ctx.getAIS());
        DirectSenderAgent.getInstance().sendMessage(message, false);
    }

    public static CalcPlan getPlan(Context ctx) throws BOSException {
        String sql = "select FRecordData from T_WFR_DataSizeRecord where fid=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{PLANID});
        try {
            if (rowSet.next()) {
                String json = rowSet.getString(1);
                return (CalcPlan)JSON.parseObject((String)json, CalcPlan.class);
            }
            return null;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, Object> getPlanStatus(Context ctx) throws BOSException {
        HashMap<String, Object> status = new HashMap<String, Object>();
        String sql = "select top 1 FSCHEDULEPLAN,FLASTTRIGGEREDTIME,FVALIDATETIME,FEXPIREDTIME from T_JOB_TRIGGER where FJOBDEFID=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{JOBID_CALC});
        try {
            status.put("running", false);
            if (rowSet.next()) {
                org.quartz.Trigger quartzTrigger;
                status.put("running", true);
                Timestamp startDate = rowSet.getTimestamp("FVALIDATETIME");
                Date expireDate = rowSet.getTimestamp("FEXPIREDTIME");
                expireDate = new Date(((Date)expireDate).getTime() + 86400000L - 1L);
                Timestamp lastTriggeredTime = rowSet.getTimestamp("FLASTTRIGGEREDTIME");
                if (lastTriggeredTime == null) {
                    lastTriggeredTime = startDate;
                }
                String plan = rowSet.getString("FSCHEDULEPLAN");
                String temp = "tempKey";
                if (plan.indexOf(32) >= 0) {
                    quartzTrigger = TriggerBuilder.newTrigger().withIdentity(temp, temp).forJob(temp, temp).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)plan)).startAt((Date)startDate).endAt(expireDate).build();
                } else {
                    String[] array = plan.split("/");
                    long interval = Long.parseLong(array[0]);
                    quartzTrigger = TriggerBuilder.newTrigger().withIdentity(temp, temp).forJob(temp, temp).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(Integer.MAX_VALUE).withIntervalInMilliseconds(interval)).startAt((Date)startDate).endAt(expireDate).build();
                }
                status.put("nextFireTime", quartzTrigger.getFireTimeAfter((Date)lastTriggeredTime));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return status;
    }

    public static void savePlan(Context ctx, String data) throws BOSException {
        WfDataManager.saveData(ctx, data, PLANID);
    }

    private static void saveData(Context ctx, String data, String planId) throws BOSException {
        String sql = "select count(*) from  T_WFR_DataSizeRecord where fid=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{planId});
        try {
            Object[] params = new Object[]{data, new Timestamp(System.currentTimeMillis()), planId};
            if (rowSet.next()) {
                sql = rowSet.getInt(1) > 0 ? "update T_WFR_DataSizeRecord set FRecordData=?,FCreateTime=? where fid=?" : "insert into T_WFR_DataSizeRecord (FRecordData,FCreateTime,fid) values (?,?,?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void publishPlan(Context ctx, String data) throws BOSException {
        IInvokeMethodDelegate invokeMethodDelegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
        invokeMethodDelegate.invokeRequired(WfDataManager.class.getName(), (Object)instance, "publishPlanInner", new Class[]{Context.class, String.class}, new Object[]{ctx, data});
    }

    public void publishPlanInner(Context ctx, String data) throws BOSException {
        try {
            String sql = "select count(*) from  t_job_def where FJOBDEFID=?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{JOBID_CALC});
            if (rowSet.next() && rowSet.getInt(1) > 0) {
                throw new BOSException("\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u4efb\u52a1");
            }
            CalcPlan newPlan = (CalcPlan)JSON.parseObject((String)data, CalcPlan.class);
            newPlan.setThreshold((long)(newPlan.getGThreshold() * 1.0737418E9f));
            WfDataManager.savePlan(ctx, data);
            String title = "~Calculate wf table size";
            JobDef def = new JobDef(JOBID_CALC, ctx, "com.kingdee.bos.workflow.metas", title, title, null, null, true, (Wrapper)new InterfaceWrapper((Object)new WfCalcDataSize()), false, null, 500, -1, Configuration.defaultJobIsolationLevel(), null);
            String schedule = "";
            String schedulePlan = newPlan.getSchedule();
            if (PLANID.equals(schedulePlan)) {
                schedule = "0 0 9 ? * 2";
            } else if (PLANID_CONFIG.equals(schedulePlan)) {
                schedule = "0 0 9 1 * ?";
            } else if (!StringUtils.isEmpty((String)schedulePlan) && schedulePlan.contains("@")) {
                long day = Long.parseLong(schedulePlan.split("@")[1]);
                day = day * 24L * 3600L * 1000L;
                schedule = day + "/-1";
            } else {
                throw new BOSException("unsupport schedule " + schedulePlan);
            }
            Date validateTime = new Date(System.currentTimeMillis());
            Date expiredTime = new Date(4070880000000L);
            Trigger trigger = new Trigger(validateTime, expiredTime, def, "timer", true, schedule, false, null, true, true);
            IJobService svc = JobServiceFactory.getLocalInstance((Context)ctx);
            svc.createJobDef(def, trigger, true);
            sql = "select count(*) from  t_job_def where FJOBDEFID=?";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{JOBID_CLEAN});
            if (rowSet.next() && rowSet.getInt(1) == 0) {
                title = "~Clean wf data in recycle";
                def = new JobDef(JOBID_CLEAN, ctx, "com.kingdee.bos.workflow.metas", title, title, null, null, true, (Wrapper)new InterfaceWrapper((Object)new WfDataCleaner()), false, null, 500, -1, Configuration.defaultJobIsolationLevel(), null);
                schedulePlan = "0 */10 * * * ?";
                trigger = new Trigger(validateTime, expiredTime, def, "timer", true, schedulePlan, false, null, true, true);
                svc.createJobDef(def, trigger, true);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void cancelPlan(Context ctx) throws BOSException {
        CalcPlan plan = WfDataManager.getPlan(ctx);
        if (plan != null) {
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            jobService.removeJobDef(JOBID_CALC);
        }
    }

    public static List<JSONObject> getDataSizeRecord(Context ctx, int last) throws BOSException {
        String sql = "select top " + last + " FRecordData, FCreateTime from T_WFR_DataSizeRecord where fid!=? order by FCreateTime desc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{PLANID});
        ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
        try {
            while (rowSet.next()) {
                String json = rowSet.getString("FRecordData");
                JSONObject data = JSON.parseObject((String)json);
                data.put("createTime", (Object)rowSet.getTimestamp("FCreateTime"));
                ret.add(data);
            }
            return ret;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, Object> getMsgSendRecord(Context ctx, int page, int rows, String sidx) throws BOSException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        try {
            int records = 0;
            int total = 0;
            String sql = "select count(*) from T_WFR_DataSizeRecord where FSendData is not null";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                records = rowSet.getInt(1);
            }
            if (records > 0) {
                total = records % rows == 0 ? records / rows : records / rows + 1;
                sql = "select fid,FSendData,FCreateTime from T_WFR_DataSizeRecord where FSendData is not null order by FCreateTime ";
                sql = StringUtils.isEmpty((String)sidx) && sidx.toLowerCase().contains("asc") ? sql + "asc" : sql + "desc";
                PagingHelper pagingHelper = new PagingHelper();
                sql = pagingHelper.getPagingSqlNoOptmize(ctx, sql, (page - 1) * rows, rows);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                ArrayList<JSONObject> rowList = new ArrayList<JSONObject>();
                while (rowSet.next()) {
                    String json = rowSet.getString("FSendData");
                    JSONObject data = JSON.parseObject((String)json);
                    data.put("createTime", (Object)rowSet.getTimestamp("FCreateTime"));
                    data.put("id", (Object)rowSet.getString("fid"));
                    data.put("title", (Object)data.getString("title"));
                    JSONArray receivers = data.getJSONArray("receivers");
                    if (receivers != null) {
                        StringBuilder sb = new StringBuilder();
                        for (Object receiver : receivers) {
                            String name = ((JSONObject)receiver).getString("name");
                            sb.append(name).append("\u3001");
                        }
                        sb.setLength(sb.length() - 1);
                        data.put("receivers", (Object)sb.toString());
                    } else {
                        data.put("receivers", (Object)"");
                    }
                    rowList.add(data);
                }
                ret.put("rows", rowList);
            }
            ret.put("records", records);
            ret.put("total", total);
            ret.put("page", page);
            return ret;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, Object> getCleanTableRecord(Context ctx, int page, int rows) throws BOSException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        try {
            int records = 0;
            int total = 0;
            String sql = "select count(*) from T_WFR_CleanRecord";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                records = rowSet.getInt(1);
            }
            if (records > 0) {
                total = records % rows == 0 ? records / rows : records / rows + 1;
                sql = "select FCleanId,FCleanYear,FCleanState,FTableName,FTableCount,FTableNameBak,FCreateTime from T_WFR_CleanRecord order by FCreateTime desc";
                PagingHelper pagingHelper = new PagingHelper();
                sql = pagingHelper.getPagingSqlNoOptmize(ctx, sql, (page - 1) * rows, rows);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                ArrayList rowList = new ArrayList();
                int querySeq_No = 0;
                String lastCleanId = null;
                while (rowSet.next()) {
                    long left;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    String cleanId = rowSet.getString("FCleanId");
                    if (!cleanId.equals(lastCleanId)) {
                        ++querySeq_No;
                    }
                    data.put("cleanId", cleanId);
                    data.put("cleanYear", rowSet.getString("FCleanYear"));
                    String cleanState = rowSet.getString("FCleanState");
                    data.put("cleanState", WfDataManager.getCleanStateAlias(ctx, cleanState));
                    String tableName = rowSet.getString("FTableName");
                    data.put("tableName2", tableName);
                    data.put("tableNameBak", rowSet.getString("FTableNameBak"));
                    data.put("id", rowSet.getString("FTableNameBak"));
                    data.put("tableType", wfLogTables.contains(tableName) ? "\u5de5\u4f5c\u6d41\u65e5\u5fd7\u8868" : "\u5de5\u4f5c\u6d41\u6570\u636e\u8868");
                    data.put("tableCount", rowSet.getString("FTableCount"));
                    Timestamp createTime = rowSet.getTimestamp("FCreateTime");
                    data.put("createTime2", createTime);
                    data.put("leftDay", "0");
                    data.put("querySeq_No", querySeq_No);
                    if (DELETE_TEMPORARY.equals(cleanState) && (left = createTime.getTime() + 2592000000L - System.currentTimeMillis()) > 0L) {
                        data.put("leftDay", left /= 86400000L);
                    }
                    rowList.add(data);
                    lastCleanId = cleanId;
                }
                ret.put("rows", rowList);
            }
            ret.put("records", records);
            ret.put("total", total);
            ret.put("page", page);
            return ret;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getCleanStateAlias(Context ctx, String state) throws BOSException {
        String alias = null;
        Locale locale = ctx.getLocale();
        if (AUTO_DELETE_PERMANENT.equals(state)) {
            alias = "\u81ea\u52a8\u6c38\u4e45\u5220\u9664";
            if ("l1".equalsIgnoreCase(locale.getDisplayLanguage())) {
                alias = "Auto permanent delete";
            } else if ("l3".equalsIgnoreCase(locale.getDisplayLanguage())) {
                alias = "\u81ea\u52d5\u6c38\u4e45\u522a\u9664";
            }
        } else if (DELETE_TEMPORARY.equals(state)) {
            alias = "\u4e34\u65f6\u5220\u9664";
            if ("l1".equalsIgnoreCase(locale.getDisplayLanguage())) {
                alias = "Temorary delete";
            } else if ("l3".equalsIgnoreCase(locale.getDisplayLanguage())) {
                alias = "\u81e8\u6642\u522a\u9664";
            }
        } else if (DELETE_PERMANENT.equals(state)) {
            alias = "\u6c38\u4e45\u5220\u9664";
            if ("l1".equalsIgnoreCase(locale.getDisplayLanguage())) {
                alias = "Permanent delete";
            } else if ("l3".equalsIgnoreCase(locale.getDisplayLanguage())) {
                alias = "\u6c38\u4e45\u522a\u9664";
            }
        } else if (RECOVERY.equals(state)) {
            alias = "\u5df2\u6062\u590d";
            if ("l1".equalsIgnoreCase(locale.getDisplayLanguage())) {
                alias = "Recovered";
            } else if ("l3".equalsIgnoreCase(locale.getDisplayLanguage())) {
                alias = "\u5df2\u6062\u5fa9";
            }
        } else {
            throw new BOSException("unsupport state " + state);
        }
        return alias;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> getCleanTableList(Context ctx) throws BOSException {
        try (Connection conn = EJBFactory.getConnection((Context)ctx);){
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ArrayList rowList = new ArrayList();
            String sql = "select min(FLASTSTATETIME),max(FLASTSTATETIME)  from T_WFR_ProcInstHst";
            Statement statment = conn.createStatement();
            ResultSet resultSet = statment.executeQuery(sql);
            if (resultSet.next() && resultSet.getTimestamp(1) != null) {
                Timestamp begin = resultSet.getTimestamp(1);
                Timestamp end = resultSet.getTimestamp(2);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(begin);
                int beginYear = calendar.get(1);
                calendar.setTime(end);
                int endYear = calendar.get(1);
                calendar.setTimeInMillis(System.currentTimeMillis() - 31536000000L);
                int limitYear = calendar.get(1) - 1;
                if (endYear > limitYear) {
                    endYear = limitYear;
                }
                calendar.set(2, 0);
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                int querySeq_No = 1;
                Locale locale = ctx.getLocale();
                String wfTableAlias = "\u5de5\u4f5c\u6d41\u6570\u636e\u8868";
                String wfLogTableAlias = "\u5de5\u4f5c\u6d41\u65e5\u5fd7\u8868";
                if ("l1".equalsIgnoreCase(locale.getDisplayLanguage())) {
                    wfTableAlias = "workflow table";
                    wfLogTableAlias = "workflow log table";
                } else if ("l3".equalsIgnoreCase(locale.getDisplayLanguage())) {
                    wfTableAlias = "\u5de5\u4f5c\u6d41\u6578\u64da\u8868";
                    wfLogTableAlias = "\u5de5\u4f5c\u6d41\u65e5\u8a8c\u8868";
                }
                for (int i = beginYear; i <= endYear; ++i) {
                    calendar.set(1, i);
                    begin = new Timestamp(calendar.getTimeInMillis());
                    calendar.set(1, i + 1);
                    end = new Timestamp(calendar.getTimeInMillis());
                    long all = 0L;
                    ArrayList rowList2 = new ArrayList();
                    for (Map.Entry<String, String> entry : tableSqlMap.entrySet()) {
                        sql = "select count(*)" + entry.getValue();
                        String tableName = entry.getKey();
                        HashMap<String, Object> nrow = new HashMap<String, Object>();
                        PreparedStatement preparedStatement = conn.prepareStatement(String.format(sql, "?", "?"));
                        preparedStatement.setTimestamp(1, begin);
                        preparedStatement.setTimestamp(2, end);
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            int count = resultSet.getInt(1);
                            all += (long)count;
                            nrow.put("count", count);
                        }
                        nrow.put("id", tableName + i);
                        nrow.put("querySeq_No", querySeq_No);
                        nrow.put("tableName", tableName);
                        nrow.put("year", i);
                        nrow.put("type", wfTableAlias);
                        if (wfLogTables.contains(tableName)) {
                            nrow.put("type", wfLogTableAlias);
                        }
                        rowList2.add(nrow);
                    }
                    if (all <= 0L) continue;
                    Collections.sort(rowList2, new Comparator<Map<String, Object>>(){

                        @Override
                        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                            String tableName1 = (String)o1.get("tableName");
                            String tableName2 = (String)o2.get("tableName");
                            int count1 = (Integer)o1.get("count");
                            int count2 = (Integer)o2.get("count");
                            boolean wf1 = wfHisTables.contains(tableName1);
                            boolean wf2 = wfHisTables.contains(tableName2);
                            if (wf2 && !wf1) {
                                return 1;
                            }
                            if (!wf2 && wf1) {
                                return -1;
                            }
                            return Integer.compare(count2, count1);
                        }
                    });
                    rowList.addAll(rowList2);
                    ++querySeq_No;
                }
            }
            ret.put("records", rowList.size());
            ret.put("rows", rowList);
            ret.put("total", 1);
            ret.put("page", 1);
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void cleanTable(Context ctx, JSONObject data) throws BOSException {
        IInvokeMethodDelegate invokeMethodDelegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
        invokeMethodDelegate.invokeRequired(WfDataManager.class.getName(), (Object)instance, "cleanTableInner", new Class[]{Context.class, JSONObject.class}, new Object[]{ctx, data});
    }

    public void cleanTableInner(Context ctx, JSONObject data) throws BOSException {
        try (Connection conn = EJBFactory.getConnection((Context)ctx);){
            String sql = "select top 1 FCreateTime from T_WFR_CleanRecord order by FCreateTime desc ";
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next() && System.currentTimeMillis() - rs.getTimestamp(1).getTime() <= 300000L) {
                Locale locale = ctx.getLocale();
                String msg = "\u8bf7\u7a0d\u540e\u64cd\u4f5c\uff0c\u76ee\u524d\u6700\u77ed\u6e05\u7406\u65f6\u95f4\u95f4\u9694\u4e3a10\u5206\u949f";
                if ("l1".equalsIgnoreCase(locale.getDisplayLanguage())) {
                    msg = "Please proceed later. Currently, the minimum cleaning interval is 10 minutes";
                } else if ("l3".equalsIgnoreCase(locale.getDisplayLanguage())) {
                    msg = "\u8acb\u7a0d\u5f8c\u64cd\u4f5c\uff0c\u76ee\u524d\u6700\u77ed\u6e05\u7406\u6642\u9593\u9593\u9694\u70ba10\u5206\u9418";
                }
                throw new BOSException(msg);
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String cleanId = Uuid.randomUUID().toString();
            boolean temporary = data.getBooleanValue("temporary");
            int cleanYear = data.getIntValue("cleanYear");
            JSONArray tables = data.getJSONArray("tables");
            if (tables.size() == 0) {
                return;
            }
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            if (temporary) {
                statement = conn.createStatement();
            }
            Statement statement2 = conn.createStatement();
            for (int i = 0; i < tables.size(); ++i) {
                JSONObject table = tables.getJSONObject(i);
                String tableName = table.getString("tableName");
                String tableNameBak = null;
                int count = table.getIntValue("count");
                if (temporary) {
                    tableNameBak = WfDataManager.createBakTableName(tableName, now);
                    sql = "select * into " + tableNameBak + tableSqlMap.get(tableName);
                    sql = String.format(sql, "{ts'" + cleanYear + "-01-01 00:00:00'}", "{ts'" + (cleanYear + 1) + "-01-01 00:00:00'}");
                    statement.addBatch(sql);
                }
                paramsList.add(new Object[]{cleanId, cleanYear, temporary ? DELETE_TEMPORARY : DELETE_PERMANENT, tableName, count, tableNameBak, now});
                sql = "delete" + tableSqlMap.get(tableName);
                sql = String.format(sql, "{ts'" + cleanYear + "-01-01 00:00:00'}", "{ts'" + (cleanYear + 1) + "-01-01 00:00:00'}");
                statement2.addBatch(sql);
            }
            if (temporary) {
                statement.executeBatch();
            }
            sql = "insert into T_WFR_CleanRecord (FCleanId,FCleanYear,FCleanState,FTableName,FTableCount,FTableNameBak,FCreateTime) values(?,?,?,?,?,?,?)";
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            statement2.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void recoverTable(Context ctx, String cleanId) throws BOSException {
        IInvokeMethodDelegate invokeMethodDelegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
        invokeMethodDelegate.invokeRequired(WfDataManager.class.getName(), (Object)instance, "recoverTableInner", new Class[]{Context.class, String.class}, new Object[]{ctx, cleanId});
    }

    public void recoverTableInner(Context ctx, String cleanId) throws BOSException {
        try (Connection conn = EJBFactory.getConnection((Context)ctx);){
            String sql = "select FTableName,FTableNameBak from T_WFR_CleanRecord where FCleanId=? and FCleanState =? ";
            PreparedStatement pareparedStatement = conn.prepareStatement(sql);
            pareparedStatement.setString(1, cleanId);
            pareparedStatement.setString(2, DELETE_TEMPORARY);
            ResultSet rs = pareparedStatement.executeQuery();
            Statement statement = conn.createStatement();
            Statement statement2 = conn.createStatement();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                String tableName = rs.getString("FTableName");
                String tableNameBak = rs.getString("FTableNameBak");
                sql = "if exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + tableNameBak + "') insert into " + tableName + " select * from " + tableNameBak;
                sql = "T_WFR_PROCINSTHST".equals(tableName) || "T_WFR_PROCINSTDATAHST".equals(tableName) ? sql + " where fprocinstId not in (select fprocinstId from " + tableName + ") " : ("T_WFR_ACTINSTHST".equals(tableName) ? sql + " where factinstId not in (select factinstId from T_WFR_ACTINSTHST) " : ("T_WFR_ASSIGNHST".equals(tableName) ? sql + " where fassignId not in (select fassignId from T_WFR_ASSIGNHST) " : ("T_WFR_PROCINSTREFHST".equals(tableName) ? sql + " where not exists (select 1 from T_WFR_PROCINSTREFHST t where FPROCINSTID=t.FPROCINSTID and  FREFID= t.FREFID )" : sql + " where fid not in (select fid from " + tableName + ") ")));
                paramsList.add(new Object[]{RECOVERY, cleanId, tableName});
                statement.addBatch(sql);
                sql = "if exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + tableNameBak + "') drop table " + tableNameBak;
                statement2.addBatch(sql);
            }
            if (paramsList.size() > 0) {
                statement.executeBatch();
                sql = " update T_WFR_CleanRecord set FCleanState=? where  fCleanId=? and fTableName=?";
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                statement2.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String createBakTableName(String tableName, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmm");
        return tableName + "_" + sdf.format(date);
    }

    public static void deleteTableBak(Context ctx) throws BOSException {
        IInvokeMethodDelegate invokeMethodDelegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
        invokeMethodDelegate.invokeRequired(WfDataManager.class.getName(), (Object)instance, "deleteTableBakInner", new Class[]{Context.class}, new Object[]{ctx});
    }

    public static void deleteTableBakInner(Context ctx) throws BOSException {
        try (Connection conn = EJBFactory.getConnection((Context)ctx);){
            String sql = "select top 15  FCleanId,FTableName,FTableNameBak from T_WFR_CleanRecord where FCreateTime < ? and FCleanState =? order by FCreateTime ";
            PreparedStatement pareparedStatement = conn.prepareStatement(sql);
            Timestamp temp = new Timestamp(System.currentTimeMillis() - 2592000000L);
            pareparedStatement.setTimestamp(1, temp);
            pareparedStatement.setString(2, DELETE_TEMPORARY);
            ResultSet rs = pareparedStatement.executeQuery();
            Statement statement = conn.createStatement();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            String lastCleanId = null;
            while (rs.next()) {
                String tableName = rs.getString("FTableName");
                String tableNameBak = rs.getString("FTableNameBak");
                String cleanId = rs.getString("FCleanId");
                if (lastCleanId != null && !cleanId.equals(lastCleanId)) break;
                sql = "if exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + tableNameBak + "') drop table " + tableNameBak;
                statement.addBatch(sql);
                paramsList.add(new Object[]{AUTO_DELETE_PERMANENT, null, tableName, cleanId});
                lastCleanId = cleanId;
            }
            if (paramsList.size() > 0) {
                statement.executeBatch();
                sql = " update T_WFR_CleanRecord set FCleanState=?,FTableNameBak=? where FTableName=? and FCleanId=? ";
                DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String formatDataSizeStr(String sqlResSize) {
        if (!sqlResSize.contains(".")) {
            return sqlResSize;
        }
        String resSizeStr = null;
        try {
            String trimSize = sqlResSize.trim();
            String sizeStr = trimSize.substring(0, trimSize.length() - 2);
            resSizeStr = trimSize.endsWith("GB") || trimSize.endsWith("gb") ? (long)(Double.parseDouble(sizeStr) * 1024.0 * 1024.0) + "KB" : (trimSize.endsWith("MB") || trimSize.endsWith("mb") ? (long)(Double.parseDouble(sizeStr) * 1024.0) + "KB" : (trimSize.endsWith("KB") || trimSize.endsWith("kb") ? (long)Double.parseDouble(sizeStr) + "KB" : sqlResSize));
        }
        catch (Exception e) {
            resSizeStr = sqlResSize;
            logger.error((Object)("formatDataSizeStr error , sqlResSize = " + sqlResSize), (Throwable)e);
        }
        return resSizeStr;
    }

    static {
        wfLogTables.add("T_WFR_ENGINELOG");
        wfLogTables.add("T_WFR_PROCESSDEFLOG");
        wfLogTables.add("T_WFR_PROCESSINSTLOG");
        wfLogTables.add("T_WFR_QUEUELOG");
        wfHisTables.add("T_BAS_MULTIAPPROVEHST");
        wfHisTables.add("T_WFR_PROCINSTHST");
        wfHisTables.add("T_WFR_COUNTERSIGNHST");
        wfHisTables.add("T_WFR_PROCINSTDATAHST");
        wfHisTables.add("T_WFR_ACTINSTHST");
        wfHisTables.add("T_WFR_ASSIGNHST");
        wfHisTables.add("T_WFR_PROCINSTREFHST");
        wfTables.add("T_BAS_MULTIAPPROVE");
        wfTables.add("T_WFR_PROCINST");
        wfTables.add("T_WFR_COUNTERSIGN");
        wfTables.add("T_WFR_PROCINSTDATA");
        wfTables.add("T_WFR_ACTINST");
        wfTables.add("T_WFR_ASSIGNDETAIL");
        wfTables.add("T_WFR_PROCINSTREF");
        wfTables.addAll(wfLogTables);
        wfTables.addAll(wfHisTables);
        wfTableSql = WfDataManager.joinTable();
        oracletableSpace = new HashMap<String, String>();
        instance = new WfDataManager();
        dbtypeCache = new ConcurrentHashMap<String, Integer>();
        tableSqlMap = new LinkedHashMap<String, String>();
        tableSqlMap.put("T_WFR_PROCINSTHST", " from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s ");
        tableSqlMap.put("T_WFR_PROCINSTDATAHST", " from T_WFR_PROCINSTDATAHST  where fprocinstId in (select fprocinstId from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s )");
        tableSqlMap.put("T_WFR_ACTINSTHST", " from T_WFR_ACTINSTHST  where fprocinstId in (select fprocinstId from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s )");
        tableSqlMap.put("T_WFR_ASSIGNHST", " from T_WFR_ASSIGNHST  where fprocinstId in (select fprocinstId from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s )");
        tableSqlMap.put("T_BAS_MULTIAPPROVEHST", " from T_BAS_MULTIAPPROVEHST where fassignmentId in (select fassignId from T_WFR_ASSIGNHST  where fprocinstId in (select fprocinstId from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s ))");
        tableSqlMap.put("T_WFR_PROCINSTREFHST", " from T_WFR_PROCINSTREFHST  where fprocinstId in (select fprocinstId from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s )");
        tableSqlMap.put("T_WFR_COUNTERSIGNHST", " from T_WFR_COUNTERSIGNHST where fassignId in (select fassignId from T_WFR_ASSIGNHST  where fprocinstId in (select fprocinstId from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s ))");
        tableSqlMap.put("T_WFR_PROCESSINSTLOG", " from T_WFR_PROCESSINSTLOG where fprocessinstid in (select fprocinstId from T_WFR_PROCINSTHST where fcreatedTime>=%s  and fcreatedTime< %s )");
        tableSqlMap.put("T_WFR_ENGINELOG", " from T_WFR_ENGINELOG where ftime>%s  and ftime< %s");
        tableSqlMap.put("T_WFR_PROCESSDEFLOG", "from T_WFR_PROCESSDEFLOG where ftime>%s  and ftime< %s ");
        tableSqlMap.put("T_WFR_QUEUELOG", " from T_WFR_QUEUELOG where ftime>%s  and ftime< %s");
    }
}

