/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.RuntimeSystemVariable;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.transaction.ActivityRunner;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ManpowerActivityRunner
implements ActivityRunner {
    private Logger log = Logger.getLogger(ManpowerActivityRunner.class);
    private WfActivity innerActivityInst;
    private ManpowerActivityDef innerActivityDef;

    public ManpowerActivityRunner(WfActivity activityInst) {
        this.innerActivityInst = activityInst;
        this.innerActivityDef = (ManpowerActivityDef)this.innerActivityInst.getDefinition();
    }

    @Override
    public void start() throws WfException {
        ApplicationDef appDef = this.innerActivityDef.getRelatedApplication();
        ActualParameterCollection actualParamCal = this.innerActivityDef.getActualParameters();
        Map objIds = ManpowerActivityRunner.getBizObjIds(appDef, actualParamCal, this.innerActivityInst);
        WfProcess process = this.innerActivityInst.container();
        process.holdBizObj(objIds);
        this.processTopic(process);
    }

    private void processTopic(WfProcess process) {
        try {
            if (!(this.innerActivityDef instanceof ApproveActivityDef)) {
                this.innerProcessTopic(process);
            } else {
                String v;
                ExtendedAttributeDef ead = this.innerActivityDef.getActivityHeader().getExtendedAttributes().get("customUIStatus");
                if (ead != null && (v = ead.getValue()) != null && v.trim().length() > 0) {
                    if ("VIEW".equalsIgnoreCase(v) || "FINDVIEW".equalsIgnoreCase(v)) {
                        return;
                    }
                    this.innerProcessTopic(process);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"\u8ba1\u7b97\u6d41\u7a0b\u4e3b\u9898\u51fa\u9519", (Throwable)e);
        }
    }

    private void innerProcessTopic(WfProcess process) throws WfException {
        BOSUuid uuid = process.getData().getMeta().getParentProcdefID();
        if (uuid != null) {
            WfProcessMgr parentMgr = process.getWfEngine().getProcessMgr(uuid.toString());
            uuid = process.getData().getMeta().getParentProcInstID();
            if (uuid != null) {
                WfProcess parentProcess = process.getWfEngine().getProcessInst(uuid.toString());
                parentMgr.processProcessTopic(parentProcess);
            }
        }
        WfProcessMgr mgr = process.manager();
        mgr.processProcessTopic(process);
    }

    static Map getBizObjIds(ApplicationDef appDef, ActualParameterCollection actualParamCal, WfActivity actInst) throws WfException {
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        if (appDef == null) {
            return idMap;
        }
        FormalParameterCollection formalPramCol = appDef.getFormalParameters();
        for (int i = 0; i < formalPramCol.size(); ++i) {
            FormalParameterDef formalParam = formalPramCol.get(i);
            if (!formalParam.getMode().equals((Object)FormalParameterMode.IN) && !formalParam.getMode().equals((Object)FormalParameterMode.INOUT) || !formalParam.getDataType().equals(BasicType.BOID) && !formalParam.getDataType().equals(BasicType.BIZOBJ) || formalParam.getIndex() >= actualParamCal.size()) continue;
            ActualParameterDef actualParam = actualParamCal.get(formalParam.getIndex());
            String dataName = actualParam.getDataField().getName();
            if (!StringUtils.isEmpty((String)actualParam.getProp())) {
                dataName = dataName + "." + actualParam.getProp();
            }
            String pramValue = null;
            Object value = actInst.container().getProcessContext().getDataFieldValue(dataName);
            if (value == null || (pramValue = value.toString()).length() == 0) continue;
            Object orgMap = actInst.container().getProcessContext().getDataFieldValue(RuntimeSystemVariable.ORGMAP.getValue());
            Object orgId = null;
            if (orgMap != null) {
                orgId = ((Map)orgMap).get(pramValue);
            }
            idMap.put(pramValue, orgId);
        }
        return idMap;
    }
}

