/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.define.validation.IRule;
import com.kingdee.bos.workflow.define.validation.Priority;
import com.kingdee.bos.workflow.define.validation.ResultInfo;
import com.kingdee.bos.workflow.define.validation.ResultType;
import com.kingdee.bos.workflow.mdo.IEntityObject;
import com.kingdee.bos.workflow.mdo.impl.MDOService;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProcessCheck
implements IRule {
    private static final Logger logger = Logger.getLogger(ProcessCheck.class);
    private Context ctx;
    private IDynamicObject dynamicObject;

    public ProcessCheck(Context ctx) {
        this.dynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
        this.ctx = ctx;
    }

    public List getProcessCheck(ProcessDef processDef) throws WfException {
        ArrayList resultInfos = new ArrayList();
        ActivityCollection activites = processDef.getActivitys();
        int size = activites.size();
        for (int i = 0; i < size; ++i) {
            ParticipantCollection participants;
            ActivityDef activityDef = activites.get(i);
            if (activityDef instanceof ManpowerActivityDef) {
                participants = ((ManpowerActivityDef)activityDef).getParticipants();
                resultInfos.addAll(this.checkReferencedData(processDef, activityDef, participants));
            }
            if (!(activityDef instanceof MessageActivityDef)) continue;
            participants = ((MessageActivityDef)activityDef).getReceivers();
            resultInfos.addAll(this.checkReferencedData(processDef, activityDef, participants));
        }
        this.dynamicObject = null;
        return resultInfos;
    }

    private List checkReferencedData(ProcessDef processDef, ActivityDef activityDef, ParticipantCollection participants) throws WfException {
        ArrayList<ResultInfo> resultInfos = new ArrayList<ResultInfo>();
        int size = participants.size();
        for (int i = 0; i < size; ++i) {
            ParticipantDef participantDef = participants.get(i);
            ResultInfo resultInfo = this.checkResultInfo(processDef, activityDef, participantDef, participantDef.getOrgID());
            if (resultInfo != null) {
                resultInfos.add(resultInfo);
            }
            if ((resultInfo = this.checkResultInfo(processDef, activityDef, participantDef, participantDef.getParticipantValue())) != null) {
                resultInfos.add(resultInfo);
            }
            if ((resultInfo = this.checkResultInfo(processDef, activityDef, participantDef, participantDef.getHierarchyId())) != null) {
                resultInfos.add(resultInfo);
            }
            if ((resultInfo = this.checkResultInfo(processDef, activityDef, participantDef, participantDef.getReferenceHumanId())) != null) {
                resultInfos.add(resultInfo);
            }
            if ((resultInfo = this.checkResultInfo(processDef, activityDef, participantDef, participantDef.getRefPositionId())) == null) continue;
            resultInfos.add(resultInfo);
        }
        return resultInfos;
    }

    private ResultInfo checkResultInfo(ProcessDef processDef, ActivityDef activityDef, ParticipantDef participantDef, String id) throws WfException {
        if (!StringUtils.isEmpty((String)id) && this.isBOSUuid(id)) {
            ParticipantType parType = participantDef.getParticipantType();
            if (ParticipantType.WFROLE.equals((Object)parType) || ParticipantType.WFROLE_GROUP.equals((Object)parType)) {
                boolean exist = this.exist4WfRole(id);
                if (!exist) {
                    Locale l2 = new Locale("l2");
                    String parName = ProcessCheck.getParticipantText(processDef, participantDef);
                    String desc = "\u6d3b\u52a8[" + activityDef.getName(l2) + "]\u4e0a\u914d\u7f6e\u7684\u89d2\u8272\u53c2\u4e0e\u4eba\u4e0d\u5b58\u5728\uff01";
                    String resolu = "\u8bf7\u68c0\u67e5\u6d3b\u52a8[" + activityDef.getName(l2) + "]\u4e0a\u914d\u7f6e\u7684" + parName + "(ID=" + id + ")\u662f\u5426\u5b58\u5728.";
                    String longDesc = "\u6d3b\u52a8[" + activityDef.getName(l2) + "]\u4e0a\u914d\u7f6e\u7684" + parName + "(ID=" + id + ")\u4e0d\u5b58\u5728\uff01";
                    return new ResultInfo((IRule)this, ResultType.ERROR, desc, longDesc, resolu, "");
                }
            } else if (!this.exist(id)) {
                Locale l2 = new Locale("l2");
                return new ResultInfo((IRule)this, ResultType.WARNING, "\u6d3b\u52a8[" + activityDef.getName(l2) + "]\u7684\u53c2\u4e0e\u4eba\u5f15\u7528\u7684\u4e1a\u52a1\u6570\u636e\u4e0d\u5b58\u5728.", "\u6d3b\u52a8[" + activityDef.getName(l2) + "]\u7684\u53c2\u4e0e\u4eba[" + ProcessCheck.getParticipantText(processDef, participantDef) + "]\u5f15\u7528\u7684\u4e1a\u52a1\u6570\u636e " + this.getBizDataMessage(BOSUuid.read((String)id)) + "\u4e0d\u5b58\u5728.", "\u8bf7\u68c0\u67e5\u6d3b\u52a8[" + activityDef.getName(l2) + "]\u7684\u53c2\u4e0e\u4eba[" + ProcessCheck.getParticipantText(processDef, participantDef) + "]\u5f15\u7528\u7684\u4e1a\u52a1\u6570\u636e " + this.getBizDataMessage(BOSUuid.read((String)id)) + "\u662f\u5426\u5b58\u5728.", "");
            }
        }
        return null;
    }

    public static String getParticipantText(ProcessDef processDef, ParticipantDef def) {
        return ProcessCheck.getSubText(processDef, def, 0) + "-" + ProcessCheck.getSubText(processDef, def, 1);
    }

    private static String getSubText(ProcessDef processDef, ParticipantDef def, int index) {
        if (index == 0) {
            int type = def.getParticipantType().getValue();
            switch (type) {
                case 3: {
                    return "\u7ec4\u7ec7\u5355\u5143-\u6240\u6709\u5458\u5de5";
                }
                case 4: {
                    return "\u7ec4\u7ec7\u5355\u5143-\u76f4\u5c5e\u5458\u5de5";
                }
                case 5: {
                    return "\u7ec4\u7ec7\u5355\u5143-\u8d1f\u8d23\u4eba";
                }
                case 14: {
                    return "\u7ec4\u7ec7\u5355\u5143-\u6743\u9650\u62e5\u6709\u4eba";
                }
                case 6: {
                    return "\u804c\u5458";
                }
                case 9: {
                    return "\u804c\u4f4d";
                }
                case 13: {
                    return "\u6d41\u7a0b\u7ba1\u7406\u5458";
                }
                case 12: {
                    return "\u53c2\u4e0e\u4eba\u53d8\u91cf";
                }
                case 16: {
                    return "\u804c\u52a1";
                }
                case 17: {
                    return "\u7ec4\u53c2\u4e0e\u4eba";
                }
                case 18: {
                    return "\u7ec4\u7ec7\u8303\u56f4";
                }
                case 19: {
                    return "\u6d41\u7a0b\u6267\u884c\u4eba";
                }
                case 20: {
                    return "\u5de5\u4f5c\u6d41\u89d2\u8272";
                }
                case 21: {
                    return "\u5de5\u4f5c\u6d41\u89d2\u8272\u7ec4";
                }
                case 8: {
                    int relationType = def.getRelationType().getValue();
                    String rtn = "\u5173\u7cfb-";
                    switch (relationType) {
                        case 0: {
                            return rtn + "\u672c\u4eba";
                        }
                        case 1: {
                            return rtn + "\u76f4\u63a5\u4e0a\u7ea7";
                        }
                        case 2: {
                            return rtn + "\u540c\u7ea7";
                        }
                        case 3: {
                            return rtn + "\u76f4\u63a5\u4e0b\u7ea7";
                        }
                        case 4: {
                            return rtn + "\u540c\u7ea7\u76f8\u540c\u804c\u4f4d\u975e\u672c\u4eba";
                        }
                        case 5: {
                            return rtn + "\u95f4\u63a5\u4e0a\u7ea7";
                        }
                        case 6: {
                            return rtn + "\u540c\u7ea7\u6240\u6709\u804c\u4f4d\u975e\u672c\u4eba";
                        }
                        case 7: {
                            return rtn + "\u540c\u7ea7\u5176\u4ed6\u804c\u4f4d\u975e\u672c\u4eba";
                        }
                        case 8: {
                            return rtn + "\u540c\u4e00\u804c\u7b49";
                        }
                        case 9: {
                            return rtn + "\u4e3b\u8981\u804c\u4f4d\u76f4\u63a5\u4e0a\u7ea7";
                        }
                    }
                    return "";
                }
                case 15: {
                    return "\u4efb\u610f\u4eba";
                }
            }
            return "";
        }
        if (index == 1) {
            int type = def.getParticipantType().getValue();
            switch (type) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 14: 
                case 20: 
                case 21: {
                    return StringUtils.cnulls((String)def.getName(), (String)"");
                }
                case 12: {
                    return ProcessCheck.getDataFieldName(processDef, def.getPerformDatafieldId());
                }
                case 9: {
                    if (!StringUtils.isEmpty((String)def.getOrgID())) {
                        return def.getOrgID() + "-" + def.getName();
                    }
                    return "\u672a\u77e5\u7ec4\u7ec7-" + def.getName();
                }
                case 16: {
                    if (!StringUtils.isEmpty((String)def.getOrgName())) {
                        return def.getOrgName() + "-" + def.getName();
                    }
                    return "\u672a\u77e5\u7ec4\u7ec7-" + def.getName();
                }
                case 17: {
                    return def.getName();
                }
                case 18: {
                    return def.getName();
                }
                case 13: {
                    return "\u6d41\u7a0b\u7ba1\u7406\u5458";
                }
                case 8: {
                    int relationType = def.getRelationType().getValue();
                    if (def.getReferenceHumanType().getValue() == 3) {
                        return "\u6d41\u7a0b\u53d1\u8d77\u4eba";
                    }
                    switch (relationType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            return StringUtils.cnulls((String)def.getReferenceHumanName(), (String)"");
                        }
                    }
                    return "";
                }
                case 15: {
                    return "\u4efb\u610f\u4eba";
                }
                case 19: {
                    if ("executed".equals(def.getProcessExecutorType())) {
                        return "\u5df2\u6267\u884c";
                    }
                    return "\u5df2\u5206\u914d";
                }
            }
            return "";
        }
        return "";
    }

    public static String getDataFieldName(ProcessDef destProcessDef, String dataFieldID) {
        if (destProcessDef == null || dataFieldID == null || dataFieldID.length() == 0) {
            return "";
        }
        if (destProcessDef.getDataFields() == null || destProcessDef.getDataFields().size() <= 0) {
            return "";
        }
        DataFieldDef tempDataFieldDef = destProcessDef.getDataFields().get(dataFieldID);
        if (tempDataFieldDef == null) {
            return "";
        }
        return tempDataFieldDef.getName();
    }

    private boolean isBOSUuid(String str) {
        try {
            BOSUuid.read((String)str);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean exist(String id) {
        BOSUuid uuid = BOSUuid.read((String)id);
        try {
            String type = uuid.getType().toString();
            if ("WFPATDEF".equals(type) || "WFACTDEF".equals(type)) {
                return true;
            }
            return this.dynamicObject.exists(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage());
            return true;
        }
    }

    private boolean exist4WfRole(String id) {
        try {
            BOSUuid uuid = BOSUuid.read((String)id);
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
            if ("WFPATDEF".equals(uuid.getType().toString()) || "WFACTDEF".equals(uuid.getType().toString())) {
                return true;
            }
            return dynamicObject.exists(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
        }
        catch (Throwable e) {
            return false;
        }
    }

    private String getBizDataMessage(BOSUuid id) {
        IEntityObject entity = null;
        try {
            MDOService tMDOService = new MDOService();
            entity = tMDOService.getEntityObject(id.getType());
        }
        catch (WfException wfException) {
            // empty catch block
        }
        if (entity == null) {
            return "";
        }
        return entity.getAlias() + "(" + entity.getFullName() + ") : " + id + " ";
    }

    public String getDescription() {
        return "\u5f15\u7528\u7684\u4e1a\u52a1\u6570\u636e\u4e0d\u5b58\u5728";
    }

    public boolean getIsMainRule() {
        return true;
    }

    public String getLongDescription() {
        return "";
    }

    public String getName() {
        return "\u5f15\u7528\u7684\u4e1a\u52a1\u6570\u636e\u4e0d\u5b58\u5728";
    }

    public Priority getPriority() {
        return Priority.P5;
    }

    public String getRuleName() {
        return this.getClass().getName();
    }

    public List check(ProcessDef process) throws WfException {
        return this.getProcessCheck(process);
    }

    public String getValidateModelType() {
        return ProcessCheck.class.getName();
    }
}

