/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.FlowContextBuilder;
import com.kingdee.bos.workflow.engine.core.FlowContextLoader;
import com.kingdee.bos.workflow.engine.core.InconsistentTimestampError;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.metas.ProcInstDataInfo;
import com.kingdee.bos.workflow.store.util.RelevantDatas;
import com.kingdee.bos.workflow.transaction.SnapshotRecorder;
import com.kingdee.bos.workflow.transaction.WfTxContext;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.bos.workflow.util.WfBizObjUtils;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.cbos.process.vm.utils.XmlUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ProcessContext {
    private static final String TIMESTAMP = "timestamp";
    private static final Logger logger = Logger.getLogger(ProcessContext.class);
    public static final String COUNTERSIGN_ACTIVITES = "countersignActivites";
    public static final String COUNTERSIGN_ASSIGNMENS = "countersignAssignments";
    public static final String INITIATE_COUNTERSIGN_ASSIGNMENTS = "initiateCountersignAssignments";
    public static final String BILL_LAST_UPDATED_TIME = "$billLastUpdatedTime";
    public static final String BILL_LAST_UPDATED_ASSIGNID = "$billLastUpdatedAssignId";
    public static final String AUTO_APPROVE_PERSON_ID = "$autoapprovepersonid";
    public static final String IS_KICK_BACK = "$isKickBack";
    public static final String PROCESS_TAG = "$ProcessTag$";
    private final WfEngine engine;
    private final ProcInstDataInfo procInstDataInfo;
    private final HashMap data;
    private final WfProcess process;
    private volatile FlowContext runtime;

    public ProcessContext(WfEngine engine, WfProcess process, ProcInstDataInfo procInstDataInfo) throws WfException {
        this.engine = engine;
        this.procInstDataInfo = procInstDataInfo;
        RelevantDatas relevantDatas = new RelevantDatas();
        relevantDatas.initial(procInstDataInfo.getDataValue());
        this.data = relevantDatas.readValue();
        this.process = process;
    }

    public FlowContext getFlowContext() throws WfException {
        if (!this.isPvmMode()) {
            throw new Error("\u975ePVM\u6a21\u5f0f\uff0c\u7981\u6b62\u8c03\u7528\u672c\u65b9\u6cd5\uff01");
        }
        FlowContext r = this.runtime;
        if (r == null) {
            r = this.loadFlowContext();
        }
        return r;
    }

    public synchronized FlowContext loadFlowContext() throws WfException {
        FlowContext r = this.runtime;
        if (r != null) {
            return r;
        }
        String xml = this.engine.getFlowContextLoader().get(this.process.getId());
        Flow flow = this.engine.getFlow(this.process.getDefinition().getHashValue());
        if (xml == null || xml.length() == 0) {
            Document doc = FlowContextBuilder.build(this.process);
            return this.setFlowContext(flow.fromXml(doc));
        }
        Document doc = this.checkTimestamp(xml);
        r = flow.fromXml(doc);
        Util.bind(this.process, r);
        this.runtime = r;
        return r;
    }

    private Document checkTimestamp(String xml) throws Error {
        int limit;
        int tmp;
        Document doc = XmlUtil.parse((String)xml);
        String timestamp = doc.getDocumentElement().getAttribute(TIMESTAMP);
        if (timestamp != null && timestamp.length() > 0 && (tmp = Integer.parseInt(timestamp)) != (limit = this.process.getProcessMeta().getLimit())) {
            this.engine.getCacheManager().removeProcessInst(this.process.getId());
            try {
                WfProcess process2 = this.engine.getProcessInst(this.process.getId());
                if (process2.getProcessMeta().getLimit() == tmp) {
                    this.process.setProcessMeta(process2.getProcessMeta());
                } else {
                    this.process.getProcessMeta().setLimit(tmp);
                    process2.getProcessMeta().setLimit(tmp);
                }
            }
            catch (WfException e) {
                e.printStackTrace();
            }
        }
        return doc;
    }

    public boolean isPvmMode() {
        return true;
    }

    public synchronized FlowContext setFlowContext(FlowContext runtime) throws WfException {
        FlowContext r = this.runtime;
        if (runtime == null) {
            return r;
        }
        Document doc = this.setTimestamp(runtime);
        String xml = XmlUtil.toString((Document)doc);
        FlowContextLoader loader = this.engine.getFlowContextLoader();
        if (r == null) {
            try {
                loader.insert(this.process.getId(), xml);
            }
            catch (Throwable t) {
                this.engine.getCacheManager().removeProcessInst(this.process.getId());
                throw new InconsistentTimestampError("\u8fd0\u884c\u65f6\u73af\u5883\u4e0d\u4e00\u81f4\uff01");
            }
            Util.bind(this.process, runtime);
            r = runtime;
        } else {
            if (r != runtime) {
                this.engine.getCacheManager().removeProcessInst(this.process.getId());
                throw new InconsistentTimestampError("\u8fd0\u884c\u65f6\u73af\u5883\u4e0d\u4e00\u81f4\uff01");
            }
            loader.save(this.process.getId(), xml, runtime.isClosed());
        }
        this.storeToDb();
        this.processChanged();
        this.runtime = r;
        return r;
    }

    private Document setTimestamp(FlowContext runtime) {
        int timestamp = this.process.setTimestamp();
        Document doc = runtime.toXml();
        doc.getDocumentElement().setAttribute(TIMESTAMP, String.valueOf(timestamp));
        return doc;
    }

    public ProcInstDataInfo getProcInstDataInfo() {
        return this.procInstDataInfo;
    }

    public String[] getDataFieldNames() {
        return this.data.keySet().toArray(new String[this.data.keySet().size()]);
    }

    public void setDataFieldValue(String name, Object value) {
        if (this.data == null) {
            return;
        }
        if (value instanceof IObjectValue) {
            IObjectValue vo = (IObjectValue)value;
            if (vo.getBOSType() != null && "63D30103".equals(vo.getBOSType().toString())) {
                this.data.put("$" + name + " .approveId$", vo.get("id"));
            }
        } else if (value == null && this.data.containsKey("$" + name + " .approveId$")) {
            this.data.put("$" + name + " .approveId$", null);
        }
        if (this.data.containsKey(name)) {
            this.data.put(name, value);
        }
        this.processChanged();
    }

    private void processChanged() {
        WfTxContext current = WfTxContext.current();
        if (current != null) {
            current.getLazyPersistentMgr().procInstChanged(this.process.getId());
        }
    }

    public void putDataFieldValue(String name, Object value) {
        if (this.data == null || name == null) {
            logger.warn((Object)"data or name is null");
        } else {
            if (value instanceof IObjectValue) {
                IObjectValue vo = (IObjectValue)value;
                if (vo.getBOSType() != null && "63D30103".equals(vo.getBOSType().toString())) {
                    this.data.put("$" + name + " .approveId$", vo.get("id"));
                }
            } else if (value == null && this.data.containsKey("$" + name + " .approveId$")) {
                this.data.put("$" + name + " .approveId$", null);
            }
            this.data.put(name, value);
        }
        this.processChanged();
    }

    public Object getDataFieldValue(String name) {
        return this.getDataFieldValue(name, null);
    }

    public Object getDataFieldValue(String name, Context ctx) {
        String s;
        String[] str;
        if (this.data == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("datafield [" + name + "] not found,return null!"));
            }
            return null;
        }
        boolean isMulti = true;
        if (ctx == null) {
            try {
                ctx = this.getWfEngine().context();
                isMulti = false;
            }
            catch (WfException wfException) {
                // empty catch block
            }
        }
        boolean isBizObj = false;
        Object bizId = null;
        String prop = "";
        if (!this.data.containsKey(name) && (str = name.split("[.]", 2)).length == 2 && !(s = str[0]).startsWith("$")) {
            String[] bizIdNames = new String[]{"$" + s + " .bizId$", "$" + s + "\n.bizId$", "$" + s + " .approveId$"};
            for (int i = 0; i < bizIdNames.length; ++i) {
                if (!this.data.containsKey(bizIdNames[i])) continue;
                isBizObj = true;
                bizId = this.data.get(bizIdNames[i]);
                break;
            }
            if (isBizObj) {
                name = str[0];
                prop = str[1];
            }
        }
        if (isBizObj && "id".equals(prop) && bizId != null) {
            return BOSUuid.read((String)bizId.toString());
        }
        Object rtn = this.data.get(name);
        if ((isMulti || rtn == null) && isBizObj && bizId != null) {
            try {
                rtn = WfBizObjUtils.getBizObj(this.getWfEngine().getProcessDef(this.getProcInstDataInfo().getProcDefHash()), name, bizId.toString(), ctx, isMulti);
                if (!isMulti) {
                    this.data.put(name, rtn);
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("wf get biz object [" + name + "] error! bizid: " + bizId + " because: " + ex.getMessage()));
            }
        }
        if (!StringUtils.isEmpty((String)prop)) {
            if (rtn instanceof IObjectValue) {
                try {
                    rtn = ScriptUtil.evalObjectProperty(prop, rtn, ctx);
                }
                catch (WfException e) {
                    logger.warn((Object)("wf datafield [" + name + "." + prop + "] not found, return null!"));
                    rtn = null;
                }
            } else {
                logger.warn((Object)("wf datafield [" + name + "] is not bizObject, return " + rtn));
            }
        }
        return rtn;
    }

    public Map cloneData() {
        Map dataClone = (Map)this.data.clone();
        dataClone.putAll(this.adjustBizObjectInner(true, false));
        return dataClone;
    }

    public Map getDataCopy() {
        return this.getDataCopy(true, false);
    }

    public Map getDataCopy(boolean isloadwhennull, boolean isforce) {
        long time = System.currentTimeMillis();
        this.adjustBizObject(isloadwhennull, isforce);
        Map rt = (Map)this.data.clone();
        if (logger.isDebugEnabled() && System.currentTimeMillis() - time > 50L) {
            logger.debug((Object)("datacopy cost:" + (System.currentTimeMillis() - time)));
        }
        return rt;
    }

    public void setDataFieldValues(Map dataMap) {
        if (dataMap != null) {
            for (Map.Entry entry : dataMap.entrySet()) {
                this.setDataFieldValue(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public void putDataFieldValues(Map dataMap) {
        if (dataMap != null) {
            for (Map.Entry entry : dataMap.entrySet()) {
                this.putDataFieldValue(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public WfEngine getWfEngine() throws WfException {
        return this.engine;
    }

    public void adjustBizObject(boolean isloadwhennull, boolean isforce) {
        this.data.putAll(this.adjustBizObjectInner(isloadwhennull, isforce));
    }

    private Map adjustBizObjectInner(boolean isloadwhennull, boolean isforce) {
        long time = System.currentTimeMillis();
        HashMap cloneData = (HashMap)this.data.clone();
        Iterator iterator = cloneData.entrySet().iterator();
        HashMap<String, IObjectValue> bizObjValue = new HashMap<String, IObjectValue>();
        while (iterator.hasNext()) {
            IObjectValue rtn;
            Object bizId;
            String bizName;
            String fn;
            Map.Entry entery = iterator.next();
            Object fieldName = entery.getKey();
            if (!(fieldName instanceof String) || !(fn = (String)fieldName).startsWith("$")) continue;
            if (fn.indexOf(".bizId$") > 0) {
                bizName = fn.substring(1, fn.length() - 8);
                if (!isforce && this.data.get(bizName) == null && !isloadwhennull || (bizId = entery.getValue()) == null) continue;
                rtn = null;
                try {
                    rtn = WfBizObjUtils.getBizObj(this.getWfEngine().getProcessDef(this.getProcInstDataInfo().getProcDefHash()), bizName, bizId.toString(), this.getWfEngine().context());
                }
                catch (Exception ex) {
                    logger.warn((Object)("wf get biz object [" + bizName + "] error! because: " + ex.getMessage()));
                    rtn = null;
                }
                bizObjValue.put(bizName, rtn);
                continue;
            }
            if (fn.indexOf(".approveId$") <= 0) continue;
            bizName = fn.substring(1, fn.length() - 12);
            if (!isforce && this.data.get(bizName) == null && !isloadwhennull || (bizId = entery.getValue()) == null) continue;
            rtn = null;
            try {
                rtn = WfBizObjUtils.getBizObj(this.getWfEngine().getProcessDef(this.getProcInstDataInfo().getProcDefHash()), bizName, bizId.toString(), this.getWfEngine().context());
                bizObjValue.put(bizName, rtn);
            }
            catch (Exception ex) {
                logger.warn((Object)("wf get approve result [" + bizName + "] error! because: " + ex.getMessage()));
                rtn = null;
            }
            bizObjValue.put(bizName, rtn);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Wf ProcessContext.adjustBizObject cost: " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        return bizObjValue;
    }

    public void storeToDb() throws WfException {
        LowTimer lowTimer = new LowTimer();
        SnapshotRecorder recorder = SnapshotRecorder.create();
        recorder.snapshoot((AbstractObjectValue)this.procInstDataInfo);
        RelevantDatas relevantDatas = new RelevantDatas();
        relevantDatas.initial("");
        relevantDatas.writeValue((Map)this.data);
        this.procInstDataInfo.setDataValue(relevantDatas.toXML());
        this.procInstDataInfo.setTime(this.getTime());
        recorder.snapshoot((AbstractObjectValue)this.procInstDataInfo);
        recorder.recordSnapshots();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ProcessContext.storeToDb() cost:" + lowTimer.msValue()));
        }
        WfProcess wfProcess = this.process;
        this.engine.getCorrelationMatchMgr().syncCorrMatchDataFields(wfProcess);
    }

    public int getInnerHashCode() {
        return this.data.hashCode();
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

