/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.SolutionChangedEvent;
import com.kingdee.bos.framework.config.SolutionChangedListener;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import java.util.List;
import org.apache.log4j.Logger;

public class WorkflowSolutionChangedListener
implements SolutionChangedListener {
    private static Logger logger = Logger.getLogger(WorkflowSolutionChangedListener.class);

    public void valueChanged(SolutionChangedEvent e) {
        List aisList;
        if (e == null) {
            throw new IllegalArgumentException();
        }
        SolutionDeployInfo solutionDeployInfo = e.getSolutionDeployInfo();
        if (solutionDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String solutionName = solutionDeployInfo.getName();
        int type = e.getType();
        if (SolutionChangedEvent.ADD == type) {
            aisList = solutionDeployInfo.getAISInfos();
            for (AISDeployInfo ais : aisList) {
                String aisName = ais.getName();
                logger.info((Object)aisName);
            }
        } else if (SolutionChangedEvent.DELETE == type) {
            aisList = solutionDeployInfo.getAISInfos();
            for (AISDeployInfo ais : aisList) {
                String aisName = ais.getName();
                this.destroy(solutionName, aisName);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("WorkflowSolutionChangedListener:");
        buffer.append(solutionName);
        buffer.append(':');
        buffer.append(type);
        String message = buffer.toString();
        logger.info((Object)message);
    }

    private void destroy(String solution, String ais) {
        try {
            WfEngine wfEngine;
            boolean exist = WfEngine.exist(ais, solution);
            if (exist && (wfEngine = WfEngine.getEngine(ais, solution)) != null) {
                wfEngine.destroy();
            }
        }
        catch (WfException e) {
            logger.error((Object)e);
        }
    }
}

