/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.cache;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.jcache.CacheLoader;
import com.kingdee.bos.jcache.ObjectRef;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.trace.WfMonitor;
import com.kingdee.util.LowTimer;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ProcessInstanceCacheLoader
implements com.kingdee.bos.cache.CacheLoader,
CacheLoader {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.cache.ProcessInstanceCacheLoader");
    private WfEngine engine;

    public ProcessInstanceCacheLoader(WfEngine engine) {
        this.engine = engine;
    }

    public Object load(Object argument) throws CacheException {
        try {
            return this.loadWfProcess((String)argument);
        }
        catch (WfException ex) {
            log.warn((Object)("can not load process instance from cache. process instance's Id : '" + argument + "' at " + this.engine.context().getAIS()), (Throwable)ex);
            throw new CacheException("WfException", (Throwable)ex);
        }
    }

    private WfProcess loadWfProcess(String procInstId) throws WfException {
        WfProcess procInst;
        LowTimer lowTimer = new LowTimer();
        try {
            ProcessInstInfo meta = this.engine.getStoreManager().getProcessStorer().getProcessInstance(procInstId, true);
            if (meta == null) {
                throw new WfException("Fatal Error, can not get processInstInfo, id '" + procInstId + "' at " + this.engine.context().getAIS());
            }
            WfProcessMgr procMgr = this.engine.getProcessMgr(meta.getProcDefId(), meta.getProcDefInnerVersion());
            if (procMgr == null) {
                throw new WfException("Fatal Error, can not get procMgr, procDef id '" + procInstId + "' at " + this.engine.context().getAIS());
            }
            procInst = new WfProcess(meta, procMgr);
            WfMonitor.trace(procInst);
        }
        catch (SQLException ex) {
            log.warn((Object)"loadWfProcess() occur error:", (Throwable)ex);
            throw new WfException("SQLException", (Throwable)ex, true);
        }
        catch (DataAccessException e) {
            log.warn((Object)"loadWfProcess() occur error:", (Throwable)e);
            throw new WfException("DataAccessException", (Throwable)e, true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProcessInstanceCacheLoader load " + procInstId + "] cost: " + lowTimer.msValue()));
        }
        return procInst;
    }

    public void cleanUp() {
    }

    public Object load(ObjectRef ref) throws Exception {
        return this.load(ref.name());
    }

    public void unload(ObjectRef ref, Object value) {
        log.info((Object)("cache item " + ref + " unload value " + value));
    }
}

