/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.wrapper.SqlExecutor;
import java.sql.Timestamp;

public class FlowProfileLoader {
    private Context ctx;

    public FlowProfileLoader(Context ctx) {
        this.ctx = ctx;
        String sql = "select KSQL_TABNAME as c from KSQL_USERTABLES WHERE KSQL_TABNAME='T_WFR_PROFILE'";
        try {
            if (SQL.executeQuery((Context)ctx, (String)sql).size() == 0) {
                sql = "CREATE TABLE T_WFR_PROFILE(fprocInstId varchar(44) not null, fserver varchar(50) not null,factinstid varchar(44) not null, fmessage clob(1000000) not null, ftime datetime not null)";
                SQL.executeUpdate((Context)ctx, (String)sql);
            }
        }
        catch (BOSException e) {
            throw new RuntimeException("check or create table {T_WFR_PROFILE} failed!", e);
        }
        Job job = new Job(ctx, (IJobHandler)new FlowProfileDisposer(this), null, false);
        JobManager.instance().add(job);
    }

    public void insert(String procInstId, String actInstId, String message) {
        Timestamp now = ClusterStateManager.get((Context)this.ctx).dbNow();
        String sql = "insert into T_WFR_PROFILE(fprocInstId, fserver, factinstid, fmessage, ftime)values(?,?,?,?,?)";
        String server = Configuration.serviceInstanceIdGenerator().getInstanceId();
        int[] types = new int[]{12, 12, 12, 12, 93};
        Object[] values = new Object[]{procInstId, server, actInstId, message, now};
        SqlExecutor.asynExecute((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
    }

    private void deleteClosed() throws BOSException {
        String sql = "delete from T_WFR_PROFILE where ftime<?";
        int[] types = new int[]{93};
        long offset = -5184000000L;
        Timestamp time = new Timestamp(System.currentTimeMillis() + offset);
        Object[] values = new Object[]{time};
        SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
    }

    private static class FlowProfileDisposer
    implements IJobHandler {
        private static final long serialVersionUID = -8867606922534984404L;
        private FlowProfileLoader loader;

        public FlowProfileDisposer(FlowProfileLoader loader) {
            this.loader = loader;
        }

        public Object execute(Job job) {
            try {
                this.loader.deleteClosed();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new Delay(36000);
        }
    }
}

