/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.core.thread;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;

public class FlowInitiator
extends WfJobHandler {
    private static final long serialVersionUID = 4166757297639611953L;
    private String procInstId;

    public static void enqueue(Context ctx, String procInstId) throws AlreadyInProcessQueueException {
        FlowInitiator handler = new FlowInitiator(procInstId, ctx.getCaller().toString());
        String title = "~" + procInstId;
        String jobId = Mutex.getMutex(ctx, procInstId);
        JobDispatcher.dispatch(jobId, ctx, title, handler, false, WfPriority.MEDIUM);
    }

    public static void enqueue(Context ctx, String procInstId, String parentProcInst) throws AlreadyInProcessQueueException {
        FlowInitiator handler = new FlowInitiator(procInstId, ctx.getCaller().toString());
        String title = "~" + procInstId;
        String jobId = Mutex.getMutex(ctx, parentProcInst);
        JobDispatcher.dispatch(jobId, ctx, title, handler, false, WfPriority.MEDIUM);
    }

    public FlowInitiator(String procInstId, String userId) {
        super(userId);
        this.procInstId = procInstId;
    }

    @Override
    protected String getProcInstId() {
        return this.procInstId;
    }

    @Override
    protected boolean requiresTran() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Context ctx) throws Exception {
        WfEngine engine = WfEngine.getEngine(ctx);
        WfProcess process = engine.getCacheManager().getProcessInst(this.procInstId);
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        if (process.isClosed() || runtime.isClosed()) {
            return;
        }
        try {
            if (runtime.isStarted()) {
                runtime.resume();
            } else {
                runtime.execute(new Object[0]);
            }
            FlowInitiator.tryOmitFirstActivitiy(runtime);
        }
        catch (Throwable error) {
            this.saveLog(error, ctx, this.procInstId);
        }
        finally {
            try {
                process.manager().processProcessTopic(process);
            }
            catch (Throwable error) {
                this.saveLog(error, ctx, this.procInstId);
            }
            super.commitMgrAndRuntimeTx(process, runtime);
        }
    }

    public static void tryOmitFirstActivitiy(FlowContext runtime) throws Exception {
        if (Util.shouldOmitFirstActivity(runtime)) {
            String actId = Util.getOmittedActInstId(runtime);
            Execution e = runtime.getExecution(actId);
            boolean isFirst = false;
            if (e != null) {
                String firstAct = Util.getFirstActId(e.getContext());
                WfActivity act = Util.getWfActivity(e);
                isFirst = act.getDefinition().getID().equals(firstAct);
            }
            if (isFirst && e.isBeforePartiallyCompleted()) {
                runtime.signal(actId);
            }
            Util.clearOmitFirstActivityFlag(runtime);
            if (isFirst && runtime.getExecution(actId) != null) {
                runtime.signal(actId);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.procInstId;
    }
}

