/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.procdiagram.cal;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.EndActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiagramActivity;
import com.kingdee.bos.workflow.extscheme.procdiagram.bean.DiagramProcess;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.CalLongestPath;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.CalNextActDef;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.EquivalentLengthActivity;
import com.kingdee.bos.workflow.extscheme.procdiagram.cal.SortAppendActivity;
import com.kingdee.bos.workflow.extscheme.procdiagram.util.ProcDiagramUtil;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.service.ormrpc.struct.WfProcessImageUtil;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalProcDiagramDetail {
    protected static final Logger logger = Logger.getLogger(CalProcDiagramDetail.class);
    private WfEngine engine;
    private String procDefHash;
    private String procinstId;
    private String actinstId;
    private Context ctx;
    private Map actDefNameMap = null;
    private DiagramProcess diagramProcess;
    private WfProcess process = null;
    private ActivityInstInfo endActInstInfo = null;
    private Map<String, Object> dataMap;
    private Map<String, Object> predictMap;
    private Map<String, List<ActivityInstInfo>> actGroupMap = new HashMap<String, List<ActivityInstInfo>>();
    private int recurveCount = 0;
    private Map<String, ActivityDef> noRepeatActDefMap = new HashMap<String, ActivityDef>();

    public CalProcDiagramDetail(String actinstId, WfEngine engine, String procDefHash, String procinstId, Context ctx) {
        this.actinstId = actinstId;
        this.engine = engine;
        this.procDefHash = procDefHash;
        this.procinstId = procinstId;
        this.ctx = ctx;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
    }

    public void setPredictMap(Map<String, Object> predictMap) {
        this.predictMap = predictMap;
    }

    public Map<String, Object> getPredictMap() {
        return this.predictMap;
    }

    public DiagramProcess calProcessPath() throws WfException {
        ArrayList<DiagramActivity> diaActList = new ArrayList<DiagramActivity>();
        ProcessDef processDef = this.engine.getProcessDef(this.procDefHash);
        Flow flow = this.engine.getFlow(this.procDefHash);
        this.actDefNameMap = WfProcessImageUtil.rename((ProcessDef)processDef, (Locale)this.ctx.getLocale());
        this.diagramProcess = new DiagramProcess(this.actinstId, this.procDefHash, this.procinstId, processDef, this.process);
        if (!StringUtils.isEmpty((String)this.procinstId)) {
            this.process = this.engine.getProcessInst(this.procinstId);
            if (this.predictMap == null) {
                this.getCompleteDiagramActivitys(diaActList, processDef);
            }
        }
        List<ActivityDef> calStartActivityList = this.getCalStartActDefAndCreateCurrentActivitys(diaActList, processDef, flow);
        if (this.predictMap != null) {
            diaActList = new ArrayList();
        }
        this.getNoStartDiaActivitys(diaActList, processDef, flow, calStartActivityList);
        if (this.predictMap == null) {
            diaActList.add(this.createDiagramActivity(this.endActInstInfo, (ActivityDef)processDef.getEndActivity()));
            this.dealProcForAppend(diaActList, processDef);
        }
        this.diagramProcess.setDiaGramActivitys(diaActList);
        this.diagramProcess.setProcess(this.process);
        return this.diagramProcess;
    }

    private void getCompleteDiagramActivitys(List<DiagramActivity> diaActList, ProcessDef processDef) throws WfException {
        ActivityInstInfo[] activityInsts = this.engine.getActInstMetaArrayByProcInstId(this.procinstId);
        for (int index = 0; index < activityInsts.length; ++index) {
            ActivityInstInfo tActivityInstInfo = activityInsts[index];
            if (!tActivityInstInfo.getState().startsWith(WfState.CLOSED.getValue()) || "closed.aborted".equals(tActivityInstInfo.getState())) continue;
            ActivityDef activityDef = processDef.getActivityDef(tActivityInstInfo.getActDefId());
            if (activityDef instanceof EndActivityDef) {
                this.endActInstInfo = tActivityInstInfo;
                continue;
            }
            boolean isappend = this.isAppendAndCreateGroupList(tActivityInstInfo);
            if (isappend) continue;
            DiagramActivity activity = this.createDiagramActivity(tActivityInstInfo, activityDef);
            diaActList.add(activity);
        }
    }

    private List<ActivityDef> getCalStartActDefAndCreateCurrentActivitys(List<DiagramActivity> diaActList, ProcessDef processDef, Flow flow) throws WfException {
        List<ActivityDef> startActDefList = new ArrayList<ActivityDef>();
        if (this.process == null) {
            StartActivityDef startActDef = processDef.getStartActivity();
            diaActList.add(this.createDiagramActivity(null, (ActivityDef)startActDef));
            startActDefList.add((ActivityDef)startActDef);
        } else {
            ArrayList<WfActivity> runActivityList = new ArrayList<WfActivity>();
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)"select factinstId from t_wfr_actinst where fprocinstId=? and fstate like 'open%'", (Object[])new Object[]{this.process.getId()});
                while (rowSet.next()) {
                    runActivityList.add(this.engine.getActivityInst(rowSet.getString(1)));
                }
            }
            catch (Exception e) {
                throw new WfException((Throwable)e);
            }
            if (runActivityList.size() > 0) {
                for (int index = 0; index < runActivityList.size(); ++index) {
                    ActivityDef actDef = ((WfActivity)runActivityList.get(index)).getDefinition();
                    this.isAppendAndCreateDiagramActivity(((WfActivity)runActivityList.get(index)).getMeta(), actDef, diaActList);
                }
                if (!(this.process.isClosed() || ProcDiagramUtil.isAbort(this.process) || ProcDiagramUtil.isSusPend(this.process))) {
                    startActDefList = this.getCurrentStartActDef(runActivityList, flow);
                }
            }
        }
        return startActDefList;
    }

    private List<ActivityDef> getCalStartActDefAndCreateCurrentActivitysNew(List<DiagramActivity> diaActList, ProcessDef processDef, Flow flow) throws WfException {
        List<ActivityDef> startActDefList = new ArrayList<ActivityDef>();
        if (this.process == null) {
            StartActivityDef startActDef = processDef.getStartActivity();
            diaActList.add(this.createDiagramActivity(null, (ActivityDef)startActDef));
            startActDefList.add((ActivityDef)startActDef);
        } else {
            ArrayList<WfActivity> runActivityList = new ArrayList<WfActivity>();
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)"select factinstId from t_wfr_actinst where fprocinstId=? and fstate like 'open%'", (Object[])new Object[]{this.process.getId()});
                while (rowSet.next()) {
                    runActivityList.add(this.engine.getActivityInst(rowSet.getString(1)));
                }
            }
            catch (Exception e) {
                throw new WfException((Throwable)e);
            }
            if (!(runActivityList.size() <= 0 || this.process.isClosed() || ProcDiagramUtil.isAbort(this.process) || ProcDiagramUtil.isSusPend(this.process))) {
                startActDefList = this.getCurrentStartActDef(runActivityList, flow);
            }
        }
        return startActDefList;
    }

    private List<ActivityDef> getCurrentStartActDef(List<WfActivity> runActivityList, Flow flow) throws WfException {
        List<ActivityDef> noBackStartActDefList;
        ActivityDef actDef;
        int index;
        ArrayList<ActivityDef> startActDefList = new ArrayList<ActivityDef>();
        if (!StringUtils.isEmpty((String)this.actinstId)) {
            for (index = 0; index < runActivityList.size(); ++index) {
                WfActivity activity = runActivityList.get(index);
                if (!this.actinstId.equals(activity.getId())) continue;
                startActDefList.add(activity.getDefinition());
                return startActDefList;
            }
        }
        for (index = 0; index < runActivityList.size(); ++index) {
            actDef = runActivityList.get(index).getDefinition();
            if (!(actDef instanceof ApproveActivityDef) && !(actDef instanceof SubflowActivityDef)) continue;
            startActDefList.add(actDef);
        }
        if (startActDefList.size() == 0) {
            for (index = 0; index < runActivityList.size(); ++index) {
                actDef = runActivityList.get(index).getDefinition();
                startActDefList.add(actDef);
            }
        }
        HashSet<String> tmp = new HashSet<String>();
        Iterator it = startActDefList.iterator();
        while (it.hasNext()) {
            ActivityDef activityDef = (ActivityDef)it.next();
            String actDefId = activityDef.getID();
            if (tmp.size() > 0) {
                for (String string : tmp) {
                    if (!string.equals(actDefId)) continue;
                    it.remove();
                }
            }
            tmp.add(actDefId);
        }
        if (startActDefList.size() > 1 && (noBackStartActDefList = this.getNoBackStartActivityList(startActDefList, flow)).size() > 0) {
            return noBackStartActDefList;
        }
        return startActDefList;
    }

    private List<ActivityDef> getNoBackStartActivityList(List<ActivityDef> startActDefList, Flow flow) throws WfException {
        ArrayList<ActivityDef> noBackActDefList = new ArrayList<ActivityDef>();
        for (int index = 0; index < startActDefList.size(); ++index) {
            ActivityDef actDef = startActDefList.get(index);
            String name = actDef.getName();
            if (name.indexOf("\u5e9f\u5f03") >= 0 || name.indexOf("\u53cd\u5ba1\u6279") >= 0) continue;
            TransitionCollection transtion = actDef.getIncomingTransitions();
            boolean isBack = true;
            for (int j = 0; j < transtion.size(); ++j) {
                TransitionDef transitionDef = transtion.get(j);
                if (ProcDiagramUtil.isBackTransition(transitionDef, flow)) continue;
                isBack = false;
                break;
            }
            if (isBack) continue;
            noBackActDefList.add(actDef);
        }
        return noBackActDefList;
    }

    private void getNoStartDiaActivitys(List<DiagramActivity> diaActList, ProcessDef processDef, Flow flow, List<ActivityDef> calStartActivityList) throws WfException {
        for (int index = 0; index < calStartActivityList.size(); ++index) {
            ActivityDef startActDef = calStartActivityList.get(index);
            List<ActivityDef> postBranchActDefList = this.getCalPostDefList(startActDef, flow, processDef, this.process);
            for (int indexPost = 0; indexPost < postBranchActDefList.size(); ++indexPost) {
                ActivityDef activityDef = postBranchActDefList.get(indexPost);
                if (this.noRepeatActDefMap.get(activityDef.getID()) != null) continue;
                diaActList.add(this.createDiagramActivity(null, activityDef));
                this.noRepeatActDefMap.put(activityDef.getID(), activityDef);
            }
        }
    }

    public List<ActivityDef> getPostActivityDefs(ActivityDef actDef, Flow flow, ProcessDef pdef, WfProcess process) throws WfException {
        return this.getCalPostDefList(actDef, flow, pdef, process);
    }

    private boolean isAppendActivity(ActivityInstInfo tActivityInstInfo) {
        return tActivityInstInfo != null && tActivityInstInfo.getParentActInstId() != null;
    }

    public DiagramActivity createDiagramActivity(ActivityInstInfo tActivityInstInfo, ActivityDef activityDef) {
        DiagramActivity tDiagramActivity = new DiagramActivity();
        tDiagramActivity.setActDefId(activityDef.getID());
        if (this.isAppendActivity(tActivityInstInfo)) {
            tDiagramActivity.setActDefName(tActivityInstInfo.getActDefName(this.ctx.getLocale()));
        } else {
            tDiagramActivity.setActDefName(this.actDefNameMap == null ? activityDef.getName() : this.actDefNameMap.get(activityDef.getID()).toString());
        }
        tDiagramActivity.setDiaActivityType(ProcDiagramUtil.getDiaActType(activityDef, tActivityInstInfo));
        tDiagramActivity.setActDef(activityDef);
        if (activityDef instanceof SubflowActivityDef) {
            this.diagramProcess.setCludeSub(true);
        }
        if (tActivityInstInfo != null) {
            tDiagramActivity.setWfstate(tActivityInstInfo.getActInstInfo().getState());
            tDiagramActivity.setActivityId(tActivityInstInfo.getActInstId());
            tDiagramActivity.setCreatedTime(tActivityInstInfo.getCreatedTime());
            tDiagramActivity.setCompleteTime(tActivityInstInfo.getCompleteTime());
        }
        tDiagramActivity.setActState(ProcDiagramUtil.getAiaActState(tActivityInstInfo, activityDef, this.process, this.ctx));
        return tDiagramActivity;
    }

    private List<ActivityDef> getCalPostDefList(ActivityDef startActDef, Flow flow, ProcessDef processDef, WfProcess process) throws WfException {
        CalLongestPath tCalLongestPath = new CalLongestPath(this.engine);
        Map<String, Integer> actDistMap = tCalLongestPath.getToEndMaxPachMap(flow, processDef);
        if (actDistMap == null || actDistMap.isEmpty()) {
            throw new WfException("\u83b7\u53d6\u6bcf\u4e2a\u8282\u70b9\u5230\u7ed3\u675f\u8282\u70b9\u7684\u6700\u5927\u8ddd\u79bb \u51fa\u9519");
        }
        int actNums = processDef.getActivitys().size();
        ArrayList<ActivityDef> actDefPosts = new ArrayList<ActivityDef>();
        ArrayList<TransitionDef> selectTrangs = new ArrayList<TransitionDef>();
        String startActDefId = startActDef.getID();
        boolean isDirect = false;
        boolean isNotStartSubProc = false;
        if (this.predictMap != null) {
            if (this.predictMap.get("isDirect") != null) {
                isDirect = (Boolean)this.predictMap.get("isDirect");
            }
            if (this.predictMap.get("isNotStartSubProc") != null) {
                isNotStartSubProc = (Boolean)this.predictMap.get("isNotStartSubProc");
            }
        }
        int count = 0;
        boolean isFirst = true;
        if (isNotStartSubProc) {
            isFirst = false;
        }
        EquivalentLengthActivity eqLenActs = new EquivalentLengthActivity();
        while (!(startActDef instanceof EndActivityDef)) {
            this.failFast(actDefPosts.size(), actNums, processDef);
            CalNextActDef calNextActDef = new CalNextActDef(actDistMap, startActDef, flow, process, processDef, selectTrangs, startActDefId, this.ctx, eqLenActs);
            if (this.dataMap != null) {
                calNextActDef.setDataMap(this.dataMap);
            }
            if (this.predictMap != null) {
                calNextActDef.setPredictMap(this.predictMap);
            }
            if (isFirst) {
                calNextActDef.setFirst(true);
                isFirst = false;
            }
            List<ActivityDef> nextActDefList = calNextActDef.calNextActDef();
            EquivalentLengthActivity eqLengthAct = calNextActDef.getEqLenActs();
            List<ActivityDef> eqLengActs = eqLengthAct.getNetActDefs();
            startActDef = nextActDefList.get(0);
            if (startActDef instanceof EndActivityDef) break;
            if (this.predictMap != null) {
                if (process != null || !calNextActDef.isFirst()) {
                    actDefPosts.add(startActDef);
                }
                if (nextActDefList.size() > 1) {
                    for (int i = 1; i < nextActDefList.size(); ++i) {
                        actDefPosts.add(nextActDefList.get(i));
                    }
                }
                if (!isDirect || !(startActDef instanceof ManpowerActivityDef) && !(startActDef instanceof ManualDecisionActivityDef)) continue;
                if (!isNotStartSubProc && process != null || count >= true) break;
                ++count;
                continue;
            }
            actDefPosts.add(startActDef);
            if (eqLengActs != null && eqLengActs.size() > 0) {
                for (ActivityDef ActDef : eqLengActs) {
                    actDefPosts.add(ActDef);
                }
            }
            eqLengthAct.resetContainer();
        }
        return actDefPosts;
    }

    private void failFast(int size, int actNums, ProcessDef processDef) throws WfException {
        if (size > actNums) {
            throw new WfException("\u4f30\u7b97\u6d41\u7a0b\u8282\u70b9\u7684\u6570\u91cf\u8d85\u8fc7\u4e86\u8be5\u6d41\u7a0b\u6240\u6709\u7684\u8282\u70b9\u7684\u6570\u91cf\uff0c\u6d41\u7a0b\u540d\u79f0\u4e3a[" + processDef.getName() + "]");
        }
    }

    private void dealProcForAppend(List<DiagramActivity> diaActList, ProcessDef processDef) throws WfException {
        for (int index = 0; index < diaActList.size(); ++index) {
            List<ActivityInstInfo> appendForParentList;
            DiagramActivity tDiagramActivity = diaActList.get(index);
            String activityId = tDiagramActivity.getActivityId();
            if (StringUtils.isEmpty((String)activityId) || (appendForParentList = this.actGroupMap.get(activityId)) == null) continue;
            ArrayList<DiagramActivity> appendActList = new ArrayList<DiagramActivity>();
            this.recurAppendList(processDef, appendActList, activityId);
            DiagramProcess appendDiagramProcess = new DiagramProcess(activityId, this.procDefHash, this.procinstId, processDef, this.process);
            appendDiagramProcess.setDiaGramActivitys(appendActList);
            appendDiagramProcess.setAppend(true);
            tDiagramActivity.setDiagramProcess(appendDiagramProcess);
        }
    }

    private void recurAppendList(ProcessDef processDef, List<DiagramActivity> appendActList, String activityId) {
        ++this.recurveCount;
        if (this.recurveCount > 100) {
            return;
        }
        List<ActivityInstInfo> appendForParentList = this.actGroupMap.get(activityId);
        if (appendForParentList != null) {
            List<ActivityInstInfo> sortActivityList = SortAppendActivity.getSequenceActivitysForGroup(appendForParentList);
            for (int j = 0; j < sortActivityList.size(); ++j) {
                ActivityInstInfo tActivityInstInfo = sortActivityList.get(j);
                DiagramActivity tDiagramActivity = this.createDiagramActivity(tActivityInstInfo, processDef.getActivityDef(tActivityInstInfo.getActDefId()));
                appendActList.add(tDiagramActivity);
                this.recurAppendList(processDef, appendActList, tActivityInstInfo.getActInstId());
            }
        }
    }

    private boolean isAppendAndCreateDiagramActivity(ActivityInstInfo tActivityInstInfo, ActivityDef activityDef, List<DiagramActivity> diaActList) {
        boolean isappend = this.isAppendAndCreateGroupList(tActivityInstInfo);
        if (!isappend) {
            DiagramActivity activity = this.createDiagramActivity(tActivityInstInfo, activityDef);
            diaActList.add(activity);
        }
        return isappend;
    }

    private boolean isAppendAndCreateGroupList(ActivityInstInfo tActivityInstInfo) {
        String parentId = tActivityInstInfo.getParentActInstId();
        if (StringUtils.isEmpty((String)parentId)) {
            return false;
        }
        List<ActivityInstInfo> groupList = this.actGroupMap.get(parentId);
        if (groupList == null) {
            groupList = new ArrayList<ActivityInstInfo>();
            groupList.add(tActivityInstInfo);
            this.actGroupMap.put(parentId, groupList);
        } else {
            groupList.add(tActivityInstInfo);
        }
        return true;
    }
}

