/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.enactment.WfDefinitionMgr;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IBackgroundService;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.store.util.JobServiceUtil;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BackgroundService
extends AbstractBOSObject
implements IBackgroundService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WBGS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.BackgroundService");

    public static IBackgroundService getService(Context ctx) {
        return new BackgroundService(ctx);
    }

    public BackgroundService(Context ctx) {
        super(ctx);
        this.registerInterface(IBackgroundService.class, (Object)this);
    }

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public String createJobProcessDef(String name, FunctionObjectInfo func, OperationInfo operation, Map jobContext, String scheduale, Locale locale) throws WfException {
        return this.createJobProcessDef(name, func, operation, jobContext, scheduale, locale, null);
    }

    public String createJobProcessDef(String name, FunctionObjectInfo func, OperationInfo operation, Map jobContext, String scheduale, Locale locale, String categoryId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:BackgroundService Method:createJobProcessDef been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: name=\"");
            buffer.append(name);
            buffer.append('\"');
            buffer.append(" func=");
            buffer.append(func);
            buffer.append(" opetation=");
            buffer.append(operation);
            buffer.append(" jobContext=");
            buffer.append(jobContext);
            buffer.append(" scheduale=\"");
            buffer.append(scheduale);
            buffer.append('\"');
            buffer.append(" locale=");
            buffer.append(name);
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        ProcessDef procDef = KpdlParser.createJobProcess((String)name, (FunctionObjectInfo)func, (OperationInfo)operation, (Map)jobContext, (String)scheduale, (Locale)locale);
        String jobDefId = null;
        try {
            JobDef def = JobServiceUtil.toJobDef((Context)this.getContext(), (ProcessDef)procDef);
            if (!StringUtils.isEmpty((String)categoryId)) {
                def.setCategoryId(categoryId);
            }
            Trigger tr = JobServiceUtil.toTrigger((JobDef)def, (ProcessDef)procDef);
            JobServiceFactory.getLocalInstance((Context)this.getContext()).createJobDef(def, tr, true);
            jobDefId = def.getDefId();
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
        return jobDefId;
    }

    public void removeJobProcessDef(String procDefId) throws WfException {
        try {
            JobServiceFactory.getLocalInstance((Context)this.getContext()).removeJobDef(procDefId);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    public String createJobProcessInst(String procDefId, Map jobContext, String initiatorId) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:BackgroundService Method:createJobProcessInst been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procDefId=\"");
            buffer.append(procDefId);
            buffer.append('\"');
            buffer.append(" jobContext=");
            buffer.append(jobContext);
            buffer.append(" initiatorId=\"");
            buffer.append(initiatorId);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        WfProcessMgr procMgr = EngineUtil.getEngine(this.getContext()).getProcessMgr(procDefId);
        Person person = EngineUtil.getEngine(this.getContext()).getPariticipantProvider().getPersonByUserId(this.getContext(), initiatorId);
        WfProcess procInst = procMgr.createProcess(null, person);
        procInst.getProcessContext().setDataFieldValues(jobContext);
        procInst.getProcessContext().storeToDb();
        WfDefinitionMgr defMgr = EngineUtil.getEngine(this.getContext()).getDefinitionMgr();
        defMgr.scheduleProcess(procInst.getDefinition(), procInst, true);
        return procInst.getId();
    }

    public ProcessDefInfo updateProcessSchedule(String procDefId, String scheduleXml) throws WfException {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Service:BackgroundService Method:updateProcessSchedule been called.");
            String desc = buffer.toString();
            buffer.append("Parameters: procDefId=\"");
            buffer.append(procDefId);
            buffer.append('\"');
            buffer.append(" scheduleXml=\"");
            buffer.append(scheduleXml);
            buffer.append('\"');
            this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
        }
        catch (Exception e) {
            log.warn((Object)"error", (Throwable)e);
        }
        String jobDefId = procDefId.substring(0, 36) + "BGJOBDEF";
        String sql = "select fid from t_job_trigger where fjobdefid='" + jobDefId + "'";
        String triggerId = null;
        try {
            triggerId = (String)SQL.getValue((String)this.getContext().getAIS(), (String)sql);
            if (triggerId == null) {
                throw new WfException("job def is not released or Backgroud Job Service is not upgraded!");
            }
            ScheduleDef schedule = new ScheduleDef(null, XmlUtil.stringToElement((String)scheduleXml));
            ScheduleType type = schedule.getType();
            String scheduleType = type != null ? type.toString() + ":" : "";
            String plan = scheduleType + schedule.getDefine();
            String userCalendar = schedule.isUseCalendar() ? "Y" : "N";
            sql = "update t_job_trigger set  fvalidateTime=getdate(), flasttriggeredtime=null, fholderid=null,ftriggeredCount=0, fisValid='Y', fid='" + Trigger.newId() + "', fusecalendar='" + userCalendar + "', fscheduleplan='" + plan + "' where fid='" + triggerId + "'";
            SQL.executeUpdate((Context)this.getContext(), (String)sql);
            String sql2 = "";
            sql2 = schedule.isUseCalendar() ? "update t_job_def set fproxyOrgID ='" + schedule.getOrgUnitId() + "' where fjobdefid='" + jobDefId + "'" : "update t_job_def set fproxyOrgID = null where fjobdefid='" + jobDefId + "'";
            SQL.executeUpdate((Context)this.getContext(), (String)sql2);
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
        ProcessDefInfo tmp = new ProcessDefInfo();
        tmp.setProcDefId(procDefId);
        return tmp;
    }

    public ProcessDef getProcessDef(String procDefId, boolean readOnly) throws WfException {
        if (procDefId == null || procDefId.length() <= 0) {
            String msg = "\"procDefId\" is empty!";
            throw new IllegalArgumentException(msg);
        }
        WfEngine engine = EngineUtil.getEngine(this.getContext());
        ProcessStorer processStorer = engine.getStoreManager().getProcessStorer();
        String kpdl = processStorer.getKpdlById(procDefId);
        if (kpdl != null && kpdl.trim().length() > 0) {
            return KpdlParser.parseKpdl((String)kpdl, (boolean)readOnly);
        }
        return null;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }
}

