/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.ProcessStartParam;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfDefinitionMgr;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.WfProcessMgr;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.core.thread.FlowAbort;
import com.kingdee.bos.workflow.engine.core.thread.FlowResume;
import com.kingdee.bos.workflow.engine.core.thread.FlowSuspend;
import com.kingdee.bos.workflow.metas.IOption;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.OptionFactory;
import com.kingdee.bos.workflow.metas.OptionInfo;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfEngineEventEnum;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.IDynamicWfService;
import com.kingdee.bos.workflow.service.IProcessControlService;
import com.kingdee.bos.workflow.service.IWfApplictionService;
import com.kingdee.bos.workflow.service.WfApplictionService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.ProcessStorer;
import com.kingdee.bos.workflow.util.UserTimeUtil;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.cbos.process.vm.runtime.Profile;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProcessControlService
extends AbstractBOSObject
implements IProcessControlService {
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFPOSCLS");
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.service.ProcessControlService");

    public static IProcessControlService getService(Context ctx) {
        return new ProcessControlService(ctx);
    }

    public ProcessControlService() {
        this.registerInterface(IProcessControlService.class, (Object)this);
    }

    public ProcessControlService(Context ctx) {
        super(ctx);
        this.registerInterface(IProcessControlService.class, (Object)this);
    }

    private WfLogger getWfLogger() throws WfException {
        return EngineUtil.getEngine(this.getContext()).getWfLogger();
    }

    public void startProcessInst(String procInstId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:startProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstId=\"");
                buffer.append(procInstId);
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        procInst.start();
    }

    public void startProcessInst(String procInstId, String firstActDefId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:startProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstId=\"");
                buffer.append(procInstId);
                buffer.append("\"");
                buffer.append(" firstActDefId=\"");
                buffer.append(firstActDefId);
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        procInst.start(firstActDefId);
    }

    public void startProcessInst(String procInstId, String firstActDefId, String firstActPerformerUserId) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:startProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstId=\"");
                buffer.append(procInstId);
                buffer.append("\"");
                buffer.append(" firstActDefId=\"");
                buffer.append(firstActDefId);
                buffer.append("\"");
                buffer.append(" firstActPerformerUserId=\"");
                buffer.append(firstActPerformerUserId);
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        procInst.start(firstActDefId, firstActPerformerUserId);
    }

    public ProcessInstInfo createProcessInst(String procDefId, String initiatorId, String initiatorName) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:createProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procDefId=\"");
                buffer.append(procDefId);
                buffer.append("\"");
                buffer.append(" initiatorId=\"");
                buffer.append(initiatorId);
                buffer.append("\"");
                buffer.append(" initiatorName=\"");
                buffer.append(initiatorName);
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcessMgr procMgr = wfEngine.getProcessMgr(procDefId);
        Person person = wfEngine.getPariticipantProvider().getPersonByUserId(this.getContext(), initiatorId);
        WfProcess procInst = procMgr.createProcess(null, person);
        return procInst.getData();
    }

    public ProcessInstInfo createProcessInstWithPersonID(String procDefId, String initiatorPersonID) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:createProcessInstWithPersonID been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procDefId=\"");
                buffer.append(procDefId);
                buffer.append("\"");
                buffer.append(" initiatorPersonID=\"");
                buffer.append(initiatorPersonID);
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcessMgr procMgr = wfEngine.getProcessMgr(procDefId);
        Person[] persons = wfEngine.getPariticipantProvider().getPersonByEmployeeId(this.getContext(), initiatorPersonID);
        if (persons == null || persons.length == 0) {
            throw new WfException("can not find person");
        }
        WfProcess procInst = procMgr.createProcess(null, persons[0]);
        return procInst.getData();
    }

    public ProcessInstInfo[] createProcessInsts(String procDefId, Map initiators) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:createProcessInsts been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procDefId=\"");
                buffer.append(procDefId);
                buffer.append("\"");
                buffer.append(" initiators=");
                buffer.append(initiators);
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (procDefId == null || procDefId.trim().length() == 0 || initiators == null) {
            throw new IllegalArgumentException();
        }
        ProcessInstInfo[] procInsts = new ProcessInstInfo[]{};
        Iterator it = initiators.entrySet().iterator();
        ArrayList<ProcessInstInfo> procInstList = new ArrayList<ProcessInstInfo>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            procInstList.add(this.createProcessInst(procDefId, entry.getKey().toString(), entry.getValue() == null ? "" : entry.getValue().toString()));
        }
        procInstList.toArray(procInsts);
        return procInsts;
    }

    public void suspendProcessInst(String procInstId) throws WfException {
        WfEngine wfEngine;
        WfProcess procInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.ERROR)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:suspendProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstId=\"");
                buffer.append(procInstId);
                buffer.append("\"");
                Throwable t = new Throwable();
                this.getWfLogger().addWfEngineLog(LogTypeEnum.ERROR, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString(), t);
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!(procInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getProcessInst(procInstId)).getProcessContext().isPvmMode()) {
            procInst.suspend("exec method 'EnactmentService.suspendProcessInst'");
        } else {
            FlowSuspend.enqueue(this.getContext(), procInstId, null);
        }
    }

    public void resumeProcessInst(String procInstId) throws WfException {
        WfEngine wfEngine;
        WfProcess procInst;
        IObjectPK logPk = WorkflowLogUtil.beginLogByLocal(this.getContext(), WorkflowLogItem.FLOW_CHART_UNSUSPEND, procInstId);
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:resumeProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstId=\"");
                buffer.append(procInstId);
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!(procInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getProcessInst(procInstId)).getProcessContext().isPvmMode()) {
            procInst.resume();
        } else {
            FlowResume.enqueue(this.getContext(), procInstId, null);
        }
        String descrip = "\u64a4\u9500\u6302\u8d77\u6d41\u7a0b";
        if (this.getContext().getLocale().getLanguage().equalsIgnoreCase("l1")) {
            descrip = " resume a process";
        } else if (this.getContext().getLocale().getLanguage().equalsIgnoreCase("l3")) {
            descrip = "\u64a4\u92b7\u639b\u8d77\u6d41\u7a0b";
        }
        this.saveOperation(null, null, OptionType.CANSUSPEND, null, null, null, null, null, "", descrip, procInstId);
        WorkflowLogUtil.endLogByLocal(this.getContext(), logPk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableTrace(String procInstId) throws Exception {
        Context ctx = this.getContext();
        String mutex = Mutex.getMutex(ctx, procInstId);
        Mutex.lock(ctx, mutex);
        try {
            WfEngine wfEngine = WfEngine.getEngine(ctx);
            WfProcess procInst = wfEngine.getProcessInst(procInstId);
            FlowContext runtime = procInst.getProcessContext().loadFlowContext();
            runtime.setProfile(Profile.PERFORMANCE);
            procInst.getProcessContext().setFlowContext(runtime);
        }
        finally {
            Mutex.unlock(ctx, mutex);
        }
    }

    public void abortProcessInst(String procInstId) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcess procInst = wfEngine.getProcessInst(procInstId);
        if (procInst.state().startsWith("closed")) {
            return;
        }
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.ERROR)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:abortProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstId=\"");
                buffer.append(procInstId);
                buffer.append("\"");
                Throwable t = new Throwable();
                this.getWfLogger().addWfEngineLog(LogTypeEnum.ERROR, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString(), t);
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!procInst.getProcessContext().isPvmMode()) {
            procInst.abort("exec method 'EnactmentService.abortProcessInst'");
        } else {
            FlowContext runtime = procInst.getProcessContext().loadFlowContext();
            Util.setAborted(runtime);
            procInst.getProcessContext().setFlowContext(runtime);
            FlowAbort.enqueue(this.getContext(), procInst.getId(), null);
        }
    }

    public void terminateProcessInst(String procInstId) throws WfException {
        WfEngine wfEngine;
        WfProcess procInst;
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:terminateProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstId=\"");
                buffer.append(procInstId);
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        if (!(procInst = (wfEngine = EngineUtil.getEngine(this.getContext())).getProcessInst(procInstId)).getProcessContext().isPvmMode()) {
            procInst.terminate();
        } else {
            FlowAbort.enqueue(this.getContext(), procInst.getId(), null);
        }
    }

    public void batchTerminate(String[] procInstIds) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:batchTerminate been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstIds=\"");
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    buffer.append(procInstIds[i]).append("\n");
                }
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        int size = procInstIds.length;
        for (int i = 0; i < size; ++i) {
            WfProcess wfProcess = WfEngine.getEngine(this.getContext()).getProcessInst(procInstIds[i]);
            if (wfProcess.isClosed()) continue;
            wfProcess.terminate();
        }
    }

    public void batchPhysicsDelete(String[] procInstIds) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:batchPhysicsDelete been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procInstIds=\"");
                int n = procInstIds.length;
                for (int i = 0; i < n; ++i) {
                    buffer.append(procInstIds[i]).append("\n");
                }
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        wfEngine.batchPhysicsDelete(procInstIds);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public void deleteProcessInst(String processInstId) throws WfException, SQLException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.ERROR)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:terminateProcessInst been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: processInstId=\"");
                buffer.append(processInstId);
                buffer.append("\"");
                Throwable t = new Throwable();
                this.getWfLogger().addWfEngineLog(LogTypeEnum.ERROR, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString(), t);
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        EngineUtil.getEngine(this.getContext()).deleteProcInst(processInstId);
    }

    public ProcessInstInfo createProcessInst(String procDefId, Person person) throws WfException {
        if (!this.getWfLogger().checkLogLevel(LogTypeEnum.INFO)) {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Service:ProcessControlService Method:createProcessInstWithPersonID been called.");
                String desc = buffer.toString();
                buffer.append("Parameters: procDefId=\"");
                buffer.append(procDefId);
                buffer.append("\"");
                buffer.append(" initiatorPersonID=\"");
                buffer.append(person.getEmployeeId());
                buffer.append("\"");
                this.getWfLogger().addWfEngineLog(LogTypeEnum.INFO, WfEngineEventEnum.CONTROLSERVICE, desc, buffer.toString());
            }
            catch (Exception e) {
                log.warn((Object)"error", (Throwable)e);
            }
        }
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcessMgr procMgr = wfEngine.getProcessMgr(procDefId);
        WfProcess procInst = procMgr.createProcess(null, person);
        return procInst.getData();
    }

    public List clearProcessInst(String processDefId) throws WfException {
        WfEngine engine = EngineUtil.getEngine(this.getContext());
        ProcessStorer processStorer = engine.getStoreManager().getProcessStorer();
        List processInstIdList = this.terminateProcessInstByDef(processDefId);
        if (processInstIdList == null || processInstIdList.size() == 0) {
            return processInstIdList;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = processInstIdList.iterator();
        while (iterator.hasNext()) {
            String processInstId = "";
            try {
                processInstId = (String)iterator.next();
                processStorer.deleteProcessInst(processDefId, processInstId);
                result.add(processInstId);
            }
            catch (Exception e) {
                String message = "Current \"processInstId\" is " + processInstId;
                log.warn((Object)message, (Throwable)e);
            }
        }
        return result;
    }

    public List terminateProcessInstByDef(String processDefId) throws WfException {
        if (StringUtils.isEmpty((String)processDefId)) {
            String message = "\"processDefId\" is null!";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        WfEngine engine = this.getWfEngine();
        ProcessInstInfo[] processInstInfoArray = engine.getProcessInstancesByProcDefId(processDefId);
        if (processInstInfoArray == null || processInstInfoArray.length <= 0) {
            return new ArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i <= processInstInfoArray.length - 1; ++i) {
            ProcessInstInfo processInstInfo = null;
            String processInstId = "";
            try {
                processInstInfo = processInstInfoArray[i];
                if (processInstInfo.getState().startsWith("closed")) continue;
                processInstId = processInstInfo.getProcInstId();
                this.terminateProcessInst(processInstId);
                result.add(processInstId);
                continue;
            }
            catch (Exception e) {
                String message = "Current \"processInstId\" is " + processInstId;
                log.warn((Object)message, (Throwable)e);
            }
        }
        return result;
    }

    private WfEngine getWfEngine() throws WfException {
        WfEngine engine = EngineUtil.getEngine(this.getContext());
        if (engine == null) {
            String message = "\"engine\" is null!";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        return engine;
    }

    public void abortProcessByHoldedObjectId(String bizObjId) throws WfException {
        WfEngine engine = this.getWfEngine();
        ProcessInstInfo[] procInstInfoArray = engine.getProcessInstanceByHoldedObjectId(bizObjId);
        for (int i = 0; i < procInstInfoArray.length; ++i) {
            ProcessInstInfo p = procInstInfoArray[i];
            if (!StringUtils.isEmpty((String)p.getParentProcInstId())) continue;
            String procInstId = p.getProcInstId();
            this.abortProcessInst(procInstId);
        }
    }

    public String[] createAndStartProcesses(ProcessStartParam[] startParams) throws WfException {
        assert (startParams != null);
        ArrayList<String> processIDs = new ArrayList<String>();
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        WfProcessMgr procMgr = null;
        int size = startParams.length;
        for (int i = 0; i < size; ++i) {
            String processDefID = startParams[i].getProcessDefID();
            String initiatorID = startParams[i].getInitiatorID();
            Map processStartContext = startParams[i].getProcessStartContext();
            procMgr = wfEngine.getProcessMgr(processDefID);
            Person person = wfEngine.getPariticipantProvider().getPersonByUserId(this.getContext(), initiatorID);
            WfProcess procInst = procMgr.createProcess(null, person);
            ProcessContext procCtx = procInst.getProcessContext();
            procCtx.setDataFieldValues(processStartContext);
            procCtx.storeToDb();
            procInst.start();
            processIDs.add(procInst.getId());
        }
        return processIDs.toArray(new String[processIDs.size()]);
    }

    public BOSObjectType[] getRelatedEntityTypes(String procdefID) throws WfException {
        WfEngine wfEngine = EngineUtil.getEngine(this.getContext());
        BOSObjectType[] bosTypeArray = wfEngine.getCacheManager().getRelatedEntityTypes(procdefID);
        return bosTypeArray;
    }

    public ProcessInstInfo[] getAllProcessInstancesByBizobjId(String bizObjID) throws WfException {
        if (StringUtils.isEmpty((String)bizObjID)) {
            throw new WfException("EnactmentServices.getAllProcessInstancesByBizobjId args bizObjID can't be null");
        }
        return this.getWfEngine().getAllProcessInstancesByBizobjId(bizObjID);
    }

    public String getBizObjIdByProcessInstanceId(String instId) throws WfException {
        if (StringUtils.isEmpty((String)instId)) {
            throw new WfException("EnactmentServices.getBizObjIdByProcessInstanceId args instId can't be null");
        }
        return this.getWfEngine().getBizObjIdByProcessInstanceId(instId);
    }

    public ArrayList getProcessNamesByUserNumber(String userNumber) throws WfException {
        if (StringUtils.isEmpty((String)userNumber)) {
            throw new WfException("EnactmentServices.getProcessNamesByUserNumber args userNumber can't be null");
        }
        return this.getWfEngine().getProcessNamesByUserNumber(userNumber);
    }

    public String getUserNumberByUserId(String id) throws WfException {
        if (StringUtils.isEmpty((String)id)) {
            throw new WfException("EnactmentServices.getUserNumberByUserId args id can't be null");
        }
        return this.getWfEngine().getUserNumberByUserId(id);
    }

    public void processEmpowerment(ArrayList processes, ArrayList owners) throws WfException {
        if (processes == null || owners == null) {
            throw new WfException("EnactmentServices.processEmpowerment processes or  owners can't be null");
        }
        this.getWfEngine().processEmpowerment(processes, owners);
    }

    public ArrayList getOpenedActivityByProcInstId(String procInstId) throws WfException {
        if (StringUtils.isEmpty((String)procInstId)) {
            throw new WfException("EnactmentServices.getOpenedActivityByProcInstId args procInstId can't be null");
        }
        return this.getWfEngine().getOpenedActivityByProcInstId(procInstId);
    }

    public ArrayList getProcessOwnersByProcessName(String processName) throws WfException {
        if (StringUtils.isEmpty((String)processName)) {
            throw new WfException("EnactmentServices.getProcessOwnersByProcessName args processName can't be null");
        }
        return this.getWfEngine().getProcessOwnersByProcessName(processName);
    }

    public void deleteProcessOwnersByUserId(String processName, ArrayList ownerIds) throws WfException {
        if (ownerIds == null) {
            throw new WfException("EnactmentServices.deleteProcessOwnersByUserId args ownerIds can't be null");
        }
        this.getWfEngine().deleteProcessOwnersByUserId(processName, ownerIds);
    }

    public List getRelatedEntityTypes(String[] procdefIDs) throws WfException {
        ArrayList<BOSObjectType[]> retVal = new ArrayList<BOSObjectType[]>();
        int size = procdefIDs.length;
        for (int i = 0; i < size; ++i) {
            try {
                retVal.add(this.getRelatedEntityTypes(procdefIDs[i]));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("ProcessControlService.getRelatedEntityTypes{" + procdefIDs[i] + "} failed!"), (Throwable)e);
            }
        }
        return retVal;
    }

    public String createAndCompleteFiristActivity(String processDefId, Map invokeContext) throws WfException {
        try {
            Context context = this.getContext();
            WfEngine engine = WfEngine.getEngine(this.getContext());
            WfProcessMgr procMgr = engine.getProcessMgr(processDefId);
            String userId = context.getCaller().toString();
            Person person = engine.getPariticipantProvider().getPersonByUserId(context, userId);
            if (person == null) {
                person = new Person();
                person.setUserId(userId);
                person.setUserName(new Locale("L2"), context.getUserName());
            }
            WfProcess wfProcess = procMgr.createProcess(null, person);
            wfProcess.startAndCompleteFirstActivity(invokeContext);
            procMgr.processProcessTopic(wfProcess);
            return wfProcess.getId();
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    public String createAndCompleteFiristActivity(String processDefId, Map invokeContext, String userId, Map boMap) throws WfException {
        try {
            Context context = this.getContext();
            WfEngine engine = WfEngine.getEngine(this.getContext());
            WfProcessMgr procMgr = engine.getProcessMgr(processDefId);
            Person person = engine.getPariticipantProvider().getPersonByUserId(context, userId);
            WfProcess wfProcess = procMgr.createProcess(null, person);
            wfProcess.getProcessContext().putDataFieldValues(invokeContext);
            wfProcess.getProcessContext().storeToDb();
            wfProcess.startAndCommitFirstActivity(boMap, userId, context, person);
            try {
                String billId = (String)invokeContext.get("billidString");
                if (!StringUtils.isEmpty((String)billId)) {
                    IObjectValue boValue = this.getBizObject(billId);
                    ProcInstInfo procInstInfo = wfProcess.getProcessMeta().getMeta();
                    procInstInfo.setControlUnitID(((CtrlUnitInfo)boValue.get("cu")).getId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e.getMessage());
            }
            procMgr.processProcessTopic(wfProcess);
            return wfProcess.getId();
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue getBizObject(String boID) throws SQLException, DataAccessException {
        IObjectValue iObjectValue;
        Connection cn = null;
        try {
            BOSUuid boUuid = BOSUuid.read((String)boID);
            cn = EJBFactory.getConnection((Context)this.getContext());
            iObjectValue = ORMappingDAO.getInstance((BOSObjectType)boUuid.getType(), (Context)this.getContext(), (Connection)cn).getValue((IObjectPK)new ObjectUuidPK(boUuid));
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)cn);
        return iObjectValue;
    }

    public String createAndCompleteFiristActivity(String processDefId, Map invokeContext, String userId) throws WfException {
        try {
            Context context = this.getContext();
            WfEngine engine = WfEngine.getEngine(this.getContext());
            WfProcessMgr procMgr = engine.getProcessMgr(processDefId);
            Person person = engine.getPariticipantProvider().getPersonByUserId(context, userId);
            WfProcess wfProcess = procMgr.createProcess(null, person);
            wfProcess.startAndCompleteFirstActivity(invokeContext);
            procMgr.processProcessTopic(wfProcess);
            return wfProcess.getId();
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    public boolean selectProcessRecordForduplicateCommit(String bizObjID) throws WfException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendActivity(AssignmentInfo assign, IDynamicWfService.DynamicActivityDef[] actDefs, boolean isPriorAppend, boolean isSequencial, boolean abortCurrentActivity) throws Exception {
        String mutex = Mutex.getMutex(this.getContext(), assign.getProcInstId());
        Mutex.lock(this.getContext(), mutex);
        try {
            this.innerAppendActivities(assign, actDefs, isPriorAppend, isSequencial, abortCurrentActivity);
        }
        finally {
            Mutex.unlock(this.getContext(), mutex);
        }
    }

    private void innerAppendActivities(AssignmentInfo assign, IDynamicWfService.DynamicActivityDef[] actDefs, boolean isPriorAppend, boolean isSequencial, boolean abortCurrentActivity) throws WfException, BOSException, Exception {
        WfEngine engine = WfEngine.getEngine(this.getContext());
        WfProcess process = engine.getProcessInst(assign.getProcInstId());
        FlowContext runtime = process.getProcessContext().loadFlowContext();
        Node[] nodes = new Node[actDefs.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = runtime.getFlow().getNode(assign.getActDefId());
        }
        Execution container = runtime.getExecution(assign.getActInstId());
        Execution[] appended = runtime.getService().append(container.getId(), isSequencial, isPriorAppend, nodes);
        String uuid = UserTimeUtil.encode(assign.getUserId(), new Date());
        String locale = this.getContext().getLocale().getLanguage();
        String result1 = "\u524d\u7f6e\u4e32\u884c\u52a0\u7b7e";
        String result2 = "\u524d\u7f6e\u5e76\u884c\u52a0\u7b7e";
        String result3 = "\u540e\u7f6e\u4e32\u884c\u52a0\u7b7e";
        String result4 = "\u540e\u7f6e\u5e76\u884c\u52a0\u7b7e";
        String to = "\u7ed9";
        if ("l1".equals(locale)) {
            result1 = " prepose-countersign serial ";
            result2 = " prepose-countersign parallel ";
            result3 = " post-countersign serial ";
            result4 = " post-countersign parallel ";
            to = " to ";
        } else if ("l3".equals(locale)) {
            result1 = "\u524d\u7f6e\u4e32\u884c\u52a0\u7c3d";
            result2 = "\u524d\u7f6e\u4e26\u884c\u52a0\u7c3d";
            result3 = "\u5f8c\u7f6e\u4e32\u884c\u52a0\u7c3d";
            result4 = "\u5f8c\u7f6e\u4e26\u884c\u52a0\u7c3d";
            to = "\u7d66";
        }
        for (int i = 0; i < actDefs.length; ++i) {
            Execution e = appended[i];
            String actinstid = appended[i].getId();
            String result = "";
            result = isPriorAppend ? (isSequencial ? result1 : result2) : (isSequencial ? result3 : result4);
            String userName = "";
            String personId = "";
            IDynamicWfService.Performer[] performers = actDefs[i].performers;
            for (int j = 0; j < performers.length; ++j) {
                personId = performers[j].personId;
                IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.getContext());
                userName = j == 0 ? svc.getPersonByPersonID(personId)[0].getUserName(this.getContext().getLocale()) : userName + ";" + svc.getPersonByPersonID(personId)[0].getUserName(this.getContext().getLocale());
            }
            result = result + to + userName;
            this.saveOperation(actDefs[i].option, assign.getBizObjectIds(), OptionType.appendActivity, null, personId, assign.getAssignmentId(), null, assign.getActInstId(), actinstid, result, assign.getProcInstId());
            this.setExtendedAttributes(actDefs, i, e);
            Set personIds = this.getPersonIds(actDefs, i);
            Util.setAppended(e, uuid);
            Util.setParticipants(e, personIds);
            Util.setMessageTitle(e, actDefs[i].message);
        }
        if (appended.length > actDefs.length) {
            Execution e = appended[actDefs.length];
            HashSet<String> personIds = new HashSet<String>();
            WfActivity act = Util.getWfActivity(container);
            for (WfAssignment assignment : act.assignments()) {
                if (assignment.state() != WfAssignmentState.ACCEPTED && assignment.state() != WfAssignmentState.ASSIGNED && assignment.state() != WfAssignmentState.NOT_ASSIGNED) continue;
                AssignmentInfo assignInfo = assignment.getMeta();
                String empId = assignInfo.getEmployeeId();
                if (StringUtils.isEmpty((String)empId)) {
                    personIds.add(assignInfo.getUserId());
                    continue;
                }
                personIds.add(empId);
            }
            if (Util.isAppended(container)) {
                e.setProperty("actDefName", assign.getActDefName(this.getContext().getLocale()));
            }
            Util.setAppended(e, uuid);
            Util.setParticipants(e, personIds);
        }
        if (abortCurrentActivity || isPriorAppend) {
            WfAssignment ass = engine.getAssignment(assign.getAssignmentId());
            ass.setState(WfAssignmentState.CANCELED);
            WfActivity act = Util.getWfActivity(container);
            act.cancelUncompleteAssignments();
            Execution current = runtime.getExecution(act.getId());
            if (current.isBeforePartiallyCompleted()) {
                runtime.signal(act.getId());
            }
            runtime.signal(act.getId());
        } else {
            runtime.resume();
        }
        String key = assign.getActDefId() + "#RETURN_TARGET";
        String targetActDefId = (String)runtime.getProperty(key);
        if (targetActDefId != null && targetActDefId.length() > 0) {
            runtime.setProperty(key, "");
        }
        process.getProcessContext().setFlowContext(runtime);
    }

    public void saveOperation(String option, String billId, OptionType type, String personId, String nextPersonid, String assignId, String nextAssignId, String actinstId, String nextActinstId, String result, String procinstId) {
        try {
            IOption Wfoption = OptionFactory.getLocalInstance((Context)this.getContext());
            OptionInfo opinfo = new OptionInfo();
            opinfo.setOption(option);
            if (!StringUtils.isEmpty((String)billId)) {
                opinfo.setBillID(BOSUuid.read((String)billId));
            }
            opinfo.setType(type);
            if (!StringUtils.isEmpty((String)personId)) {
                opinfo.setPersonID(BOSUuid.read((String)personId));
            }
            if (!StringUtils.isEmpty((String)nextPersonid)) {
                opinfo.setNextHandlerPersonID(nextPersonid);
            }
            if (!StringUtils.isEmpty((String)assignId)) {
                opinfo.setAssignmentID(BOSUuid.read((String)assignId));
            }
            if (!StringUtils.isEmpty((String)nextAssignId)) {
                opinfo.setNextAssignid(BOSUuid.read((String)nextAssignId));
            }
            if (!StringUtils.isEmpty((String)actinstId)) {
                opinfo.setCurrentAcinstID(BOSUuid.read((String)actinstId));
            }
            if (!StringUtils.isEmpty((String)nextActinstId)) {
                opinfo.setActinstID(BOSUuid.read((String)nextActinstId));
            }
            if (result.length() > 250) {
                opinfo.setResult(result.substring(0, 500));
            } else {
                opinfo.setResult(result);
            }
            if (!StringUtils.isEmpty((String)procinstId)) {
                opinfo.setProcinstID(BOSUuid.read((String)procinstId));
            }
            Wfoption.addnew(opinfo);
        }
        catch (Exception e) {
            log.error((Object)" add option error", (Throwable)e);
        }
    }

    private void setExtendedAttributes(IDynamicWfService.DynamicActivityDef[] actDefs, int i, Execution e) {
        IDynamicWfService.DynamicActivityDef def = actDefs[i];
        e.setProperty("attachMode", def.attachmentMode);
        e.setProperty("appendActivity", String.valueOf(def.allowAppend));
        e.setProperty("jumpTo", String.valueOf(Boolean.FALSE));
        e.setProperty("kickBack", String.valueOf(Boolean.FALSE));
        e.setProperty("assignnextparticipantActivity", String.valueOf(def.allowSubmitNextPerformer));
        e.setProperty("sendMail", String.valueOf(def.isSendMail));
        e.setProperty("sendSMS", String.valueOf(def.isSendSMS));
        String result = "[\u52a0\u7b7e]";
        String locale = this.getContext().getLocale().getLanguage();
        if ("l1".equals(locale)) {
            result = "[Countersign]";
        } else if ("l3".equals(locale)) {
            result = "[\u52a0\u7c3d]";
        }
        e.setProperty("actDefName", result + actDefs[i].actName);
    }

    public Map getExtendedAttributesFromActivityInst(String actInstId) throws WfException {
        String key;
        FlowContext runtime;
        String targetActDefId;
        WfEngine engine = WfEngine.getEngine(this.getContext());
        ActivityInstInfo aii = engine.getActivityInst(actInstId).getMeta();
        String hash = aii.getProcDefHashValue();
        WfDefinitionMgr defMgr = engine.getDefinitionMgr();
        ProcessDef procDef = defMgr.getProcessDefByHash(hash);
        if (procDef == null) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49(" + hash + ")\u4e0d\u5b58\u5728!");
        }
        ActivityDef adf = procDef.getActivityDef(aii.getActDefId());
        IWfApplictionService svc = WfApplictionService.getService(this.getContext());
        Map extAttr = svc.getExtendedAttributeFromActDef(adf);
        if (aii.getParentActInstId() != null && !aii.getState().equals(WfState.COMPLETED.getValue())) {
            Map dynamic = svc.getDynamicExendedProperties(aii.getActInstId(), aii.getProcInstId());
            extAttr.putAll(dynamic);
        }
        if (!StringUtils.isEmpty((String)(targetActDefId = (String)(runtime = engine.getProcessInst(aii.getProcInstId()).getProcessContext().getFlowContext()).getProperty(key = adf.getID() + "#RETURN_TARGET")))) {
            extAttr.put("appendActivity", "false");
        }
        return extAttr;
    }

    private Set getPersonIds(IDynamicWfService.DynamicActivityDef[] actDefs, int i) {
        HashSet<String> personIds = new HashSet<String>();
        IDynamicWfService.Performer[] performers = actDefs[i].performers;
        for (int j = 0; j < performers.length; ++j) {
            personIds.add(performers[j].personId);
        }
        return personIds;
    }
}

