/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service.ormrpc;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IWfFacade;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import com.kingdee.bos.workflow.service.ormrpc.struct.WfProcessImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class WfFacade
extends AbstractBOSObject
implements IWfFacade {
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"WFFACADE");

    public IProcessImage getProcessImage(Locale locale, String id) throws BOSException {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.getContext());
        String procInstId = null;
        if (id.endsWith("WFWKITEM")) {
            AssignmentInfo info = svc.getAssignmentById(id);
            procInstId = info.getProcInstId();
        } else if (id.endsWith("WFPCINST")) {
            procInstId = id;
        } else if (!id.endsWith("WFPRCDEF")) {
            throw new BOSException("{" + id + "} is an invalid id, has no process image!");
        }
        if (procInstId == null) {
            ProcessDef processDef = null;
            ProcessDefInfo defInfo = svc.getProcessDefInfo(id);
            if (defInfo == null) {
                throw new BOSException("WfFacade getProcessImage get processDef error");
            }
            String hash = defInfo.getMd5HashValue();
            processDef = svc.getProcessDefByDefineHashValue(hash);
            return new WfProcessImage(locale, processDef);
        }
        ProcessInstInfo procInstInfo = svc.getProcessInstInfo(procInstId);
        ProcessDef processDef = svc.getProcessDefByDefineHashValue(procInstInfo.getProcDefHashValue());
        ActivityInstInfo[] actInstInfos = svc.getActInstMetaArrayByProcInstId(procInstId);
        actInstInfos = this.sortActs(actInstInfos);
        return new WfProcessImage(locale, processDef, actInstInfos, procInstInfo);
    }

    private ActivityInstInfo[] sortActs(ActivityInstInfo[] actInstInfos) {
        ArrayList<Object> actInstInfoList = new ArrayList<Object>();
        ArrayList<ActivityInstInfo> actInstInfoNotInitList = new ArrayList<ActivityInstInfo>();
        boolean hasNotInit = false;
        for (int i = 0; i < actInstInfos.length; ++i) {
            if (!actInstInfos[i].getInited()) {
                hasNotInit = true;
                actInstInfoNotInitList.add(actInstInfos[i]);
                continue;
            }
            actInstInfoList.add(actInstInfos[i]);
        }
        if (hasNotInit) {
            actInstInfoList.addAll(actInstInfoNotInitList);
            actInstInfos = actInstInfoList.toArray(new ActivityInstInfo[0]);
        }
        return actInstInfos;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public WfFacade() throws BOSException {
        super.registerInterface(IWfFacade.class, (Object)this);
    }

    public WfFacade(Context ctx) throws BOSException {
        super(ctx);
        super.registerInterface(IWfFacade.class, (Object)this);
    }

    public Map getProcessDataFieldsType(String procHashValue) throws BOSException {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.getContext());
        ProcessDef processDef = svc.getProcessDefByDefineHashValue(procHashValue);
        DataFieldCollection fields = processDef.getDataFields();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < fields.size(); ++i) {
            DataFieldDef f = fields.get(i);
            DataType type = f.getDataType();
            map.put(f.getName(), type == null ? "" : type.toString());
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set getPerformerUserIds(String actInstId) throws BOSException {
        Context ctx = this.getContext();
        IEnactmentService esc = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo[] assignments = esc.getAssignmentByActInstId(actInstId);
        HashSet<String> userids = new HashSet<String>();
        if (assignments == null || assignments.length == 0) {
            ActivityInstInfo actInst = esc.getActivityInstByActInstId(actInstId);
            ProcessDef processDef = esc.getProcessDefByDefineHashValue(actInst.getProcDefHashValue());
            ActivityDef actDef = processDef.getActivityDef(actInst.getActDefId());
            ActivityCollection acts = actDef.getPreviousActivities();
            boolean isFirst = false;
            for (int i = 0; i < acts.size(); ++i) {
                if (!(acts.get(i) instanceof StartActivityDef)) continue;
                isFirst = true;
            }
            if (!isFirst) return null;
            ProcessInstInfo procInstInfo = esc.getProcessInstInfo(actInst.getProcInstId());
            if (procInstInfo.getParentProcInstId() != null) {
                return null;
            }
            String initiator = procInstInfo.getInitiatorId();
            userids.add(initiator);
            return userids;
        } else {
            for (int i = 0; i < assignments.length; ++i) {
                String userid = assignments[i].getUserId();
                userids.add(userid);
            }
        }
        return userids;
    }

    public boolean isMustShowPostActivityPerformers(String actDefId, String procMd5Hash) throws BOSException {
        Context ctx = this.getContext();
        IEnactmentService esc = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessDef def = esc.getProcessDefByDefineHashValue(procMd5Hash);
        ActivityDef act = def.getActivityDef(actDefId);
        if (!(act instanceof ManpowerActivityDef)) {
            return false;
        }
        ManpowerActivityDef man = (ManpowerActivityDef)act;
        return man.isMustShowParticipantsCheckList();
    }

    public boolean isShowAllEmptyPostActivityPerformers(String actDefId, String procMd5Hash) throws BOSException {
        Context ctx = this.getContext();
        IEnactmentService esc = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessDef def = esc.getProcessDefByDefineHashValue(procMd5Hash);
        ActivityDef act = def.getActivityDef(actDefId);
        if (!(act instanceof ManpowerActivityDef)) {
            return false;
        }
        ManpowerActivityDef man = (ManpowerActivityDef)act;
        return man.isShowAllEmptyManpowerActivites();
    }
}

