/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.store.ActivityStorer;
import com.kingdee.bos.workflow.store.listener.AbstractDataProvider;
import com.kingdee.bos.workflow.store.util.StoreUtil;
import com.kingdee.bos.workflow.transaction.IBatchPersistence;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class ActivityBatchPersistence
extends AbstractDataProvider
implements IBatchPersistence {
    private static final Logger logger = Logger.getLogger(ActivityBatchPersistence.class);
    private static final BOSObjectType bosObjectType = new ActInstInfo().getBOSType();

    public ActivityBatchPersistence(Context ctx) {
        super(ctx);
    }

    @Override
    public void executeBatch(List newObjects, List changedObjects) throws WfException {
        LowTimer lowTimer = new LowTimer();
        Connection cn = null;
        try {
            if (newObjects != null && !newObjects.isEmpty()) {
                ActivityStorer activityStorer = WfEngine.getEngine(this.innerContext).getStoreManager().getActivityStorer();
                activityStorer.addNewBatch(newObjects);
            }
            if (changedObjects != null && changedObjects.size() > 0) {
                cn = this.getConnection();
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)bosObjectType, (Context)this.innerContext, (Connection)cn);
                int size = changedObjects.size();
                for (int i = 0; i < size; ++i) {
                    IObjectValue objectValue = (IObjectValue)changedObjects.get(i);
                    ObjectUuidPK pk = new ObjectUuidPK(objectValue.getBOSUuid(objectValue.getPKField()));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("ActivityBatchPersistence executeBatch changedObjects(" + (i + 1) + "/" + size + "): id:" + pk));
                    }
                    dao.updateBatch((IObjectPK)pk, objectValue);
                }
                dao.executeBatch();
                if (this.isEnableListen()) {
                    ProcessDef def = null;
                    if (changedObjects != null && changedObjects.size() > 0) {
                        ActInstInfo info = (ActInstInfo)changedObjects.get(0);
                        String actInstId = info.getActInstID().toString();
                        def = StoreUtil.getProcessDefByActInstID(actInstId, this.innerContext);
                        this.setDataChanged(StoreUtil.generateTransDataByProcessDef(this, this.getContext(), "executeBatch", new Class[]{List.class, List.class}, new Object[]{null, changedObjects}, def));
                    }
                }
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(cn);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ActivityBatchPersistence.executeBatch cost:" + lowTimer.msValue()));
        }
    }

    @Override
    public BOSObjectType getBOSObjectType() {
        return bosObjectType;
    }
}

