/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.CorrelationMatchCollection;
import com.kingdee.bos.workflow.metas.CorrelationMatchFactory;
import com.kingdee.bos.workflow.metas.CorrelationMatchInfo;
import com.kingdee.bos.workflow.metas.ICorrelationMatch;
import com.kingdee.bos.workflow.store.AbstractBaseStorer;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class CorrelationMatchStorer
extends AbstractBaseStorer {
    private static final Logger logger = Logger.getLogger(CorrelationMatchStorer.class);

    CorrelationMatchStorer(Context context) {
        super(context);
    }

    public void deleteCorrelationMatchesByProcInstId(String procInstId) throws WfException {
        try {
            ICorrelationMatch correlationMatch = CorrelationMatchFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE procInstId = '" + procInstId + "' ";
            correlationMatch.delete(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public void deleteCorrelationMatchesByActInstId(String actInstId) throws WfException {
        try {
            ICorrelationMatch correlationMatch = CorrelationMatchFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE actInstId = '" + actInstId + "' ";
            correlationMatch.delete(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public void deleteCorrelationMatchesByProcDefHash(String procDefHash) throws WfException {
        try {
            ICorrelationMatch correlationMatch = CorrelationMatchFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE procDefHash = '" + procDefHash + "' ";
            correlationMatch.delete(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public void deleteProcessCorrelationesMatchByProcDefId(String procDefId) throws WfException {
        try {
            ICorrelationMatch correlationMatch = CorrelationMatchFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE procDefId = '" + procDefId + "' AND type = " + 10;
            correlationMatch.delete(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public CorrelationMatchInfo getCorrelationMatchInfo(String procDefHash, String actDefId) throws WfException {
        try {
            ICorrelationMatch correlationMatch = CorrelationMatchFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE procDefHash =  '" + procDefHash + "' AND actDefId = '" + actDefId + "' ";
            return correlationMatch.getValue(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public Set getMatchedProcDefIds() throws WfException {
        HashSet<String> hashSet;
        HashSet<String> retVal = new HashSet<String>();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection();
            ps = cn.prepareStatement("SELECT DISTINCT FProcDefId FROM T_WFR_CorrelationMatch");
            rs = ps.executeQuery();
            while (rs.next()) {
                retVal.add(rs.getString("FProcDefId"));
            }
            hashSet = retVal;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return hashSet;
    }

    public boolean exist(String actInstId) throws WfException {
        try {
            ICorrelationMatch correlationMatch = CorrelationMatchFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE actInstId =  '" + actInstId + "' ";
            return correlationMatch.exists(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public void addCorrelationMatch(CorrelationMatchInfo correlationMatchInfo) throws WfException {
        try {
            ICorrelationMatch correlationMatch = CorrelationMatchFactory.getLocalInstance((Context)this.getContext());
            correlationMatch.addnew((IObjectPK)new ObjectUuidPK(correlationMatchInfo.getId()), correlationMatchInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }

    public void addCorrelationMatches(CorrelationMatchCollection correlationSetCollection) throws WfException {
        Connection cn = null;
        try {
            cn = this.getConnection();
            IORMappingDAO ormdao = this.getDAO(WfBOSObjectTypeUtil.CORRELATIONMATCH, cn);
            int size = correlationSetCollection.size();
            for (int i = 0; i < size; ++i) {
                ormdao.addNewBatch((IObjectValue)correlationSetCollection.get(i));
            }
            ormdao.executeBatch();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        catch (DataAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        finally {
            this.cleanup(cn);
        }
    }

    public CorrelationMatchCollection findCorrelationMatches(String requestKey) throws WfException {
        try {
            ICorrelationMatch correlationMatch = CorrelationMatchFactory.getLocalInstance((Context)this.getContext());
            String oql = "WHERE requestKey = '" + requestKey + "' ORDER BY type ASC";
            return correlationMatch.getCollection(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
    }
}

