/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.timeliness;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.AutoApproveDef;
import com.kingdee.bos.workflow.define.DeadlineCollection;
import com.kingdee.bos.workflow.define.DeadlineDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ScriptDef;
import com.kingdee.bos.workflow.define.WfPriority;
import com.kingdee.bos.workflow.enactment.ParticipantHelper;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.message.WfMessageUtil;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.engine.core.Mutex;
import com.kingdee.bos.workflow.engine.core.thread.JobDispatcher;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.event.WfEvent;
import com.kingdee.bos.workflow.event.WfEventType;
import com.kingdee.bos.workflow.event.WfSendNotificationAction;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.transaction.WfTxHelper;
import com.kingdee.bos.workflow.transaction.WfTxInvocationDesc;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.bos.workflow.util.MethodDesc;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.eas.base.multiapprove.app.DeadLineAutoApprove;
import com.kingdee.exception.ExceptionMessage;
import com.kingdee.exception.ExceptionUtil;
import com.kingdee.exception.IExceptionInfoSupport;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DeadlineWaiterJob
implements Job {
    public static final String DATAMAP_NAME_DEADLINE_INDEX = "Deadline_Index";
    public static final String DATAMAP_NAME_ENGINE_NAME = "Engine_Name";
    public static final String DATAMAP_NAME_ACTINST_ID = "ActInst_Id";
    private static Logger log = Logger.getLogger((String)DeadlineWaiterJob.class.getName());
    private static final Locale L1 = new Locale("l1");
    private static final Locale L2 = new Locale("l2");
    private static final Locale L3 = new Locale("l3");

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap dataMap = jec.getJobDetail().getJobDataMap();
        if (dataMap != null) {
            try {
                this.executeAction(dataMap);
            }
            catch (WfException e) {
                throw new JobExecutionException("error to Excute Deadline Action!", (Throwable)e, false);
            }
        }
    }

    public void executeAction(JobDataMap dataMap) throws WfException, JobExecutionException {
        String engineName = dataMap.getString(DATAMAP_NAME_ENGINE_NAME);
        WfEngine engine = WfEngine.getEngine(engineName);
        DeadlineWaiterJob obj = this;
        Class<?> classCaller = this.getClass();
        String methodName = "executeActionInWfTx";
        Class[] parameterTypes = new Class[]{JobDataMap.class};
        Object[] args = new Object[]{dataMap};
        MethodDesc methodDesc = new MethodDesc(classCaller, methodName, parameterTypes);
        WfTxInvocationDesc invocationDesc = new WfTxInvocationDesc(methodDesc, obj, args);
        WfTxHelper.invokeRequired(engine.context(), invocationDesc);
    }

    public void executeActionInWfTx(JobDataMap dataMap) throws WfException, JobExecutionException {
        int deadlineIndex = dataMap.getInt(DATAMAP_NAME_DEADLINE_INDEX);
        String engineName = dataMap.getString(DATAMAP_NAME_ENGINE_NAME);
        String actInstId = dataMap.getString(DATAMAP_NAME_ACTINST_ID);
        if (engineName == null || actInstId == null) {
            throw new JobExecutionException("dataMap error!", null, false);
        }
        WfEngine engine = WfEngine.getEngine(engineName);
        if (engine == null) {
            throw new WfException("cannot find Engine '" + engineName + "'!");
        }
        WfActivity act = engine.getActivityInst(actInstId);
        if (act == null) {
            throw new WfException("cannot find ActivityInst '" + actInstId + "'!");
        }
        ManpowerActivityDef manpower = (ManpowerActivityDef)act.getDefinition();
        DeadlineCollection deadlines = manpower.getDeadlines();
        DeadlineDef deadline = (DeadlineDef)deadlines.getObject(deadlineIndex);
        if (deadline == null) {
            throw new WfException("cannot find Deadline!");
        }
        if (act != null && act.state().startsWith("closed")) {
            return;
        }
        int eventAction = deadline.getEventPolicy().getEventAction();
        if (eventAction != 0) {
            if ((8 & eventAction) != 0) {
                this.execScript(engine, act, deadline);
            }
            if ((7 & eventAction) != 0 && (0x10 & eventAction) == 0) {
                this.sendMessage(engine, act, deadline, eventAction);
            }
            if ((0x10 & eventAction) != 0) {
                this.execAutoApprove(engine, act, deadline, eventAction);
            }
        }
    }

    private void execAutoApprove(WfEngine engine, WfActivity act, DeadlineDef deadline, int eventAction) throws WfException {
        AutoApproveDef def = deadline.getEventPolicy().getAutoApprove();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opinion", def.getApproveAttitude());
        map.put("isPass", def.getApproveResult());
        map.put("handlerContent", def.getDecisionContent());
        map.put("handlerOpinion", def.getDecisionNumber());
        String receivers = this.getReceivers(engine, act, deadline);
        HashMap titles = new HashMap();
        HashMap bodies = new HashMap();
        this.buildMessage(act, titles, bodies, deadline, eventAction);
        String is_mail = "false";
        String is_mobile = "false";
        if ((2 & eventAction) != 0) {
            is_mail = "true";
        }
        if ((4 & eventAction) != 0) {
            is_mobile = "true";
        }
        map.put("is_mail", is_mail);
        map.put("is_mobile", is_mobile);
        map.put("databaseCenter", engine.context().getAIS());
        map.put("solution", engine.context().getSolution());
        Locale[] locales = ApplicationUtil.getContextLocales((Context)act.getWfEngine().context());
        String[] initiatorName = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            initiatorName[i] = act.container().getData().getInitiatorName(locale);
            if (initiatorName[i] != null) continue;
            initiatorName[i] = "";
        }
        map.put("titles", titles);
        map.put("bodies", bodies);
        map.put("receivers", receivers);
        map.put("initiatorName", initiatorName);
        map.put("locales", locales);
        String initiatorId = act.container().getData().getInitiatorId();
        map.put("initiatorId", initiatorId);
        String processDefId = act.container().getData().getProcDefId();
        map.put("processDefId", processDefId);
        String processInstId = act.container().getData().getProcInstId();
        map.put("processInstId", processInstId);
        String activityDefId = act.getDefinition().getID();
        map.put("activityDefId", activityDefId);
        String activityInstId = act.getId();
        map.put("activityInstId", activityInstId);
        String processDefHashValue = act.container().getData().getProcDefHashValue();
        map.put("processDefHashValue", processDefHashValue);
        String jobId = Mutex.getMutex(engine.context(), processInstId);
        String title = "~AutoApprove:" + act.getId();
        JobDispatcher.dispatch(jobId, engine.context(), title, (WfJobHandler)new DeadLineAutoApprove(map, processInstId, act.getId(), engine.context().getCaller().toString()), false, WfPriority.LOWEST);
    }

    private void execScript(WfEngine engine, WfActivity act, DeadlineDef deadline) throws WfException {
        WfProcess process = act.container();
        ScriptDef scriptDef = deadline.getEventPolicy().getHandleScript();
        if (scriptDef != null && !StringUtils.isEmpty((String)scriptDef.getScriptContent())) {
            String script = scriptDef.getScriptContent();
            Map data = act.container().getProcessContext().getDataCopy();
            try {
                ScriptUtil.executeScript(script, act, data);
                Iterator dataFiledNames = process.getProcessContext().getDataCopy().keySet().iterator();
                while (dataFiledNames.hasNext()) {
                    String name = dataFiledNames.next().toString();
                    process.getProcessContext().setDataFieldValue(name, data.get(name));
                }
                engine.getStoreManager().getDataFieldStorer().store(process.getProcessContext().getProcInstDataInfo());
            }
            catch (WfException ex) {
                try {
                    ExceptionMessage msg = ExceptionUtil.getMessages((IExceptionInfoSupport)ex);
                    WfLogger wfLogger = engine.getWfLogger();
                    wfLogger.addWfProcessInstLog(LogTypeEnum.ERROR, ProcessInstEventEnum.EVALPOSTSCRIPTERROR, process.getId(), msg.getDetail() + "\n" + msg.getStack());
                }
                catch (Throwable e) {
                    log.warn((Object)e.getMessage(), e);
                }
            }
        }
    }

    private void sendMessage(WfEngine engine, WfActivity act, DeadlineDef deadline, int eventAction) throws WfException {
        if (act != null && act.state().startsWith("closed")) {
            return;
        }
        WfSendNotificationAction action = new WfSendNotificationAction();
        WfEvent event = new WfEvent(engine);
        event.setEventType(WfEventType.DEADLINE);
        event.setActDefId(act.getDefinition().getID());
        event.setActivityId(act.getId());
        event.setProcessDefId(act.container().getDefinition().getID());
        event.setProcessDefVersion(act.container().manager().getInnverVersion());
        event.setProcessId(act.container().getId());
        HashMap titles = new HashMap();
        HashMap bodies = new HashMap();
        this.buildMessage(act, titles, bodies, deadline, eventAction);
        String receivers = this.getReceivers(engine, act, deadline);
        if (deadline.getEventPolicy() != null && deadline.getEventPolicy().isUseSystemDefaultMessage()) {
            Map parameters = this.getparameters(deadline, engine, receivers, act, titles, bodies);
            action.action(event, parameters);
        } else {
            String[] receiver = receivers.split(";");
            for (int i = 0; i < receiver.length; ++i) {
                Map body = (Map)bodies.get(receiver[i]);
                if (body == null) continue;
                Map parameters = this.getparameters(deadline, engine, receiver[i], act, titles, body);
                action.action(event, parameters);
            }
        }
        if (log.isDebugEnabled()) {
            try {
                StringBuffer logTip = new StringBuffer();
                logTip.append("messageType:");
                logTip.append(deadline.getEventPolicy().getEventAction());
                logTip.append(" receiver:");
                logTip.append(receivers);
                log.debug((Object)logTip.toString());
                log.debug((Object)("start time:" + new Date()));
            }
            catch (RuntimeException e) {
                log.error((Object)e);
            }
        }
    }

    private Map getparameters(DeadlineDef deadline, WfEngine engine, String receiver, WfActivity act, Map titles, Map bodies) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("participants", deadline.getEventPolicy().getParticipants());
        parameters.put("messgae", titles);
        parameters.put("body", bodies);
        parameters.put("ais", engine.context().getAIS());
        parameters.put("solution", engine.context().getSolution());
        parameters.put("receiver", receiver);
        int messageType = deadline.getEventPolicy().getEventAction();
        parameters.put("messageType", new Integer(messageType));
        parameters.put("wfActivity", act);
        return parameters;
    }

    private String getReceivers(WfEngine engine, WfActivity act, DeadlineDef deadline) throws WfException {
        String receiver = "";
        List tmp = ParticipantHelper.getPersonsByParticipants(act, deadline.getEventPolicy().getParticipants());
        if (deadline.getEventPolicy().isUseActivityParticipants()) {
            List allPersons = this.getAllPersons(act);
            int len = allPersons.size();
            for (int i = 0; i < len; ++i) {
                String personId = (String)allPersons.get(i);
                Person person = engine.getPariticipantProvider().getPersonByUserId(engine.context(), personId);
                if (this.isContainInList(tmp, person)) continue;
                tmp.add(person);
            }
        }
        HashSet completePersons = this.getCompletePersons(act);
        ArrayList<Person> persons = new ArrayList<Person>();
        for (int i = 0; i < tmp.size(); ++i) {
            Person p = (Person)tmp.get(i);
            if (completePersons.contains(p.getEmployeeId())) continue;
            persons.add(p);
        }
        receiver = WfMessageUtil.getDistinctRecievers(persons);
        return receiver;
    }

    private boolean isContainInList(List l, Person p) {
        boolean f = false;
        if (p == null) {
            return true;
        }
        for (int i = l.size() - 1; i >= 0; --i) {
            Person tmp;
            Object obj = l.get(i);
            if (!(obj instanceof Person) || !(tmp = (Person)obj).getEmployeeId().equals(p.getEmployeeId()) || !tmp.getUserId().equals(p.getUserId())) continue;
            f = true;
            break;
        }
        return f;
    }

    private List getAllPersons(WfActivity act) throws WfException {
        Iterator it = act.assignments().iterator();
        ArrayList<String> personIds = new ArrayList<String>();
        while (it.hasNext()) {
            WfAssignment assign = (WfAssignment)it.next();
            personIds.add(assign.getMeta().getUserId());
        }
        return personIds;
    }

    private HashSet getCompletePersons(WfActivity act) throws WfException {
        Iterator it = act.assignments().iterator();
        HashSet<String> personIds = new HashSet<String>();
        while (it.hasNext()) {
            WfAssignment assign = (WfAssignment)it.next();
            if (assign.state() != WfAssignmentState.COMPLETED && assign.state() != WfAssignmentState.REJECTED && assign.state() != WfAssignmentState.PROCESSING && assign.state() != WfAssignmentState.CANCELED) continue;
            personIds.add(assign.getMeta().getEmployeeId());
        }
        return personIds;
    }

    private int eval(ProcessContext context, String str) {
        int retVal = 0;
        try {
            retVal = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            Object object = context.getDataFieldValue(str);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            throw new IllegalArgumentException("error! object:" + object);
        }
        return retVal;
    }

    private String buildDeadlineMsg(ProcessContext context, DeadlineDef deadline, Locale l) {
        String condition = deadline.getDeadlineCondition();
        String[] time = StringUtils.split((String)condition, (String)"/");
        int year = 0;
        int month = this.eval(context, time[0]);
        int date = this.eval(context, time[1]);
        int hour = this.eval(context, time[2]);
        int min = this.eval(context, time[3]);
        int sec = this.eval(context, time[4]);
        StringBuffer buffer = new StringBuffer();
        if (year != 0) {
            if (L1.equals(l)) {
                buffer.append(year).append(" Years");
            } else if (L3.equals(l)) {
                buffer.append(year).append("\u5e74");
            } else {
                buffer.append(year).append("\u5e74");
            }
        }
        if (month != 0) {
            if (L1.equals(l)) {
                buffer.append(month).append(" Months");
            } else if (L3.equals(l)) {
                buffer.append(month).append("\u6708");
            } else {
                buffer.append(month).append("\u6708");
            }
        }
        if (date != 0) {
            if (L1.equals(l)) {
                buffer.append(date).append(" Days");
            } else if (L3.equals(l)) {
                buffer.append(date).append("\u65e5");
            } else {
                buffer.append(date).append("\u65e5");
            }
        }
        if (hour != 0) {
            if (L1.equals(l)) {
                buffer.append(hour).append(" Hours");
            } else if (L3.equals(l)) {
                buffer.append(hour).append("\u5c0f\u6642");
            } else {
                buffer.append(hour).append("\u5c0f\u65f6");
            }
        }
        if (min != 0) {
            if (L1.equals(l)) {
                buffer.append(min).append(" Minutes");
            } else if (L3.equals(l)) {
                buffer.append(min).append("\u5206\u9418");
            } else {
                buffer.append(min).append("\u5206\u949f");
            }
        }
        if (sec != 0) {
            if (L1.equals(l)) {
                buffer.append(sec).append(" Seconds");
            } else if (L3.equals(l)) {
                buffer.append(sec).append("\u79d2");
            } else {
                buffer.append(sec).append("\u79d2");
            }
        }
        return buffer.toString();
    }

    private void buildMessage(WfActivity activit, Map titles, Map bodies, DeadlineDef deadline, int eventAction) throws WfException {
        block6: {
            boolean isAutoApprove;
            Locale[] locales;
            block5: {
                locales = ApplicationUtil.getContextLocales((Context)activit.getWfEngine().context());
                if (deadline.getEventPolicy() == null || deadline.getEventPolicy().isUseSystemDefaultMessage() || deadline.getEventPolicy().getMessage() == null) break block5;
                List assigns = activit.assignments();
                if (locales == null) break block6;
                for (int j = 0; j < assigns.size(); ++j) {
                    String userId = ((WfAssignment)assigns.get(j)).getAssignmentInfo().getUserId();
                    HashMap<Locale, String> bodyMap = new HashMap<Locale, String>();
                    for (int i = 0; i < locales.length; ++i) {
                        AssignmentMessage message = deadline.getEventPolicy().getMessage();
                        String title = WfMessageUtil.parseMessage(message.getTitle(locales[i]), activit, locales[i]);
                        String body = WfMessageUtil.parseMessageForDeadlineJob(message.getBody(locales[i]), activit, locales[i], (WfAssignment)assigns.get(j));
                        titles.put(locales[i], title);
                        bodyMap.put(locales[i], body);
                    }
                    bodies.put(userId, bodyMap);
                }
                break block6;
            }
            boolean bl = isAutoApprove = (0x10 & eventAction) != 0;
            if (locales != null) {
                for (int i = 0; i < locales.length; ++i) {
                    String assignStr = WfMessageUtil.getMessageTitle(activit, locales[i]);
                    if (StringUtils.isEmpty((String)assignStr)) {
                        assignStr = activit.getName();
                    }
                    String deadlineTitle = this.getDeadlineTitle(isAutoApprove, locales[i]);
                    String deadlineBody = this.getDeadlineBody(activit, deadline, locales[i], isAutoApprove);
                    String title = "[" + assignStr + "]" + deadlineTitle;
                    String body = deadlineBody + "\r\n\r\n" + WfMessageUtil.getMessageContent(activit, locales[i]);
                    titles.put(locales[i], title);
                    bodies.put(locales[i], body);
                }
            }
        }
    }

    private String getDeadlineBody(WfActivity activit, DeadlineDef deadline, Locale l, boolean isAutoApprove) throws WfException {
        String deadlineBody = L1.equals(l) ? "Deadline offset time: " : (L3.equals(l) ? "\u6700\u5f8c\u671f\u9650\u7684\u76f8\u5c0d\u6642\u9593\uff1a" : "\u6700\u540e\u671f\u9650\u7684\u76f8\u5bf9\u65f6\u95f4\uff1a");
        deadlineBody = deadlineBody + this.buildDeadlineMsg(activit.container().getProcessContext(), deadline, l);
        if (isAutoApprove && !L1.equals(l)) {
            deadlineBody = L3.equals(l) ? "\n \u6700\u5f8c\u671f\u9650\u5df2\u5230\uff0c\u5df2\u7531\u7cfb\u7d71\u6839\u64da\u9810\u5b9a\u914d\u7f6e\u5b8c\u6210\u672c\u5be9\u6279\u64cd\u4f5c\uff01\u76f8\u95dc\u4fe1\u606f\u5982\u4e0b\uff1a\r\n" + deadlineBody : "\n \u6700\u540e\u671f\u9650\u5df2\u5230\uff0c\u5df2\u7531\u7cfb\u7edf\u6839\u636e\u9884\u5b9a\u914d\u7f6e\u5b8c\u6210\u672c\u5ba1\u6279\u64cd\u4f5c\uff01\u76f8\u5173\u4fe1\u606f\u5982\u4e0b\uff1a\r\n" + deadlineBody;
        }
        return deadlineBody;
    }

    private String getDeadlineTitle(boolean isAutoApprove, Locale l) {
        if (L1.equals(l)) {
            return isAutoApprove ? "deadline was reached, and the task was auto approved by system!" : "deadline was reached.";
        }
        if (L3.equals(l)) {
            return isAutoApprove ? "\u9054\u5230\u6700\u5f8c\u671f\u9650\uff0c\u5df2\u9032\u884c\u81ea\u52d5\u5be9\u6279\u64cd\u4f5c\uff01" : "\u9054\u5230\u6700\u5f8c\u671f\u9650\uff0c\u8acb\u76e1\u5feb\u8655\u7406\uff01";
        }
        return isAutoApprove ? "\u8fbe\u5230\u6700\u540e\u671f\u9650\uff0c\u5df2\u8fdb\u884c\u81ea\u52a8\u5ba1\u6279\u64cd\u4f5c\uff01" : "\u8fbe\u5230\u6700\u540e\u671f\u9650\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\uff01";
    }
}

