/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.util.InnerVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InnerVariableManager {
    private static final Logger logger = Logger.getLogger(InnerVariableManager.class);
    public static final int INNER_TYPE_PROCESS = 1;
    public static final int INNER_TYPE_ACTIVITY = 2;
    public static final String BOS_PROCESSDEFID_KEY = "__processDefId";
    public static final String BOS_ACTIVITYDEFID_KEY = "__activityDefId";
    public static final String BOS_PROCESSTRIGGER_KEY = "__processTrigger";
    public static final String BOS_CONTEXT_KEY = "__bosContext";
    private Map map = new HashMap();
    private ProcessDef processDef;
    private WfActivity activity;

    public InnerVariableManager() {
        this.initVariable();
    }

    public InnerVariableManager(ProcessDef processDef) {
        this.processDef = processDef;
        this.initVariable();
        this.initProcessDefVariable();
    }

    public InnerVariableManager(WfActivity activity) {
        this.activity = activity;
        this.initVariable();
        this.initWfActivityVariable();
    }

    public void putVariable(String key, Object value) {
        this.map.put(key, value);
    }

    public Object getVariableValue(String key) {
        return this.map.get(key);
    }

    public Map getVariableMap() {
        return this.map;
    }

    public Set getAllVariablesName() {
        return this.map.keySet();
    }

    public Set getProcessVariablesName() {
        HashSet<String> set = new HashSet<String>();
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            InnerVariable temp = (InnerVariable)this.map.get(it.next());
            if (temp.getType() != 1) continue;
            set.add(temp.getName());
        }
        return set;
    }

    public Set getActivityVariablesName() {
        HashSet<String> set = new HashSet<String>();
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            InnerVariable temp = (InnerVariable)this.map.get(it.next());
            if (temp.getType() != 2) continue;
            set.add(temp.getName());
        }
        return set;
    }

    private void initVariable() {
        if (this.map == null) {
            this.map = new HashMap();
        }
        InnerVariable processDefId = new InnerVariable();
        processDefId.setName(BOS_PROCESSDEFID_KEY);
        processDefId.setType(1);
        processDefId.setAlias("\u6d41\u7a0b\u5b9a\u4e49ID");
        this.map.put(processDefId.getName(), processDefId);
        InnerVariable activityDefId = new InnerVariable();
        activityDefId.setName(BOS_ACTIVITYDEFID_KEY);
        activityDefId.setType(2);
        activityDefId.setAlias("\u8282\u70b9\u5b9a\u4e49ID");
        this.map.put(activityDefId.getName(), activityDefId);
        InnerVariable processTrigger = new InnerVariable();
        processTrigger.setName(BOS_PROCESSTRIGGER_KEY);
        processTrigger.setType(1);
        processTrigger.setAlias("\u5916\u90e8\u4e1a\u52a1\u5bf9\u8c61");
        this.map.put(processTrigger.getName(), processTrigger);
        InnerVariable bosContext = new InnerVariable();
        bosContext.setName(BOS_CONTEXT_KEY);
        bosContext.setType(1);
        bosContext.setAlias("BOS\u4e0a\u4e0b\u6587\u73af\u5883\u53d8\u91cf");
        this.map.put(bosContext.getName(), bosContext);
    }

    private void initProcessDefVariable() {
        if (this.processDef == null) {
            return;
        }
        if (!this.map.containsKey(BOS_PROCESSDEFID_KEY)) {
            InnerVariable processDefId = new InnerVariable();
            processDefId.setName(BOS_PROCESSDEFID_KEY);
            processDefId.setType(1);
            processDefId.setAlias("\u6d41\u7a0b\u5b9a\u4e49ID");
            processDefId.setValue((Object)this.processDef.getID());
            this.map.put(BOS_PROCESSDEFID_KEY, processDefId);
        } else {
            InnerVariable processDefId = (InnerVariable)this.map.get(BOS_PROCESSDEFID_KEY);
            if (processDefId.getValue() == null || !processDefId.getValue().equals(this.processDef.getID())) {
                processDefId.setValue((Object)this.processDef.getID());
                this.map.put(BOS_PROCESSDEFID_KEY, processDefId);
            }
        }
    }

    private void initWfActivityVariable() {
        if (this.activity == null) {
            return;
        }
        try {
            this.processDef = this.activity.getWfEngine().getProcessInst(this.activity.getProcInstId()).getDefinition();
            this.initProcessDefVariable();
            if (!this.map.containsKey(BOS_ACTIVITYDEFID_KEY)) {
                InnerVariable activityDefId = new InnerVariable();
                activityDefId.setName(BOS_ACTIVITYDEFID_KEY);
                activityDefId.setType(2);
                activityDefId.setAlias("\u8282\u70b9\u5b9a\u4e49ID");
                activityDefId.setValue((Object)this.activity.getDefinition().getID());
                this.map.put(BOS_ACTIVITYDEFID_KEY, activityDefId);
            } else {
                InnerVariable activityDefId = (InnerVariable)this.map.get(BOS_ACTIVITYDEFID_KEY);
                if (activityDefId.getValue() == null || !activityDefId.getValue().equals(this.activity.getDefinition().getID())) {
                    activityDefId.setValue((Object)this.activity.getDefinition().getID());
                    this.map.put(BOS_ACTIVITYDEFID_KEY, activityDefId);
                }
            }
        }
        catch (WfException e) {
            logger.error((Object)"initWfActivityVariable()", (Throwable)e);
        }
    }
}

