/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.wfdesigner.service;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.dynui.DynUIPackageDef;
import com.kingdee.bos.workflow.dynui.DynUIParser;
import com.kingdee.bos.workflow.dynui.WfDynUIParseException;
import com.kingdee.bos.workflow.dynui.approve.ApproveUIDef;
import com.kingdee.bos.workflow.wfdesigner.service.DBOperationBridge;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DynUIStorer {
    private DBOperationBridge bridge;
    private Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.wfdesigner.service.DynUIStorer");

    DynUIStorer(DBOperationBridge bridge) {
        this.bridge = bridge;
    }

    public Connection getConnection() throws SQLException {
        return this.bridge.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addDynUIPackage(DynUIPackageDef info) throws SQLException {
        String sql = "INSERT INTO T_WFM_APPROVEPACKAGE (FID, FPARENTID, FNAME_L1, FNAME_L2, FNAME_L3, FDESC_L1, FDESC_L2, FDESC_L3) VALUES (?,?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        String id = BOSUuid.create((String)"DUPD").toString();
        info.setId(id);
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getId());
            stmt.setString(2, info.getParentId());
            stmt.setString(3, info.getName(BOSLocaleUtil.EN_US));
            stmt.setString(4, info.getName(BOSLocaleUtil.ZH_CN));
            stmt.setString(5, info.getName(BOSLocaleUtil.ZH_TW));
            stmt.setString(6, info.getDesc(BOSLocaleUtil.EN_US));
            stmt.setString(7, info.getDesc(BOSLocaleUtil.ZH_CN));
            stmt.setString(8, info.getDesc(BOSLocaleUtil.ZH_TW));
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return id;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean modDynUIPackage(DynUIPackageDef info) throws SQLException {
        String sql = "UPDATE T_WFM_APPROVEPACKAGE SET FPARENTID=?, FNAME_L1=?, FNAME_L2=?, FNAME_L3=?, FDESC_L1=?, FDESC_L2=?, FDESC_L3=? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getParentId());
            stmt.setString(2, info.getName(BOSLocaleUtil.EN_US));
            stmt.setString(3, info.getName(BOSLocaleUtil.ZH_CN));
            stmt.setString(4, info.getName(BOSLocaleUtil.ZH_TW));
            stmt.setString(5, info.getDesc(BOSLocaleUtil.EN_US));
            stmt.setString(6, info.getDesc(BOSLocaleUtil.ZH_CN));
            stmt.setString(7, info.getDesc(BOSLocaleUtil.ZH_TW));
            stmt.setString(8, info.getId());
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delDynUIPackage(String id) throws SQLException {
        String sql = "DELETE T_WFM_APPROVEPACKAGE WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delDynUIPackage(String[] ids) throws SQLException {
        if (ids == null) return false;
        if (ids.length == 0) {
            return false;
        }
        StringBuffer sql = new StringBuffer("DELETE T_WFM_APPROVEPACKAGE WHERE FID in (?");
        for (int i = 1; i < ids.length; ++i) {
            sql.append(",?");
        }
        sql.append(')');
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < ids.length; ++i) {
                stmt.setString(i + 1, ids[i]);
            }
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getDynUIPackageRoot() throws SQLException {
        String sql = "SELECT FID,FNAME_L1,FNAME_L2,FNAME_L3,FDESC_L1,FDESC_L2,FDESC_L3 FROM T_WFM_APPROVEPACKAGE WHERE FPARENTID = ? OR FPARENTID IS NULL";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<DynUIPackageDef> rts = new ArrayList<DynUIPackageDef>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, "");
            rs = stmt.executeQuery();
            while (rs.next()) {
                DynUIPackageDef info = new DynUIPackageDef();
                info.setId(rs.getString(1));
                info.setName(BOSLocaleUtil.EN_US, rs.getString(2));
                info.setName(BOSLocaleUtil.ZH_CN, rs.getString(3));
                info.setDefaultName(rs.getString(3));
                info.setName(BOSLocaleUtil.ZH_TW, rs.getString(4));
                info.setDesc(BOSLocaleUtil.EN_US, rs.getString(5));
                info.setDesc(BOSLocaleUtil.ZH_CN, rs.getString(6));
                info.setDefaultDesc(rs.getString(6));
                info.setDesc(BOSLocaleUtil.ZH_TW, rs.getString(7));
                info.setParentId("");
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getSubDynUIPackageByPackageId(String id) throws SQLException {
        String sql = "SELECT FID,FNAME_L1,FNAME_L2,FNAME_L3,FDESC_L1,FDESC_L2,FDESC_L3 FROM T_WFM_APPROVEPACKAGE WHERE FPARENTID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<DynUIPackageDef> rts = new ArrayList<DynUIPackageDef>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                DynUIPackageDef info = new DynUIPackageDef();
                info.setId(rs.getString(1));
                info.setName(BOSLocaleUtil.EN_US, rs.getString(2));
                info.setName(BOSLocaleUtil.ZH_CN, rs.getString(3));
                info.setDefaultName(rs.getString(3));
                info.setName(BOSLocaleUtil.ZH_TW, rs.getString(4));
                info.setDesc(BOSLocaleUtil.EN_US, rs.getString(5));
                info.setDesc(BOSLocaleUtil.ZH_CN, rs.getString(6));
                info.setDefaultDesc(rs.getString(6));
                info.setDesc(BOSLocaleUtil.ZH_TW, rs.getString(7));
                info.setParentId("");
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addDynUIApproveDef(ApproveUIDef info) throws SQLException {
        String sql = "INSERT INTO T_WFM_APPROVEUI (FID,FNAME_L1,FNAME_L2,FNAME_L3,FHASHKEY,FDESC_L1,FDESC_L2,FDESC_L3,FLASTUPDATE,FDEFXML,FVERSION,FPACKAGEID) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        String id = BOSUuid.create((String)"DUAD").toString();
        info.setId(id);
        String xml = info.toXml();
        info.setHashKey(xml.hashCode());
        info.setLastUpdate(new Date());
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getId());
            stmt.setString(2, info.getTitle(BOSLocaleUtil.EN_US));
            stmt.setString(3, info.getTitle(BOSLocaleUtil.ZH_CN));
            stmt.setString(4, info.getTitle(BOSLocaleUtil.ZH_TW));
            stmt.setInt(5, info.getHashKey());
            stmt.setString(6, info.getDesc(BOSLocaleUtil.EN_US));
            stmt.setString(7, info.getDesc(BOSLocaleUtil.ZH_CN));
            stmt.setString(8, info.getDesc(BOSLocaleUtil.ZH_TW));
            stmt.setDate(9, new java.sql.Date(info.getLastUpdate().getTime()));
            stmt.setString(10, xml);
            stmt.setString(11, "1.0");
            stmt.setString(12, info.getPackageId());
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return id;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delDynUIApproveDef(String id) throws SQLException {
        String sql = "DELETE T_WFM_APPROVEUI WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delDynUIApproveDefs(String[] ids) throws SQLException {
        if (ids == null) return false;
        if (ids.length == 0) {
            return false;
        }
        StringBuffer sql = new StringBuffer("DELETE T_WFM_APPROVEUI WHERE FID in (?");
        for (int i = 1; i < ids.length; ++i) {
            sql.append(",?");
        }
        sql.append(')');
        Connection conn = null;
        PreparedStatement stmt = null;
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < ids.length; ++i) {
                stmt.setString(i + 1, ids[i]);
            }
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean modDynUIApproveDef(ApproveUIDef info) throws SQLException {
        String sql = "UPDATE T_WFM_APPROVEUI SET FNAME_L1=?,FNAME_L2=?,FNAME_L3=?,FDESC_L1=?,FDESC_L2=?,FDESC_L3=?,FHASHKEY=?,FDEFXML=?,FLASTUPDATE=?,FVERSION=?,FPACKAGEID=? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        String xml = info.toXml();
        info.setHashKey(xml.hashCode());
        info.setLastUpdate(new Date());
        boolean rts = false;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getTitle(BOSLocaleUtil.EN_US));
            stmt.setString(2, info.getTitle(BOSLocaleUtil.ZH_CN));
            stmt.setString(3, info.getTitle(BOSLocaleUtil.ZH_TW));
            stmt.setString(4, info.getDesc(BOSLocaleUtil.EN_US));
            stmt.setString(5, info.getDesc(BOSLocaleUtil.ZH_CN));
            stmt.setString(6, info.getDesc(BOSLocaleUtil.ZH_TW));
            stmt.setInt(7, info.getHashKey());
            stmt.setString(8, xml);
            stmt.setDate(9, new java.sql.Date(info.getLastUpdate().getTime()));
            stmt.setString(10, "1.0");
            stmt.setString(11, info.getPackageId());
            stmt.setString(12, info.getId());
            rts = stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApproveUIDef getApproveUIDefById(String id) throws SQLException {
        String sql = "SELECT FID,FNAME_L1,FNAME_L2,FNAME_L3,FDESC_L1,FDESC_L2,FDESC_L3,FHASHKEY,FLASTUPDATE,FDEFXML,FVERSION,FPACKAGEID FROM T_WFM_APPROVEUI WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ApproveUIDef info = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String xml = rs.getString(10);
                try {
                    info = DynUIParser.parser((String)xml);
                }
                catch (WfDynUIParseException e) {
                    this.log.error((Object)("DynUIParseException: " + e.getMessage()));
                    info = new ApproveUIDef();
                }
                info.setId(rs.getString(1));
                info.setTitle(rs.getString(2), BOSLocaleUtil.EN_US);
                info.setTitle(rs.getString(3), BOSLocaleUtil.ZH_CN);
                info.setTitle(rs.getString(4), BOSLocaleUtil.ZH_TW);
                info.setDesc(rs.getString(5), BOSLocaleUtil.EN_US);
                info.setDesc(rs.getString(6), BOSLocaleUtil.ZH_CN);
                info.setDesc(rs.getString(7), BOSLocaleUtil.ZH_TW);
                info.setHashKey(rs.getInt(8));
                info.setLastUpdate(new Date(rs.getDate(9).getTime()));
                info.setPackageId(rs.getString(12));
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return info;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getAllApproveUIDef() throws SQLException {
        String sql = "SELECT FID,FNAME_L1,FNAME_L2,FNAME_L3,FDESC_L1,FDESC_L2,FDESC_L3,FHASHKEY,FLASTUPDATE,FVERSION,FPACKAGEID FROM T_WFM_APPROVEUI WHERE FVERSION NOT LIKE 'D_%'";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ApproveUIDef info = null;
        ArrayList<ApproveUIDef> rts = new ArrayList<ApproveUIDef>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new ApproveUIDef();
                info.setId(rs.getString(1));
                info.setTitle(rs.getString(2), BOSLocaleUtil.EN_US);
                info.setTitle(rs.getString(3), BOSLocaleUtil.ZH_CN);
                info.setTitle(rs.getString(4), BOSLocaleUtil.ZH_TW);
                info.setDesc(rs.getString(5), BOSLocaleUtil.EN_US);
                info.setDesc(rs.getString(6), BOSLocaleUtil.ZH_CN);
                info.setDesc(rs.getString(7), BOSLocaleUtil.ZH_TW);
                info.setHashKey(rs.getInt(8));
                info.setLastUpdate(new Date(rs.getDate(9).getTime()));
                info.setPackageId(rs.getString(11));
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getApproveUIDefByPackageId(String packageId) throws SQLException {
        String sql = "SELECT FID,FNAME_L1,FNAME_L2,FNAME_L3,FDESC_L1,FDESC_L2,FDESC_L3,FHASHKEY,FLASTUPDATE,FVERSION,FPACKAGEID FROM T_WFM_APPROVEUI WHERE FPACKAGEID = ? AND FVERSION NOT LIKE 'D_%'";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ApproveUIDef info = null;
        ArrayList<ApproveUIDef> rts = new ArrayList<ApproveUIDef>();
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, packageId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                info = new ApproveUIDef();
                info.setId(rs.getString(1));
                info.setTitle(rs.getString(2), BOSLocaleUtil.EN_US);
                info.setTitle(rs.getString(3), BOSLocaleUtil.ZH_CN);
                info.setTitle(rs.getString(4), BOSLocaleUtil.ZH_TW);
                info.setDesc(rs.getString(5), BOSLocaleUtil.EN_US);
                info.setDesc(rs.getString(6), BOSLocaleUtil.ZH_CN);
                info.setDesc(rs.getString(7), BOSLocaleUtil.ZH_TW);
                info.setHashKey(rs.getInt(8));
                info.setLastUpdate(new Date(rs.getDate(9).getTime()));
                info.setPackageId(rs.getString(11));
                rts.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    DBOperationBridge.cleanup(rs, stmt, conn);
                    throw throwable;
                }
                catch (SQLException ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            }
        }
        try {
            DBOperationBridge.cleanup(rs, stmt, conn);
            return rts;
        }
        catch (SQLException ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

