/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.engine.core.Util;
import com.kingdee.bos.workflow.engine.listener.AbstractAssignmentCheck;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Task;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class AssignmentAllocator
implements Task {
    public static final AssignmentAllocator INS = new AssignmentAllocator();

    public void compile(VariableScope scope) {
    }

    public void start(Execution<? extends Node> e) throws Exception {
        AssignmentAllocator.createAssignments(e);
        AbstractAssignmentCheck.setAssigned(e);
    }

    public static void createAssignments(Execution<? extends Node> e) throws Exception, WfException {
        List<?> participants = AssignmentAllocator.getParticipants(e);
        if (participants.size() > 0) {
            WfActivity act = Util.getWfActivity(e);
            boolean appended = Util.isAppended(e);
            boolean sendMsg = act.isSendAssignmentMsg() && !appended && !act.isShareCenter();
            act.createAssignments(participants, sendMsg);
            act.clearDynamicPerformers();
        }
    }

    protected static final List<?> getParticipants(Execution<? extends Node> e) throws Exception {
        WfActivity act = Util.getWfActivity(e);
        if (Util.isAppended(e)) {
            List<Person> list = AssignmentAllocator.getPerformers4Appended(e, act);
            return list;
        }
        if (Util.shouldOmitFirstActivity((FlowContext)e.getContext())) {
            Util.setOmittedActInstId((FlowContext)e.getContext(), (String)e.getId());
            AssignmentAllocator.outputFirstManpowerActivityValues(act);
            return new ArrayList(0);
        }
        if (AssignmentAllocator.isSubmitActivity(act)) {
            return act.getParticipant4SubmitActivity();
        }
        List persons = act.getPerformerList();
        return persons;
    }

    private static boolean isSubmitActivity(WfActivity act) throws Exception {
        if (((WfProcess)act.getProcess()).getProcessMeta().getParentProcInstId() != null) {
            return false;
        }
        ActivityCollection ac = act.getDefinition().getPreviousActivities();
        for (int i = 0; i < ac.size(); ++i) {
            if (!(ac.get(i) instanceof StartActivityDef)) continue;
            return true;
        }
        return false;
    }

    private static List<Person> getPerformers4Appended(Execution<? extends Node> e, WfActivity act) throws WfException, WfParticipantException {
        ArrayList<Person> list = new ArrayList<Person>();
        IParticipantProvider provider = act.getWfEngine().getPariticipantProvider();
        Collection persons = Util.getParticipants(e);
        Context ctx = act.getContext();
        for (Object person : persons) {
            String empId = (String)person;
            Person[] personArray = provider.getPersonByEmployeeId(ctx, empId);
            if (personArray.length == 0) {
                list.add(provider.getPersonByUserId(ctx, empId));
                continue;
            }
            list.addAll(Arrays.asList(personArray));
        }
        return list;
    }

    private static void outputFirstManpowerActivityValues(WfActivity act) throws WfException, WfParticipantException, BOSException {
        Context ctx = act.getContext();
        WfEngine engine = act.getWfEngine();
        String initiatorId = act.container().getProcessMeta().getInitiatorId();
        Person person = engine.getPariticipantProvider().getPersonByUserId(ctx, initiatorId);
        ArrayList<Person> participants = new ArrayList<Person>(1);
        participants.add(person);
        AssignmentInfo[] assignmentInfos = WorkItemStorer.buildNewAssignmentInfos((Context)ctx, (WfActivity)act, participants, null, null, (boolean)false);
        engine.getValueToOutput(act.getDefinition(), assignmentInfos[0], act.container());
    }
}

