/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.engine.ws;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FormalParameterMode;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SchemaType;
import com.kingdee.bos.workflow.engine.ws.Util;
import com.kingdee.cbos.process.vm.utils.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessXsd {
    static final String PROC_STATE = "_state_";
    private static final String XS = "http://www.w3.org/2001/XMLSchema";

    public static String getXsd(String dataCenter, String procCode) throws Exception {
        Context ctx = Ctx.getDefaultContext((String)dataCenter);
        String procDefHash = Util.findHashCode(procCode, ctx);
        if (procDefHash == null) {
            return null;
        }
        ProcessDef procDef = Util.getProcessDef(ctx, procDefHash);
        String serviceURL = Util.getServiceURL(dataCenter, procCode);
        Document doc = ProcessXsd.addProcessIOtype(ctx, procDef, serviceURL);
        return XmlUtil.toString((Document)doc);
    }

    private static Document addProcessIOtype(Context ctx, ProcessDef procDef, String serviceURL) {
        String XSD = "<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema' version='1.0' targetNamespace='" + serviceURL + "'><xs:complexType name='input'><xs:sequence></xs:sequence></xs:complexType><xs:complexType name='output'><xs:sequence></xs:sequence></xs:complexType></xs:schema>";
        Document doc = XmlUtil.parse((String)XSD);
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        Element input = (Element)nodes.item(0).getChildNodes().item(0);
        Element output = (Element)nodes.item(1).getChildNodes().item(0);
        FormalParameterCollection parameters = procDef.getFormalParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Element parent;
            FormalParameterDef param = parameters.get(i);
            String type = ProcessXsd.getType(param.getDataType());
            boolean isOutput = param.getMode().equals((Object)FormalParameterMode.OUT);
            Element element = parent = isOutput ? output : input;
            if (type != null) {
                ProcessXsd.createTypeElement(doc, param, type, parent);
                continue;
            }
            if (!param.getDataType().equals(BasicType.BIZOBJ)) continue;
            try {
                DataFieldDef df = procDef.getDataFieldDef(param.getID());
                String entity = df.getInitValue();
                Element element2 = doc.createElement("xs:element");
                parent.appendChild(element2);
                element2.setAttribute("name", param.getName());
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectInfo billObject = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entity));
                ProcessXsd.createEntityType(ctx, doc, element2, billObject);
                continue;
            }
            catch (WfException wfException) {
                // empty catch block
            }
        }
        Element element = doc.createElement("xs:element");
        output.appendChild(element);
        element.setAttribute("name", PROC_STATE);
        element.setAttribute("type", "xs:string");
        return doc;
    }

    private static void createEntityType(Context ctx, Document doc, Element element, EntityObjectInfo billObject) {
        Element parent = element;
        element = doc.createElement("xs:complexType");
        parent.appendChild(element);
        parent = element;
        element = doc.createElement("xs:sequence");
        parent.appendChild(element);
        parent = element;
        PropertyCollection properties = billObject.getPropertiesRuntime();
        for (int j = 0; j < properties.size(); ++j) {
            PropertyInfo property = properties.get(j);
            element = doc.createElement("xs:element");
            parent.appendChild(element);
            element.setAttribute("name", property.getName());
            if (property instanceof OwnPropertyInfo) {
                String type = ProcessXsd.getType((OwnPropertyInfo)property);
                element.setAttribute("type", type);
                continue;
            }
            if (property instanceof LinkPropertyInfo) {
                RelationshipInfo rInfo = ((LinkPropertyInfo)property).getRelationship();
                if (rInfo.getType().equals((Object)RelationshipType.ASSOCIATION)) {
                    element.setAttribute("type", "xs:string");
                    continue;
                }
                if (rInfo.getType().equals((Object)RelationshipType.COMPOSITION)) {
                    if (rInfo.getSupplierObject().equals((Object)billObject)) continue;
                    parent = element;
                    element = doc.createElement("xs:complexType");
                    parent.appendChild(element);
                    parent = element;
                    element = doc.createElement("xs:sequence");
                    parent.appendChild(element);
                    parent = element;
                    element = doc.createElement("xs:element");
                    parent.appendChild(element);
                    element.setAttribute("name", "item");
                    element.setAttribute("maxOccurs", "unbounded");
                    ProcessXsd.createEntityType(ctx, doc, element, rInfo.getSupplierObject());
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
    }

    private static Element createTypeElement(Document doc, FormalParameterDef param, String type, Element parent) {
        Element element = doc.createElement("xs:element");
        parent.appendChild(element);
        element.setAttribute("name", param.getName());
        element.setAttribute("type", type);
        return element;
    }

    static String getType(DataType type) {
        if (BasicType.BOID.equals((Object)type)) {
            return "xs:string";
        }
        if (BasicType.BOOLEAN.equals((Object)type)) {
            return "xs:boolean";
        }
        if (BasicType.DATETIME.equals((Object)type)) {
            return "xs:dateTime";
        }
        if (BasicType.INTEGER.equals((Object)type)) {
            return "xs:int";
        }
        if (BasicType.STRING.equals((Object)type)) {
            return "xs:string";
        }
        if (BasicType.PK.equals((Object)type)) {
            return "xs:string";
        }
        if (BasicType.FLOAT.equals((Object)type)) {
            return "xs:float";
        }
        if (ExternalType.ENUM.equals((Object)type)) {
            return "xs:string";
        }
        if (SchemaType.STRING.equals((Object)type)) {
            return "xs:string";
        }
        if (SchemaType.INT.equals((Object)type)) {
            return "xs:int";
        }
        return null;
    }

    static String getType(OwnPropertyInfo info) {
        com.kingdee.bos.metadata.entity.DataType type = info.getDataType();
        if (com.kingdee.bos.metadata.entity.DataType.BOOLEAN.equals((Object)type)) {
            return "xs:boolean";
        }
        if (com.kingdee.bos.metadata.entity.DataType.BOSUUID.equals((Object)type)) {
            return "xs:ID";
        }
        if (com.kingdee.bos.metadata.entity.DataType.BYTE.equals((Object)type)) {
            return "xs:int";
        }
        if (com.kingdee.bos.metadata.entity.DataType.BYTEARRAY.equals((Object)type)) {
            return "xs:base64Binary";
        }
        if (com.kingdee.bos.metadata.entity.DataType.DATE.equals((Object)type)) {
            return "xs:date";
        }
        if (com.kingdee.bos.metadata.entity.DataType.DECIMAL.equals((Object)type)) {
            return "xs:decimal";
        }
        if (com.kingdee.bos.metadata.entity.DataType.DOUBLE.equals((Object)type)) {
            return "xs:double";
        }
        if (com.kingdee.bos.metadata.entity.DataType.FLOAT.equals((Object)type)) {
            return "xs:float";
        }
        if (com.kingdee.bos.metadata.entity.DataType.INTEGER.equals((Object)type)) {
            return "xs:int";
        }
        if (com.kingdee.bos.metadata.entity.DataType.LONG.equals((Object)type)) {
            return "xs:long";
        }
        if (com.kingdee.bos.metadata.entity.DataType.SHORT.equals((Object)type)) {
            return "xs:short";
        }
        if (com.kingdee.bos.metadata.entity.DataType.TIME.equals((Object)type)) {
            return "xs:time";
        }
        if (com.kingdee.bos.metadata.entity.DataType.TIMESTAMP.equals((Object)type)) {
            return "xs:dateTime";
        }
        if (com.kingdee.bos.metadata.entity.DataType.OBJECTCOLLECTION.equals((Object)type)) {
            throw new UnsupportedOperationException();
        }
        if (com.kingdee.bos.metadata.entity.DataType.OBJECTVALUE.equals((Object)type)) {
            throw new UnsupportedOperationException();
        }
        if (com.kingdee.bos.metadata.entity.DataType.ROWSET.equals((Object)type)) {
            throw new UnsupportedOperationException();
        }
        return "xs:string";
    }

    private static FormalParameterCollection createParameterTypes(Document doc, ActivityDef act, Element parent) {
        FormalParameterCollection params = Util.getFormalParameters(act);
        for (int j = 0; j < params.size(); ++j) {
            FormalParameterDef param = params.get(j);
            String datatype = ProcessXsd.getType(param.getDataType());
            if (datatype == null || !FormalParameterMode.OUT.equals((Object)param.getMode())) continue;
            ProcessXsd.createTypeElement(doc, param, datatype, parent);
        }
        return params;
    }

    private static Element createComplexElement(Document doc, Element root, ActivityDef act) {
        Element type = doc.createElement("xs:complexType");
        type.setAttribute("name", "import_" + act.getID().replace('-', '_'));
        root.appendChild(type);
        Element parent = doc.createElement("xs:sequence");
        type.appendChild(parent);
        return parent;
    }
}

