/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell;

import com.kingdee.bos.sql.shell.IKSQLSetting;
import com.kingdee.bos.sql.shell.Repository;
import org.apache.log4j.Logger;

public class KSQLSettingFactory {
    private static final Logger logger;
    private static final IKSQLSetting setting;

    public static IKSQLSetting getInstance() {
        return setting;
    }

    static {
        IKSQLSetting s;
        logger = Logger.getLogger(KSQLSettingFactory.class);
        try {
            s = (IKSQLSetting)Class.forName("com.kingdee.bos.framework.config.KSQLSetting").newInstance();
        }
        catch (Exception e) {
            s = new DefaultKSQLSetting();
            logger.info((Object)"KSQL setting try to use bos config failed and init with defalut setting.", (Throwable)e);
        }
        setting = s;
    }

    private static class DefaultKSQLSetting
    implements IKSQLSetting {
        private DefaultKSQLSetting() {
        }

        @Override
        public int getFetchSize() {
            return 100;
        }

        @Override
        public int getSQLExecute_TimeOut() {
            return 3600;
        }

        @Override
        public int getQueryExecute_TimeOut() {
            return 3600;
        }

        @Override
        public Repository setCurrentRepository(Repository repo) {
            return null;
        }

        @Override
        public Repository getCurrentRepository() {
            return null;
        }

        @Override
        public int getTestConnection_TimeOut() {
            return 10000;
        }
    }
}

