/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.osf.webservice.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;

public class PropertiesUtil {
    private Properties properties;
    private static PropertiesUtil instance;
    private static final ReentrantLock lock;

    private PropertiesUtil() {
    }

    private static PropertiesUtil getInstance() {
        if (instance == null) {
            try {
                lock.lock();
                if (instance == null) {
                    instance = new PropertiesUtil();
                    instance.initProperties();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return instance;
    }

    public static String getProperty(String key) {
        return PropertiesUtil.getInstance().properties.getProperty(key);
    }

    private void initProperties() {
        this.properties = new Properties();
        InputStream in = null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            in = this.getClass().getClassLoader().getResourceAsStream("com/kingdee/shr/osf/webservice/client/userInfo.properties");
            this.properties.load(in);
        }
        catch (IOException e) {
            System.err.println("Init OSFWebservice properties error: " + e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

