/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.provider.BotpFormulaSQLEFunctions;
import com.kingdee.bos.bot.engine.provider.IBotSQLFunctions;
import com.kingdee.bos.cache.CacheEngine;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTTransformSQLE;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.eas.base.botp.BOTPExtendInterface;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BOTPFormulaEngineTools {
    private static Logger logger = Logger.getLogger(BOTPFormulaEngineTools.class);
    private static String ROOTCACHE = "BOTCACHE";
    public static String localInstance = "getLocalInstance";
    public static final String BOTP_FUNC_EXTPROPNAME = "billFormulaClass";

    public static void initFormula(Context ctx, BOTTransformSQLE botTransformSqle, BOTMappingInfo botMappingInfo) throws DataAccessException, IOException, KScriptException {
        List formulaFuncsSrcList;
        BOTPFormulaEngineTools.addBOTPFormulaFunction(ctx, botTransformSqle);
        EntityObjectInfo destEntity = botMappingInfo.getDestEntity();
        List formulaFuncsDestList = BOTPFormulaEngineTools.getFormulaFuncsList(destEntity);
        if (formulaFuncsDestList != null && formulaFuncsDestList.size() > 0) {
            int size = formulaFuncsDestList.size();
            for (int i = 0; i < size; ++i) {
                botTransformSqle.addFunctionProvider((IBotSQLFunctions)formulaFuncsDestList.get(i));
            }
        }
        if ((formulaFuncsSrcList = BOTPFormulaEngineTools.getFormulaFuncsList(botMappingInfo.getSrcEntity())) != null && formulaFuncsSrcList.size() > 0) {
            int size = formulaFuncsSrcList.size();
            for (int i = 0; i < size; ++i) {
                botTransformSqle.addFunctionProvider((IBotSQLFunctions)formulaFuncsSrcList.get(i));
            }
        }
    }

    private static List getFormulaFuncsList(EntityObjectInfo destEntity) {
        if (destEntity == null) {
            return null;
        }
        ArrayList<IBotSQLFunctions> formulaFuncsSrcList = new ArrayList<IBotSQLFunctions>();
        String billFormulaClassStr = destEntity.getExtendedProperty(BOTP_FUNC_EXTPROPNAME);
        if (StringUtils.isEmpty((String)billFormulaClassStr)) {
            return null;
        }
        String[] billFormulaClass = StringUtils.split((String)billFormulaClassStr, (String)";");
        for (int i = 0; i < billFormulaClass.length; ++i) {
            String bizClassName = billFormulaClass[i].trim();
            if (StringUtils.isEmpty((String)bizClassName)) continue;
            try {
                Class<?> billFormula = Class.forName(bizClassName);
                Object clzObj = billFormula.newInstance();
                if (clzObj == null || !(clzObj instanceof IBotSQLFunctions)) continue;
                IBotSQLFunctions funcInstance = (IBotSQLFunctions)clzObj;
                formulaFuncsSrcList.add(funcInstance);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage());
                continue;
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
                continue;
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return formulaFuncsSrcList;
    }

    private static void addEntityFormulaFunction(Context ctx, BOTTransformSQLE botTransform, BOTMappingCollection botMappingCols) throws DataAccessException, IOException, KScriptException {
        Iterator botMappingIter = botMappingCols.iterator();
        while (botMappingIter.hasNext()) {
            BOTMappingInfo botMappingInfo = (BOTMappingInfo)botMappingIter.next();
            BOTPFormulaEngineTools.innerAddEntityFormulaFunction(ctx, botTransform, botMappingInfo.getDestEntity());
            BOTPFormulaEngineTools.innerAddEntityFormulaFunction(ctx, botTransform, botMappingInfo.getSrcEntity());
        }
    }

    private static void innerAddEntityFormulaFunction(Context ctx, BOTTransformSQLE botTransform, EntityObjectInfo entity) throws DataAccessException, IOException, KScriptException {
        if (entity == null) {
            return;
        }
        String billFormulaClassStr = entity.getExtendedProperty("boteSqleFunctionClass");
        if (billFormulaClassStr != null && billFormulaClassStr.length() > 0) {
            String[] billFormulaClass = StringUtils.split((String)billFormulaClassStr, (String)";");
            for (int i = 0; i < billFormulaClass.length; ++i) {
                if (billFormulaClass[i].trim().equals("")) continue;
                try {
                    Class<?> billFormula = Class.forName(billFormulaClass[i].trim());
                    IBotSQLFunctions funcInstance = (IBotSQLFunctions)billFormula.newInstance();
                    if (funcInstance == null) continue;
                    botTransform.addFunctionProvider(funcInstance);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    logger.error((Object)ex.getMessage());
                    continue;
                }
                catch (InstantiationException e) {
                    logger.error((Object)e.getMessage());
                    continue;
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    public static void clearCache(Context ctx, String sessionId) {
        CacheRegion botCurrentCache;
        CacheRegion botRootCache;
        CacheRegion root = CacheEngine.getLocalRootRegion();
        if (root.exists((Object)ROOTCACHE) && (botRootCache = root.getRegion(ROOTCACHE)) != null && botRootCache.exists((Object)sessionId) && (botCurrentCache = botRootCache.getRegion(sessionId)) != null) {
            botCurrentCache.destroy();
        }
    }

    private static void addBOTPFormulaFunction(Context ctx, BOTTransformSQLE botTransform) throws DataAccessException, IOException, KScriptException {
        botTransform.addFunctionProvider(new BotpFormulaSQLEFunctions(ctx.getLocale()));
        if (SPManager.isEASInstalled()) {
            Object clz = null;
            try {
                clz = BOTPExtendInterface.getBOTP_EXTENDSQLFUNCIONS();
                if (clz == null) {
                    clz = BOTPFormulaEngineTools.getExtendFormulaFunctionClzByXML();
                }
                if (clz != null && clz instanceof IBotSQLFunctions) {
                    botTransform.addFunctionProvider((IBotSQLFunctions)clz);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"The ExtendFormulaFunction class is not found!", (Throwable)e);
            }
        }
    }

    private static Object getExtendFormulaFunctionClzByXML() {
        Object clz = null;
        try {
            clz = BOTPTools.getProviderClassObject("BOTP_EXTENDFUNCIONS");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return clz;
    }

    public static String getCurrentTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = d.format(date);
        return str;
    }

    public static Object invokeDynMethod(Object obj, String methodName, Class[] clzs, Object[] params) throws BOSException {
        if (obj == null) {
            return null;
        }
        Method mothod = null;
        try {
            mothod = obj.getClass().getMethod(methodName, clzs);
            if (mothod == null) {
                return null;
            }
            return mothod.invoke(obj, params);
        }
        catch (Exception e) {
            throw new BOSException("InvokeDynMethod error!  obj=" + obj + ",  methodName=" + methodName + ", clzs=" + clzs + ", params=" + params, (Throwable)e);
        }
    }
}

