/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.bot.trace.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.eas.base.bot.trace.util.TraceLevel;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.app.BOTAppTools;
import com.kingdee.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceConfigurator {
    private static Logger logger = LogManager.getLogger((String)"com.kingdee.eas.base.trace.botp");
    private BOTMappingInfo mappingInfo = null;

    public static Logger getLogger() {
        return logger;
    }

    public static TraceLevel getTraceLevel(BOTMappingCollection mappingInfoCol) throws BOSException {
        BOTMappingInfo mappingInfo = null;
        if (mappingInfoCol != null && mappingInfoCol.size() > 0) {
            mappingInfo = mappingInfoCol.get(0);
        }
        return TraceConfigurator.getTraceLevel(mappingInfo);
    }

    public static TraceLevel getTraceLevel(BOTMappingInfo mappingInfo) throws BOSException {
        TraceLevel level = TraceLevel.LEVEL_NO;
        if (mappingInfo != null) {
            level = TraceConfigurator.innerGetTraceControl(mappingInfo);
        }
        return level;
    }

    public static TraceLevel getTraceLevel(Context ctx, IObjectCollection relations) throws BOSException {
        BOTRelationInfo relationInfo = null;
        if (relations != null && relations.size() > 0) {
            relationInfo = (BOTRelationInfo)relations.getObject(0);
        }
        return TraceConfigurator.getTraceLevel(ctx, relationInfo);
    }

    public static TraceLevel getTraceLevel(Context ctx, BOTRelationInfo relationInfo) throws BOSException {
        if (relationInfo == null) {
            return TraceLevel.LEVEL_NO;
        }
        BOTMappingInfo mappingInfo = null;
        boolean isCrossSysRelation = false;
        try {
            isCrossSysRelation = BOTPTools.isExistCrossSysRelation(ctx, relationInfo.getDestObjectID());
        }
        catch (Exception e) {
            logger.error("fail to get CrossSysRelation", (Throwable)e);
        }
        if (!isCrossSysRelation) {
            mappingInfo = BOTAppTools.getMappingInfoByRelationInCache((Context)ctx, (BOTRelationInfo)relationInfo);
        }
        return TraceConfigurator.getTraceLevel(mappingInfo);
    }

    private static TraceLevel innerGetTraceControl(BOTMappingInfo mappingInfo) throws BOSException {
        if (mappingInfo == null) {
            throw new BOSException("Get TraceControl Error!  mappingInfo=" + mappingInfo);
        }
        String extconfig = mappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        String traceControl = "";
        try {
            if (extconfig != null && !extconfig.equals("")) {
                BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
                info = processor.marshallingExtConfig(extconfig);
                traceControl = info.getTraceControl();
                if (!StringUtils.isEmpty((String)traceControl)) {
                    return TraceLevel.getInstance(traceControl);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException("Get TraceControl Error! " + e.getMessage() + ", mappingInfo=" + mappingInfo, (Throwable)e);
        }
        return TraceLevel.LEVEL_NO;
    }
}

