/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.maintain.res.share.ResFile;
import com.kingdee.bos.maintain.res.share.Resource;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.FilterUtil;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.client.AbstractBOTMappingListUI;
import com.kingdee.eas.base.botp.client.BOTExportOptionUI;
import com.kingdee.eas.base.botp.client.BOTMappingCompareUI;
import com.kingdee.eas.base.botp.client.BOTMappingEditUI;
import com.kingdee.eas.base.botp.client.BOTMappingImportMsgBox;
import com.kingdee.eas.base.botp.client.BOTPConfigUI;
import com.kingdee.eas.base.botp.client.BOTProgressDlgUI;
import com.kingdee.eas.base.botp.client.CompareMappingInfoSelectUI;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BOTMappingListUI
extends AbstractBOTMappingListUI {
    private static Logger logger = Logger.getLogger(BOTMappingListUI.class);
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpResx";
    private static final String EFFECTEDSUCCESS = "EFFECTEDSUCCESS";
    private static final String UNEFFECTEDSUCCESS = "UNEFFECTEDSUCCESS";
    private String currentImportDir;
    private boolean isFirstQuery = true;
    public static final String ACTIONKEY_DAP = "DAP";
    protected DAPMutiBillShortcutListener showDAP = new DAPMutiBillShortcutListener("DAP");
    private static String handlerName = "com.kingdee.eas.base.botp.app.BOTMappingListUIHandler";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return BOTMappingEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BOTMappingFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    private DefineSysEnum getDefineSys() {
        if (ACTIONKEY_DAP.equals(this.getUIContext().get("UIClassParam"))) {
            return DefineSysEnum.DAP;
        }
        if ("BTP".equals(this.getUIContext().get("UIClassParam"))) {
            return DefineSysEnum.BTP;
        }
        return null;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1) {
            if (this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("extRule.isEffected") != null) {
                boolean isEnabled = (Boolean)this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("extRule.isEffected").getValue();
                this.changeBTEnabeld(isEnabled);
            }
        } else {
            this.disabledBT();
        }
    }

    private void changeBTEnabeld(boolean isEnabled) {
        this.btnEnable.setEnabled(!isEnabled);
        this.btnDisable.setEnabled(isEnabled);
    }

    private void disabledBT() {
        this.btnEnable.setEnabled(false);
        this.btnDisable.setEnabled(false);
    }

    @Override
    protected void tree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.tree_valueChanged(e);
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode == null) {
            return;
        }
        FilterInfo filterInfo = this.initFilterItem(treeNode);
        if (this.getDefineSys() != null) {
            FilterItemInfo defineSysFilterItem = new FilterItemInfo("defineSys", (Object)new Integer(this.getDefineSys().getValue()));
            FilterUtil.mergeQueryFilter(filterInfo, defineSysFilterItem);
        }
        if (!this.isFirstQuery) {
            this.mainQuery.setFilter(filterInfo);
        }
        this.mainQuery = this.getEntityViewInfoForMe(this.mainQuery);
        this.refreshList();
        this.isFirstQuery = false;
    }

    private FilterInfo initFilterItem(DefaultKingdeeTreeNode treeNode) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)treeNode.getUserObject();
        String rootPk = briefInfo.getFullName();
        ArrayList<String> list = new ArrayList<String>();
        if (briefInfo.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            list.add(rootPk);
        } else if (briefInfo.isPackage()) {
            BOTMappingListUI.initEntityBriefList(list, treeNode);
            rootPk = briefInfo.getPackgeName();
        }
        if (list.size() > 0) {
            ArrayList<String> equalList = new ArrayList<String>();
            for (String pk : list) {
                if (pk.startsWith(rootPk)) continue;
                equalList.add(pk);
            }
            filter.getFilterItems().add(new FilterItemInfo("srcEntityFullName", (Object)(rootPk + "%"), CompareType.LIKE));
            if (equalList.size() > 0) {
                String strLists = StringUtils.arrayToString((Object[])equalList.toArray(), (String)",");
                filter.getFilterItems().add(new FilterItemInfo("srcEntityFullName", (Object)strLists, CompareType.INCLUDE));
                filter.setMaskString("#0 or #1");
            }
        }
        return filter;
    }

    private EntityViewInfo getEntityViewInfoForMe(EntityViewInfo QueryFilter) throws BOSException {
        FilterInfo filterCU = this.getDefaultFilterForQuery();
        if (filterCU != null && filterCU.getFilterItems().size() > 0) {
            if (QueryFilter.getFilter() != null && QueryFilter.getFilter().getFilterItems().size() > 0 && !QueryFilter.getFilter().toString().equals("")) {
                FilterItemCollection filters = QueryFilter.getFilter().getFilterItems();
                boolean hasCUFilter = false;
                for (int i = 0; i < filters.size(); ++i) {
                    if (!filters.get(i).getPropertyName().equals("CU.id")) continue;
                    hasCUFilter = true;
                    break;
                }
                if (!hasCUFilter) {
                    QueryFilter.getFilter().mergeFilter(filterCU, "AND");
                }
            } else {
                QueryFilter.setFilter(filterCU);
            }
        }
        return QueryFilter;
    }

    private static void initEntityBriefList(List list, DefaultKingdeeTreeNode treeNode) {
        if (treeNode.getParent() == null) {
            return;
        }
        int count = treeNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
            MetaDataBriefInfo childBriefInfo = (MetaDataBriefInfo)childNode.getUserObject();
            if (childBriefInfo.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
                list.add(childBriefInfo.getFullName());
            }
            if (!childBriefInfo.isPackage()) continue;
            BOTMappingListUI.initEntityBriefList(list, childNode);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = (RequestContext)clientHanlder.getRequestContext();
        request.put("BOTMappingListUI_init_mdbViewName", (Object)"com_kingdee_eas_base_botp");
        return clientHanlder;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if (BOTPTools.isCtrlUintAuthor(null)) {
            try {
                return this.getUpperCUFilter();
            }
            catch (BOSException e) {
                return null;
            }
        }
        return super.getDefaultFilterForQuery();
    }

    public FilterInfo getUpperCUFilter() throws BOSException {
        CtrlUnitInfo currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
        String orgLongNumber = currentCU.getLongNumber();
        Object[] orgLongNumbers = orgLongNumber.split("!");
        FilterInfo filterInfo = new FilterInfo();
        String strNumberLists = StringUtils.arrayToString((Object[])orgLongNumbers, (String)",");
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)strNumberLists, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.setFilter(filterInfo);
        CtrlUnitCollection cucol = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(entityViewInfo);
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < cucol.size(); ++i) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cucol.get(i).getId().toString()));
            if (i != 0) {
                maskString.append(" or ");
            }
            maskString.append("#" + i);
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public void onLoad() throws Exception {
        IColumn col;
        super.onLoad();
        this.setBtnShareFromCloud();
        if (BOTPTools.isCtrlUintAuthor(null)) {
            FilterInfo filter = this.getUpperCUFilter();
            this.mainQuery.getFilter().mergeFilter(filter, "or");
        }
        this.tblMain.getSelectManager().setSelectMode(10);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnRuleCompare.setIcon(EASResource.getIcon((String)"imgTbtn_analyze"));
        this.btnRemove.setEnabled(true);
        this.actionImportRule.setEnabled(true);
        this.actionExportRule.setEnabled(true);
        this.actionExportAll.setEnabled(true);
        if (this.getDefineSys() != null) {
            this.setUITitle(this.getDefineSys().getAlias());
        }
        if (this.getDefineSys() != null) {
            col = this.tblMain.getColumn("defineSys");
            col.getStyleAttributes().setHided(true);
        }
        if (DefineSysEnum.BTP.equals((Object)this.getDefineSys())) {
            col = this.tblMain.getColumn("org.name");
            col.getStyleAttributes().setHided(true);
        }
        IBriefViewTreeNode vtn = SubSystemUtils.getSubSystemByName((String)this.getSubSystemName(), (BOSObjectType)MetaDataTypeList.ENTITY);
        IBriefViewTreeNode rvtn = SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)vtn);
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)rvtn);
        ((KingdeeTreeModel)this.tree.getModel()).setRoot((TreeNode)root);
        this.tblMain.setColumnMoveable(true);
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f12 = KeyStroke.getKeyStroke(123, 3);
        imEntry.put(ctrl_shift_f12, ACTIONKEY_DAP);
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put(ACTIONKEY_DAP, this.showDAP);
        this.addBOTPConfigUIListener();
    }

    public void onShow() throws Exception {
        this.tree.setSelectionRow(0);
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDapFromMulti.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.actionDapFromMulti.setEnabled(true);
        if (!SPManager.isEASInstalled()) {
            this.btnDapFromMulti.setVisible(false);
        }
        this.btnLocate.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.menuItemLocate.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (e.getSource().equals(this.btnAddNew)) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
            if (treeNode == null) {
                return;
            }
            MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)treeNode.getUserObject();
            EntityObjectInfo srcEntity = SubSystemUtils.getEntityObjectInfo((MetaDataBriefInfo)briefInfo);
            if (srcEntity != null) {
                uiContext.put((Object)"srcEntity", (Object)srcEntity);
            }
            if (this.getDefineSys() != null) {
                uiContext.put((Object)"defineSys", (Object)this.getDefineSys());
            }
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    @Override
    public RequestContext prepareActionDisable(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionDisable(itemAction);
        RequestContext requestQuery = this.prepareQueryContext(null);
        request.putAll(requestQuery);
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String mappingId = row.getCell(this.getKeyFieldName()).getValue().toString();
        String currentCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        request.put("BOTMappingListUI_ActionDisable_mappingId", (Object)mappingId);
        request.put("BOTMappingListUI_ActionDisable_currentCU", (Object)currentCU);
        ArrayList pks = this.getSelectedMappingPKs();
        request.put("BOTMappingListUI_ActionDisable_pks", (Object)pks);
        return request;
    }

    @Override
    public boolean isPrepareActionDisable() {
        return false;
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        super.actionDisable_actionPerformed(e);
        ArrayList pks = this.getSelectedMappingPKs();
        String currentCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        ((IBOTMapping)this.getBizInterface()).disableMapping(currentCU, pks);
        this.refresh(e);
        this.showEffectedStatus(false);
        this.tblMain.getSelectManager().add(selectBlock);
    }

    private void showEffectedStatus(boolean isEffected) {
        String msg = isEffected ? EASResource.getString((String)RESXFILENAME, (String)EFFECTEDSUCCESS) : EASResource.getString((String)RESXFILENAME, (String)UNEFFECTEDSUCCESS);
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    public RequestContext prepareActionEnable(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionDisable(itemAction);
        RequestContext requestQuery = this.prepareQueryContext(null);
        request.putAll(requestQuery);
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String mappingId = row.getCell(this.getKeyFieldName()).getValue().toString();
        String currentCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        request.put("BOTMappingListUI_ActionEnable_mappingId", (Object)mappingId);
        request.put("BOTMappingListUI_ActionEnable_currentCU", (Object)currentCU);
        ArrayList pks = this.getSelectedMappingPKs();
        request.put("BOTMappingListUI_ActionEnable_pks", (Object)pks);
        return request;
    }

    @Override
    public boolean isPrepareActionEnable() {
        return false;
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        super.actionEnable_actionPerformed(e);
        ArrayList pks = this.getSelectedMappingPKs();
        String currentCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        ((IBOTMapping)this.getBizInterface()).enableMapping(currentCU, pks);
        this.refresh(e);
        this.showEffectedStatus(true);
        this.tblMain.getSelectManager().add(selectBlock);
    }

    private ArrayList getSelectedMappingPKs() {
        ArrayList<Object> pks = new ArrayList<Object>();
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                int begin = sb.getTop();
                int end = sb.getBottom();
                for (int j = begin; j <= end; ++j) {
                    IRow row = this.tblMain.getRow(j);
                    ICell cell = row.getCell(this.getKeyFieldName());
                    if (cell == null) continue;
                    pks.add(cell.getValue());
                }
            }
        }
        return pks;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExportAll.setIcon(EASResource.getIcon((String)"imgTbtn_applycondition"));
        this.menuItemImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnShareFromCloud.setIcon(EASResource.getIcon((String)"imgTbtn_duizsetting"));
    }

    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionDisable(itemAction);
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String mappingId = row.getCell(this.getKeyFieldName()).getValue().toString();
        String currentCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        request.put("BOTMappingListUI_ActionRemove_mappingId", (Object)mappingId);
        request.put("BOTMappingListUI_ActionRemove_currentCU", (Object)currentCU);
        ArrayList pks = this.getSelectedMappingPKs();
        request.put("BOTMappingListUI_ActionRemove_pks", (Object)pks);
        return request;
    }

    public boolean isPrepareActionRemove() {
        return false;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.chechCuOrgBeforeAction()) {
            MsgBox.showError((String)EASResource.getString((String)RESXFILENAME, (String)"Msg_Must_CurrentCuOrg"));
            return;
        }
        super.actionRemove_actionPerformed(e);
        this.tblMain_tableSelectChanged(null);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"alias", "name"};
        return locateNames;
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionEdit(itemAction);
        RequestContext requestQuery = this.prepareQueryContext(null);
        request.putAll(requestQuery);
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        String mappingId = row.getCell(this.getKeyFieldName()).getValue().toString();
        String currentCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        request.put("BOTMappingListUI_ActionEdit_mappingId", (Object)mappingId);
        request.put("BOTMappingListUI_ActionEdit_currentCU", (Object)currentCU);
        return request;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    public RequestContext prepareActionView(IItemAction itemAction) throws Exception {
        this.checkSelected();
        RequestContext request = super.prepareActionView(itemAction);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        request.put("BOTMappingListUI_ActionView_mappingId", (Object)pk);
        return request;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.chechCuOrgBeforeAction()) {
            String releaseID = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
            MsgBox.showError((String)EASResource.getString((String)RESXFILENAME, (String)"Msg_Must_CurrentCuOrg"));
            MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(releaseID);
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected boolean chechCuOrgBeforeAction() throws Exception {
        boolean canDoAction = false;
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        if (row == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        String mappingId = row.getCell(this.getKeyFieldName()).getValue().toString();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)mappingId));
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("CU"));
        IBOTMapping iBM = BOTMappingFactory.getRemoteInstance();
        BOTMappingInfo mapping = iBM.getValueNoChild((IObjectPK)pk);
        String currentCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String mappingCU = mapping.getCU().getId().toString();
        canDoAction = mappingCU.equals(currentCU);
        return canDoAction;
    }

    protected boolean chechCuOrgBeforeActionBatch(List mappingIdList) throws Exception {
        for (int i = 0; i < mappingIdList.size(); ++i) {
            String mappingId = (String)mappingIdList.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)mappingId));
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("CU"));
            IBOTMapping iBM = BOTMappingFactory.getRemoteInstance();
            BOTMappingInfo mapping = iBM.getValueNoChild((IObjectPK)pk);
            String currentCU = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            String mappingCU = mapping.getCU().getId().toString();
            if (mappingCU.equals(currentCU)) continue;
            return false;
        }
        return true;
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    @Override
    public void actionDapFromMulti_actionPerformed(ActionEvent e) throws Exception {
        if (!SPManager.isEASInstalled()) {
            return;
        }
        super.actionDapFromMulti_actionPerformed(e);
        UIContext uiCtx = new UIContext((Object)this);
        Class clz = BOTPTools.getProviderClass("BOTP_DAPFROMMULTIBILLUI");
        if (clz == null) {
            return;
        }
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(clz.getName(), (Map)uiCtx);
        uiWin.show();
    }

    @Override
    public void actionRuleCompare_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        IBOTMapping iBotMapping = BOTMappingFactory.getRemoteInstance();
        String botId = (String)idList.get(0);
        BOTMappingInfo currentMappingInfo = iBotMapping.getBOTMappingInfo((IObjectPK)new ObjectStringPK(botId));
        String sFileName = null;
        File[] files = null;
        if (this.currentImportDir == null || !new File(this.currentImportDir).exists()) {
            this.currentImportDir = System.getProperty("user.home");
        }
        KDFileChooser choose = new KDFileChooser(this.currentImportDir);
        SimpleFileFilter ff = new SimpleFileFilter(new String[]{"xml"});
        choose.setMultiSelectionEnabled(true);
        choose.setFileFilter((FileFilter)ff);
        int rVal = choose.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            files = choose.getSelectedFiles();
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                File file = files[i];
                if (!file.exists()) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.FILENOTEXISTS"));
                    return;
                }
                sFileName = file.getAbsolutePath();
                if (sFileName.lastIndexOf("\\") > 0) {
                    this.currentImportDir = sFileName.substring(0, sFileName.lastIndexOf("\\"));
                } else if (sFileName.lastIndexOf("/") > 0) {
                    this.currentImportDir = sFileName.substring(0, sFileName.lastIndexOf("/"));
                }
                String name = choose.getSelectedFile().getName();
                Pattern pattern = Pattern.compile("[/:\\*\\?<>\\|\"]");
                Matcher match = pattern.matcher(name);
                if (match.find()) {
                    throw new BOTPException(BOTPException.FILENAMEILLEGAL, new Object[]{name});
                }
                String fileType = sFileName.substring(sFileName.length() - 3, sFileName.length());
                if (fileType.equalsIgnoreCase("xml")) continue;
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.FILEFORMATCANONLYBEXML"));
                return;
            }
        }
        if (files != null) {
            BOTCompareRun work = new BOTCompareRun();
            work.setOldMappingInfo(currentMappingInfo);
            work.setFiles(files);
            work.setOwner(this);
            work.start();
        }
    }

    @Override
    public RequestContext prepareActionImportRule(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionImportRule(itemAction);
        RequestContext requestQuery = this.prepareQueryContext(null);
        request.putAll(requestQuery);
        return request;
    }

    @Override
    public boolean isPrepareActionImportRule() {
        return false;
    }

    @Override
    public void actionImportRule_actionPerformed(ActionEvent e) throws Exception {
        String sFileName = null;
        File[] files = null;
        if (this.currentImportDir == null || !new File(this.currentImportDir).exists()) {
            this.currentImportDir = System.getProperty("user.home");
        }
        KDFileChooser choose = new KDFileChooser(this.currentImportDir);
        SimpleFileFilter ff = new SimpleFileFilter(new String[]{"xml"});
        choose.setMultiSelectionEnabled(true);
        choose.setFileFilter((FileFilter)ff);
        int rVal = choose.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            files = choose.getSelectedFiles();
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                File file = files[i];
                if (!file.exists()) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.FILENOTEXISTS"));
                    return;
                }
                sFileName = file.getAbsolutePath();
                if (sFileName.lastIndexOf("\\") > 0) {
                    this.currentImportDir = sFileName.substring(0, sFileName.lastIndexOf("\\"));
                } else if (sFileName.lastIndexOf("/") > 0) {
                    this.currentImportDir = sFileName.substring(0, sFileName.lastIndexOf("/"));
                }
                String name = choose.getSelectedFile().getName();
                Pattern pattern = Pattern.compile("[/:\\*\\?<>\\|\"]");
                Matcher match = pattern.matcher(name);
                if (match.find()) {
                    throw new BOTPException(BOTPException.FILENAMEILLEGAL, new Object[]{name});
                }
                String fileType = sFileName.substring(sFileName.length() - 3, sFileName.length());
                if (fileType.equalsIgnoreCase("xml")) continue;
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.FILEFORMATCANONLYBEXML"));
                return;
            }
        }
        if (files != null) {
            BOTImportRun work = new BOTImportRun();
            work.setFiles(files);
            work.setOwner(this);
            UIContext uiContext = new UIContext((Object)this);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.botp.client.BOTProgressDlgUI", (Map)uiContext);
            BOTProgressDlgUI progressUI = (BOTProgressDlgUI)uiWindow.getUIObject();
            work.setProgressDlgUI(progressUI);
            progressUI.setAction(work);
            uiWindow.show();
            if (progressUI.getResult()) {
                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.IMPORTSUCCESS") + work.countSuc + EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.IMPORTCOUNT") + "," + EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.IMPORTFAIL") + work.countFail + EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.IMPORTCOUNT") + "!"));
                this.refreshList();
            }
        }
    }

    @Override
    public RequestContext prepareActionExportRule(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionExportRule(itemAction);
        RequestContext requestQuery = this.prepareQueryContext(null);
        request.putAll(requestQuery);
        return request;
    }

    @Override
    public boolean isPrepareActionExportRule() {
        return false;
    }

    @Override
    public void actionExportRule_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("kdtable", this.tblMain);
        uiContext.put("idList", this.getSelectedIdValues());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BOTExportOptionUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionExportAll_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityName", null, CompareType.NOTEQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("destEntityName"));
        evi.getSelector().add(new SelectorItemInfo("defineSys"));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.BOTMappingQuery"));
        exec.setObjectView(evi);
        IRowSet rs = exec.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                idList.add(rs.getString("id"));
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("kdtable", this.tblMain);
        uiContext.put("idList", idList);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BOTExportOptionUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    public IUIActionPostman prepareRPC(RequestContext request) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(true);
        request.setClassName(handlerName);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    protected String getEditUIModal() {
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)).getClass().getName().equals("com.kingdee.eas.base.uiframe.client.MainFrame")) {
            return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    private void addBOTPConfigUIListener() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F9"), "actionOpenConfig");
        this.getActionMap().put("actionOpenConfig", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContext uiContext = new UIContext((Object)this);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BOTPConfigUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                    uiWindow.show();
                }
                catch (UIException uIException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl shift S"), "actionOpenSrc");
        this.getActionMap().put("actionOpenSrc", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContext uiContext = new UIContext((Object)this);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.bos.metadata.test.client.SrctBillListUI", (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                }
                catch (UIException uIException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl shift D"), "actionOpenDest");
        this.getActionMap().put("actionOpenDest", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContext uiContext = new UIContext((Object)this);
                IUIWindow uiWindow = null;
                try {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.bos.metadata.test.client.DestBillListUI", (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                }
                catch (UIException uIException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F11"), "actionUploadToShare");
        this.getActionMap().put("actionUploadToShare", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BOTMappingListUI.this.actionUploadToShare_actionPerformed(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    @Override
    public void actionShareFromCloud_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"type", (Object)"103");
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.bos.maintain.res.share.client.ResShareCenterUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException uIException) {
            // empty catch block
        }
        this.refreshList();
    }

    @Override
    public void actionUploadToShare_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Resource resource = this.getResource();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"type", (Object)"103");
        uiContext.put((Object)"share", (Object)resource);
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.bos.maintain.res.share.client.ResShareNewUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException uIException) {
            // empty catch block
        }
    }

    public BOTMappingCollection getMappingInfoList() throws BOSException {
        ArrayList idlist = this.getSelectedIdValues();
        IBOTMapping iBotMapping = BOTMappingFactory.getRemoteInstance();
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        StringBuffer mask = new StringBuffer();
        for (int j = 0; j < idlist.size(); ++j) {
            String botId = (String)idlist.get(j);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)botId));
            if (j == 0) {
                mask.append("#");
            } else {
                mask.append(" or #");
            }
            mask.append(j);
        }
        if (mask.toString().length() > 0) {
            filter.setMaskString(mask.toString());
            botMappingCols = iBotMapping.getBOTMappingCollection(evi);
        }
        return botMappingCols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResource() throws BOSException {
        BOTMappingCollection mappingList = this.getMappingInfoList();
        Resource res = new Resource("");
        ResFile resfile = new ResFile();
        Object treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode == null) {
            SysUtil.abort();
        }
        res.name = "";
        do {
            res.name = treeNode.toString() + "-" + res.name;
        } while ((treeNode = treeNode.getParent()) != null);
        res.updateTime = new Date().toString();
        res.desc = "";
        resfile.fileName = "";
        resfile.fileDesc = "";
        res.profile = "";
        for (int i = 0; i < mappingList.size() && i < 4; ++i) {
            BOTMappingInfo info = mappingList.get(i);
            res.desc = res.desc + info.getAlias() + ";";
            res.profile = res.profile + info.getAlias() + ";";
            resfile.fileName = resfile.fileName + info.getName() + ";";
            resfile.fileDesc = resfile.fileDesc + (info.getDescription() == null ? "" : info.getDescription()) + ";";
        }
        String fileName = System.getProperty("user.home") + File.separator + "TEMPNAME.xml";
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        int n = 0;
        try {
            File file = new File(fileName);
            BOTMappingInfo.writerBOTMappingCollectionToFile(mappingList, fileName);
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream(100000);
            byte[] b = new byte[100000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            resfile.fileContent = bos.toByteArray();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                logger.error((Object)"error to close IO!");
            }
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        res.files.add(resfile);
        return res;
    }

    private void setBtnShareFromCloud() {
        this.btnShareFromCloud.setEnabled(false);
        this.btnShareFromCloud.setVisible(false);
        this.btnUploadToShareCenter.setEnabled(false);
        this.btnUploadToShareCenter.setVisible(false);
    }

    protected String getSubSystemName() {
        return "com_kingdee_eas_base_botp";
    }

    public void actionSync_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (treeNode == null) {
            return;
        }
        MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)treeNode.getUserObject();
        String bosType = briefInfo.getBOType().toString();
        BOTSyncBillAndRelation work = new BOTSyncBillAndRelation();
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.botp.client.BOTProgressDlgUI", (Map)uiContext);
        BOTProgressDlgUI progressDlgUI = (BOTProgressDlgUI)uiWindow.getUIObject();
        progressDlgUI.setUITitle("\u540c\u6b65\u5355\u636e\u4e0e\u5173\u8054\u5173\u7cfb");
        work.setProgressDlgUI(progressDlgUI);
        work.setBosType(bosType);
        progressDlgUI.setAction(work);
        uiWindow.show();
    }

    class BOTSyncBillAndRelation
    implements Runnable {
        BOTProgressDlgUI progressDlgUI;
        String bosType;

        BOTSyncBillAndRelation() {
        }

        @Override
        public void run() {
            try {
                IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
                iBTPManager.syncBillAndRelation(this.bosType);
            }
            catch (Exception e) {
                BOTMappingListUI.this.handleException(e);
            }
            finally {
                this.progressDlgUI.stop();
                this.progressDlgUI.getUIWindow().close();
            }
        }

        public BOTProgressDlgUI getProgressDlgUI() {
            return this.progressDlgUI;
        }

        public void setProgressDlgUI(BOTProgressDlgUI progressDlgUI) {
            this.progressDlgUI = progressDlgUI;
        }

        public String getBosType() {
            return this.bosType;
        }

        public void setBosType(String bosType) {
            this.bosType = bosType;
        }
    }

    class BOTCompareRun
    implements Runnable {
        String fileName;
        File[] files;
        BOTMappingListUI owner;
        BOTMappingInfo oldMappingInfo;
        BOTMappingInfo newMappingInfo;

        BOTCompareRun() {
        }

        public void start() {
            Thread thread = new Thread(this);
            thread.start();
        }

        @Override
        public void run() {
            try {
                this.exec();
            }
            catch (Exception e) {
                BOTMappingListUI.this.handleException(e);
            }
        }

        public void exec() throws Exception {
            IUIWindow window;
            BOTMappingCollection botMappingCols = null;
            try {
                botMappingCols = BOTMappingInfo.readBOTMappingColsFromFile(this.files);
            }
            catch (Exception ex) {
                throw new BOTPException(BOTPException.FILEHASNOMAPPING);
            }
            if (botMappingCols == null || botMappingCols.size() == 0) {
                throw new BOTPException(BOTPException.FILEHASNOMAPPING);
            }
            String srcName = this.oldMappingInfo.getSrcEntityFullName();
            String destName = this.oldMappingInfo.getDestEntityFullName();
            BOTMappingCollection suitBotMappingCols = new BOTMappingCollection();
            for (int i = 0; i < botMappingCols.size(); ++i) {
                BOTMappingInfo tempInfo = botMappingCols.get(i);
                if (!tempInfo.getSrcEntityFullName().equals(srcName) || !tempInfo.getDestEntityFullName().equals(destName)) continue;
                suitBotMappingCols.add(tempInfo);
            }
            if (suitBotMappingCols == null || suitBotMappingCols.size() == 0) {
                throw new BOTPException(BOTPException.FILEHASNOMAPPINGORSUIT);
            }
            if (suitBotMappingCols.size() > 1) {
                HashMap<String, Object> uiContext = new HashMap<String, Object>();
                uiContext.put("Owner", this);
                uiContext.put("BOTMappings", (Object)suitBotMappingCols);
                window = null;
                window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CompareMappingInfoSelectUI.class.getName(), uiContext, null);
                window.show();
                if (((CompareMappingInfoSelectUI)window.getUIObject()).isCanceled() || ((CompareMappingInfoSelectUI)window.getUIObject()).getSelectBotMappingInfo() == null) {
                    return;
                }
                this.newMappingInfo = ((CompareMappingInfoSelectUI)window.getUIObject()).getSelectBotMappingInfo();
            } else {
                this.newMappingInfo = suitBotMappingCols.get(0);
            }
            HashMap<String, Object> uiContext = new HashMap<String, Object>();
            uiContext.put("Owner", this);
            uiContext.put("oldMappingInfo", this.oldMappingInfo);
            uiContext.put("newMappingInfo", this.newMappingInfo);
            window = null;
            window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BOTMappingCompareUI.class.getName(), uiContext, null);
            window.show();
        }

        public File[] getFiles() {
            return this.files;
        }

        public void setFiles(File[] files) {
            this.files = files;
        }

        public BOTMappingListUI getOwner() {
            return this.owner;
        }

        public void setOwner(BOTMappingListUI owner) {
            this.owner = owner;
        }

        public void setOldMappingInfo(BOTMappingInfo oldMappingInfo) {
            this.oldMappingInfo = oldMappingInfo;
        }
    }

    class BOTImportRun
    implements Runnable {
        String fileName;
        File[] files;
        BOTMappingListUI owner;
        BOTProgressDlgUI progressDlgUI;
        int countSuc = 0;
        int countFail = 0;

        BOTImportRun() {
        }

        @Override
        public void run() {
            try {
                this.exec();
            }
            catch (Exception e) {
                BOTMappingListUI.this.handleException(e);
            }
            finally {
                this.progressDlgUI.stop();
                this.progressDlgUI.getUIWindow().close();
            }
        }

        public void exec() throws Exception {
            int i;
            IUIWindow uiWindow = null;
            BOTMappingCollection botMappingCols = null;
            try {
                botMappingCols = BOTMappingInfo.readBOTMappingColsFromFile(this.files);
            }
            catch (Exception ex) {
                throw new BOTPException(BOTPException.FILEHASNOMAPPING);
            }
            if (botMappingCols == null || botMappingCols.size() == 0) {
                throw new BOTPException(BOTPException.FILEHASNOMAPPING);
            }
            IBOTMapping iBot = BOTMappingFactory.getRemoteInstance();
            CtrlUnitInfo currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
            int count = botMappingCols.size();
            boolean existName = false;
            boolean firstShow = true;
            int isdisEnable = 0;
            int countSuccess = 0;
            for (i = 0; i < count; ++i) {
                BOTMappingInfo botMappingInfo = botMappingCols.get(i);
                if (firstShow && botMappingInfo.getDefineSys() != null && botMappingInfo.getDefineSys().equals((Object)DefineSysEnum.DAP)) {
                    if (firstShow) {
                        isdisEnable = MsgBox.showConfirm2((String)EASResource.getString((String)BOTMappingListUI.RESXFILENAME, (String)"IMPORTDAPRULES"));
                        firstShow = false;
                    }
                    if (isdisEnable == 0) {
                        botMappingInfo.getExtRule().setIsEffected(false);
                    }
                }
                BOSUuid botId = botMappingInfo.getId();
                RequestContext request = new RequestContext();
                request.put("BOTMappingListUI_ActionImportRule_mappingInfo", (Object)botMappingInfo);
                request.put("BOTMappingListUI_ActionImportRule_currentCU", (Object)currentCU);
                request.setMethodName("handleImport");
                BOTMappingListUI.this.prepareRPC(request).callHandler();
                if (botId != null && botId.toString().length() > 0) {
                    if (iBot.exists((IObjectPK)new ObjectUuidPK(botId))) {
                        BOTMappingImportMsgBox msgBox;
                        if (uiWindow == null) {
                            UIContext uiContext = new UIContext((Object)this.progressDlgUI);
                            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                            uiWindow = uiFactory.create("com.kingdee.eas.base.botp.client.BOTMappingImportMsgBox", (Map)uiContext);
                        }
                        if ((msgBox = (BOTMappingImportMsgBox)uiWindow.getUIObject()).isNextShow()) {
                            String msgForShow = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.BOTPMAPPINGDUPALARM"), botMappingInfo.getName());
                            msgBox.setMsgForShow(msgForShow);
                            uiWindow.show();
                        }
                        if (msgBox.getResult() == BOTMappingImportMsgBox.EXIT) break;
                        if (msgBox.getResult() == BOTMappingImportMsgBox.SKIP) continue;
                        if (msgBox.getResult() != BOTMappingImportMsgBox.CONFIRM) break;
                        this.validateCU(botMappingInfo);
                        iBot.update((IObjectPK)new ObjectUuidPK(botId), (CoreBaseInfo)botMappingInfo);
                        ++countSuccess;
                        continue;
                    }
                    existName = iBot.exists("where name='" + botMappingInfo.getName() + "' or alias='" + botMappingInfo.getAlias() + "'");
                    if (existName) {
                        BOTMappingCollection botCol = iBot.getBOTMappingCollection("select id,cu.name where name='" + botMappingInfo.getName() + "' or alias='" + botMappingInfo.getAlias() + "'");
                        String custr = "";
                        for (int j = 0; j < botCol.size(); ++j) {
                            BOTMappingInfo info = botCol.get(j);
                            custr = j == 0 ? info.getCU().getName() : custr + "," + info.getCU().getName();
                        }
                        if (uiWindow == null) {
                            UIContext uiContext = new UIContext((Object)this.progressDlgUI);
                            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                            uiWindow = uiFactory.create("com.kingdee.eas.base.botp.client.BOTMappingImportMsgBox", (Map)uiContext);
                        }
                        String msgForShow = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.5_BOTMappingListUI"), custr, botMappingInfo.getAlias());
                        MsgBox.showWarning((String)msgForShow);
                        continue;
                    }
                    this.validateCU(botMappingInfo);
                    try {
                        iBot.addnew((IObjectPK)new ObjectUuidPK(botId), (CoreBaseInfo)botMappingInfo);
                        ++countSuccess;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        logger.error((Object)("-----------------\u6e05\u9664deleteUselessData \uff1a" + botId));
                        this.deleteUselessData();
                        iBot.addnew((IObjectPK)new ObjectUuidPK(botId), (CoreBaseInfo)botMappingInfo);
                        ++countSuccess;
                    }
                    continue;
                }
                this.validateCU(botMappingInfo);
                try {
                    iBot.addnew((IObjectPK)new ObjectUuidPK(botId), (CoreBaseInfo)botMappingInfo);
                    ++countSuccess;
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    this.deleteUselessData();
                    iBot.addnew((IObjectPK)new ObjectUuidPK(botId), (CoreBaseInfo)botMappingInfo);
                    ++countSuccess;
                }
            }
            if (i == count && count > 0) {
                this.progressDlgUI.setResult(true);
                this.countSuc = countSuccess;
                this.countFail = count - countSuccess;
            }
        }

        private void deleteUselessData() throws BOSException {
        }

        private void validateCU(BOTMappingInfo botMappingInfo) {
            botMappingInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        }

        public File[] getFiles() {
            return this.files;
        }

        public void setFiles(File[] files) {
            this.files = files;
        }

        public BOTMappingListUI getOwner() {
            return this.owner;
        }

        public void setOwner(BOTMappingListUI owner) {
            this.owner = owner;
        }

        public BOTProgressDlgUI getProgressDlgUI() {
            return this.progressDlgUI;
        }

        public void setProgressDlgUI(BOTProgressDlgUI progressDlgUI) {
            this.progressDlgUI = progressDlgUI;
        }
    }

    class DAPMutiBillShortcutListener
    extends AbstractAction {
        String shortcut;

        DAPMutiBillShortcutListener(String sc) {
            this.shortcut = sc;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (BOTMappingListUI.ACTIONKEY_DAP.equals(this.shortcut)) {
                try {
                    BOTMappingListUI.this.actionDapFromMulti_actionPerformed(evt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

