/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.botp.client.AbstractBOTMappingSelectUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class BOTMappingSelectUI
extends AbstractBOTMappingSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(BOTMappingSelectUI.class);
    private boolean isCanceled = true;
    private BOTMappingCollection selectBotMappingInfos;
    private BOTMappingInfo selectBotMappingInfo;
    private BOTMappingCollection botMappingCollection;
    private boolean isMultiDAPTrans = false;
    private int selectedRow = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblBotMapping.checkParsed();
        this.tblBotMapping.getSelectManager().setSelectMode(2);
        this.tblBotMapping.getStyleAttributes().setLocked(true);
        this.tblBotMapping.getColumn("selected").setWidth(0);
        if (null != this.getUIContext().get("isMultiDAPTrans")) {
            this.isMultiDAPTrans = Boolean.valueOf(this.getUIContext().get("isMultiDAPTrans").toString());
        }
        if (this.isMultiDAPTrans) {
            this.btnMultiselect.setVisible(true);
            this.tblBotMapping.getColumn("selected").setResizeable(false);
        } else {
            this.btnMultiselect.setVisible(false);
            this.tblBotMapping.getColumn("selected").setResizeable(false);
        }
        this.btnMultiselect.addActionListener((ActionListener)new MultiselectActionListener());
        this.checkAll.addActionListener((ActionListener)new CheckAllActionListener());
        this.loadCtx();
        this.actionCancel.setEnabled(true);
        this.actionConfirm.setEnabled(true);
    }

    private void loadCtx() {
        this.tblBotMapping.removeRows();
        this.botMappingCollection = (BOTMappingCollection)((Object)this.getUIContext().get("BOTMappings"));
        if (this.botMappingCollection != null && this.botMappingCollection.size() > 0) {
            int count = this.botMappingCollection.size();
            for (int i = 0; i < count; ++i) {
                IRow row = this.tblBotMapping.addRow();
                BOTMappingInfo botMappingInfo = this.botMappingCollection.get(i);
                row.getCell("id").setValue((Object)botMappingInfo.getId());
                row.getCell("id").setUserObject((Object)botMappingInfo);
                row.getCell("name").setValue((Object)botMappingInfo.getName());
                row.getCell("alias").setValue((Object)botMappingInfo.getAlias(SysContext.getSysContext().getOriginLocale()));
                row.getCell("description").setValue((Object)botMappingInfo.getDescription(SysContext.getSysContext().getOriginLocale()));
                row.getCell("selected").setValue((Object)false);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tblBotMapping_tableClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = this.tblBotMapping.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && this.tblBotMapping.getColumn("selected").getWidth() > 0) {
            Boolean isSelected = (Boolean)this.tblBotMapping.getRow(rowIndex).getCell("selected").getValue();
            if (isSelected.booleanValue()) {
                this.tblBotMapping.getRow(rowIndex).getCell("selected").setValue((Object)false);
                --this.selectedRow;
                this.checkAll.setSelected(16);
            } else {
                this.tblBotMapping.getRow(rowIndex).getCell("selected").setValue((Object)true);
                ++this.selectedRow;
                if (this.selectedRow == this.botMappingCollection.size()) {
                    this.checkAll.setSelected(32);
                }
            }
        }
        if (e.getClickCount() == 2 && this.tblBotMapping.getColumn("selected").getWidth() <= 0) {
            this.confirmBotMappingInfo();
        }
    }

    @Override
    protected void tblBotMapping_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblBotMapping_tableSelectChanged(e);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public BOTMappingCollection getSelectBotMappingInfos() {
        return this.selectBotMappingInfos;
    }

    public void setSelectBotMappingInfos(BOTMappingCollection selectBotMappingInfos) {
        this.selectBotMappingInfos = selectBotMappingInfos;
    }

    public BOTMappingInfo getSelectBotMappingInfo() {
        return this.selectBotMappingInfo;
    }

    public void setSelectBotMappingInfo(BOTMappingCollection selectBotMappingInfos) {
        this.selectBotMappingInfo = selectBotMappingInfos.get(0);
    }

    private void confirmBotMappingInfo() {
        if (0 == this.tblBotMapping.getColumn("selected").getWidth()) {
            int rowIndex = this.tblBotMapping.getSelectManager().getActiveRowIndex();
            if (rowIndex < 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"NOMAPPINGSELECTEDINSELECTUI"));
            } else {
                BOTMappingCollection mappingCollection = new BOTMappingCollection();
                BOTMappingInfo mappingInfo = (BOTMappingInfo)this.tblBotMapping.getRow(rowIndex).getCell("id").getUserObject();
                mappingCollection.add(mappingInfo);
                this.setSelectBotMappingInfos(mappingCollection);
                this.setSelectBotMappingInfo(mappingCollection);
                this.setCanceled(false);
                this.getUIWindow().close();
            }
        } else {
            BOTMappingCollection mappingCollection = new BOTMappingCollection();
            for (int i = 0; i < this.tblBotMapping.getRowCount(); ++i) {
                if (!Boolean.valueOf(this.tblBotMapping.getRow(i).getCell("selected").getValue().toString()).booleanValue()) continue;
                BOTMappingInfo mappingInfo = (BOTMappingInfo)this.tblBotMapping.getRow(i).getCell("id").getUserObject();
                mappingCollection.add(mappingInfo);
            }
            if (0 == mappingCollection.size()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"NOMAPPINGSELECTEDINSELECTUI"));
            } else {
                this.setSelectBotMappingInfos(mappingCollection);
                this.setCanceled(false);
                this.getUIWindow().close();
            }
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.confirmBotMappingInfo();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setCanceled(true);
        this.getUIWindow().close();
    }

    class CheckAllActionListener
    implements ActionListener {
        CheckAllActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (32 == BOTMappingSelectUI.this.checkAll.getSelected()) {
                for (int i = 0; i < BOTMappingSelectUI.this.tblBotMapping.getRowCount(); ++i) {
                    BOTMappingSelectUI.this.tblBotMapping.getRow(i).getCell("selected").setValue((Object)true);
                }
            } else {
                for (int i = 0; i < BOTMappingSelectUI.this.tblBotMapping.getRowCount(); ++i) {
                    BOTMappingSelectUI.this.tblBotMapping.getRow(i).getCell("selected").setValue((Object)false);
                }
            }
        }
    }

    class MultiselectActionListener
    implements ActionListener {
        MultiselectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BOTMappingSelectUI.this.checkAll.setSelected(false);
            BOTMappingSelectUI.this.tblBotMapping.getColumn("selected").setResizeable(true);
            for (int i = 0; i < BOTMappingSelectUI.this.tblBotMapping.getRowCount(); ++i) {
                BOTMappingSelectUI.this.tblBotMapping.getRow(i).getCell("selected").setValue((Object)false);
            }
            if (BOTMappingSelectUI.this.tblBotMapping.getColumn("selected").getWidth() > 0) {
                BOTMappingSelectUI.this.tblBotMapping.getColumn("selected").setWidth(0);
                BOTMappingSelectUI.this.checkAll.setVisible(false);
            } else {
                BOTMappingSelectUI.this.tblBotMapping.getColumn("selected").setWidth(30);
                BOTMappingSelectUI.this.checkAll.setVisible(true);
            }
        }
    }
}

