/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.client.AbstractBOTMappingSorterUI;
import com.kingdee.eas.base.botp.util.BotpMetaDataFactory;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.base.commonquery.SorterSignEnum;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BOTMappingSorterUI
extends AbstractBOTMappingSorterUI {
    private static final Logger logger = CoreUIObject.getLogger(BOTMappingSorterUI.class);
    protected static final int SORTER_CONDITION = 0;
    protected static final int SORTER_SORTER_TYPE = 1;
    private boolean hasModified = false;
    private BOTMappingInfo botMappingInfo;
    private ArrayList headProperties = new ArrayList();
    private ArrayList entryProperties = new ArrayList();
    private String entryName;
    private IBotpMetaData srcBotpEntity;
    private IBotpMetaData entryBotpEntity;
    private List srcPropertyList = new ArrayList();
    private String sortfield = "";

    public String getSortfield() {
        return this.sortfield;
    }

    public List getSrcPropertyList() {
        return this.srcPropertyList;
    }

    public boolean isHasModified() {
        return this.hasModified;
    }

    public void addCommonMenusToTable(KDTable table) {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.moveDown.setEnabled(true);
        this.moveDownToBottom.setEnabled(true);
        this.moveUp.setEnabled(true);
        this.moveUpToTop.setEnabled(true);
        this.addLine.setEnabled(true);
        this.removeline.setEnabled(true);
        this.kDTableHead.checkParsed();
        this.kDTableDetail.checkParsed();
    }

    public void setBotMappingInfo(BOTMappingInfo botMappingInfo) {
        this.botMappingInfo = botMappingInfo;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo srcEntity = null;
        try {
            srcEntity = loader.getEntity(BOSObjectType.create((String)botMappingInfo.getSrcEntityName()));
        }
        catch (MetaDataNotFoundException e) {
            MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.SRCENTITYNOTEXISTINBOTMAPPING"), botMappingInfo.getSrcEntityName()));
            SysUtil.abort();
        }
        this.srcBotpEntity = BotpMetaDataFactory.createEntity(srcEntity);
        ArrayList srcBotpChildrenPropertyList = this.srcBotpEntity.getChildren();
        Iterator iter2 = srcBotpChildrenPropertyList.iterator();
        this.initProperty(this.srcBotpEntity, this.headProperties, true);
        this.entryName = this.getEntryName(srcEntity);
        if (this.entryName != null) {
            while (iter2.hasNext()) {
                IBotpMetaData childProperty = (IBotpMetaData)iter2.next();
                if (childProperty.getDetailEntity() == null || !childProperty.getName().equals(this.entryName)) continue;
                this.entryBotpEntity = childProperty;
                break;
            }
            this.initProperty(this.entryBotpEntity, this.entryProperties, true);
        } else {
            this.entryName = "null";
        }
        this.loadMapToTable();
    }

    private void loadMapToTable() {
        String sortBuffer = this.botMappingInfo.getExtRule().getSortField();
        if (sortBuffer != null && sortBuffer.length() > 0) {
            String[] sortGroup = sortBuffer.split(",");
            for (int j = 0; j < sortGroup.length; ++j) {
                IRow row;
                String[] temp = sortGroup[j].split(" ");
                if (temp[0].startsWith(this.entryName)) {
                    row = this.addRow(this.kDTableDetail, this.entryProperties);
                    temp[0] = temp[0].substring(this.entryName.length() + 1);
                    row.getCell(0).setValue((Object)this.getPropertyDisplayName(temp[0], true));
                } else {
                    row = this.addRow(this.kDTableHead, this.headProperties);
                    row.getCell(0).setValue((Object)this.getPropertyDisplayName(temp[0], false));
                }
                if (temp[1].indexOf("DESC") != -1) {
                    row.getCell(1).setValue((Object)SorterSignEnum.DESC);
                    continue;
                }
                row.getCell(1).setValue((Object)SorterSignEnum.ASC);
            }
        }
    }

    private void initProperty(IBotpMetaData entity, ArrayList properties, boolean isRoot) {
        ArrayList destBotpChildrenPropertyList = entity.getChildren();
        Iterator iter = destBotpChildrenPropertyList.iterator();
        boolean index = false;
        while (iter.hasNext()) {
            IBotpMetaData childProperty = (IBotpMetaData)iter.next();
            if (isRoot && childProperty.getProperty() != null && childProperty.getProperty() instanceof LinkPropertyInfo && this.isF7LinkPro(childProperty)) {
                this.initProperty(childProperty, properties, false);
            }
            if (childProperty.getEntity() != null || childProperty.getProperty() != null && (DataType.BOOLEAN.getName().equals(childProperty.getProperty().get("dataType")) || DataType.BOSUUID.getName().equals(childProperty.getProperty().get("dataType")))) continue;
            properties.add(childProperty);
        }
    }

    private boolean isF7LinkPro(IBotpMetaData childProperty) {
        RelationshipInfo relationship;
        PropertyInfo property;
        return childProperty.getEntity() != null && !childProperty.equals(this.srcBotpEntity) && (property = childProperty.getProperty()) instanceof LinkPropertyInfo && (relationship = ((LinkPropertyInfo)property).getRelationship()) != null && relationship.getClientObject() != null && (CardinalityType.ONE.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getSupplierCardinality()));
    }

    private String getSortFieldFromTable(boolean fromEntry) {
        StringBuffer sortfield = new StringBuffer();
        String property = null;
        String sortType = null;
        KDTable kdtable = null;
        kdtable = fromEntry ? this.kDTableDetail : this.kDTableHead;
        int size = kdtable.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow currentRow = kdtable.getRow(i);
            Object pro = currentRow.getCell(0).getValue();
            if (pro == null || pro.equals("") || (property = this.getPropertyName(pro.toString(), fromEntry)) == null) continue;
            this.srcPropertyList.add(property);
            sortType = "ASC";
            if (SorterSignEnum.DESC.equals((Object)((SorterSignEnum)currentRow.getCell(1).getValue()))) {
                sortType = "DESC";
            }
            if (i == 0) {
                sortfield.append(property);
                sortfield.append(" ");
                sortfield.append(sortType);
                continue;
            }
            sortfield.append(",");
            sortfield.append(property);
            sortfield.append(" ");
            sortfield.append(sortType);
        }
        return sortfield.toString();
    }

    private String getPropertyName(String propertyDisplayName, boolean fromEntry) {
        ArrayList proList = fromEntry ? this.entryProperties : this.headProperties;
        for (int i = 0; i < proList.size(); ++i) {
            IBotpMetaData property = (IBotpMetaData)proList.get(i);
            String prefixDisplayName = "";
            String prefixName = "";
            if (property.getParent() != null && !property.getParent().equals(this.srcBotpEntity) && !property.getParent().equals(this.entryBotpEntity)) {
                prefixDisplayName = property.getParent().getDisplayName() + ".";
                prefixName = property.getParent().getName() + ".";
            }
            if (!propertyDisplayName.equals(prefixDisplayName + property.getDisplayName())) continue;
            return fromEntry ? this.entryName + "." + prefixName + property.getName() : prefixName + property.getName();
        }
        return null;
    }

    private String getPropertyDisplayName(String propertyName, boolean fromEntry) {
        ArrayList proList = fromEntry ? this.entryProperties : this.headProperties;
        for (int i = 0; i < proList.size(); ++i) {
            IBotpMetaData property = (IBotpMetaData)proList.get(i);
            String prefixDisplayName = "";
            String prefixName = "";
            if (property.getParent() != null && !property.getParent().equals(this.srcBotpEntity) && !property.getParent().equals(this.entryBotpEntity)) {
                prefixDisplayName = property.getParent().getDisplayName() + ".";
                prefixName = property.getParent().getName() + ".";
            }
            if (!propertyName.equals(prefixName + property.getName())) continue;
            return prefixDisplayName + property.getDisplayName();
        }
        return null;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.srcPropertyList = new ArrayList();
        String headFields = this.getSortFieldFromTable(false);
        String entryFields = this.getSortFieldFromTable(true);
        this.sortfield = headFields.trim().length() > 0 && entryFields.trim().length() > 0 ? headFields + "," + entryFields : (headFields.trim().length() == 0 ? this.getSortFieldFromTable(true) : this.getSortFieldFromTable(false));
        this.hasModified = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private KDComboBox setComboBoxField(KDTable table, int rowIndex, int colIndex, List list) {
        Object[] pl = new Object[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            pl[i] = list.get(i);
        }
        KDComboBox comboBox = new KDComboBox(pl);
        comboBox.setMaximumRowCount(20);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
        table.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
        if (colIndex == 0) {
            comboBox.setCanSearch(true);
        }
        return comboBox;
    }

    private Object[] getRowData(KDTable kdtable, int rowIndex) {
        Object[] object = new Object[2];
        for (int i = 0; i < 2; ++i) {
            object[i] = kdtable.getRow(rowIndex).getCell(i).getValue();
        }
        return object;
    }

    private IRow addRow(KDTable table, List propertylist) {
        IRow irow = table.addRow();
        ArrayList<String> pl = new ArrayList<String>();
        for (int i = 0; i < propertylist.size(); ++i) {
            IBotpMetaData p = (IBotpMetaData)propertylist.get(i);
            String prefixDisplayName = p.getParent() != null && !p.getParent().equals(this.srcBotpEntity) && !p.getParent().equals(this.entryBotpEntity) ? p.getParent().getDisplayName() + "." : "";
            pl.add(prefixDisplayName + p.getDisplayName());
        }
        this.setComboBoxField(table, irow.getRowIndex(), 0, pl);
        List typelist = SorterSignEnum.getEnumList();
        this.setComboBoxField(table, irow.getRowIndex(), 1, typelist);
        irow.getCell(1).setValue((Object)SorterSignEnum.ASC);
        return irow;
    }

    public BOTMappingInfo getBotMappingInfo() {
        return this.botMappingInfo;
    }

    private String getEntryName(EntityObjectInfo entity) {
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            RelationshipInfo relation;
            if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
            EntityObjectInfo relateEntity = null;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(entity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            return propInfo.getName();
        }
        return null;
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDContainer1.isVisible()) {
            this.addRow(this.kDTableHead, this.headProperties);
        } else {
            this.addRow(this.kDTableDetail, this.entryProperties);
        }
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdtable = null;
        kdtable = this.kDContainer1.isVisible() ? this.kDTableHead : this.kDTableDetail;
        if (kdtable.getRowCount() == 0 || kdtable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int currenRow = ((KDTSelectBlock)kdtable.getSelectManager().getBlocks().get(0)).getBeginRow();
        kdtable.removeRow(currenRow);
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdtable = null;
        kdtable = this.kDContainer1.isVisible() ? this.kDTableHead : this.kDTableDetail;
        if (kdtable.getRowCount() == 0 || kdtable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int selectRowIndex = kdtable.getSelectManager().getActiveRowIndex();
        int selectColIndex = kdtable.getSelectManager().getActiveColumnIndex();
        if (selectRowIndex == 0) {
            return;
        }
        this.modifyRowData(kdtable, selectRowIndex, selectRowIndex - 1);
        kdtable.getSelectManager().select(selectRowIndex - 1, selectColIndex);
        kdtable.scrollToVisible(selectRowIndex - 1, selectColIndex);
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        KDTable kdtable = null;
        kdtable = this.kDContainer1.isVisible() ? this.kDTableHead : this.kDTableDetail;
        if (kdtable.getRowCount() == 0 || kdtable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int selectRowIndex = kdtable.getSelectManager().getActiveRowIndex();
        int selectColIndex = kdtable.getSelectManager().getActiveColumnIndex();
        if (selectRowIndex == kdtable.getRowCount() - 1) {
            return;
        }
        this.modifyRowData(kdtable, selectRowIndex, selectRowIndex + 1);
        kdtable.getSelectManager().select(selectRowIndex + 1, selectColIndex);
        kdtable.scrollToVisible(selectRowIndex + 1, selectColIndex);
    }

    @Override
    public void actionMoveUpToTop_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdtable = null;
        kdtable = this.kDContainer1.isVisible() ? this.kDTableHead : this.kDTableDetail;
        if (kdtable.getRowCount() == 0 || kdtable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int selectRowIndex = kdtable.getSelectManager().getActiveRowIndex();
        int selectColIndex = kdtable.getSelectManager().getActiveColumnIndex();
        if (selectRowIndex == 0) {
            return;
        }
        this.modifyRowData(kdtable, selectRowIndex, 0);
        kdtable.getSelectManager().select(0, selectColIndex);
        kdtable.scrollToVisible(0, selectColIndex);
    }

    @Override
    public void actionMoveDownToBottom_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdtable = null;
        kdtable = this.kDContainer1.isVisible() ? this.kDTableHead : this.kDTableDetail;
        if (kdtable.getRowCount() == 0 || kdtable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int selectRowIndex = kdtable.getSelectManager().getActiveRowIndex();
        int selectColIndex = kdtable.getSelectManager().getActiveColumnIndex();
        int buttomIndex = kdtable.getRowCount() - 1;
        if (selectRowIndex == buttomIndex) {
            return;
        }
        this.modifyRowData(kdtable, selectRowIndex, buttomIndex);
        kdtable.getSelectManager().select(buttomIndex, selectColIndex);
        kdtable.scrollToVisible(buttomIndex, selectColIndex);
    }

    private void modifyRowData(KDTable kdtable, int selectRowIndex, int modifyRowIndex) {
        Object[] lastRowData = this.getRowData(kdtable, modifyRowIndex);
        Object[] currentRowData = this.getRowData(kdtable, selectRowIndex);
        this.setData(kdtable, selectRowIndex, lastRowData);
        this.setData(kdtable, modifyRowIndex, currentRowData);
    }

    private void setData(KDTable kdtable, int rowIndex, Object[] objects) {
        if (objects != null) {
            int length = objects.length;
            for (int i = 0; i < length; ++i) {
                kdtable.getRow(rowIndex).getCell(i).setValue(objects[i]);
            }
        }
    }
}

